var Login = function() {

    var handleLogin = function() {

        $('.login-form').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            rules: {
                username: {
                    required: true
                },
                emailid: {
                    required: true,
                    email_validate:true
                },
                pwd: {
                    required: true
                },
                remember: {
                    required: false
                }
            },

            messages: {
                username: {
                    required: "Please enter User ID"
                },
                emailid: {
                    required: "Please enter Email ID"
                },
                pwd: {
                    required: "Please enter Password"
                }
            },
            highlight: function(element)
            {
                $(element).closest('.form-group').addClass('has-error');
            },
            success: function(label)
            {
                label.closest('.form-group').removeClass('has-error');
                label.remove();
            },
            errorPlacement: function(error, element)
            {
                error.insertAfter(element);
                error.addClass('help-small no-left-padding').insertAfter(element);
            },

            submitHandler: function(form) {
                form.submit(); // form validation success, call ajax form submit
            }
        });

        $('.login-form input').keypress(function(e)
        {
            if (e.which == 13) {
                if ($('.login-form').validate().form()) {
                    $('.login-form').submit(); //form validation success, call ajax form submit
                }
                return false;
            }
        });
    }

    var handleForgetPassword = function()
    {
        $('.forget-form').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            ignore: "",
            onkeyup: false,
            rules: {
                forgot_username: {
                    required: true,
                    minlength:6,
                    maxlength:100
                }
            },

            messages: {
                forgot_username: {
                    required: "Please enter Email ID."
                }
            },
            highlight: function(element) { // hightlight error inputs
                $(element)
                    .closest('.form-group').addClass('has-error'); // set error class to the control group
            },

            success: function(label) {
                label.closest('.form-group').removeClass('has-error');
                label.remove();
            },

            errorPlacement: function(error, element)
            {
                error.insertAfter(element);
            },
            submitHandler: function(form)
            {
                $(".loader_animation").show();
                $("#forgot-submit-btn").prop("disabled",true);
                $("#forgot-alert-holder").html('');
                $.post('/login/forgotcheck',$('.forget-form').serialize(),
                function(res)
                {
                    if(res.status==1)
                    {
                        $("#forgot-alert-holder").html('\
                            <div class="alert alert-success">\
                                <button class="close" data-dismiss="alert"></button>\
                                <span>A password reset email has been sent to the Email ID provided. Please follow the instructions in the email to reset your password.<br><b>*If you do not see the password reset email in your Inbox, please check your SPAM / Junk mail folder.</b></span>\
                            </div>');
                    }
                    else if(res.status==2)
                    {
                        $("#forgot-alert-holder").html('\
                            <div class="alert alert-success">\
                                <button class="close" data-dismiss="alert"></button>\
                                <span>A password reset email has been sent to the Email ID provided. Please follow the instructions in the email to reset your password.<br><b>*If you do not see the password reset email in your Inbox, please check your SPAM / Junk mail folder.</b></span>\
                            </div>');
                    }
                    else if(res.status==3)
                    {
                        $("#forgot-alert-holder").html('\
                            <div class="alert alert-success">\
                                <button class="close" data-dismiss="alert"></button>\
                                <span>A password reset email has been sent to the Email ID provided. Please follow the instructions in the email to reset your password.<br><b>*If you do not see the password reset email in your Inbox, please check your SPAM / Junk mail folder.</b></span>\
                            </div>');
                    }
                    else
                    {
                        $("#forgot-alert-holder").html('\
                            <div class="alert alert-danger">\
                                <button class="close" data-dismiss="alert"></button>\
                                <span>Something went wrong! Please try again.</span>\
                            </div>');
                    }
                    $(".loader_animation").hide();
                    $("#forgot-submit-btn").prop("disabled",false);
                });
                return false;
                form.submit();
            }
        });

        $('.forget-form input').keypress(function(e) {
            if (e.which == 13) {
                if ($('.forget-form').validate().form()) {
                    $('.forget-form').submit();
                }
                return false;
            }
        });

        jQuery('#forget-password').click(function() {
            jQuery('.login-form').hide();
            jQuery('.forget-form').show();
        });

        jQuery('#back-btn').click(function() {
            jQuery('.login-form').show();
            jQuery('.forget-form').hide();
        });

    }

    var handleRegister = function()
    {
        $('.register-form').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block', // default input error message class
            focusInvalid: false, // do not focus the last invalid input
            onkeyup: false,
            ignore: "",
            rules:
            {

                firstname:
                {
                    required: true,
                    minlength: 2,
                    maxlength: 50,
                    lettersonly:true
                },
                middlename:
                {
                    spaces:true,
                    maxlength: 50,
                    lettersonly:true
                },
                lastname:
                {
                    required: true,
                    minlength: 2,
                    maxlength: 50,
                    lettersonly:true
                },
                email:
                {
                    required: true,
                    no_uppercase:true,
                    email_validate: true,
                    minlength: 6,
                    maxlength: 100,
                    remote:
                    {
                        url: "/login/emailcheck",
                        type: "post",
                        data:
                        {
                            email: function()
                            {
                                return $( ".register-form #email" ).val();
                            }
                        },
                        beforeSend: function () {
                            $( ".register-form #email" ).addClass("spinner");
                        },
                        complete: function (response) {
                            $( ".register-form #email" ).removeClass("spinner");
                        }
                    }
                },
                /*gender:
                {
                    required: true
                },
                dob:
                {
                    required: true,
                    dobval:true
                },*/
                username:
                {
                    required: true,
                    alphabetsnumbers2: true,
                    minlength: 6,
                    maxlength: 60,
                    remote:
                    {
                        url: "/login/usernamecheck",
                        type: "post",
                        data:
                        {
                            username: function()
                            {
                                return $( ".register-form #username" ).val();
                            }
                        },
                        beforeSend: function () {
                            $( ".register-form #username" ).addClass("spinner");
                        },
                        complete: function (response) {
                            $( ".register-form #username" ).removeClass("spinner");
                        }
                    }
                },
                password:
                {
                    required: true,
                    minlength: 8,
                    maxlength: 50
                },
                rpassword:
                {
                    required: true,
                    equalTo: "#register_password"
                },
                country:
                {
                    required:true
                },
                zip:
                {
                    minlength:3,
                    maxlength:15,
                    name_validate14:true
                },
                phone:
                {
                    minlength:8,
                    maxlength:15,
                    digits:true,
                    spaces:true
                },
                tnc:
                {
                    required: true
                }
            },

            messages:
            {
                username:
                {
                    required: "Please enter User ID",
                    remote: "User ID already exists"
                },
                password:
                {
                    required: "Please enter Password"
                },
                rpassword:
                {
                    required: "Please re enter Password",
                    equalTo: "Passwords  does not match"
                },
                firstname:
                {
                    required: "Please enter First Name"
                },
                lastname:
                {
                    required: "Please enter Last Name"
                },
                email:
                {
                    required: "Please enter Email ID",
                    remote: "Email ID already exists"
                },
                /*dob:
                {
                    required: "Please choose Date of Birth"
                },
                gender:
                {
                    required: "Please select Gender"
                },*/
                phone:
                {
                    required:"Please enter Phone Number"
                },
                country:
                {
                    required:"Please select Country"
                },
                zip:
                {
                    required:"Please enter ZIP/PIN Code"
                
                },
                tnc:
                {
                    required: "Please accept Terms of Service"
                }
            },
            highlight: function(element) { // hightlight error inputs
                $(element)
                    .closest('.form-group').addClass('has-error'); // set error class to the control group
            },

            success: function(label)
            {
                label.closest('.form-group').removeClass('has-error');
                label.remove();
            },

            errorPlacement: function(error, element) {
                if (element.attr("name") == "tnc") { // insert checkbox errors after the container                  
                    error.insertAfter($('#register_tnc_error'));
                } else if (element.closest('.input-icon').size() === 1)
                {
                    error.insertAfter(element.closest('.input-icon'));
                } else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function(form)
            {
                $(".loader_animation").show();
                $("#register-submit-btn").prop("disabled",true);
                $("#reg-alert-holder").html('');
                $.post('/login/register',$('.register-form').serialize(),
                function(res)
                {
                    if(res.status==1)
                    {
                        $("#login-alert-holder").html('\
                            <div class="alert alert-success">\
                                <button class="close" data-dismiss="alert"></button>\
                                <span><b>Your account has been created successfully. Please login to continue</b></span>\
                            </div>');
                        $('.register-form')[0].reset();
                        $("#register-back-btn").click();
                        Metronic.scrollTo($('#login-alert-holder'));
                    }
                    else
                    {
                        $("#reg-alert-holder").html('\
                            <div class="alert alert-danger">\
                                <button class="close" data-dismiss="alert"></button>\
                                <span>Invalid request</span>\
                            </div>');
                        Metronic.scrollTo($('#reg-alert-holder'));
                    }
                    $(".loader_animation").hide();
                    $("#register-submit-btn").prop("disabled",false);
                });
                return false;
            }
        });

        $('.register-form input').keypress(function(e) {
            if (e.which == 13) {
                if ($('.register-form').validate().form()) {
                    $('.register-form').submit();
                }
                return false;
            }
        });

        jQuery('#register-btn').click(function() {
            jQuery('.login-form').hide();
            jQuery('.register-form').show();
            $("#reg_alert").modal("show");
        });

        jQuery('#register-back-btn').click(function() {
            jQuery('.login-form').show();
            jQuery('.register-form').hide();
        });
    }

    return {
        //main function to initiate the module
        init: function() {

            handleLogin();
            handleForgetPassword();
            handleRegister();

        }

    };

}();