$(document).ready(function () {
    $("#online").change(function () {
        if ($(this).is(":checked")) {
            $("#cashOrCheque").prop("checked", false);
            $("#onlineDiv").show();
            $("#onlineButton").show();
            $("#offlineDiv").hide();
            $("#offlineButton").hide();
        }
    });
    $("#offline").change(function () {
        if ($(this).is(":checked")) {
            $("#cashOrCheque").prop("checked", true);
            $("#onlineDiv").hide();
            $("#onlineButton").hide();
            $("#offlineDiv").show();
            $("#offlineButton").show();
        }
    });

});

function saveMembership() {
    var type = $('ul.tabs').find('li').find('a.active').data('type');
    var price = $('ul.tabs').find('li').find('a.active').data('price');
    location.href = "/preview.html?sub=";
}

var incDecFlag = false;
function qtyDec(skuCode) {
    var flag = $("input[name=qtyDe" + skuCode + "]").data('incart');
    if (skuCode) {
        var no = parseInt($('input[name=qty' + skuCode + "]").data('value')) - 1;
        if (no >= 1) {
            if (!flag) {
                $('input[name=qty' + skuCode + "]").data('value', no);
                $('input[name=qty' + skuCode + "]").val(no);
            } else {
                addItemToCartFromSearchPage(skuCode, null, 2);
            }
        }
    }
}

function qtyInc(skuCode) {
    var flag = $("input[name=qtyIn" + skuCode + "]").data('incart');
    if (skuCode) {
        var no = parseInt($('input[name=qty' + skuCode + "]").data('value')) + 1;
        if (!flag) {
            $('input[name=qty' + skuCode + "]").data('value', no);
            $('input[name=qty' + skuCode + "]").val(no);
        } else {
            $('input[name=qty' + skuCode + "]").data('value', no);
            addItemToCartFromSearchPage(skuCode, null, 1);
        }
    }
}

function addItemToCartFromSearchPage(skuCode, button, flag) {
    incDecFlag = flag ? true : false;
    $('input[name=qty' + skuCode + ']').val('Adding...');
    var val = $('input[name=qty' + skuCode + "]").data('value');
    var no = addToCart(skuCode, flag && flag === 1 ? 1 : flag && flag === 2 ? -1 : val);
    if (no && no > 0) {
        $("#showCart").show();
        $("input[name=qtyIn" + skuCode + ']').data('incart', 1);
        $("input[name=qtyDe" + skuCode + ']').data('incart', 1);
        $('input[name=qty' + skuCode + ']').val(no);
        $('input[name=qty' + skuCode + ']').data('value', no);
        if (button) {
            $("div[name=remove" + skuCode + "]").show();
            $("div[name=add" + skuCode + "]").hide();
        }
        if (location.href.indexOf("cart.html") !== -1)
            location.href = '/cart.html';
    }
}

function deleteItem(skuCode) {
    var val = $('input[name=qty' + skuCode + "]").data('value');
    jQuery.post('/addItemToCart.save',
            {productId: skuCode, quantity: -val},
    function (data) {
        if (data.indexOf("deleted") !== -1) {
            $("#cartQty").html("Cart (" + data.split(";")[0] + ")");
            $("#cartQtyR").html("Cart (" + data.split(";")[0] + ")");
            $("#cartUpdateNotification").html("Item removed from the cart.");
            $(".cart_popup").show();
            window.setTimeout("$('.cart_popup').hide()", 2000);
            $("div[name=remove" + skuCode + "]").hide();
            $("div[name=add" + skuCode + "]").show();
            $("input[name=qtyIn" + skuCode + ']').data('incart', 0);
            $("input[name=qtyDe" + skuCode + ']').data('incart', 0);
            $('input[name=qty' + skuCode + ']').val(1);
            $('input[name=qty' + skuCode + ']').data('value', data.no);
            if (parseInt(data.split(";")[0]) === 0) {
                $("#showCart").hide();
            }
            if (location.href.indexOf("cart.html") !== -1)
                location.href = '/cart.html';
        }
    });
}

function addToCart(skuCode, no, button, textInput) {
    var addItemFlag = true;
    var returnVal = 0;
    if (addItemFlag) {
        $.ajax({
            url: '/addItemToCart.save',
            data: "productId=" + skuCode + "&quantity=" + no,
            async: false,
            type: 'POST',
            success: function (data, textStatus, jqXHR) {
                $("#cartQty").html("Cart (" + data.split(";")[0] + ")");
                $("#cartQtyR").html("Cart (" + data.split(";")[0] + ")");
                $(".cart_wrap_head").html("Your cart <span>(" + data.split(';')[0] + ") Items</span>");
                $(".mob_cart").html(data.split(';')[0]);
                $(".cart_s_count").html("(" + data.split(';')[0] + " Items)");
                //fillCart();
                if (data.indexOf("added") !== -1 || data.indexOf("updated") !== -1) {
                    if (incDecFlag)
                        $("#cartUpdateNotification").html("Item quantity updated.");
                    else
                        $("#cartUpdateNotification").html("Item added to cart.");
                    window.setTimeout("$('.cart_popup').hide()", 2000);
                    $(".cart_popup").show();
                    selectedProduct = 0;
                    $("#skuSearch").val('');
                    if (button) {
                        $(button).attr('value', "Added");
                        $(button).attr('disabled', 'disabled');
                        $(button).addClass('item_added');
                        document.getElementById(skuCode).dataset.done = 'done';
                    }
                    returnVal = data.split(';')[1];
                } else {
                    if (!incDecFlag) {
                        $("#cartUpdateNotification").html("Failed to add item to cart.");
                        $(".cart_popup").show();
                        window.setTimeout("$('.cart_popup').hide()", 3000);
                    }
                    if (button)
                        $(button).attr('value', "Add to Cart");
                }
                incDecFlag = false;
                if (button)
                    $(button).removeClass("item_adding");
            }
        });
    }
    return returnVal;
}