var pageFlag = true, loading = false, size = 0;
$(document).ready(function () {
    $("#adoptBtn").click(function () {
        if ($("#units").val() === '0') {
            showMessage("please select adoption unit(s)");
        } else {
            $('#adoptBirdForm')[0].submit();
        }
    });
});
function filterBirds(sizeId) {
    $("#filterBirdsDiv").find("input").each(function () {
        if ($(this).attr("id") !== "size" + sizeId)
            $(this).prop("checked", false);
    });
    currentPage = 0;
    getBirdList('', sizeId, true);
}
function getBirdList(search, sizeId, clearFlag) {
    $(".loading").show();
    jQuery.post("/site/bird-list.json", {search: search, sizeId: sizeId, pageNo: currentPage, pageSize: 8}, function (data) {
        size = sizeId;
        if (clearFlag) {
            $("#birdList").empty();
            $("#resBirdList").empty();
        }
        if (data && data !== "") {
            var bird = data.result;
            if (bird.length > 0) {
                var text = "";
                var rtext = "";
                for (var e in bird) {
                    text += "<a href='/bird/" + bird[e].birdId + ".html'><div class='adopt_block'>";
                    var imageName = "/images/no-image.png";
                    for (var g in bird[e].images) {
                        var img1 = bird[e].images[g];
                        if (img1.indexOf("thumb") !== -1) {
                            imageName = "/sgs-static/Birds/" + bird[e].id + "/" + img1;
//                            text += "<img title='" + img1 + "' src = '/sgs-static/Birds/" + bird[e].id + "/" + (img1 !== null && img1 !== "" ? img1 : "no-image.png") + "'/>";
                        }
                    }
                    text += "<div class='image_div'><img src='" + imageName + "'></div>";
                    text += "<h6>" + bird[e].name + "</h6>";
                    if (bird[e].adopted) {
                        text += "<div class = 'water_mark'>";
                        text += "<h5> This " + (bird[e].size.indexOf("Group") !== -1 ? "Group" : "Bird") + " is Adopted " + (bird[e].availableUnits === 0 ? 'Completely' : 'Partially') + "</h5>";
                        var adoptors = bird[e].clientBirds;
                        var clientNames = "";
                        for (var a in adoptors) {
                            clientNames += (a === "0" ? "" : ", ") + adoptors[a].clientName;
                        }
                        text += "<page> by  " + clientNames + " </page>";
                    } else {
                        text += "<div class='adopt_block_bg'>";
                        text += "<h5> ";
                        text += bird[e].name;
                        text += "<br/>Adoption Price: $" + bird[e].amount.toFixed(2);
                        if (bird[e].birdSizeId === 5) {
                            text += "<br/>Unit Price: $" + (bird[e].amount / bird[e].adoptionUnits).toFixed(2);
                            text += "<br/>Available Units: " + bird[e].availableUnits;
                        }
                        text += " </h5>";
                        text += "<page>" + bird[e].description + "</page>";
                        text += "<h4 class='ad_r'>more</h4>";
                    }
                    text += "</div></div></a>";
                    rtext += "<a href = '/bird/" + bird[e].birdId + ".html'> <div class = 'mobile_block'>";
                    var image = "/images/no-image.png";
                    for (var i in bird[e].images) {
                        if (bird[e].images[i].indexOf("thumb_") !== -1) {
                            image = "/sgs-static/Birds/" + bird[e].id + "/" + bird[e].images[i];
                        }
                    }
                    rtext += "<div class='image_div'><img src = '" + image + "'/></div>";
                    rtext += "<div class = 'mobile_block_bg'>";
                    if (bird[e].adopted) {
                        rtext += "<h5> This " + (bird[e].size.indexOf("Group") !== -1 ? "Group" : "Bird") + " is Adopted " + (bird[e].availableUnits === 0 ? 'Completely' : 'Partially') + "</h5>";
                        if (bird[e].adoptedBy !== null) {
                            rtext += "<page>  by " + bird[e].adoptedBy + " </page>";
                        }
                    } else {
                        rtext += "<h5> ";
                        rtext += bird[e].name;
                        rtext += "<br/>Adoption Price: " + bird[e].amount;
                        rtext += "<br/>Unit Price: " + (bird[e].amount / bird[e].adoptionUnits);
                        rtext += "<br/>Available Units: " + bird[e].availableUnits;
                        rtext += "</h5>";
                        rtext += "<page> " + bird[e].description + "</page>";
                        rtext += "<h4 class = 'mb_r'> more </h4> ";
                    }
                    rtext += "</div></div></a>";
                }
                $("#birdList").append(text);
                $("#resBirdList").append(rtext);
                $(".adopt_block .image_div img, .mobile_block .image_div img").on('load', function () {
                    $(this).fadeIn(1000);
                    window.setTimeout("$(this).parent().css('background-image', 'none')", 1000);
                });
                $("#birdPage").show();
                var paginator = data.paginator;
                var no = paginator.totalRows / paginator.pageSize;
                no = paginator.totalRows % paginator.pageSize > 0 ? no + 1 : no;
                $("#birdPageMsg").html('Showing 1 - ' + ((paginator.currentPage + 1) * paginator.pageSize > paginator.totalRows ? paginator.totalRows : (paginator.currentPage + 1) * paginator.pageSize) + ' of ' + paginator.totalRows + " birds");
                var options = {
                    currentPage: paginator.currentPage + 1,
                    totalPages: no,
                    alignment: 'right',
                    size: 'small',
                    useBootstrapTooltip: false,
                    itemContainerClass: function (type, page, current) {
                        return (page === current) ? "active" : "pointer-cursor";
                    },
                    pageUrl: function (type, page, current) {
                        return "javascript:getBirdList('" + search + "'," + sizeId + "," + clearFlag + ")";
                    }
                };
//                $("#birdPaginator").bootstrapPaginator(options);
                currentPage = paginator.currentPage + 1;
                pageFlag = paginator.totalRows - (paginator.pageSize * (paginator.currentPage + 1)) > 0;
            } else {
//                showMessage("No Bird(s) Found");
                $("#birdPage").hide();
            }
        } else {
//            showMessage("No Bird(S) Found");
            $("#birdPage").hide();
        }
        loading = false;
        $(".loading").hide();
    });
}

$(document).ready(function () {
    $(".adopt_block .image_div img, .mobile_block .image_div img").on('load', function () {
        $(this).fadeIn(1000);
        window.setTimeout("$(this).parent().css('background-image', 'none')", 1000);
    });
});