<link href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | All VedoktaShanti Requests" type="hidden">
<style type="text/css">
    @media only screen and (min-width: 992px) and (max-width: 1450px){
        .buttons{
            padding: 29px 0px 6px 0px;
        }
    }
</style>
<?PHP echo $this->general_model->help_link(); ?>
<?PHP
    $this->load->view("vedoktashanti/admin/nav_buttons");
?>
<h3 class="page-title">
All VedoktaShanti Requests
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            All VedoktaShanti Requests
        </li>
    </ul>
</div>
     
<div class="row-fluid">
<?PHP
if($this->session->flashdata("vedoktashanti_error"))
{
    ?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Invalid Request</strong>
    </div>
    <?PHP
}
?>
    <form action="" method="get" name="list_of_mes" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form">
        <div class="col-md-2">
            <select id="fstatus" onChange="search(1)" class="form-control input-inline custom-input">
                <option value="">All Tickets (Except Closed)</option>
                <option value="1">Open Tickets</option>
                <option value="2">Waiting Admin Tickets</option>
                <option value="3">Waiting User Tickets</option>
                <option value="4">Closed Tickets</option>
            </select>
        </div>
        <div class="col-md-2">
            <select id="guests" onChange="search(1)" class="form-control input-inline custom-input">
                <option value="1">All Users</option>
                <option value="2">Created by Admin</option>
                <option value="3">Created by User</option>
                <option value="4">Created by Guest</option>
            </select>
        </div>
        <div class="col-md-2">
            <select id="purpose" onChange="search(1)" class="form-control input-inline custom-input">
                <option value="">All Purposes</option>
                <?PHP
                foreach ($this->purposeArray as $key => $purpose)
                {
                    ?>
                    <option value="<?PHP echo $key; ?>"><?PHP echo $purpose; ?></option>
                    <?PHP
                }
                ?>
            </select>
        </div>
        <div class="col-md-2">
            <select name="app" onChange="search(1)" id="app" class=" input-inline form-control custom-input">
                <option value="">All Sources</option>
                <option value="1">App</option>
                <option value="0">Website</option>
            </select>
        </div>
        <br style="clear:both;" class="hidden-sm hidden-xs">

        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="input-inline form-control custom-input" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                <option value="email">Email ID</option>
                <option value="vedoktashanti_id">VedoktaShanti ID</option>
                <option value="username">User Name</option>
                <option value="name">Name</option>
                <option value="content">Support Message</option>
            </select>
        </div>
        <div class="col-md-2" style="display:none">
            <select name="wild" id="wild" class="input-inline form-control custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts with</option>
                <option value="ends">Ends with</option>
            </select>
        </div>
        <div class="col-md-2">
            
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="from_date" id="from_date"
            placeholder="From date"/>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="to_date" id="to_date"
            placeholder="To date" />
        </div>
        <div class="buttons">
            <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
            onClick="search(0)"><i class="fa fa-search"></i> Search</button>
            <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
            style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
            <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
        </div>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption"> <i class="fa fa-list"></i> All VedoktaShanti Requests
            <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
        </div>
        
        <div class="portlet-body no-more-tables">
            
            <table id="fbtable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                <thead>
                    <tr>
                        <th>S. No.</th>
                        <th>Support ID</th>
                        <th>User</th>
                        <th><nobr>Purpose</nobr></th>
                        <th>Date Created</th>
                        <th>Last Update</th>
                        <th>Checked In</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                
            </table>
        
            <div style="clear:both;"></div>
        </div>
    </div>
</div>

<div id="send-to-modal" class="modal fade" data-width="500" tabindex="-1">
    <form class="send-to-form">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
            <h4 class="modal-title" style="color:#fff;">Send to</h4>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Email</label>
                <input type="hidden" name="vedoktashanti_id" id="vedoktashanti_id">
                <input class="form-control" type="text" name="send_to" id="send_to"/>
            </div>
            <div class="form-group">
                <?PHP
                if(defined('vedoktashanti_emails') && !empty(vedoktashanti_emails))
                {
                    foreach (vedoktashanti_emails as $vedoktashanti_email)
                    {
                        ?>
                        <a href="javascript:;" class="vedoktashanti-email"><?PHP echo $vedoktashanti_email; ?></a><br>
                        <?PHP
                    }
                }
                ?>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" data-dismiss="modal" class="btn btn-xs">
                <i class="fa fa-remove"></i> Close
            </button>
            <button type="submit" class="btn btn-xs blue">
                <i class="fa fa-check"></i> Send
            </button>
        </div>
    </form>
</div>

<script src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var from_date = '';
var to_date = '';
var search_text = '';
var search_col = '';
var wild = '';
var fstatus=$("#fstatus").val();
var table = '';
var guests=1;
var purpose='';
var app='';

function search(flag) 
{
    clearNotifications();
    if(!$("#from_date").length || !$("#to_date").length || !$("#search_text").length || !$("#search_col").length ||
            !$("#wild").length)
    {
        showNotification("ruby","Something wrong, please refresh the page and try again.");
        return;
    }
    if (flag == 0)
    {
        if ($("#from_date").length && $("#to_date").length && $("#search_text").length && 
            $("#from_date").val().trim() == '' && $("#to_date").val().trim() == '' && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords or select dates');
            return false;
        }
        if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
        {
            var frm=Date.parse($("#from_date").val());
            var to=Date.parse($("#to_date").val());
            if(frm>to)
            {
                showNotification('ruby','From date cannot be after To date');
                return false
            }
        }
    }
    $(".dataTables_processing").show();
    if($("#from_date").length)
        from_date = $("#from_date").val().trim();
    if($("#to_date").length)
        to_date = $("#to_date").val().trim();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#search_col").length)
        search_col = $("#search_col").val().trim();
    if($("#wild").length)
        wild = $("#wild").val().trim();
    
    if($("#guests").length)
        guests = $("#guests").val();
    if($("#purpose").length)
        purpose = $("#purpose").val();
    if($("#app").length)
        app=$("#app").val();
    if (from_date != '' || to_date != '' || search_text != '')
        $("#searchClear").css("display", "inline-block");
    fstatus=$("#fstatus").val();
    
    table.fnDraw();
}
function search_clear() 
{
    $(".dataTables_processing").show();
    $("#from_date").val('');
    from_date = '';
    $("#to_date").val('');
    to_date = '';
    $("#search_text").val('');
    search_text = '';
    search_col = '';
    wild = '';
    $("#fstatus").val('');
    fstatus='';
    guests=1;
    purpose='';
    $("#purpose").val('');
    $("#guests").val(1);
    app='';
    $("#app").val("");
    $("#searchClear").css("display", "none");
    table.fnDraw();
}
var statusflag=0;
function changeStatus(id, status)
{
    if(statusflag==1)
        return false;
    statusflag=1;
    $(".dataTables_processing").show();
    $.post('/vedoktashantiadmin/changestatus/' + id + '/' + status, {}, function(res) 
    {
        if(res=='login')
        {
            window.location="<?PHP echo base_url; ?>"
        }
        if(res=='access_denied')
        {
            showNotification('ruby',"Access Denied");
            $(".dataTables_processing").hide();
            if (status == 4) 
            {
                $("#fb" + id).modal('toggle');
            }
            statusflag=0;
            return;
        }
        var r = $.parseJSON(res);
        $(".dataTables_processing").hide();
        if (r.flag == 1) 
        {
            table.fnSettings.bResetDisplay  =false;
            table.fnDraw(table.fnSettings);
            showNotification(r.message.color, "VedoktaShanti Request '" + r.data.vedoktashanti_id + "' " + r.message.info);
        }
        else
        {
            showNotification("ruby", r.error);
        }
        if (status == 4) 
        {
            $("#fb" + id).modal('toggle');
        }
        statusflag=0;
    });
}
$(".vedoktashanti-email").on("click",function()
{
    $("#send_to").val($(this).html());
});
$(".send-to-button").live("click",function()
{
    var id=$(this).data("id");
    $("#vedoktashanti_id").val(id);
    $("#send-to-modal").modal("show");
});
$(document).ready(function()
{
    $('.send-to-form').validate({
        errorElement: 'span',
        errorClass: 'help-block',
        focusInvalid: true,
        rules: {
            send_to: {
                required: true,
                minlength:6,
                maxlength:1000,
                email_validate:true,
            }
        },
        messages: {
            send_to: {
                required: "Please enter Email ID"
            }
        },
        highlight: function(element)
        {
            $(element).closest('.form-group').addClass('has-error');
        },
        success: function(label)
        {
            label.closest('.form-group').removeClass('has-error');
            label.remove();
        },
        errorPlacement: function(error, element)
        {
            error.insertAfter(element);
            error.addClass('help-small no-left-padding').insertAfter(element);
        },

        submitHandler: function(form)
        {
            $("#send-to-modal").modal("hide");
            $(".loader_animation").show();
            $.post('/vedoktashantiadmin/send_to/'+$("#vedoktashanti_id").val(),$('.send-to-form').serialize(),
            function(res)
            {
                if(res.flag==1)
                {
                    showNotification("lime","VedoktaShanti forwarded to '"+$("#send_to").val()+"'.");
                }
                if(res.flag==0)
                {
                    showNotification("ruby","Invalid request");
                }
                $("#send_to").val('');
                $(".loader_animation").hide();
            });
            return false;
        }
    });
});

$(document).ready(function()
{
    $("#search_text").val('');
    $("#from_date").val('');
    $("#to_date").val('');
    $("#wild").val($("#wild option:first").val());
    $("#search_col").val($("#search_col option:first").val());
    $("#guests").val($("#guests option:first").val());
    $("#purpose").val($("#purpose option:first").val());
    
    table = $('#fbtable').dataTable(
    {
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [6, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            $('.tooltips').tooltip();
        },
        "columns": [
            {
                "width": "7%",
                "orderable": false
            }, {
                name: "vedoktashanti_id",
                "width": "15%",
                "orderable": true
            }, {
                name: "name",
                "orderable": true
            }, {
                name: "purpose",
                "width": "12%",
                "orderable": false
            }, {
                name: "date",
                "width": "12%",
                "orderable": true
            }, {
                name: "modified_on",
                "width": "12%",
                "orderable": true
            }, {
                "width": "12%",
                "orderable": false
            }, {
                width: "7%",
                "orderable": false
            }
        ],
        "ajax": {
            url: '/vedoktashantiadmin/listmessages/',
            type: 'POST',
            data: function(d) 
            {
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
                d.wild = wild;
                d.fstatus=fstatus;
                d.guests=guests;
                d.purpose=purpose;
                d.app=app;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            if(aData.read==0)
                $(nRow).addClass("bold");
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Support ID");
                ii++;
            }

            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "User");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Purpose");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Date Created");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Last Update");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Checked In");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) 
            {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                var str ="";
                if(row.app==1)
                {
                    str+='<span class="custom-label darkblue pull-right">A</span>';
                }
                str+="<a href='/vedoktashantiadmin/view/" + row.id + "' target='_blank'>"+row.vedoktashanti_id + ' ('+row.count+')</a><div class="clearfix margin-bottom-5"></div>';                

                if(row.fstatus==1)
                    str+="<span class='custom-label green'>Open</span>";
                else if(row.fstatus==2)
                    str+="<span class='custom-label darkblue'>Waiting Admin</span>";
                else if(row.fstatus==3)
                    str+="<span class='custom-label yellow'>Waiting User</span>";
                else if(row.fstatus==4)
                    str+="<span class='custom-label darkred'>Closed</span>";

                if(row.admin ==1)
                {
                    str+="<br><span style='margin-top:5px;' class='custom-label purple'>Created by Admin</span>";
                }
                return str;
            },
            "targets": 1
        }, {
            "render": function(data, type, row) 
            {
                var str='';
                if(row.username!='guest' && row.user_id!=0)
                {
                    str+='<a href="/usersadmin/view/'+row.user_id+'"><i class="fa fa-user"></i> '+row.username+'</a><br>';
                } else {
                    str+='<span class="custom-label darkred">Guest</span><br>';
                }
                str+=row.name;
                str+='<br>'+row.email;
                if(row.phone!='null' && row.phone!='' && row.phone!=null)
                {
                    var new_phone = row.phone;
                    if(row.isd_code!='null' && row.isd_code!='' && row.isd_code!=null)
                    {
                        new_phone = "+"+row.isd_code +" "+row.phone;
                    }
                    str+='<br><a href="https://api.whatsapp.com/send?phone='+new_phone.replace(" ","").replace("+","")+'" target="_blank"><i class="fa fa-whatsapp pull-right" style="color:green; margin-top:3px; font-size:22px;"></i>'+new_phone+'</a>';
                }
                return str;
            },
            "targets": 2
        }, {
            "render": function(data, type, row) 
            {
                return row.purpose;
            },
            "targets": 3
        }, {
            "render": function(data, type, row)
            {
                return row.date;
            },
            "targets": 4
        },
        {
            "render": function(data, type, row)
            {
                return '<span style="color:red;">'+row.modified_on+'</span>';
            },
            "targets": 5
        },
        {
            "render": function(data, type, row)
            {
                if(row.checked_in==1)
                    return '<b style="color:red;">'+row.checked_in_username+'</b>';
                else
                    return 'N/A';
            },
            "targets": 6
        },
        {
            "render": function(data, type, row) 
            {
                var str = '<div class="btn-group" id="actions' + row.id + '">' +
                            '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                            '<i class="fa fa-angle-down"></i></a>' +
                            '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                            '<li><a href="/vedoktashantiadmin/view/' + row.id + '" target="_blank"><i class="fa fa-eye"></i> View</a></li>';
                str+='<li><a href="javascript:;" class="send-to-button" data-id="' + row.id + '"><i class="fa fa-forward"></i> Send to</a></li>';

                if(row.fstatus!=4)
                {
                    str += '<li><a href="#fb' + row.id + '" role="button" data-toggle="modal">' +
                    '<i class="fa fa-ban"></i> Close</a></li>' +

                    '<div id="fb' + row.id + '" class="modal fade" tabindex="-1">' +
                    '<div class="modal-header">' +
                    '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                    '<h4 class="modal-title">Close Confirmation</h4>' +
                    '</div>' +
                    '<div class="modal-body"><div class="pull-left delete-confirmation-icon"' +
                    '><i class="fa fa-exclamation-triangle"></i></div>' +
                    'Do you really want to close the Support Message: ' +
                    '<span style="color:red; font-weight:bold;">' + row.vedoktashanti_id + '</span>?' +
                    '</div>' +
                    '<div class="modal-footer">' +
                    '<button type="button" data-dismiss="modal" class="btn btn-xs close' + row.id + '">' +
                    '<i class="fa fa-remove"></i> Cancel</button>' +
                    '<a onClick="changeStatus(' + row.id + ',4)" class="btn btn-xs red">' +
                    '<i class="fa fa-ban"></i> Close</a>' +
                    '</div>' +
                    '</div>';
                }

                return str;
            },
            "targets": 7
        }
        ]
    });
    $('.columnhide').on('click', function(e) 
    {
        var column = table.api().column( $(this).attr('data-column') );
        var cnum=$(this).attr('data-column');
        
        column.visible( ! column.visible(),true );
        var bVis = table.fnSettings().aoColumns[cnum].bVisible;
        var title = table.fnSettings().aoColumns[cnum].sTitle;
        
        var visibility=table.api().column(cnum).visible();
        table.api().column(cnum).nodes().to$().attr("data-title",title);
        if (visibility == false) 
        {
            $(this).removeClass('blue').addClass('red');
        }
        else 
        {
            $(this).removeClass('red').addClass('blue');
        }
    });
});
$("#excelButton").on("click",function()
{
    $(".loader_animation").show();
    clearNotifications();
    var sortindex=table.fnSettings().aaSorting[0][0];
    var order_by=table.fnSettings().aoColumns[sortindex].name;
    var dir=table.fnSettings().aaSorting[0][1];
    $.post('/vedoktashantiadmin/listmessages/1',
    {
        from_date:from_date,to_date:to_date,search_text:search_text,wild:wild,search_col:search_col,
        fstatus:fstatus,order_by:order_by,dir:dir,app:app,guests:guests,purpose:purpose
    },
        function(res)
        {
            var r=$.parseJSON(res);
            if(r.flag==1)
            {
                window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
            }
            if(r.flag==2)
            {
                showNotification("ruby","Sorry! You have already requested the same report.");
            }
            if(r.flag==0)
            {
                showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
            }
            $(".loader_animation").hide();
        }
    );
});
</script>