<?PHP
$partHeader='Add Standard Reply';
if($id)
{
    $partHeader=htmlentities($standardreply_data->question);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Standard Replies | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
    $this->load->view("vedoktashanti/admin/nav_buttons");
?>
<h3 class="page-title">
    <?PHP
        echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="<?PHP echo base_url; ?>admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/vedoktashantiadmin/standardreplies">All Standard Replies</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("standardreply_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("standardreply_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Standard Reply created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("standardreply_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="standardreply_form" name="standardreply_form" method="post">
					<div class="form-group">
		                <label class="control-label">Standard Reply Category
		                </label>
		                <div class="form-content">
	                        <select name="standardreply_category"  class="form-control" >
                                <option value="">Select a Category</option>
                                <?PHP
                                foreach($categories as $ct)
                                {
                                    ?>
                                    <option value="<?PHP echo $ct->id; ?>"
                                    <?PHP
                                    if($id)
                                    if($ct->id==$standardreply_data->vedoktashanti_standard_replies_category) echo "selected";
                                    ?>
                                    ><?PHP echo $ct->category; ?></option>
                                   
                                    <?PHP
                                }
                                ?>
                              </select>
		                </div>
		            </div>

		            <div class="form-group">
		                <label class="control-label">Standard Reply
		                </label>
		                <div class="form-content">
                            <input type="text" class="form-control" name="standardreply" id="standardreply"
		                        value="<?PHP if($id) echo htmlentities($standardreply_data->question); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label">Answer
		                </label>
		                <div class="form-content">
                            <textarea class="form-control" name="answer" id="answer" rows="6"><?PHP 
		                        if($id) echo htmlentities($standardreply_data->answer); ?></textarea>
		                </div>
		            </div>
		            <div class="form-group">
						<div class="form-content">
							<button type="submit" name="add_standardreply" id="add_standardreply" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Standard Reply"; ?></button>
							<a href="/vedoktashantiadmin/standardreplies" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>


				</form>
			</div>
		</div>



    </div>
 
</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
				
$( document ).ready(function() 
{
    CKEDITOR.env.isCompatible = true;
    CKEDITOR.replace( 'answer',
    {
        height:'150px',
        toolbar :
            [
                { name: 'indent', items : [ 'Bold','Italic','Underline','Link','Unlink'] }
            ],
        enterMode: CKEDITOR.ENTER_BR,
    });

    CKEDITOR.on( 'dialogDefinition', function( ev ) {
        var dialogName = ev.data.name;
        var dialogDefinition = ev.data.definition;
        var dialog = ev.data.definition.dialog;
        if ( dialogName == 'image' || dialogName == 'link' || dialogName == 'iframe' ) {
            dialogDefinition.removeContents( 'advanced' );
            dialog.on('show', function () {
                if(dialogName != 'link')
                {
                    this.selectPage('Upload');
                }
            });
        }
    });

    CKEDITOR.instances["answer"].on("instanceReady", function () {
        //set keyup event
        this.document.on("keyup", function () { CKEDITOR.instances["answer"].updateElement(); $('#answer').valid(); });
        //and paste event
        this.document.on("paste", function () { CKEDITOR.instances["answer"].updateElement(); $('#answer').valid(); });
        //and cut event
        this.document.on("cut", function () { CKEDITOR.instances["answer"].updateElement(); $('#answer').valid(); });

    });
    
	$('#standardreply_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		 onkeyup: false,
       rules: {
            standardreply_category: {
                required: true
            },
			standardreply: {
                required: true,
                minlength:3,
                maxlength:100
				
            },
			answer: {
                required: true,
				minlength:10,
				maxlength:5000
            }
        },

        messages: {
            standardreply_category: {
                required: "Please select a category"
            },
			standardreply: {
                required: "Please enter Standard Reply"
				
            },
			answer: {
                required: "Please give answer"
				
            }
        },
    	highlight: function (element)
        {
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label, element)
        {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },
        errorPlacement: function (error, element)
        {
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });
});
</script>
