<input class="current-browser-title" data-title=" Admin Dashboard  | All Admin Users | Add Edit Admin User" type="hidden">
<?PHP
    $this->load->view("users/admin/users_nav_buttons");
?>
<h3 class="page-title">
	<?PHP
     if(!$id) echo "Add New Admin User";
    else
    {
        echo htmlentities($user_data->username);
	}
	?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="<?PHP echo base_url; ?>admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/usersadmin/adminusers">All Admin Users</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP if($id) echo htmlentities($user_data->username); else echo "Add New Admin User"; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("user_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("user_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Admin added successfully</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("user_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption">Add/Edit Admin User</div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="admin_form" name="admin_form" class="form-horizontal" method="post">

		            <div class="form-group">
		                <label class="control-label col-md-2">User ID
		                </label>
		                <div class="col-md-6">
		                <?PHP
		                if(!$id)
		                {
		                ?>
		                    <div class="input-icon right">
		                        <i class="fa"></i>
		                        <input type="text" class="form-control" name="username" id="username"
		                        value="<?PHP if($id) echo htmlentities($user_data->username); ?>">
		                    </div>
		                   	<?PHP
	                    }
	                    else
	                    {
	                    	echo htmlentities($user_data->username);
	                    	?>

	                    	<?PHP
	                    }
	                    ?>
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label col-md-2">Password
		                </label>
		                <div class="col-md-6">
		                    <div class="input-icon right">
		                        <i class="fa"></i>
		                        <input type="password" class="form-control" name="password" id="password">
		                    </div>
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label col-md-2">Confirm Password
		                </label>
		                <div class="col-md-6">
		                    <div class="input-icon right">
		                        <i class="fa"></i>
		                        <input type="password" class="form-control" name="rpassword" id="rpassword">
		                    </div>
		                </div>
		            </div>
		            <?PHP
		            if($id)
		            {
		            	?>
		            	<div class="alert alert-info">
		            		<b>Leave password fields empty if you don't want to update password.
		            	</div>
		            	<?PHP
		            }
		            ?>
		            <div class="form-group">
		                <label class="control-label col-md-2">Email ID
		                </label>
		                <div class="col-md-6">
		                    <div class="input-icon right">
		                        <i class="fa"></i>
		                        <input type="text" class="form-control" name="email" id="email"
		                        value="<?PHP if($id) echo htmlentities($user_data->email); ?>">
		                    </div>
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label col-md-2">First Name
		                </label>
		                <div class="col-md-6">
		                    <div class="input-icon right">
		                        <i class="fa"></i>
		                        <input type="text" class="form-control" name="firstname" id="firstname"
		                        value="<?PHP if($id) echo htmlentities($user_data->firstname); ?>">
		                    </div>
		                </div>
		            </div>

		            <div class="form-group">
		                <label class="control-label col-md-2">Last Name
		                </label>
		                <div class="col-md-6">
		                    <div class="input-icon right">
		                        <i class="fa"></i>
		                        <input type="text" class="form-control" name="lastname" id="lastname"
		                        value="<?PHP if($id) echo htmlentities($user_data->lastname); ?>">
		                    </div>
		                </div>
		            </div>

		            <div class="form-group">
		                <label class="control-label col-md-2">Roles
		                </label>
		                <div class="col-md-10">
		                    <div class="input-icon right">
		                        <i class="fa"></i>
		                        <?PHP
		                        if($id)
		                        $rolesArray=array_filter(explode(",",$user_data->roles));
		                        foreach ($roles as $role) 
		                        {
		                        	?>
		                        	<div class="col-md-3">
		                        		<label>
		                        			<input type="checkbox" value="<?PHP echo $role->id; ?>" name="roles[]"
		                        			<?PHP if($id && in_array($role->id,$rolesArray)) echo "checked"; ?>>
		                        			<?PHP echo $role->role; ?>
		                        		</label>
		                        	</div>
		                        	<?PHP
		                        }
		                        ?>
		                    </div>
		                </div>
		            </div>
	
		            <div class="form-group">
						<label class="col-md-2 control-label">
							
						</label>
						<div class="col-md-6">
							<button type="submit" name="add_admin" id="add_admin" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Admin"; ?></button>
							<a href="<?PHP echo URL_PREFIX; ?>usersadmin/adminusers" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>


				</form>
			</div>
		</div>



    </div>
 
</div>

<script type="text/javascript">
				
$( document ).ready(function() 
{			
	jQuery.validator.addMethod("usernameCheck", function(value, element) 
	{ 
		$.ajaxSetup({async: false});
		var rr=true;
		var rt=$.post('/usersadmin/usernamecheck', {username: value}, function(res) 
		{
			if(res==0)
			{
				rr=false;
			}
			$("#username").removeClass("spinner");
		});
		return rr;

	}, "Username already exists");
	jQuery.validator.addMethod("emailCheck", function(value, element) 
	{ 
		$.ajaxSetup({async: false});
		var rr=true;
		var rt=$.post('/usersadmin/emailcheck', {email: value,id:<?PHP echo $id; ?>}, function(res) 
		{
			if(res==0)
			{
				rr=false;
			}
			$("#username").removeClass("spinner");
		});
		return rr;

	}, "Email ID already exists");

			$('#admin_form').validate({
	            errorElement: 'label', //default input error message container
	            errorClass: 'help-inline', // default input error message class
	            focusInvalid: true, // do not focus the last invalid input
				 onkeyup: false,
	           rules: {
	           		username:
	           		{
	           			required:true,
	           			minlength:6,
	           			maxlength:50,
	           			usernameCheck:true
	           		},
	           		email:
	           		{
	           			required:true,
	           			minlength:6,
	           			maxlength:100,
	           			email:true,
	           			emailCheck:true
	           		},
	           		password:
	           		{
	           			<?PHP
			            if(!$id)
			            {
			            	?>
	           				required:true,
	           				<?PHP
	           			}
	           			?>
	           			minlength:6,
	           			maxlength:50
	           		},
	           		rpassword:
	           		{
	           			equalTo: "#password"
	           		},
	                firstname:
	                {
	                    required: true,
	                    minlength:3,
	                    maxlength:100
	                },
	                lastname:
	                {
	                	required:true,
	                	minlength:3,
	                	maxlength:100
	                }
	            },

	            messages: 
	            {
	            	username:
	                {
	                    required: "Please enter User ID"
	                },
	                email:
	                {
	                    required: "Please enter Email ID"
	                },
	                password:
	                {
	                    required: "Please enter Password"
	                },
	                rpassword:
	                {
	                    equalTo: "Passwords didn't match"
	                },
	                firstname:
	                {
	                    required: "Please enter First Name"
	                },
	                lastname:
	                {
	                    required: "Please enter Last Name"
	                }
	            },

	            invalidHandler: function (event, validator) 
	            {

	            },

	        	  highlight: function (element) { // hightlight error inputs
                    $(element)
                        .closest('.form-group').removeClass("has-success").addClass('has-error'); // set error class to the control group   
                },
				unhighlight: function (element) { // revert the change done by hightlight
                    
                },

	             success: function (label, element) {
                    var icon = $(element).parent('.input-icon').children('i');
                    $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
                    icon.removeClass("fa-warning").addClass("fa-check");
					label.remove();
                },

	             errorPlacement: function (error, element) { // render error placement for each input type
                    var icon = $(element).parent('.input-icon').children('i');
                    icon.removeClass('fa-check').addClass("fa-warning");  
                    icon.attr("data-original-title", error.text()).tooltip({'container': 'body'});
					error.addClass('help-small no-left-padding').insertAfter(element);
                }
	        });
	
});
	</script>
