<form id="subscribe_sms_form" novalidate="novalidate">
    <div class="form-group">
        <div class="controls" >
            <input type="text" name="subscribe_name2" class="form-control" 
            id="subscribe_name2" autocomplete="off" placeholder="Enter your Name">
         </div>
    </div>
    <div class="form-group">
        <div class="controls" >
            <input type="text" name="subscribe_phone" class="form-control"
            id="subscribe_phone" autocomplete="off" placeholder="Enter your Mobile Number">
         </div>
    </div>
    <div class="form-group">
        <div class="controls" >
            <select name="country_code" class="form-control" id="country_code">
            <option value="">Select Country</option>
            <?PHP
            $countries=$this->locations_model->getCountries();
            foreach ($countries as $country)
            {
                ?>
                <option value="<?PHP echo $country->country_code; ?>">
                    <?PHP echo $country->country_name." +".$country->isd_code; ?>
                </option>
                <?PHP
            }
            ?>
            </select>
         </div>
    </div>
    <div class="form-group">
        <div class="controls" >
            <input type="text" name="subscribe_city2" class="form-control"
            id="subscribe_city2" autocomplete="off" placeholder="Enter your City">
         </div>
    </div>
    <div class="form-group">
        <div class="controls" >
            <button type="submit" class="btn blue  btn-xs" id="subscribe-phone">
            <i class="fa fa-check"></i> Subscribe</button>
         </div>
    </div>
</form>
<script type="text/javascript">
    $(document).ready(function()
    {
        jQuery('#subscribe_sms_form').validate(
        {
            errorElement: 'span',
            errorClass: 'help-block help-block-error',
            focusInvalid: true,
            rules: 
            {
                subscribe_phone: 
                {
                    required: true,
                    digits:true,
                    minlength: 10,
                    maxlength:15,
                },
                country_code:
                {
                    required:true
                },
                subscribe_city2:
                {
                    required:true,
                    minlength:2,
                    name_validate13:true
                },
                subscribe_name2:
                {
                    required:true,
                    minlength:3,
                    maxlength:200
                }
            },

            messages:
            {
                subscribe_name2:
                {
                    required: "Please enter your Name"
                },
                country_code:
                {
                    required:'Please select Country'
                },
                subscribe_city2:
                {
                    required: "Please enter your City"
                },
                subscribe_phone:
                {
                    required: "Please enter your Mobile Number"
                }
            },
            highlight: function (element) 
            {
                $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
            },
            success: function (label,element) 
            {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
                label.remove();
                
            },
            errorPlacement: function (error, element) 
            {
                error.addClass('help-small no-left-padding').insertAfter(element);
            },
            submitHandler:function()
            {
                $("#subscribe-phone").prop("disabled",true);
                jQuery.post('/subscribe/phone',$("#subscribe_sms_form").serialize(), function(res) 
                {
                    var r=$.parseJSON(res);
                    if(r.flag==1)
                        showNotification("lime","You have subscribed successfully");
                    else
                        showNotification("ruby","You have already Subscribed");
                    $("#subscribe_name2").val('');
                    $("#subscribe_phone").val('');
                    $("#country_code").val('');
                    $("#subscribe_city2").val('');
                    $("#subscribe-phone").prop("disabled",false);
                },'html');
            }

        });
    });
</script>