<form id="subscribe_email_form" novalidate="novalidate">
    <div class="form-group">
        <div class="controls" >
            <input type="text" name="subscribe_name1" class="form-control" 
            id="subscribe_name1" autocomplete="off" placeholder="Enter your Name">
         </div>
    </div>

    <div class="form-group">
        <div class="controls" >
            <input type="text" name="subscribe_email" class="form-control"
            id="subscribe_email" autocomplete="off" placeholder="Enter your Email ID">
         </div>
    </div>
    <div class="form-group">
        <div class="controls" >
            <select name="country_code1" class="form-control" id="country_code">
            <option value="">Select Country</option>
            <?PHP
            $countries=$this->locations_model->getCountries();
            foreach ($countries as $country)
            {
                ?>
                <option value="<?PHP echo $country->country_code; ?>">
                    <?PHP echo $country->country_name." +".$country->isd_code; ?>
                </option>
                <?PHP
            }
            ?>
            </select>
         </div>
    </div>
    <div class="form-group">
        <div class="controls" >
            <input type="text" name="subscribe_city1" class="form-control"
            id="subscribe_city1" autocomplete="off" placeholder="Enter your City">
         </div>
    </div>
    <div class="form-group">
        <div class="controls" >
            <button type="submit" class="btn blue  btn-xs" id="subscribe-email">
            <i class="fa fa-check"></i> Subscribe</button>
         </div>
    </div>
</form>
<script type="text/javascript">
    $(document).ready(function()
    {
        jQuery('#subscribe_email_form').validate(
        {
            errorElement: 'span',
            errorClass: 'help-block help-block-error',
            focusInvalid: true,
            rules: 
            {
                subscribe_email: 
                {
                    required: true,
                    no_uppercase:true,
                    minlength: 6,
                    maxlength:200,
                    email_validate:true
                },
                subscribe_city1:
                {
                    required:true,
                    minlength:2,
                    name_validate13:true
                },
                country_code1:
                {
                    required:true
                },
                subscribe_name1:
                {
                    required:true,
                    minlength:3,
                    maxlength:200
                }
            },

            messages:
            {
                subscribe_name1:
                {
                    required: "Please enter your Name"
                },
                subscribe_city1:
                {
                    required: "Please enter your City"
                },
                country_code1:
                {
                    required:'Please select Country'
                },
                subscribe_email:
                {
                    required: "Please enter your Email ID"
                }
            },
            highlight: function (element) 
            {
                $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
            },
            success: function (label,element) 
            {
                $(element).closest('.form-group').removeClass('has-error');
                label.remove();
            },
            errorPlacement: function (error, element) 
            {
                error.addClass('help-small no-left-padding').insertAfter(element);
            },
            submitHandler:function()
            {
                $("#subscribe-email").prop("disabled",true);
                jQuery.post('/subscribe/email',$("#subscribe_email_form").serialize(), function(res) 
                {
                    var r=$.parseJSON(res);
                    if(r.flag==1)
                        showNotification("lime","You have subscribed successfully");
                    else
                        showNotification("ruby","You have already subscribed");
                    $("#subscribe_name1").val('');
                    $("#subscribe_city1").val('');
                    $("#country_code1").val('');
                    $("#subscribe_email").val('');
                    $("#subscribe-email").prop("disabled",false);
                },'html');
            }

        });
    });
</script>