<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | Search Logs" type="hidden">
<style type="text/css">
    @media only screen and (min-width: 992px) and (max-width: 1450px){
        .buttons{
            padding: 29px 0px 6px 0px;
        }
    }
</style>
<?PHP echo $this->general_model->help_link(); ?>
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<h3 class="page-title">
    Search Logs
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
            Search Logs
        </li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->
<div class="row-fluid">
    <form action="" method="get" name="list_of_categories" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form">
        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="input-inline form-control custom-input" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                <option value="keyword">Keyword</option>
                <option value="module">Module(s)</option>
                <option value="username">User ID</option>
                <option value="ip_address">IP Addresss</option>
            </select>
        </div>
        <div class="col-md-2" style="display:none">
            <select name="wild" id="wild" class="input-inline form-control custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts with</option>
                <option value="ends">Ends with</option>
            </select>
        </div>
        <div class="col-md-2">
            
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="from_date" id="from_date"
            placeholder="From date"/>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="to_date" id="to_date"
            placeholder="To date" />
        </div>
        <div class="buttons">
            <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
            onClick="search(0)"><i class="fa fa-search"></i> Search</button>
            <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
            style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
            <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
        </div>
    </form>
    <br class="hidden-lg hidden-md">

    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption">Search Logs  <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
            
        </div>
        
        <div class="portlet-body no-more-tables">
        
            <table id="search_logs_table" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                <thead>
                    <tr>
                        <th>S. No.</th>
                        <th>Keyword</th>
                        <th>Module(s)</th>
                        <th>User ID</th>
                        <th>Date</th>
                        <th>IP Address</th>
                    </tr>
                </thead>
                
            </table>

        </div>
    </div>
</div>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-editable/bootstrap-editable/js/bootstrap-editable.min.js"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var search_text = '';
var search_col = '';
var wild = '';
var table = '';
var from_date = '';
var to_date = '';
function search(flag) 
{
    clearNotifications();
    if(!$("#from_date").length || !$("#to_date").length || !$("#search_text").length || !$("#search_col").length ||
            !$("#wild").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {  
        if ($("#from_date").length && $("#to_date").length && $("#search_text").length && 
            $("#from_date").val().trim() == '' && $("#to_date").val().trim() == '' && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords or select dates');
            return false;
        }
        if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
        {
            var frm=Date.parse($("#from_date").val());
            var to=Date.parse($("#to_date").val());
            if(frm>to)
            {
                showNotification('ruby','From date cannot be after To date');
                return false
            }
        }
    }

    $(".dataTables_processing").show();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#search_col").length)
        search_col = $("#search_col").val().trim();
    if($("#wild").length)
        wild = $("#wild").val().trim();
    if($("#from_date").length)
            from_date = $("#from_date").val().trim();
        if($("#to_date").length)
            to_date = $("#to_date").val().trim();
    if (from_date != '' || to_date != '' || search_text != '')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();
}
function search_clear() 
{
    $(".dataTables_processing").show();
    $("#from_date").val('');
    from_date = '';
    $("#to_date").val('');
    to_date = '';
    $("#search_text").val('');
    search_text = '';
    search_col = '';
    wild = '';
    $("#searchClear").css("display", "none");
    table.fnDraw();
}
var statusflag=0;

$(document).ready(function()
{
    $.fn.editable.defaults.mode = 'inline';
    $.fn.editable.defaults.inputclass = 'form-control';
    $.fn.editableform.buttons = '<button type="submit" disabled class="btn btn-xs blue editable-submit"><i class="fa fa-check"></i> Save</button>';
    $.fn.editableform.buttons += '<button type="button" class="btn btn-xs red editable-cancel"><i class="fa fa-remove"></i> Cancel</button>';
    $("#search_text").val('');
    $("#wild").val($("#wild option:first").val());
    $("#search_col").val($("#search_col option:first").val());

    table = $('#search_logs_table').dataTable({
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [4, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
        },
        "columns": [
        {
            "width": "60",
            "orderable": false
        }, {
            name: "keyword",
            "orderable": true
        }, {
            name: "module",
            width:"25%",
            "orderable": false
        }, {
            name: "username",
            width:"20%",
            "orderable": true
        }, {
            name: "date",
            width:"15%",
            "orderable": true
        }, {
            name: "ip_address",
            width:"11%",
            "orderable": false
        }],
        "ajax": {
            url: '/server_logs/listsearchlogs',
            type: 'POST',
            data: function(d) 
            {
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                if (status != '' && $.isNumeric(status)) 
                {
                    d.status = status;
                }
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
                d.wild = wild;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Keyword");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "User ID");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Module(s)");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Date");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
                $('td:eq(' + ii + ')', nRow).attr('data-title', "IP Address");
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                return row.keyword;
            },
            "targets": 1
        }, {
            "render": function(data, type, row) 
            {
                return row.module;
            },
            "targets": 2
        }, {
            "render": function(data, type, row) 
            {
                if(row.username!=null && row.username!='')
                return  "<a href='/usersadmin/view/" + row.username + "' target='_blank'>"+row.username + '</a>';
                else
                return '-';
            },
            "targets": 3
        }, {
            "render": function(data, type, row) 
            {
                return row.date;
            },
            "targets": 4
        }, {
            "render": function(data, type, row) 
            {
                return row.ip_address;
            },
            "targets": 5
        }]
    });
});
$("#excelButton").on("click",function()
{
    $(".loader_animation").show();
    clearNotifications();
    var sortindex=table.fnSettings().aaSorting[0][0];
    var order_by=table.fnSettings().aoColumns[sortindex].name;
    var dir=table.fnSettings().aaSorting[0][1];
    $.post('/server_logs/listsearchlogs/1',
    {
        from_date:from_date,to_date:to_date,search_text:search_text,wild:wild,search_col:search_col,order_by:order_by,dir:dir
    },
        function(res)
        {
            var r=$.parseJSON(res);
            if(r.flag==1)
            {
                window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
            }
            if(r.flag==2)
            {
                showNotification("ruby","Sorry! You have already requested the same report.");
            }
            if(r.flag==0)
            {
                showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
            }
            $(".loader_animation").hide();
        }
    );
});
</script>