<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | Satsangs Admin | All Satsangs" type="hidden">
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
    $this->load->view("satsangs/admin/nav_buttons");
?>
<h3 class="page-title">
All Satsangs
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>All Satsangs</li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->

<div class="row-fluid">
    <div class="alert alert-info">
        <strong>Satsangs public URL:</strong>
        <a href="<?php echo base_url. "satsangs"; ?>" target="_blank">
        <?php echo base_url . "satsangs"; ?></a>
    </div>
    <form action="" method="get" name="" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form">
        
        <div class="col-md-2">
            <select name="country" id="country" onChange="search(1)" class="form-control input-inline custom-input">
                <option value="">All Countries</option>
                <?PHP
                foreach ($satsangs_countries as $satsangCountry)
                {
                    ?>
                    <option value="<?PHP echo $satsangCountry->country_id; ?>"><?PHP echo $satsangCountry->country_name." +".$satsangCountry->isd_code; ?></option>
                    <?PHP
                }
                ?>
            </select>
        </div>
        <br style="clear:both;" class="hidden-sm hidden-xs">
        
        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="input-inline form-control custom-input" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                <option value="name">Satsang Name</option>
                <option value="state_name">State</option>
                <option value="city">City</option>
                <option value="contact_person">Contact Person</option>
            </select>
        </div>
        <div class="col-md-2" style="display:none">
            <select name="wild" id="wild" class="input-inline form-control custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts with</option>
                <option value="ends">Ends with</option>
            </select>
        </div>
        
        <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
        onClick="search(0)"><i class="fa fa-search"></i> Search</button>
        <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
        style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
        <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
    </form>
    <br class="hidden-lg hidden-md">
    
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption"> <i class="fa fa-list"></i> All Satsangs <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
        </div>
        
        <div class="portlet-body no-more-tables">
            <div class="col-md-12 nopadding column-buttons">
                <a href="javascript:;" data-column="3" class="columnhide btn btn-xs blue">Contact Person</a>
                <a href="javascript:;" data-column="4" class="columnhide btn btn-xs blue">Country</a>
                <a href="javascript:;" data-column="5" class="columnhide btn btn-xs red">State</a>
                <a href="javascript:;" data-column="6" class="columnhide btn btn-xs red">City</a>
                <div style="clear:both;"></div>
            </div>
                <table id="stable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Satsang ID</th>
                            <th>Satsang Name</th>
                            <th>Contact Person</th>
                            <th>Country</th>
                            <th>State</th>
                            <th>City</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    
                </table>
            <div style="clear:both;"></div>
        </div>
    </div>

    <div class="alert alert-info">
        <span class="label label-danger">Note:</span><br><br>

        <span style="color:red">* To delete a Satsang, please contact the Admin.</span>
        <div class="margin-bottom-20"></div>

        * Please create following Email IDs in CPanel when a new Satsang is added<br>
        Satsang Newsletter Service: newsletter_s_{id}<br>
        Email ID: noreply-newsletter-s{id}<?PHP echo email_domain; ?><br>
        <div class="margin-bottom-20"></div>

        * If a Satsang name is changed, need to change the same in Email Settings<br>
        <a href="<?PHP echo base_url; ?>website_settings/email_settings"><?PHP echo base_url; ?>website_settings/email_settings</a>

    </div>
</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type = "text/javascript">
    
    var search_text = '';
    var search_col = '';
    var wild = '';
    var table = '';
    var country='';
    function search(flag) 
    {
        clearNotifications();
         if(!$("#search_text").length || !$("#search_col").length || !$("#wild").length)
        {
            showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
            return;
        }
        if (flag == 0)
        {  
            if ($("#search_text").length && $("#search_text").val().trim() == '') 
            {
                showNotification('ruby','Please enter search keywords');
                return false;
            }
        }
        $(".dataTables_processing").show();
        if($("#search_text").length)
            search_text = $("#search_text").val().trim();
        if($("#search_col").length)
            search_col = $("#search_col").val().trim();
        if($("#wild").length)
            wild = $("#wild").val().trim();
        if($("#country").length)
            country = $("#country").val();

        if (search_text != '')
            $("#searchClear").css("display", "inline-block");
        
        table.fnDraw();

    }

    function search_clear() 
    {
        $(".dataTables_processing").show();
        $("#search_text").val('');
        search_text = '';
        search_col = '';
        wild = '';
        $("#searchClear").css("display", "none");
        country='';
        $("#country").val('');
        table.fnDraw();
    }

    var statusflag=0;
    function deleteDyc(id)
    {
        if(statusflag==1)
            return false;
        statusflag=1;
        $(".dataTables_processing").show();
        $.post('/satsangsadmin/delete/' + id , {}, function(res) 
        {
            if(res=='login')
            {
                window.location="<?PHP echo base_url; ?>"
            }
            if(res=='access_denied')
            {
                showNotification('ruby',"Access Denied");
                $(".dataTables_processing").hide();
                $("#ashram" + id).modal('toggle');
                statusflag=0;
                return;
            }
            var r = $.parseJSON(res);
            $(".dataTables_processing").hide();
            if (r.flag == 1) 
            {
                table.fnSettings.bResetDisplay  =false;
                table.fnDraw(table.fnSettings);
                showNotification('ruby', "Satsang '" + r.name + "' has been deleted successfully ");
            }
            else
            {
                showNotification("ruby", "Error occured. Please try again.");
            }
            $("#ashram" + id).modal('toggle');
            statusflag=0;
        });
    }
    $(document).ready(function()
    {
        $("#search_text").val('');
        $("#country").val($("#country option:first").val());
        $("#wild").val($("#wild option:first").val());
        $("#search_col").val($("#search_col option:first").val());

        table = $('#stable').dataTable({
            "processing": true,
            "language": {
                "sProcessing": '<div class="spinnerspin"></div>',
                "emptyTable": "No records found!"
            },
            "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
            "sPaginationType": "bootstrap",
            "serverSide": true,
            "iDisplayLength": 50,
            "order": [
                [1, "asc"]
            ],
            "responsive": true,
            "lengthMenu": [
                [20, 50, 100],
                [20, 50, 100]
            ],
            "drawCallback": function(settings) 
            {
                var api = this.api();
                var totalrows = api.rows({
                    page: 'current'
                }).data().context[0]._iRecordsTotal;
                $("#total_records").html('(' + totalrows + ')');
                $('.tooltips').tooltip();
            },
            "columns": [
            {
                "width": "5%",
                "orderable": false
            }, {
                name: "id",
                "width": "10%",
                "orderable": true
            }, {
                name: "name",
                "orderable": true
            }, {
                "width": "15%",
                "orderable": false
            }, {
                name: "country_name",
                "width": "12%",
                "orderable": false
            }, {
                name: "state_name",
                "width": "12%",
                "orderable": false
            }, {
                name: "city",
                "width": "12%",
                "orderable": false
            }, {
                width: "10%",
                "orderable": false
            }],
            "ajax": {
                url: '/satsangsadmin/listc',
                type: 'POST',
                data: function(d) 
                {
                    d.search_text = search_text;
                    d.search_col = search_col;
                    d.country = country;
                    d.wild = wild;
                },
                error: function (xhr, error, thrown) 
                {
                    if(xhr.responseText=='login')
                    {
                        window.location="<?PHP echo base_url; ?>"
                    }
                    else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                    {
                       showNotification('ruby',"Invalid request");
                    }
                    $(".dataTables_processing").hide();
                    return false;
                },
                dataSrc:function(res)
                {
                    if(res.data.length==0 && res.recordsTotal!=0)
                    {
                        table.fnDraw();
                    }
                    return res.data;
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                var vis = true;
                var ii = 0;
                var sno = 0;

                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Satsang ID");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Satsang Name");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Contact Person");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Country");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "State");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "City");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible())
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
                return nRow;
            },
            "columnDefs":
            [
                {
                    "render": function(data, type, row) {
                        return row.sno;
                    },
                    "targets": 0
                }, {
                    "render": function(data, type, row) 
                    {
                        return row.id;
                    },
                    "targets": 1
                }, {
                    "render": function(data, type, row) 
                    {
                        var str = '';
                        str += "<a href='/satsangsadmin/add_edit_satsang/" + row.id + "' target='_blank'>"+row.name + '</a>';
                        return str;
                    },
                    "targets": 2
                }, {
                    "render": function(data, type, row) 
                    {
                        return row.contact_person;
                    },
                    "targets": 3
                }, {
                    "render": function(data, type, row) {
                        return row.country_name;
                    },
                    "targets": 4
                }, {
                    "render": function(data, type, row) {
                        return row.state_name;
                    },
                    "targets": 5,
                    'bVisible':false
                }, {
                    "render": function(data, type, row) {
                        return row.city;
                    },
                    "targets": 6,
                    'bVisible':false
                }, {
                    "render": function(data, type, row) 
                    {
                        var str = '<div class="btn-group" id="actions' + row.id + '">' +
                            '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                            '<i class="fa fa-angle-down"></i></a>' +
                            '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                            '<li><a href="/satsangsadmin/add_edit_satsang/' + row.id + '" target="_blank"><i class="fa fa-pencil"></i> Edit</a></li>'+
                            '</div>';

                        return str;
                    },
                    "targets": 7
                }
            ]
        });
        $('.columnhide').on('click', function(e) 
        {
            var column = table.api().column( $(this).attr('data-column') );
            var cnum=$(this).attr('data-column');
            
            column.visible( ! column.visible(),true );
            var bVis = table.fnSettings().aoColumns[cnum].bVisible;
            var title = table.fnSettings().aoColumns[cnum].sTitle;
            
            var visibility=table.api().column(cnum).visible();
            table.api().column(cnum).nodes().to$().attr("data-title",title);
            if (visibility == false) 
            {
                $(this).removeClass('blue').addClass('red');
            }
            else 
            {
                $(this).removeClass('red').addClass('blue');
            }
        });
    });
    $("#excelButton").on("click",function()
    {
        $(".loader_animation").show();
        clearNotifications();
        var sortindex=table.fnSettings().aaSorting[0][0];
        var order_by=table.fnSettings().aoColumns[sortindex].name;
        var dir=table.fnSettings().aaSorting[0][1];
        $.post('/satsangsadmin/listc/1',
        {
            country:country,search_text:search_text,wild:wild,search_col:search_col,
            order_by:order_by,dir:dir
        },
            function(res)
            {
                var r=$.parseJSON(res);
                if(r.flag==1)
                {
                    window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
                }
                if(r.flag==2)
                {
                    showNotification("ruby","Sorry! You have already requested the same report.");
                }
                if(r.flag==0)
                {
                    showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
                }
                $(".loader_animation").hide();
            }
        );
    });
</script>