<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" User Dashboard | My Reminders | All Reminders" type="hidden">
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<h3 class="page-title">
All Reminders
<?PHP
    $this->load->view("reminders/user/nav_buttons");
?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/myaccount">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
        	All Reminders
        </li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->
<div class="row-fluid">
    <form action="" method="get" name="" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form">
        
        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="input-inline form-control custom-input" style="border:1px solid skyblue;" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                <option value="title">Reminder Title</option>
            </select>
        </div>
       <!--  <div class="col-md-2">
            <select name="wild" id="wild" class="input-inline form-control custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts with</option>
                <option value="ends">Ends with</option>
            </select>
        </div> -->
        
        <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
        onClick="search(0)"><i class="fa fa-search"></i> Search</button>
        <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
        style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
    </form>
    <br class="hidden-lg hidden-md">

   <div class="portlet box blue">
		<div class="portlet-title">
			<div class="caption">All Reminders <span id="total_records"></span></div>
			<div class="tools">
				<a href="javascript:;" class="collapse"></a>
			</div>
            
		</div>
        
		<div class="portlet-body no-more-tables">
        
            <table id="rtable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Reminder Title </th>
                            <th>Reminder Time</th>
                            <th>Remind Before (Min)</th>
                            <th>Timezone</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    
                </table>
            
            <div style="clear:both;"></div>
        
       
        </div>
   </div>
   
   
</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var search_text = '';
var search_col = '';
var table = '';
function applyFilter(ele) 
{
    table.fnDraw();
}
function search(flag) 
{
    clearNotifications();
    if(!$("#search_text").length || !$("#search_col").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {
        if ($("#search_text").length && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords or select dates');
            return false;
        }
    }
    $(".dataTables_processing").show();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#search_col").length)
        search_col = $("#search_col").val().trim();
    if (search_text != '')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();
}
function search_clear() 
{
    $(".dataTables_processing").show();
    $("#search_text").val('');
    search_text = '';
    search_col = '';
    $("#searchClear").css("display", "none");
    table.fnDraw();
}
var statusflag=0;
$(".delete-button").live("click",function()
{
    if(statusflag==1)
        return false;
    statusflag=1;
    var pid=$(this).attr("data-id");
    $(".dataTables_processing").show();
    $.post('/myreminders/delete/'+ pid, {}, function(res) 
    {
        var r = $.parseJSON(res);
        if (r.flag == 1) 
        {
            table.fnSettings.bResetDisplay  =false;
            table.fnDraw(table.fnSettings);
            showNotification('ruby', "Reminder '" + r.title + "' deleted successfully.");
        }
        else 
        {
            showNotification("ruby", "Error occured. Please try again.");
        }
        $("#reminder"+pid).modal("toggle");
        $(".dataTables_processing").hide();
        statusflag=0;
    });
});
$(document).ready(function()
{
    $("#search_text").val('');
    $("#search_col").val($("#search_col option:first").val());

    table = $('#rtable').dataTable({
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "order": [
            [2, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [10, 20],
            [10, 20]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            $('.tooltips').tooltip();
            $("#checkall").prop('checked', false);
        },
        "columns": [
        {
            "width": "7%",
            "orderable": false
        }, {
            name: "title",
            "width": "15%",
            "orderable": true
        }, {
            name:"reminder_time",
            "width": "20%",
            "orderable": true
        }, {
            name: "alarm_before",
            "width": "12%",
            "orderable": false
        }, {
            name: "timezone",
            "width": "12%",
            "orderable": false
        }, {
            width: "7%",
            "orderable": false
        }],
        "ajax": {
            <?PHP
                $tableUrl="/myreminders/listc";
            ?>
            url: '<?PHP echo $tableUrl; ?>',
            type: 'POST',
            data: function(d) 
            {
                if (status != '' && $.isNumeric(status)) 
                {
                    d.status = status;
                }
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Reminder Title");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Reminder Time");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Before (Min)");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Timezone");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                var str = '';
                str += "<a href='/myreminders/add_edit_reminder/" + row.id + "' target='_blank'>"+row.title + '</a>';
                return str;
            },
            "targets": 1
        }, {
            "render": function(data, type, row) 
            {
                var str = row.reminder_time;
                return str;
            },
            "targets": 2
        }, {
            "render": function(data, type, row) 
            {
                var str=row.alarm_before+" Minutes";
                return str;
            },
            "targets": 3
        }, {
            "render": function(data, type, row) 
            {
                var str=row.timezone;
                return str;
            },
            "targets": 4
        }, {
            "render": function(data, type, row) 
            {
                var str = '<div class="btn-group" id="actions' + row.id + '">' +
                    '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                    '<i class="fa fa-angle-down"></i></a>' +
                    '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                    '<li><a href="/myreminders/add_edit_reminder/' + row.id + '" target="_blank"><i class="fa fa-eye"></i> Edit</a></li>';
        
                str += '<li><a href="#reminder' + row.id + '" role="button" data-toggle="modal">' +
                    '<i class="fa fa-trash-o"></i> Delete</a></li>' +

                    '<div id="reminder' + row.id + '" class="modal fade" tabindex="-1">' +
                    '<div class="modal-header">' +
                    '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                    '<h4 class="modal-title">Delete Confirmation</h4>' +
                    '</div>' +
                    '<div class="modal-body"><div class="pull-left delete-confirmation-icon"' +
                    '><i class="fa fa-exclamation-triangle"></i></div>' +
                    'Do you really want to delete the Reminder: ' +
                    '<span style="color:red; font-weight:bold;">' + row.title + '</span>?' +
                    '</div>' +
                    '<div class="modal-footer">' +
                    '<button type="button" data-dismiss="modal" class="btn btn-xs close' + row.id + '">' +
                    '<i class="fa fa-remove"></i> Cancel</button>' +
                    '<a class="btn btn-xs red delete-button" data-id="'+row.id+'">' +
                    '<i class="fa fa-trash"></i> Delete</a>' +
                    '</div>' +
                    '</div>';

                return str;
            },
            "targets": 5
        }]
    });
    $('.columnhide').on('click', function(e) 
    {
        var column = table.api().column( $(this).attr('data-column') );
        var cnum=$(this).attr('data-column');
        
        column.visible( ! column.visible(),true );
        var bVis = table.fnSettings().aoColumns[cnum].bVisible;
        var title = table.fnSettings().aoColumns[cnum].sTitle;
        
        var visibility=table.api().column(cnum).visible();
        table.api().column(cnum).nodes().to$().attr("data-title",title);
        if (visibility == false) 
        {
            $(this).removeClass('blue').addClass('red');
        }
        else 
        {
            $(this).removeClass('red').addClass('blue');
        }
    });
});
</script>  