<link rel="stylesheet" type="text/css" href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css"/>
<?PHP
$partHeader='Add Reminder';
if($id)
{
    $partHeader=htmlentities($reminderData->title);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | My Reminders | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
	$this->load->view("reminders/admin/nav_buttons");
?>
<h3 class="page-title">
    <?PHP
    	echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/reminders">All Reminders</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("reminder_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("reminder_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Reminder created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("reminder_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Reminder saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="r_form" name="r_form" method="post">
				<div class="row">
				<div class="col-md-6">

		            <div class="form-group">
		                <label class="control-label">Reminder Title
		                </label>
		                <div class="form-content">
		                        <input type="text" class="form-control" name="title" id="title"
		                        value="<?PHP if($id) echo htmlentities($reminderData->title); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label">Timezone
		                </label>
		                <div class="form-content">
		                        <?PHP
								$selectedzone='Asia/Kolkata';
								function tz_list()
								{
									$zones_array = array();
									$timestamp = time();
									foreach(timezone_identifiers_list() as $key => $zone) {
									date_default_timezone_set($zone);
									$zones_array[$key]['zone'] = $zone;
									$zones_array[$key]['diff_from_GMT'] = 'UTC/GMT ' . date('P', $timestamp);
									$zones_array1['zone'][$key] = $zone;
									$zones_array1['diff_from_GMT'][$key] = 'UTC/GMT ' . date('P', $timestamp);
									}
									asort($zones_array1['diff_from_GMT']);
									return $zones_array1;
								}
								$tz=tz_list();

								?>
								<select name="timezone" id="timezone"  class="form-control">
									<option value="">Select Timezone</option>
									<?php
									foreach($tz['diff_from_GMT'] as $key=>$t)
									{
										?>
										<option value="<?php print $tz['zone'][$key]; ?>"
										<?PHP
										if($id && $reminderData->timezone==$tz['zone'][$key]) echo "selected";
										?>>
										<?php print $t . ' - ' . $tz['zone'][$key]; ?>
										</option>
										<?php
									}
									?>
								</select>
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label">Reminder Date
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control datepickerclass" name="reminder_date" id="reminder_date"
		                        value="<?PHP if($id) echo date("d M Y",strtotime($reminderData->reminder_time)); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label">Reminder Time
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control timepicker-default" name="reminder_time" id="reminder_time"
		                        value="<?PHP if($id) echo date("h:i A",strtotime($reminderData->reminder_time)); else echo date("h:i A"); ?>">
		                </div>
		            </div>
					<div class="form-group">
		                <label class="control-label">Remind Before  <span style="color:red;">(Minutes)</span>
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control" name="remind_before" id="remind_before"
		                        value="<?PHP if($id) echo $reminderData->alarm_before; ?>">
		                </div>
		            </div>
		            <div class="form-group">
						<div class="form-content">
							<button type="submit" name="add_reminder" id="add_reminder" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Reminder"; ?></button>
							<a href="/reminders" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>
				</div>
				</div>


				</form>
			</div>
		</div>



    </div>
 
</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/jstz.js"></script>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js"></script>
<script type="text/javascript">
		
$( document ).ready(function() 
{
	var timezone = jstz.determine();
	var tz=timezone.name();
	$(".datepickerclass").datepicker(
   	{
		format: 'dd M yyyy'
   	});

	$('.datepickerclass').datepicker('setStartDate','<?PHP echo date("d M Y",strtotime("-1 Day")); ?>');
	<?PHP
	if(!$id)
	{
		?>
		$("#timezone").val(tz)
		<?PHP
	}
	?>
	$('.timepicker-default').timepicker(
	{
		defaultTime:false
	});
	jQuery.validator.addMethod("maxval", function(value, element) 
	{ 
       if(value>59)
	   return false
	   else return true

	}, "Max value is 59");
	jQuery.validator.addMethod("minval", function(value, element) 
	{ 
       if(value<0)
	   return false
	   else return true

	}, "Min value 0 to be entered");
	$('#r_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules:
       	{
            title: {
                required: true,
                minlength:2,
                maxlength:100
            },
			timezone: 
			{
				required:true
            },
			reminder_date: 
			{
				required:true
            },
            reminder_time: 
			{
				required:true
            },
            remind_before:
            {
            	required:true,
            	digits:true,
            	maxval:true,
				minval:true
            }
        },

        messages: {
            title: {
                required: "Please enter Reminder Title"
            },
            timezone: {
                required: "Please select Timezone"
            },
            reminder_date: {
                required: "Please select Date"
            },
            reminder_time: {
                required: "Please select Time"
            },
            remind_before: {
                required: "Please enter Minutes"
            }
        },

    	highlight: function (element) { // hightlight error inputs
            $(element)
                .closest('.form-group').removeClass("has-success").addClass('has-error'); // set error class to the control group   
        },
        success: function (label, element)
        {
            var icon = $(element).parent('.input-icon').children('i');
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            icon.removeClass("fa-warning").addClass("fa-check");
			label.remove();
        },

        errorPlacement: function (error, element) { // render error placement for each input type
            var icon = $(element).parent('.input-icon').children('i');
            icon.removeClass('fa-check').addClass("fa-warning");  
            icon.attr("data-original-title", error.text()).tooltip({'container': 'body'});
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });

});
	</script>
