<?PHP
$partHeader='Add Release';
if($id)
{
    $partHeader=htmlentities($releaseData->name);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Peetham Releases | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
	$this->load->view("releases/admin/nav_buttons");
?>
<h3 class="page-title">
	<?PHP
	    echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/releasesadmin">All Releases</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("release_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("release_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Release created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("release_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="release_form" name="release_form" method="post">

		            <div class="form-group">
		                <label class="control-label">Name
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control" name="name" id="name"
		                        value="<?PHP if($id) echo htmlentities($releaseData->name); ?>">
		                </div>
		            </div>

		            <div class="row">
		            	<div class="col-md-6">

				            <div class="form-group">
				                <label class="control-label">Type
				                </label>
				                <div class="form-content">
				                    <select name="type" id="type" class="form-control input-inline">
					                    <?PHP
						                foreach ($this->types as $tp)
						                {
						                    ?>
						                    <option
						                    <?PHP
						                    if($id && $releaseData->type==$tp) echo "selected";
						                    ?>
						                    >
						                        <?PHP echo htmlentities($tp); ?>
						                    </option>
						                    <?PHP
						                }
						                ?>
				                    	
				                    </select>
				                </div>
				            </div>
				        </div>
				        <div class="col-md-6">
				            <div class="form-group">
				                <label class="control-label">Date
				                </label>
				                <div class="form-content">
				                    <input type="text" class="form-control datepickerclass input-inline" name="date" id="date"
				                        value="<?PHP if($id) echo date("d M Y",strtotime($releaseData->date)); ?>">
				                </div>
				            </div>
				        </div>
				    </div>

		            <div class="form-group">
		                <div class="form-content">
		                	<label>
		                    	<input type="checkbox" name="display_year"  id="display_year"
			                     	<?PHP if($id && $releaseData->display_year==1) echo "checked"; else if(!$id) echo "checked"; ?>
	                             	style="vertical-align:top;" /> Display only year when checked
                            </label>
		                </div>
		            </div>

		            <div class="form-group">
		                <div class="form-content">
		                	<label>
		                    	<input type="checkbox" name="mark_new" id="mark_new" 
			                     	<?PHP if($id && $releaseData->mark_new==1) echo "checked"; else if(!$id) echo "checked"; ?>
	                             	style="vertical-align:top;" /> Mark as New
                            </label>
		                </div>
		            </div>
		            

		            <div class="form-group">
		                <label class="control-label">Description
		                </label>
		                <div class="form-content">
		                    <textarea class="form-control" name="description" id="description" rows="6"><?PHP 
		                        if($id) echo $releaseData->description; ?></textarea>
		                </div>
		            </div>

		            
		            <div class="form-group">
						<div class="form-content">
							<button type="submit" name="save_release" id="save_release" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Release"; ?></button>
							<a href="/releasesadmin" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>


				</form>
			</div>
		</div>



    </div>
 
</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
CKEDITOR.env.isCompatible = true;
CKEDITOR.replace( 'description',
{
    height:'300px',
    toolbar :
        [
    { name: 'indent', items : [ 'Bold','Italic','Underline','NumberedList','BulletedList','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock','Link','Unlink'] }
        ]
});
$( document ).ready(function() 
{
	$('#release_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules: {
            name: {
                required: true,
                minlength:6,
                maxlength:200
            },
            date:
            {
            	required:true
            }
        },

        messages:
        {
            name:
            {
                required: "Please enter Release Name"
            },
            date:
            {
                required: "Please choose Date"
            }
        },
    	highlight: function (element)
    	{
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error'); // set error class to the control group   
        },
        success: function (label, element)
        {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },

        errorPlacement: function (error, element) { // render error placement for each input type
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });

});
</script>
