
<input class="current-browser-title" data-title="Register Online" type="hidden">
<div class="page-content">
	<!-- BEGIN PAGE HEADER-->
	<h3 class="page-title">
		<div class="left-block">
	        <i class="icomoon-clipboard"></i>
	        <span class="top-line">
	            Register Online
	        </span>
	        <br>
	        <span class="caption">
	            Register for events
	        </span>
	    </div>
        <div class=" hidden-sm hidden-xs right-block">
            <?PHP echo site_name_string1; ?> - Register for events
        </div>
    </h3>
    <div class="clearfix"></div>
	<div class="page-bar">
		<ul class="page-breadcrumb">
			<li>
				<a href="<?PHP echo base_url; ?>">Home</a>
				<i class="fa fa-angle-right"></i>
			</li>
			<li class="active">
           		Register Online
            </li>
		</ul>
	</div>
	<!-- END PAGE HEADER-->
	<?PHP
	$name='';
	$email='';
	
	if($this->session->userdata('user_id'))//if user && override admin
	{
	    $name=$this->session->userdata('user_data')->firstname." ".$this->session->userdata('user_data')->lastname;
	    $email=$this->session->userdata('user_data')->email;
	}
	if($GLOBALS['site_settings']['registration_form']==0)
	{
		?>
		<div class="breaking-news">
            <div class="breaking-title" style="width: 100%;">
                <h3 style="text-transform: none;">Jaya Guru Datta. Registration Form is currently unavailable.</h3>
            </div>
            <div class="clearfix"></div>
        </div>
		<?PHP
	}
	?>
	
	<div class="row">
		<div class="col-md-9">
		
		<form class="registration_form form-horizontal" novalidate style="padding:10px; border:1px solid #c3c3c3;">
			<div class="row">
				<div class="col-md-6">
					<div class="form-group">
			            <label class="control-label" style="text-align:left;">Name <span class="required">*</span></label>
			            <div class="controls" >
			                <input type="text" name="name" class="form-control"
			                value="<?PHP echo htmlentities($name); ?>" 
			                id="name" autocomplete="off" placeholder="Enter your Name">
			             </div>
			        </div>
			    </div>
			   	<div class="col-md-6">
			        <div class="form-group">
			            <label class="control-label" style="text-align:left;">Email ID <span class="required">*</span></label>
			            <div class="controls" >
			                <input type="text" name="email" class="form-control" id="email"
			                value="<?PHP echo htmlentities($email); ?>" placeholder="Enter your Email ID">
			            </div>
			        </div>
			    </div>
			</div>
			<div class="row">
				<div class="col-md-6">
			        <div class="form-group">
			            <label class="control-label" style="text-align:left;">Phone <span class="required">*</span></label>
			            <div class="row">
		                	<div class="col-md-3 col-sm-3 col-xs-3">
		                		<div class="controls" >
		                        <input type="hidden" name="country" id="country" value="IN">
			                        <div class="btn-group" style="display: block;">
			                            <button class="btn btn-default dropdown-toggle" id="cnt-country-code-button" type="button" data-toggle="dropdown" aria-expanded="false" style="width: 100%; text-align: left;">
			                            +91
			                            </button>
			                            <ul class="dropdown-menu" role="menu" style="max-height: 150px; overflow: auto; margin-top: 35px;">
			                                <?PHP
			                                $countries=$this->locations_model->getCountries();
			                                foreach ($countries as $country)
			                                {
			                                    ?>
			                                    <li data-code="<?PHP echo $country->country_code; ?>" data-isd="<?PHP echo $country->isd_code; ?>">
			                                        <a href="javascript:;" class="c_country_item"><?PHP echo $country->country_name." +".$country->isd_code; ?></a>
			                                    </li>
			                                    <?PHP
			                                }
			                                ?>
			                            </ul>
			                        </div>
			                    </div>
		                	</div>
		                	<div class="col-md-9 col-sm-9 col-xs-9">
					            <div class="controls" >
					                <input type="text" name="phone" class="form-control"
					                id="phone" autocomplete="off" placeholder="Enter your Phone">
					             </div>
					        </div>
					    </div>
			        </div>
			    </div>
			    <div class="col-md-6">
			        <div class="form-group">
			            <label class="control-label" style="text-align:left;">Purpose <span class="required">*</span></label>
			            <div class="controls" >
			            	<select name="purpose" id="purpose" class="form-control">
			            		<?PHP
			            		foreach ($this->register_categories_model->getCategories(1) as $category)
			            		{
			            			?>
			            			<option value="<?PHP echo $category->id; ?>"><?PHP echo $category->name; ?></option>
			            			<?PHP
			            		}
			            		?>
		                    </select>
			             </div>
			        </div>
			    </div>
			</div>

			<div class="form-group">
	            <label class="control-label" style="text-align:left;">Address <span class="required">*</span></label>
	            <div class="controls">
	                <textarea name="address" id="address" placeholder="Enter your Address" rows="6"
	                style="resize:none;" class="form-control"></textarea>
	             </div>
	        </div>

	        <div class="form-group">
	            <label class="control-label" style="text-align:left;">Notes <span class="required">*</span></label>
	            <div class="controls">
	                <textarea name="notes" id="notes" placeholder="Enter your Notes" rows="6"
	                style="resize:none;" class="form-control"></textarea>
	             </div>
	        </div>

	        <div class="form-group">
	            <div class="controls">
					<button type="submit" value="Send" class="btn blue btn-xs" id="registration-submit"><i class="fa fa-check"></i> Submit</button>
	            </div>
	        </div>
		</form>
		</div>
		<div class="col-md-3">
			<?PHP
	        	$this->load->view("common/public/site_".global_site_flag."/_internal_sidebar");
	        ?>
		</div>
	</div>
	
	<div class="clearfix">
	</div>
</div>
<script>
<?PHP
if($GLOBALS['site_settings']['registration_form']==0)
{
	?>
	$("input, textarea, button, select").prop("disabled",true);
	<?PHP
}
?>
$(document).ready(function()
{
	$(".c_country_item").on("click",function()
    {
        var isd=$(this).parent().attr("data-isd");
        var code=$(this).parent().attr("data-code");
        $("#cnt-country-code-button").html("+"+isd);
        $("#c_country_code").val(code);
    });

    $('.registration_form').validate(
    {
        errorElement: 'span',
        errorClass: 'help-block help-block-error',
        focusInvalid: true,
        rules: 
        {
            name: 
            {
                required: true,
                lettersonly:true,
                minlength: 3,
                maxlength:200
            },
            email:
            {
                required:true,
                no_uppercase:true,
                email_validate:true,
                minlength:6,
                maxlength:100
            },
            phone:
            {
            	required:true,
            	spaces:true,
            	minlength:8,
            	maxlength:15
            },
            address: {
                required: true,
                minlength:10,
                maxlength:2000
            },
            purpose:
            {
                required:true
            },
            notes:
            {
                required:true,
                maxlength:2000
            }
        },

        messages:
        {
            name:
            {
                required: "Please enter your Name"
            },
            purpose:
            {
                required: "Please select Purpose"
            },
            phone:
            {
                required:"Please enter phone number"
            },
            email:
            {
                required: "Please enter your Email ID"
            },
            notes:
            {
                required:"Please enter notes"
            },
            address:
            {
                required:"Please enter address"
            }
        },
        highlight: function (element) 
        {
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label,element) 
        {
            $(element).closest('.form-group').removeClass('has-error');
            label.remove();
        },
        errorPlacement: function (error, element) 
        {
            error.addClass('help-small no-left-padding').insertAfter(element);
        },
        submitHandler:function()
        {
        	$(".loader_animation").show();
            $("#registration-submit").prop("disabled",true);
            jQuery.post('/register/send',$(".registration_form").serialize(), function(res) 
            {
            	try
		        {
		            var r=$.parseJSON(res);
		        }
		        catch(err)
		        {
		        	$("#registration-submit").prop("disabled",false);
		            $(".loader_animation").hide();
		            showNotification('ruby',"Something wrong, please refresh the page and try again.");
		            return false;
		        }

		        if(r.flag==1)
		        {
		        	$(".registration_form")[0].reset();
		        	$("#country").val("IN");
	                showNotification("lime","Your Registration request has been submitted");
	                Metronic.scrollTo($('.page-title'));
	            }
	            else if(r.flag==2)
	            {
	            	showNotification("ruby","Registration Form is currently unavailable.");
	                Metronic.scrollTo($('.page-title'));
	            }
	            else
	            {
	            	showNotification('ruby',"Something wrong, please refresh the page and try again.");
	            }
                $("#registration-submit").prop("disabled",false);
                $(".loader_animation").hide();
            });
        }
    });

});
</script>

