<link href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/bootstrap-fileupload/bootstrap-fileupload.css" rel="stylesheet" type="text/css"/>
<link href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/jquery-file-upload/css/jquery.fileupload-ui.css" rel="stylesheet" />
<?PHP
$tempTitle="Add / Edit Quick Link";
?>
<input class="current-browser-title" data-title=" Admin Dashboard | Quick Links | <?PHP echo $tempTitle; ?>" type="hidden">
<h3 class="page-title">
    Add / Edit Quick Link
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="<?PHP echo base_url; ?>admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/quicklinksadmin">Quick Links</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            Add Quick Link
        </li>
    </ul>
</div>

<?PHP
if($this->session->flashdata('link_error'))
{
    ?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Invalid request.</strong>
    </div>
    <?PHP
}
?>
<?PHP
if($this->session->flashdata('link_added'))
{
    ?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Link Saved Successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption"> <i class="fa fa-list"></i> Add / Edit Quick Link <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
        </div>
        
        <div class="portlet-body no-more-tables">
            <form id="ql_form" method="post" onsubmit="return validate()" enctype="multipart/form-data">

                <div class="form-group" id="text-block">
                    <label class="control-label">Title
                    </label>
                    <div>
                        <input type="text" name="title" id="title" class="form-control" value = "<?PHP if(isset($_POST['title'])) echo htmlentities($_POST['title']); else if($id) echo htmlentities($result->title); ?>" />
                    </div>
                </div>

                <div class="form-group" id="text-block">
                    <label class="control-label">Description
                    </label>
                    <div>
                       <textarea name="description" id="description" class="form-control"><?PHP
                            if(isset($_POST['description'])) echo htmlentities($_POST['description']);
                            else if($id) echo htmlentities($result->description); 
                        ?></textarea>
                    </div>
                </div>

                <div class="form-group" id="text-block">
                    <label class="control-label">Include base URL</label>
                    <div>
                        <label>
                           <input type="checkbox" name="include_base_url" id="include_base_url" 
                            <?php if($id && $result->include_base_url)
                                echo "checked";
                            ?>
                            />
                           <?PHP echo base_url; ?>
                        </label>
                    </div>
                </div>

                <div class="form-group" id="text-block">
                    <label class="control-label">Link</label>
                    <div>
                           <input type="text" name="link" id="link" class="form-control" value="<?PHP if(isset($_POST['link'])) echo htmlentities($_POST['link']); else if($id) echo htmlentities($result->link); ?>" />
                    </div>
                </div>

                <div class="form-group">
                    <div>
                        <button type="submit" class="btn btn-xs blue" id="save_link" name="save_link">
                            <?php if($id)
                            {
                            ?>
                                <i class="fa fa-check"></i> Save</button>
                            <?php
                            }
                            else
                            {
                            ?>
                                <i class="fa fa-check"></i> Add</button>
                                <?php
                            }
                            ?>
                        <a class="btn btn-xs red" href="/quicklinksadmin/add_link">
                            <i class="fa fa-ban"></i> Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function()
    {
        $('#ql_form').validate(
        {
            errorElement: 'label', //default input error message container
            errorClass: 'help-inline', // default input error message class
            focusInvalid: true, // do not focus the last invalid input
            onkeyup: false,
            rules:
            {
                title: {
                    required: true,
                    minlength:3,
                    maxlength:100
                },
                description:
                {
                    minlength:3,
                    maxlength:200
                },
                link: {
                    required: true,
                    minlength:3,
                    maxlength:100
                }
            },

            messages:
            {
                title:
                {
                    required: "Please enter Title"
                },
                link:
                {
                    required: "Please enter Link"
                }
            },
            highlight: function (element)
            {
                $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
            },
            success: function (label, element)
            {
                label.remove();
            },
            errorPlacement: function (error, element)
            {
                error.addClass('help-small no-left-padding').insertAfter(element);
            }
        });
    });
</script>