
<input class="current-browser-title" data-title="Pledge Form" type="hidden">
<div class="page-content">
	<!-- BEGIN PAGE HEADER-->
	<h3 class="page-title">
		<div class="left-block">
	        <i class="icomoon-moneybag"></i>
	        <span class="top-line">
	            Pledge Form
	        </span>
	        <br>
	        <span class="caption">
	            Pledge for Seva
	        </span>
	    </div>
        <div class=" hidden-sm hidden-xs right-block">
            <?PHP echo site_name_string1; ?> - Pledge form to donate for Sevas and Events online or offline.
        </div>
    </h3>
    <div class="clearfix"></div>
	<div class="page-bar">
		<ul class="page-breadcrumb">
			<li>
				<a href="<?PHP echo base_url; ?>">Home</a>
				<i class="fa fa-angle-right"></i>
			</li>
			<li class="active">
           		Pledge Form
            </li>
		</ul>
	</div>
	<!-- END PAGE HEADER-->
	<?PHP
	$name='';
	$email='';
	
	if($this->session->userdata('user_id'))//if user && override admin
	{
	    $name=$this->session->userdata('user_data')->firstname." ".$this->session->userdata('user_data')->lastname;
	    $email=$this->session->userdata('user_data')->email;
	}
	if($GLOBALS['site_settings']['pledge_form']==0)
	{
		?>
		<div class="breaking-news">
            <div class="breaking-title" style="width: 100%;">
                <h3 style="text-transform: none;">Jaya Guru Datta. Pledge Form is currently unavailable.</h3>
            </div>
            <div class="clearfix"></div>
        </div>
		<?PHP
	}
	?>
	
	<div class="row">
		<div class="col-md-9">
		
		<form class="pledge_form form-horizontal" novalidate style="padding:10px; border:1px solid #c3c3c3;">
			<div class="row">
				<div class="col-md-6">
					<div class="form-group">
			            <label class="control-label" style="text-align:left;">Name <span class="required">*</span></label>
			            <div class="controls" >
			                <input type="text" name="name" class="form-control"
			                value="<?PHP echo htmlentities($name); ?>" 
			                id="name" autocomplete="off" placeholder="Enter your Name">
			             </div>
			        </div>
			    </div>
			   	<div class="col-md-6">
			        <div class="form-group">
			            <label class="control-label" style="text-align:left;">Email ID <span class="required">*</span></label>
			            <div class="controls" >
			                <input type="text" name="email" class="form-control" id="email"
			                value="<?PHP echo htmlentities($email); ?>" placeholder="Enter your Email ID">
			            </div>
			        </div>
			    </div>
			</div>
			<div class="row">
				<div class="col-md-6">
			        <div class="form-group">
			            <label class="control-label" style="text-align:left;">Phone <span class="required">*</span></label>
			            <div class="row">
		                	<div class="col-md-3 col-sm-3 col-xs-3">
		                		<div class="controls" >
		                        <input type="hidden" name="country" id="country" value="IN">
			                        <div class="btn-group" style="display: block;">
			                            <button class="btn btn-default dropdown-toggle" id="cnt-country-code-button" type="button" data-toggle="dropdown" aria-expanded="false" style="width: 100%; text-align: left;">
			                            +91
			                            </button>
			                            <ul class="dropdown-menu" role="menu" style="max-height: 150px; overflow: auto; margin-top: 35px;">
			                                <?PHP
			                                $countries=$this->locations_model->getCountries();
			                                foreach ($countries as $country)
			                                {
			                                    ?>
			                                    <li data-code="<?PHP echo $country->country_code; ?>" data-isd="<?PHP echo $country->isd_code; ?>">
			                                        <a href="javascript:;" class="c_country_item"><?PHP echo $country->country_name." +".$country->isd_code; ?></a>
			                                    </li>
			                                    <?PHP
			                                }
			                                ?>
			                            </ul>
			                        </div>
			                    </div>
		                	</div>
		                	<div class="col-md-9 col-sm-9 col-xs-9">
					            <div class="controls" >
					                <input type="text" name="phone" class="form-control"
					                id="phone" autocomplete="off" placeholder="Enter your Phone">
					             </div>
					        </div>
					    </div>
			        </div>
			    </div>
			    <div class="col-md-6">
			        <div class="form-group">
			            <label class="control-label" style="text-align:left;">Purpose <span class="required">*</span></label>
			            <div class="controls" >
			            	<select name="purpose" id="purpose" class="form-control">
			            		<?PHP
			            		foreach ($this->pledge_categories_model->getCategories(1) as $category)
			            		{
			            			?>
			            			<option value="<?PHP echo $category->id; ?>"><?PHP echo $category->name; ?></option>
			            			<?PHP
			            		}
			            		?>
		                    </select>
			             </div>
			        </div>
			    </div>
			</div>

			<div class="row">
				<div class="col-md-6">
			        <div class="form-group">
			            <label class="control-label" style="text-align:left;">Pledge amount <span class="required">*</span></label>
			            <div class="row">
		                	<div class="col-md-3 col-sm-3 col-xs-3">
		                		<div class="controls" >
		                        <input type="hidden" name="currency" id="currency" value="<?PHP echo default_currency; ?>">
			                        <div class="btn-group" style="display: block;">
			                            <button class="btn btn-default dropdown-toggle" id="currency-button" type="button" data-toggle="dropdown" style="width: 100%; text-align: left;">
			                            <?PHP echo strtoupper(default_currency); ?>
			                            </button>
			                            <ul class="dropdown-menu" role="menu" style="max-height: 150px; overflow: auto; margin-top: 35px;">
			                                <?PHP
			                                $currencies=$this->currencies_model->getByAshram(0);
			                                foreach ($currencies as $currency)
			                                {
			                                    ?>
			                                    <li data-val="<?PHP echo $currency['currency']; ?>" data-display="<?PHP echo strtoupper($currency['currency']); ?>">
			                                        <a href="javascript:;" class="currency_item"><?PHP echo strtoupper($currency['currency']); ?></a>
			                                    </li>
			                                    <?PHP
			                                }
			                                ?>
			                            </ul>
			                        </div>
			                    </div>
		                	</div>
		                	<div class="col-md-9 col-sm-9 col-xs-9">
					            <div class="controls" >
					                <input type="text" name="amount" class="form-control" id="amount" autocomplete="off" placeholder="Enter Amount">
					             </div>
					        </div>
					    </div>
			        </div>
			    </div>
			    <div class="col-md-6">
			    	<div class="form-group">
			            <label class="control-label" style="text-align:left;">Payment mode <span class="required">*</span></label>
			            <div class="controls" >
			                <select name="mode" id="mode" class="form-control">
			                	<option value="">Select mode</option>
			                	<option value="1">Cash</option>
			                	<option value="2">DD/Cheque</option>
			                	<option value="3">Online</option>
			                </select>
			             </div>
			        </div>
			    </div>
			</div>

			<div class="form-group">
	            <label class="control-label" style="text-align:left;">Address <span class="required">*</span></label>
	            <div class="controls">
	                <textarea name="address" id="address" placeholder="Enter your Address" rows="6"
	                style="resize:none;" class="form-control"></textarea>
	             </div>
	        </div>

	        <div class="form-group">
	            <label class="control-label" style="text-align:left;">Notes <span class="required">*</span></label>
	            <div class="controls">
	                <textarea name="notes" id="notes" placeholder="Enter your Notes" rows="6"
	                style="resize:none;" class="form-control"></textarea>
	             </div>
	        </div>

	        <div class="form-group">
	            <div class="controls">
					<button type="submit" value="Send" class="btn blue btn-xs" id="pledge-submit"><i class="fa fa-check"></i> Submit</button>
	            </div>
	        </div>
		</form>
		</div>
		<div class="col-md-3">
			<?PHP
	        	$this->load->view("common/public/site_".global_site_flag."/_internal_sidebar");
	        ?>
		</div>
	</div>
	
	<div class="clearfix">
	</div>
</div>
<script>
<?PHP
if($GLOBALS['site_settings']['pledge_form']==0)
{
	?>
	$("input, textarea, button, select").prop("disabled",true);
	<?PHP
}
?>
$(document).ready(function()
{
	$(".c_country_item").on("click",function()
    {
        var isd=$(this).parent().attr("data-isd");
        var code=$(this).parent().attr("data-code");
        $("#cnt-country-code-button").html("+"+isd);
        $("#c_country_code").val(code);
    });
	$(".currency_item").on("click",function()
    {
        var code=$(this).parent().attr("data-val");
        var disp=$(this).parent().attr("data-display");
        $("#currency-button").html(disp);
        $("#currency").val(code);
    });
    jQuery.validator.addMethod("minvalcheck", function(value, element) 
	{ 
	    var value=parseInt(value);
		if(value<1)
		{
			return false
		}
		else return true

	}, "Please enter minimum value of 1");

	
    $('.pledge_form').validate(
    {
        errorElement: 'span',
        errorClass: 'help-block help-block-error',
        focusInvalid: true,
        rules: 
        {
            name: 
            {
                required: true,
                lettersonly:true,
                minlength: 3,
                maxlength:200
            },
            email:
            {
                required:true,
                no_uppercase:true,
                email_validate:true,
                minlength:6,
                maxlength:100
            },
            phone:
            {
            	required:true,
            	spaces:true,
            	minlength:8,
            	maxlength:15
            },
            amount:
            {
            	required:true,
            	digits:true,
            	minvalcheck:true,
            	minlength:2,
            	maxlength:10
            },
            mode:
            {
            	required:true,
            },
            address: {
                required: true,
                minlength:10,
                maxlength:2000
            },
            purpose:
            {
                required:true
            },
            notes:
            {
                required:true,
                maxlength:2000
            }
        },

        messages:
        {
            name:
            {
                required: "Please enter your Name"
            },
            purpose:
            {
                required: "Please select Purpose"
            },
            phone:
            {
                required:"Please enter phone number"
            },
            mode:
            {
                required:"Please enter mode of payment"
            },
            email:
            {
                required: "Please enter your Email ID"
            },
            notes:
            {
                required:"Please enter notes"
            },
            amount:
            {
                required:"Please enter amount"
            },
            address:
            {
                required:"Please enter address"
            }
        },
        highlight: function (element) 
        {
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label,element) 
        {
            $(element).closest('.form-group').removeClass('has-error');
            label.remove();
        },
        errorPlacement: function (error, element) 
        {
            error.addClass('help-small no-left-padding').insertAfter(element);
        },
        submitHandler:function()
        {
        	$(".loader_animation").show();
            $("#pledge-submit").prop("disabled",true);
            jQuery.post('/pledge/send',$(".pledge_form").serialize(), function(res) 
            {

            	try
		        {
		            var r=$.parseJSON(res);
		        }
		        catch(err)
		        {
		        	$("#pledge-submit").prop("disabled",false);
		            $(".loader_animation").hide();
		            showNotification('ruby',"Something wrong, please refresh the page and try again.");
		            return false;
		        }

		        if(r.flag==1)
		        {
		        	$(".pledge_form")[0].reset();
		        	$("#country").val("IN");
		        	$("#currency").val("<?PHP echo default_currency ?>");
	                showNotification("lime","Your Pledge request has been submitted");
	                Metronic.scrollTo($('.page-title'));
	            }
	            else if(r.flag==2)
	            {
	            	showNotification("ruby","Pledge Form is currently unavailable.");
	                Metronic.scrollTo($('.page-title'));
	            }
	            else
	            {
	            	showNotification('ruby',"Something wrong, please refresh the page and try again.");
	            }
                $("#pledge-submit").prop("disabled",false);
                $(".loader_animation").hide();
            });
        }
    });

});
</script>

