<?PHP
$partHeader='Add Category';
if($id)
{
    $partHeader=htmlentities($cat_data->name);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | All Pledges | All Pledge Categories | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
	//$this->load->view("faqs/admin/nav_buttons");
?>

<h3 class="page-title">
	<?PHP
        echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="<?PHP echo base_url; ?>admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/pledgeadmin">All Pledges</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/pledgeadmin/categories">All Pledge Categories</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("cat_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("category_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Category created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("category_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="cat_form" name="cat_form" method="post">

		            <div class="form-group">
		                <label class="control-label">Category Name
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control" name="category" id="category"
		                        value="<?PHP if($id) echo htmlentities($cat_data->name); ?>">
		                </div>
		            </div>
		            <div class="form-group">
						<div class="form-content">
							<button type="submit" name="add_cat" id="add_cat" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Category"; ?></button>
							<a href="/pledgeadmin/categories" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>


				</form>
			</div>
		</div>



    </div>
 
</div>

<script type="text/javascript">
				
$( document ).ready(function() 
{	
	jQuery.validator.addMethod("category_exist", function(value, element) 
    {
        $.ajaxSetup({async: false});
        var rr=true;
        var rt=$.post('/pledgeadmin/category_check', {category: value,id:<?PHP echo $id; ?>}, function(res)
          {
             if(res==0)
             {
                 rr=false;
             }
            
          });
          return rr;

    }, "Category Name already exists");

	$('#cat_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules: {
            category: 
            {
                required: true,
				minlength:3,
				maxlength:50,
				category_exist:true
            }
        },

        messages: 
        {
            category: 
            {
                required: "Please enter Category"
            }
        },
    	highlight: function (element) { // hightlight error inputs
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label, element)
        {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },
        errorPlacement: function (error, element)
        {
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });
});
</script>
