<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | Content Admin | All Photo Albums" type="hidden">
<style type="text/css">
    @media only screen and (min-width: 992px) and (max-width: 1450px){
        .buttons{
            padding: 29px 0px 6px 0px;
        }
    }
</style>
<?PHP
    $this->load->view("photoalbums/admin/nav_buttons");
?>
<h3 class="page-title">
All Photo Albums
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>All Photo Albums</li>
    </ul>
</div>
     
<div class="row-fluid">
<?PHP
if($this->session->flashdata("album_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Invalid Request</strong>
    </div>
    <?PHP
}
?>
    <?PHP
    if($this->currentUser->roles==3)
    {
        $ashramData=$this->ashrams_model->ashramData($this->currentUser->ashram_id);
        ?>
        <div class="alert alert-info">
            <strong>Photos public URL:</strong>
            <a href="<?php echo base_url. "ashrams/".$ashramData->slug."/photos"; ?>" target="_blank">
            <?php echo base_url . "ashrams/".$ashramData->slug."/photos"; ?></a>
        </div>
        <?PHP
    }
    else if($this->currentUser->roles==6)
    {
        $satsangData=$this->satsangs_model->satsangData($this->currentUser->satsang_id);
        ?>
        <div class="alert alert-info">
            <strong>Photos public URL:</strong>
            <a href="<?php echo base_url. "satsangs/".$satsangData->slug."/photos"; ?>" target="_blank">
            <?php echo base_url ."satsangs/".$satsangData->slug. "/photos"; ?></a>
        </div>
        <?PHP
    }
    else
    {
        ?>
        <div class="alert alert-info">
            <strong>Photos public URL:</strong>
            <a href="<?php echo base_url. "photos"; ?>" target="_blank">
            <?php echo base_url . "photos"; ?></a>
        </div>
        <div class="alert alert-info">
            <strong>Only global photo albums are displayed until Ashram selection</strong>
        </div>
        <?PHP
    }
    ?>
	<form action="" method="get" name="list_of_albums" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form">
        <?PHP
        if(is_single_ashram_site)
        { 
        ?>
            <input type="hidden" name="ashram_id" id="ashram_id" value="<?php echo default_ashram_id; ?>">
        <?PHP
        }
        else if($this->currentUser->roles==1 || $this->currentUser->roles==7)
        {   ?>
            <div class="col-md-2">
                <select name="ashram_id" id="ashram_id" onChange="switchAshram(this.value)" class="form-control input-inline custom-input">
                    <option value="0">Select Ashram</option>
                    <?PHP
                    foreach ($ashrams as $ashramData)
                    {
                        ?>
                        <option value="<?PHP echo $ashramData->id; ?>"
                        <?PHP
                        if($this->session->userdata("ashramId")==$ashramData->id)
                            echo " selected";
                        ?>
                        >
                            <?PHP echo $ashramData->name; ?>
                        </option>
                        <?PHP
                    }
                    ?>
                </select>
            </div>
            <br style="clear:both;" class="hidden-sm hidden-xs">
            <script>
                function switchAshram(ashram_id)
                {
                    $.post("/ashramadmin/switchashram/"+ashram_id,{},function(res)
                    {
                        window.location.reload();
                    });
                }
            </script>
            <?PHP
        }
        ?>
        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="input-inline form-control custom-input" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                <option value="name">Album Name</option>
                <option value="id">Album ID</option>
            </select>
        </div>
        <!-- <div class="col-md-2">
            <select name="wild" id="wild" class="input-inline form-control custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts with</option>
                <option value="ends">Ends with</option>
            </select>
        </div> -->
        <div class="col-md-2">
            
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="from_date" id="from_date"
            placeholder="From date"/>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="to_date" id="to_date"
            placeholder="To date" />
        </div>
        <div class="buttons">
            <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
            onClick="search(0)"><i class="fa fa-search"></i> Search</button>
            <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
            style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
        </div>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption"> <i class="fa fa-list"></i> All Photo Albums <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
        </div>
        
        <div class="portlet-body no-more-tables">

            <table id="albumstable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                <thead>
                    <tr>
                        <th>S. No.</th>
                        <th>Album ID</th>
                        <th>Ashram</th>
                        <th>Album Name</th>
                        <th>Photos</th>
                        <th>Created Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                
            </table>
            <div style="clear:both;"></div>
        </div>
    </div>

</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var from_date = '';
var to_date = '';
var search_text = '';
var search_col = '';
var table = '';
function applyFilter(ele) 
{
    table.fnDraw();
}
function search(flag) 
{
    clearNotifications();
    if(!$("#from_date").length || !$("#to_date").length || !$("#search_text").length || !$("#search_col").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {
        if ($("#from_date").length && $("#to_date").length && $("#search_text").length && 
            $("#from_date").val().trim() == '' && $("#to_date").val().trim() == '' && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords or select dates');
            return false;
        }
        if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
        {
            var frm=Date.parse($("#from_date").val());
            var to=Date.parse($("#to_date").val());
            if(frm>to)
            {
                showNotification('ruby','From date cannot be after To date');
                return false
            }
        }
    }
    $(".dataTables_processing").show();
    if($("#from_date").length)
        from_date = $("#from_date").val().trim();
    if($("#to_date").length)
        to_date = $("#to_date").val().trim();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#search_col").length)
        search_col = $("#search_col").val().trim();
    if (from_date != '' || to_date != '' || search_text != '')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();
}
function search_clear() 
{
    $(".dataTables_processing").show();
    $("#from_date").val('');
    from_date = '';
    $("#to_date").val('');
    to_date = '';
    $("#search_text").val('');
    search_text = '';
    search_col = '';
    $("#searchClear").css("display", "none");
    table.fnDraw();
}
var statusflag=0;
$(".delete-button").live("click",function()
{
    if(statusflag==1)
        return false;
    statusflag=1;
    var pid=$(this).attr("data-id");
    $(".dataTables_processing").show();
    $.post('/photoalbumsadmin/deletealbum/'+ pid, {}, function(res) 
    {
        var r = $.parseJSON(res);
        if (r.flag == 1) 
        {
            table.fnSettings.bResetDisplay  =false;
            table.fnDraw(table.fnSettings);
            showNotification('ruby', "Album '" + r.unique_id + "' deleted successfully.");
        }
        else 
        {
            $(".dataTables_processing").hide();
            showNotification("ruby", "Error occured. Please try again.");
        }
        $("#album"+pid).modal("toggle");
        $(".dataTables_processing").hide();
        statusflag=0;
    });
});
$(document).ready(function()
{
    $("#search_text").val('');
    $("#from_date").val('');
    $("#to_date").val('');
    $("#search_col").val($("#search_col option:first").val());

    table = $('#albumstable').dataTable({
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [4, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            $('.tooltips').tooltip();
            $("#checkall").prop('checked', false);
        },
        "columns": [
        {
            "width": "7%",
            "orderable": false
        }, {
            name: "id",
            "width": "10%",
            "orderable": true
        }, {
            name: "ashram",
            "width": "25%",
            "orderable": true
        }, {
            name: "name",
            "orderable": true
        }, {
            name: "count",
            "width": "8%",
            "orderable": false
        }, {
            name: "created_on",
            "width": "12%",
            "orderable": true
        }, {
            width: "7%",
            "orderable": false
        }],
        "ajax": {
            url: '/photoalbumsadmin/listalbums',
            type: 'POST',
            data: function(d) 
            {
                if (status != '' && $.isNumeric(status)) 
                {
                    d.status = status;
                }
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Album ID");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Ashram");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Album Name");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Photos");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Created Date");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                return row.id;
            },
            "targets": 1
        },{
            "render": function(data, type, row) 
            {
                return row.ashram_name;
            },
            "targets": 2
        }, {
            "render": function(data, type, row) 
            {
                var str='';
                str += "<a href='/photoalbumsadmin/add_edit_album/"+ row.id + "' target='_blank' class='clampme tooltips'";
                str += ' data-container="body" data-placement="bottom" data-original-title="' + row.tooltiptitle + '">' + row.name + '</a>';
                return str;
            },
            "targets": 3
        },  {
            "render": function(data, type, row) {
                return row.count;
            },
            "targets": 4
        }, {
            "render": function(data, type, row) {
                return row.created_on;
            },
            "targets": 5
        },{
            "render": function(data, type, row) 
            {
                var str = '<div class="btn-group" id="actions' + row.id + '">' +
                    '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                    '<i class="fa fa-angle-down"></i></a>' +
                    '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                    '<li><a href="/photoalbumsadmin/add_edit_album/' + row.id + '" target="_blank"><i class="fa fa-eye"></i> Edit</a></li>';
        
                str += '<li><a href="#album' + row.id + '" role="button" data-toggle="modal">' +
                    '<i class="fa fa-trash-o"></i> Delete</a></li>' +

                    '<div id="album' + row.id + '" class="modal fade" tabindex="-1">' +
                    '<div class="modal-header">' +
                    '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                    '<h4 class="modal-title">Delete Confirmation</h4>' +
                    '</div>' +
                    '<div class="modal-body"><div class="pull-left delete-confirmation-icon"' +
                    '><i class="fa fa-exclamation-triangle"></i></div>' +
                    'Do you really want to delete the Photo Album: ' +
                    '<span style="color:red; font-weight:bold;">' + row.name + '</span>?' +
                    '</div>' +
                    '<div class="modal-footer">' +
                    '<button type="button" data-dismiss="modal" class="btn btn-xs close' + row.id + '">' +
                    '<i class="fa fa-remove"></i> Cancel</button>' +
                    '<a class="btn btn-xs red delete-button" data-id="'+row.id+'">' +
                    '<i class="fa fa-trash"></i> Delete</a>' +
                    '</div>' +
                    '</div>';

                return str;
            },
            "targets": 6
        }]
    });
    $('.columnhide').on('click', function(e) 
    {
        var column = table.api().column( $(this).attr('data-column') );
        var cnum=$(this).attr('data-column');
        
        column.visible( ! column.visible(),true );
        var bVis = table.fnSettings().aoColumns[cnum].bVisible;
        var title = table.fnSettings().aoColumns[cnum].sTitle;
        
        var visibility=table.api().column(cnum).visible();
        table.api().column(cnum).nodes().to$().attr("data-title",title);
        if (visibility == false) 
        {
            $(this).removeClass('blue').addClass('red');
        }
        else 
        {
            $(this).removeClass('red').addClass('blue');
        }
    });
});
</script>     