<?PHP
if($orderData['order']->order_type==3)
{
    $partHeader="Order ID: ".$orderData['order']->order_number;
}
else
{
    if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
    {
        $partHeader="Gift ID: ".$orderData['order']->order_number;
    }
    else
    {
        $partHeader="Seva ID: ".$orderData['order']->order_number;
    }
}
?>
<style>
.grand_total:before
{
    font-size:18px;
}
</style>
<input class="current-browser-title" data-title="<?PHP echo $partHeader; ?>" type="hidden">
<div class="page-content">
    <!-- BEGIN PAGE HEADER-->
    <h3 class="page-title">
        <?PHP echo $partHeader; ?>
    </h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?PHP echo base_url; ?>">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="<?PHP echo base_url.$this->uri->segment(1); ?>"><?PHP echo $this->pageName; ?></a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <?PHP echo $partHeader; ?>
            </li>
        </ul>
    </div>
    <!-- END PAGE HEADER-->
    <?PHP
    if($this->session->flashdata("order_placed"))
    {
        ?>
        <div class="alert alert-success hidden-print">
            <button class="close" data-dismiss="alert"></button>
            <strong>Thanks for donating towards <?PHP echo site_short_name; ?> charitable activities.</strong>
        </div>
        <div class="alert alert-warning">
        <button class="close" data-dismiss="alert"></button>
        <strong>
            Jaya Guru Datta. If you do not find the Seva confirmation email in your inbox, please check your spam folder / spam filter or bulk email folder. Automated emails are sometimes blocked by spam filters and email providers.<br>
            For any further questions or concerns please open a <a href="<?PHP echo base_url('mytechsupport/createticket'); ?>">Feedback / Support</a> request with your registered Email ID. 
        </strong>
    </div>
        <?PHP
    }
    ?>
    <div class="row margin-bottom-20 no-more-tables">
        <div class="col-md-12 margin-bottom-10">
            <a href="javascript:;" class="btn btn-xs blue pull-right hidden-print" id="print_order">
                <i class="fa fa-print"></i> 
                <?PHP
                if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
                {
                    echo 'Print Gift Details';
                }
                else
                {
                    echo 'Print Seva Details';
                }
                ?>
            </a>
            <div style="clear:both;"></div>
        </div>
        <?PHP
        $this->load->view("orders/user/_order_details");
        ?>
    </div>
    
    <div class="row margin-bottom-20">
        <div class="col-md-12 margin-bottom-10">
            <a href="javascript:;" class="btn btn-xs red pull-right hidden-print" id="print_receipt">
                <i class="fa fa-print"></i> Print Order Receipt
            </a>
            <div style="clear:both;"></div>
        </div>
        <?PHP
            $this->load->view("orders/user/_order_receipt");
        ?>
    </div>


    <div class="clearfix"></div>


</div>

<script type="text/javascript">
$("#print_order").on("click",function()
{
    $("#grand-total-title").removeClass("hidden-xs");
    $(".order-details").removeClass("hidden-print");
    window.print();
    $(".order-details").addClass("hidden-print");
    $("#grand-total-title").addClass("hidden-xs");
});
$("#print_receipt").on("click",function()
{
    $(".order-receipt").removeClass("hidden-print");
    window.print();
    $(".order-receipt").addClass("hidden-print");
});

</script>