<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<style type="text/css">
    @media (max-width: 992px) {
        .mobMarginBtm{
            margin-top: 5px;
        }
    }
    @media only screen and (min-width: 992px) and (max-width: 1450px){
        .buttons{
            padding: 29px 0px 6px 0px;
        }
    }
</style>

<input class="current-browser-title" data-title=" Admin Dashboard | Transaction missed data check" type="hidden">
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
    $this->load->view("orders/admin/nav_buttons");
?>
<h3 class="page-title">
    Transaction missed data check
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>Transaction missed data check</li>
    </ul>
</div>

<div class="row-fluid">
    <form action="" method="get" name="" style="margin:0px;" onsubmit="return false" class="form-horizontal row search_form">
        <?PHP
        if(is_single_ashram_site)
        { 
        ?>
            <input type="hidden" name="ashram_id" id="ashram_id" value="<?php echo default_ashram_id; ?>">
        <?PHP
        }
        else if($this->currentUser->roles==1)
        {
            ?>
            <div class="col-md-2">
                <select name="ashram_id" id="ashram_id" onChange="switchAshram(this.value)" class="form-control input-inline custom-input">
                    <option value="0">All Ashrams</option>
                    <?PHP
                    foreach ($ashrams as $ashramData)
                    {
                        ?>
                        <option value="<?PHP echo $ashramData->id; ?>"
                        <?PHP
                        if($this->session->userdata("ashramId")==$ashramData->id)
                            echo " selected";
                        ?>
                        >
                            <?PHP echo $ashramData->name; ?>
                        </option>
                        <?PHP
                    }
                    ?>
                </select>
            </div>
            <script>
                function switchAshram(ashram_id)
                {
                    $.post("/ashramadmin/switchashram/"+ashram_id,{},function(res)
                    {
                        window.location.reload();
                    });
                }
            </script>
            <?PHP
        }
        ?>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="from_date" id="from_date"
            placeholder="From date" value="<?PHP echo date("d M Y"); ?>" />
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="to_date" id="to_date"
            placeholder="To date" value="<?PHP echo date("d M Y"); ?>" />
        </div>
        <div class="buttons">
            <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
            onClick="search(0)"><i class="fa fa-search"></i> Search</button>
            <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"><i class="fa fa-search-minus"></i> Clear</a>
            <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> All missed data transactions</button>
        </div>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="alert alert-warning" id="displayingRecordsMsgAlertBox">
        <strong id="displayingRecordsMsg">
            Displaying records from "<?PHP echo date("d M Y"); ?>" to "<?PHP echo date("d M Y"); ?>"
        </strong>
    </div>
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption"> <i class="fa fa-list"></i> All missed data transactions <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
        </div>
        
        <div class="portlet-body no-more-tables">
            <table id="transactionstable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                <thead>
                    <tr>
                        <th>S. No.</th>
                        <th>Tx ID</th>
                        <th>Tx Date</th>
                        <th>Seva ID</th>
                        <th>User</th>
                        <th>Seva Type</th>
                        <th>Description</th>
                    </tr>
                </thead>
                
            </table>
            <div style="clear:both;"></div>
        </div>
    </div>
</div>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
    var from_date = $("#from_date").val();
    var to_date = $("#to_date").val();
    function search(flag) 
    {
        clearNotifications();
        if($('#from_date').val().trim()=='')
        {
            showNotification('ruby','Please select From date');
            return false;
        }
        if($('#to_date').val().trim()=='')
        {
            showNotification('ruby','Please select To date');
            return false;
        }
        if(!$("#from_date").length || !$("#to_date").length)
        {
            showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
            return;
        }
        if (flag == 0)
        {  
            if ($("#from_date").length && $("#to_date").length && $("#from_date").val().trim() == '' && $("#to_date").val().trim() == '') 
            {
                showNotification('ruby','Please enter search keywords or select dates');
                return false;
            }
            if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
            {
                var frm=Date.parse($("#from_date").val());
                var to=Date.parse($("#to_date").val());
                if(frm>to)
                {
                    showNotification('ruby','From date cannot be after To date');
                    return false
                }
            }
        }
        $(".dataTables_processing").show();
        if($("#from_date").length)
            from_date = $("#from_date").val().trim();
        if($("#to_date").length)
            to_date = $("#to_date").val().trim();

        if (from_date != '' || to_date != '' || search_text != '')
            $("#searchClear").css("display", "inline-block");
        
        displayFromDateToDateAlertBox(from_date,to_date);
        table.fnDraw();
    }

    function displayFromDateToDateAlertBox(fromDate,toDate)
    {
        if(fromDate != '' || toDate != '')
        {
            var displayRecordStr = "Displaying records";
            if(fromDate != '')
            {
                displayRecordStr+= ' from "'+fromDate+'"';
            }
            if(fromDate == '' && toDate != '')
            {
                displayRecordStr+= ' till "'+toDate+'"';
            }
            else if(toDate != '')
            {
                displayRecordStr+= ' to "'+toDate+'"';
            }
            $("#displayingRecordsMsg").empty().html(displayRecordStr);
            $("#displayingRecordsMsgAlertBox").show();
        }
        else
        {
            $("#displayingRecordsMsg").empty();
            $("#displayingRecordsMsgAlertBox").hide();
        }
    }

    function search_clear() 
    {
        var currentDate = "<?PHP echo date("d M Y"); ?>";
        var firstDateOfCurrentMonth = "<?PHP echo date("01 M Y"); ?>";
        $(".dataTables_processing").show();
        $("#from_date").val(firstDateOfCurrentMonth);
        from_date = firstDateOfCurrentMonth;
        $("#to_date").val(currentDate);
        to_date = currentDate;
        wild = '';
        $("#searchClear").css("display", "none");
        displayFromDateToDateAlertBox(from_date,to_date);
        table.fnDraw();
    }


    $(document).ready(function()
    {
        table = $('#transactionstable').dataTable({
            "processing": true,
            "language": {
                "sProcessing": '<div class="spinnerspin"></div>',
                "emptyTable": "No records found."
            },
            "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
            "sPaginationType": "bootstrap",
            "serverSide": true,
            "iDisplayLength": 50,
            "order": [
                [2, "desc"]
            ],
            "responsive": true,
            "lengthMenu": [
                [20, 50, 100],
                [20, 50, 100]
            ],
            "drawCallback": function(settings) 
            {
                var api = this.api();
                var totalrows = api.rows({
                    page: 'current'
                }).data().context[0]._iRecordsTotal;
                $("#total_records").html('(' + totalrows + ')');
                
                $('.tooltips').tooltip();
            },
            "columns": [
            {
                "width": "5%",
                "orderable": false
            }, {
                name: "tx",
                "width": "15%",
                "orderable": true
            }, {
                name: "created_on",
                "width": "10%",
                "orderable": true
            }, {
                name: "order_id",
                "width": "12%",
                "orderable": true
            }, {
                name: "username",
                "width": "15%",
                "orderable": true
            }, {
                name: "order_type",
                width: "10%",
                "orderable": true
            }, 
            {
                "orderable": false
            }],
            "ajax": {
                url: '/sevas/listMissedTransactionsData',
                type: 'POST',
                data: function(d) 
                {
                    if (from_date != '')
                        d.from_date = from_date;
                    if (to_date != '')
                        d.to_date = to_date;
                },
                complete: function (xhr, error, thrown) 
                {
                    var jdata=$.parseJSON(xhr.responseText);
                },
                error: function (xhr, error, thrown) 
                {
                    if(xhr.responseText=='login')
                    {
                        window.location="<?PHP echo base_url; ?>"
                    }
                    else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                    {
                       showNotification('ruby',"Invalid request");
                    }
                    $(".dataTables_processing").hide();
                    return false;
                },
                dataSrc:function(res)
                {
                    if(res.data.length==0 && res.recordsTotal!=0)
                    {
                        table.fnDraw();
                    }

                    return res.data;
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                var vis = true;
                var ii = 0;
                var sno = 0;

                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Tx ID");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Tx Date");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Seva ID");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "User");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Seva Type");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Description");
                    ii++;
                }
                return nRow;
            },
            "columnDefs": [
            {
                "render": function(data, type, row) {
                    return row.sno;
                },
                "targets": 0
            }, {
                "render": function(data, type, row) 
                {
                    return row.tx;
                },
                "targets": 1
            }, {
                "render": function(data, type, row) 
                {
                    return row.created_on;
                },
                "targets": 2
            }, {
                "render": function(data, type, row) 
                {
                    var str = '<a href="/orders/view/'+row.order_id+'" target="_blank"><b>'+row.tx_order_number + '</b></a><br>';
                    return str;
                },
                "targets": 3
            }, {
                "render": function(data, type, row) 
                {
                    var str='';
                    if(row.tx_username!='' || row.userid!=0)
                        str+='<a href="/usersadmin/view/'+row.userid+'" target="_blank">'+row.tx_username+'</a>';
                    else
                        str+='<span style="color:red;">Guest</span>';

                    str+='<br>'+row.firstname+" "+row.lastname;
                    str+='<br>'+row.email;
                    str+='<br>'+row.phone;

                    return '<span style="font-size:11px;">'+str+'</span>';
                },
                "targets": 4
            }, {
                "render": function(data, type, row) 
                {
                    var str = "NA";
                    if(row.tx_order_type==1)
                    {
                        str = '<span class="label label-dark-red">Poojas</span>';
                    }
                    else if(row.tx_order_type==4)
                    {
                        str = '<span class="label label-dark-purple">Subscriptions</span>';
                    }
                    else if(row.tx_order_type==2)
                    {
                        str = '<span class="label label-dark-green">Donations</span>';
                    }
                    else if(row.tx_order_type==3)
                    {
                        str = '<span class="label label-dark-blue">Store</span>';
                    }
                    return str;
                },
                "targets": 5
            }, {
                "render": function(data, type, row) 
                {
                    return row.transaction_description;
                },
                "targets": 6
            }]
        });
    });

    $("#excelButton").on("click",function()
    {
        $(".loader_animation").show();
        clearNotifications();
        var sortindex=table.fnSettings().aaSorting[0][0];
        var order_by=table.fnSettings().aoColumns[sortindex].name;
        var dir=table.fnSettings().aaSorting[0][1];
        $.post('/sevas/listMissedTransactionsData/1',
        {
            from_date:from_date,to_date:to_date
        },
            function(res)
            {
                var r=$.parseJSON(res);
                if(r.flag==1)
                {
                    window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
                }
                if(r.flag==0)
                {
                    showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
                }
                if(r.flag==2)
                {
                    showNotification("ruby","Sorry! You have already requested the same report.");
                }
                $(".loader_animation").hide();
            }
        );
    });
</script>