<!DOCTYPE html>
<html>
<head>
<style media = "screen">
body 
{
  background: rgb(204,204,204); 
}
page 
{
    background: white;
    display: block;
    margin: 0 auto;
    margin-bottom: 0.5cm;
    box-shadow: 0 0 0.5cm rgba(0,0,0,0.5);
}
page[size="A4"] 
{  
    width: 21cm;
    height: 29.7cm;
    overflow: auto;
    min-height: 100px;
    height: auto;
    word-wrap: break-word;
}
@media
    only screen  and (max-width: 760px), (min-device-width: 768px) and (max-device-width: 1024px)  
    {
        /* Force table to not be like tables anymore */
        page[size="A4"] 
        {
            width:100%;
        }
    }
</style>
<style type="text/css" media = "print">
@media print 
{   
    page[size="A4"] 
    {
        margin: 0;
        border: initial;
        border-radius: initial;
        width: initial;
        min-height: initial;
        box-shadow: initial;
        background: initial;
        page-break-after: always;
        page-break-after: avoid;
        overflow: auto;
        min-height: 100px;
        height: auto;
        page-break-before: avoid;
    }
    html, body {
      height:100vh; 
      margin: 0 !important; 
      padding: 0 !important;
    }
}
</style>
</head>
    <body>
        <input class="current-browser-title" data-title=" Admin Dashboard | All Transactions | Don. Declarations" type="hidden">
        <a href="javascript:;" onclick="printDeclarations();" class="btn btn-xs green pull-right hidden-print declaration_print" style="margin-bottom:10px;">
            <i class="fa fa-print"></i> Print All Don. Declarations
        </a>
        <div class="clearfix"></div>
        <div class = "declaration_print">
            <?PHP
            $i = 0;
            foreach($declarations as $transaction)
            { 
                $order_data=unserialize($transaction->order_data);
                $orderData=$this->orders_model->orderData($transaction->order_id);
                if(empty($orderData))
                    continue;
                if($i==2 || $i==0)
                {
                    ?>
                    <page size="A4">
                    <?php
                }
                $i++;
                $giftLetterFileName = '';
                if((isset($transaction->declaration_type) && $transaction->declaration_type=='Gift') && (isset($transaction->declaration_template) && $transaction->declaration_template!='')  )
                {

                    $templatepathcheck=$_SERVER['DOCUMENT_ROOT'].'/application/views/ashrams/admin/gift_donation_templates/'.trim($transaction->declaration_template).'.php';
                    if(file_exists($templatepathcheck))
                    {
                        $giftLetterFileName = trim($transaction->declaration_template);
                    }
                }
                if($giftLetterFileName!='')
                {
                    $countryData = $this->locations_model->getCountryByCode($orderData['order']->country);
                    $this->load->view("ashrams/admin/gift_donation_templates/".trim($transaction->declaration_template),array("transaction"=>$transaction,"modal"=>1, "showTransactionDetails"=>1,"countryData"=>$countryData));
                }
                else
                {
                    if($transaction->payment_mode=='paypal')
                        $transaction->date=$transaction->created_on;
                    ?>
                    <div class="col-md-12 order-declaration" style="border: 2px solid #000; margin-top: 10px; padding: 10px;height:440px;overflow:hidden;">
                        <div class="agreement_summary">
                            <div align="center" class="receipt_header2" style="margin-top: 15px;">
                                Donation Declaration
                            </div>
                                 
                            <div style="clear:both;margin-top: 25px;"></div>  
                            <p style="float:left; margin:0px;">
                                <b><?PHP if(isset($transaction->declaration_type) && $transaction->declaration_type=='Gift') { echo 'Gift'; } else { echo 'Donation'; } ?> ID:</b> <?PHP echo $orderData['order']->order_number; ?>
                            </p>

                            <p style="float:right; margin:0px;">
                                <b>Date:</b> <?PHP if(!empty($transaction->date)) echo date("d M Y",strtotime($transaction->date));
                                else  echo date("d M Y",strtotime($transaction->created_on)); ?><br>
                            </p>
                            <div style="clear:both"></div>      
                            <p style="float:right; margin:0px;"><b>Donor IP:</b> <?PHP echo $transaction->ip_address; ?></p>
                            <div style="clear:both; height:20px;"></div> 
                            <?PHP
                            $txamount=$transaction->amount;
                            /*if($transaction->sub_tx!='')
                                $txamount=$transaction->t2amount;*/

                            ?>
                            <span>
                                I / We <span class="dec_trust bold1"><?PHP echo htmlentities($orderData['order']->firstname)." ".htmlentities($orderData['order']->lastname);  ?></span> hereby affirm that a donation of
                                         <span class="bold1" id="amount_declare"><?PHP echo strtoupper($orderData['order']->currency)." ".$txamount;  ?></span> (in words) <span class="bold2" id="amount_declare_words"><?PHP echo strtoupper($orderData['order']->currency)." ".$this->general_model->amountToWords($txamount); ?></span> only, has been made by me/us 
                                        <?PHP
                                        if(strtolower($orderData['order']->currency)=='inr')
                                        {
                                            ?>
                                            with a specific direction that it shall form a part of the
                                            <span class="bold1">corpus</span> of
                                            <?PHP
                                        }
                                        else
                                        {
                                            ?>
                                            towards
                                            <?PHP
                                        }
                                        ?>
                                        <span class="dec_trust bold1">
                                            <?PHP
                                                if(!empty($order_data))
                                                    echo htmlentities($order_data['trustData']->trust_name);
                                                else
                                                    echo htmlentities($orderData['order']->trust_name);
                                            ?>
                                        </span>.
                                <br><br>
                                <strong>Donor Address:</strong><br>
                                <div class="donor_address">
                                    <?PHP
                                        $countryData = $this->locations_model->getCountryByCode($orderData['order']->country);
                                        echo htmlentities($orderData['order']->address1)."<br>";
                                        if($orderData['order']->address2!='')
                                            echo htmlentities($orderData['order']->address2)."<br>";
                                        if($orderData['order']->address3!='')
                                            echo htmlentities($orderData['order']->address3)."<br>";
                                        echo
                                            htmlentities($orderData['order']->city).", ".
                                            htmlentities($orderData['order']->state);
                                        if(isset($orderData['order']->zipcode)!='')
                                        {
                                            echo " - ".$orderData['order']->zipcode;
                                        }
                                        echo "<br>".htmlentities($countryData->country_name);

                                        $isdcode = '';
                                        if(isset($orderData['order']->isd_code)!='')
                                        {  
                                            $isdcode = "+".$orderData['order']->isd_code;
                                        }
                                        echo '<br>Ph: '.$isdcode." ".htmlentities($orderData['order']->phone);
                                        if(isset($orderData['order']->pan_or_aadhaar) && $orderData['order']->pan_or_aadhaar=='PAN' && strtolower($orderData['order']->currency)=='inr')
                                        {
                                            echo '<br>PAN Number: '.htmlentities($orderData['order']->order_pan_number);
                                        }
                                        else if(isset($orderData['order']->pan_or_aadhaar) && $orderData['order']->pan_or_aadhaar=='Aadhaar' && strtolower($orderData['order']->currency)=='inr')
                                        {
                                            echo '<br>Aadhaar Number: '.htmlentities($orderData['order']->order_aadhaar_number);
                                        }
                                        else if(isset($orderData['order']->pan_or_aadhaar) && $orderData['order']->pan_or_aadhaar=='TIN' && strtolower($orderData['order']->currency)=='inr')
                                        {
                                            echo '<br>TIN Number: '.htmlentities($orderData['order']->order_tin_number);
                                        }
                                        else if(isset($orderData['order']->pan_or_aadhaar) && $orderData['order']->pan_or_aadhaar=='Passport' && strtolower($orderData['order']->currency)=='inr')
                                        {
                                            echo '<br>Passport Number: '.htmlentities($orderData['order']->order_passport_number);
                                        }
                                        else if(isset($orderData['order']->pan_or_aadhaar) && $orderData['order']->pan_or_aadhaar=='EPIC' && strtolower($orderData['order']->currency)=='inr')
                                        {
                                            echo '<br>Voter EPIC Number: '.htmlentities($orderData['order']->order_voter_epic_number);
                                        }
                                        else if(isset($orderData['order']->pan_or_aadhaar) && $orderData['order']->pan_or_aadhaar=='DL' && strtolower($orderData['order']->currency)=='inr')
                                        {
                                            echo '<br>Driving License Number: '.htmlentities($orderData['order']->order_driving_license_number);
                                        }
                                        else if(isset($orderData['order']->pan_or_aadhaar) && $orderData['order']->pan_or_aadhaar=='RationCard' && strtolower($orderData['order']->currency)=='inr')
                                        {
                                            echo '<br>Ration Card Number: '.htmlentities($orderData['order']->order_ration_card_number);
                                        }
                                        echo '<br>Email ID: '.htmlentities($orderData['order']->email);
                                    ?>
                                </div>
                            </span>
                            <div class="control-group">
                                <div class="controls">
                                    <p  align="right" style="border:1px solid grey; float:right; padding:2px;margin-top: -20px;">
                                        <?PHP echo $orderData['order']->donation_initials; ?>
                                    </p>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                    <?php
                }
                if($i==2 || $i==0)
                {
                    ?>
                    </page>
                    <?php
                    $i=0;
                }
            }
            ?>
        </div>
    </body>
</html>
<script type="text/javascript">
    function printDeclarations()
    {
        try 
        {
            iframe = document.getElementById('iframe-id');
            iframe.contentWindow.document.execCommand('print', false, null);
        }
        catch(e) {
            window.print();
        }
    }
</script>