<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | All Sevas | Cart logs" type="hidden">
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
    $this->load->view("orders/admin/nav_buttons");
?>
<h3 class="page-title">
Sevas - Cart logs
</h3>
<style type="text/css">
    .table tr.fail,
    .table tr.fail td.fail
    {
        background: rgba(255,0,0,0.1);
    }
    .table tr.success,
    .table tr.success td.success
    {
        background: rgba(0,255,0,0.1);
    }
    .table tr.init,
    .table tr.init td.init
    {
        background: rgba(255,255,0,0.1);
    }
</style>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/orders">All Sevas</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>Cart logs</li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->
<?PHP
if($this->session->flashdata("log_error"))
{
    ?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error deleting logs.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("log_deleted"))
{
    ?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Logs deleted successfully.</strong>
    </div>
    <?PHP
}
?>
<div class="row-fluid">
    <form action="" method="get" style="margin:0px;" class="form-horizontal row search_form">
        
        <?PHP
        if(is_single_ashram_site)
        { 
        ?>
            <input type="hidden" name="ashram_id" id="ashram_id" value="<?php echo default_ashram_id; ?>">
        <?PHP
        }
        else if($this->currentUser->roles==1)
        {
            ?>
            <div class="col-md-2">
                <select name="ashram_id" id="ashram_id" onChange="switchAshram(this.value)" class="form-control input-inline custom-input">
                    <option value="0">Select Ashram</option>
                    <?PHP
                    foreach ($ashrams as $ashramData)
                    {
                        ?>
                        <option value="<?PHP echo $ashramData->id; ?>"
                        <?PHP
                        if($this->session->userdata("ashramId")==$ashramData->id)
                            echo " selected";
                        ?>
                        >
                            <?PHP echo $ashramData->name; ?>
                        </option>
                        <?PHP
                    }
                    ?>
                </select>
            </div>
            <script>
                function switchAshram(ashram_id)
                {
                    $.post("/ashramadmin/switchashram/"+ashram_id,{},function(res)
                    {
                        window.location.reload();
                    });
                }
            </script>
            <?PHP
        }
        if($this->session->userdata("ashramId"))
        {
            ?>
            <div class="col-md-2">
                <select name="type" id="type" class="input-inline form-control custom-input" onchange="search(1)">
                    <option value="">All Seva Types</option>
                    <option value="1" <?PHP if($this->input->get("type")=='1') echo "selected"; ?>>Poojas</option>
                    <option value="2" <?PHP if($this->input->get("type")=='2') echo "selected"; ?>>Donations</option>
                    <option value="3" <?PHP if($this->input->get("type")=='3') echo "selected"; ?>>Store</option>
                </select>
            </div>
            
            <br style="clear:both;" class="hidden-sm hidden-xs">
            
            <div class="col-md-2">
                <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
                class="input-inline form-control custom-input" value="<?PHP echo htmlentities($this->input->get("search_text")); ?>" />
            </div>
            <div class="col-md-2">
                <select name="search_col" id="search_col" class="input-inline form-control custom-input">
                    <option value="session_id" <?PHP if($this->input->get("search_col")=='session_id') echo "selected"; ?>>Session ID</option>
                    <option value="ip_address" <?PHP if($this->input->get("search_col")=='ip_address') echo "selected"; ?>>IP Address</option>
                    <option value="username" <?PHP if($this->input->get("search_col")=='username') echo "selected"; ?>>User ID</option>
                </select>
            </div>
            <div class="col-md-2">
                <input type="text" class="datepickerclass form-control input-inline custom-input"  name="from_date" id="from_date"
                placeholder="From date" value="<?PHP if($this->input->get("from_date")!='') echo $this->input->get("from_date"); else
                {
                    echo date("d M Y");
                    $_GET['from_date']=date("d M Y");
                } ?>" />
            </div>
            <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
            onClick="search(0)"><i class="fa fa-search"></i> Search</button>
            <?PHP
            if($this->input->get("search_text")!='' || $this->input->get("type")!='' || $this->input->get("from_date")!='')
            {
                ?>
                <a class="btn btn-xs red" href="/orders/cart_logs"><i class="fa fa-search-minus"></i> Clear</a>
                <?PHP
            }
        }
        
        ?>
    </form>
    <?PHP
    if($this->session->userdata("ashramId"))
    {
        ?>
        <br class="hidden-lg hidden-md">
        
        <div class="portlet box blue">
            <div class="portlet-title">
                <div class="caption"> <i class="fa fa-list"></i> Cart logs <span id="total_records"></span></div>
                <div class="tools">
                    <a href="javascript:;" onClick="CopyToClipboard('report')" style="margin-right: 10px;"><i class="fa fa-copy" style="color:#fff; position: absolute; margin: 3px 14px 0px -10px;"></i>
                    </a>
                    <a href="javascript:;" class="collapse"></a>
                </div>
            </div>
            
            <div class="portlet-body no-more-tables" id="report">
                <?PHP
                $this->db->query("SET SESSION group_concat_max_len = 10000000");
                $this->db->select("*,
                                    group_concat(message SEPARATOR '----') as messages,
                                    group_concat(date SEPARATOR '----') as dates,
                                    group_concat(username SEPARATOR '----') as usernames,
                                    group_concat(admin SEPARATOR '----') as admins,
                                    group_concat(type SEPARATOR '----') as types");
                if(in_array($this->input->get("type"),array(1,2,3)))
                {
                    $this->db->where("type",$this->input->get("type"));
                }
                if($this->input->get("search_text")!='')
                {
                    $this->db->like($this->input->get("search_col"),$this->input->get("search_text"));
                }
                if($this->input->get("from_date")!='')
                {
                    $this->db->where("DATE(date)",date("Y:m:d",strtotime($this->input->get("from_date"))));
                }
                $this->db->where("ashram_id",$this->session->userdata("ashramId"));
                $this->db->order_by("date","desc");
                $this->db->group_by("session_id","ip_address");
                $q=$this->db->get("cart_log");
                $i=1;
                foreach ($q->result() as $row)
                {
                    ?>
                    Session ID: <?PHP echo $row->session_id; ?><br>
                    IP Address: <?PHP echo $row->ip_address; ?>
                
                    <?PHP 
                    $messages=explode("----",$row->messages);
                    $dates=explode("----",$row->dates);
                    $types=explode("----",$row->types);
                    $usernames=explode("----",$row->usernames);
                    $admins=explode("----",$row->admins);
                    ?>
                    <table class="display table-bordered table-condensed table table-striped table-hover">
                        <thead>
                            <th width="14%">Date</th>
                            <th width="15%">Username</th>
                            <th>User Action</th>
                        </thead>
                        <tbody>
                            <?PHP
                            foreach ($messages as $key => $message)
                            {
                                ?>
                                <tr>
                                    <td data-title="Date" style="font-size: 12px;"><?PHP echo date("d M Y h:i:s A",strtotime($dates[$key])); ?></td>
                                    <td data-title="Username">
                                        <?PHP
                                        if($admins[$key]==1)
                                            echo $usernames[$key];
                                        else
                                        {
                                            ?>
                                            <a href="/usersadmin/view/<?PHP echo $usernames[$key]; ?>" target="_blank">
                                                <?PHP echo $usernames[$key]; ?>
                                            </a>
                                            <?PHP
                                        }
                                        ?>
                                    </td>
                                    <td data-title="User Action" style="display: flow-root;">
                                        <?PHP 
                                        echo $message;
                                        if($types[$key]==1)
                                        {
                                            ?>
                                            <span class="label label-dark-red pull-right">Poojas</span>
                                            <?PHP
                                        }
                                        if($types[$key]==2)
                                        {
                                            ?>
                                            <span class="label label-dark-green pull-right">Donations</span>
                                            <?PHP
                                        }
                                        if($types[$key]==3)
                                        {
                                            ?>
                                            <span class="label label-dark-blue pull-right">Store</span>
                                            <?PHP
                                        }
                                        if($types[$key]==4)
                                        {
                                            ?>
                                            <span class="label label-dark-purple pull-right">Subscriptions</span>
                                            <?PHP
                                        }
                                        ?>
                                    </td>
                                </tr>
                                <?PHP
                            }
                            ?>
                        </tbody>
                    </table>
                    <hr>
                    <?PHP
                    $i++;
                }
                if($q->num_rows()==0)
                {
                    ?>
                    <div class="alert alert-info">
                        No records found.
                    </div>
                    <?PHP
                }
                ?>
                <div style="clear:both;"></div>
            </div>
        </div>
        <?PHP
    }
    else
    {
        ?>
        <div class="alert alert-danger">
            Please select Ashram
        </div>
        <?PHP
    }
    ?>
</div>

<?PHP
if($this->session->userdata("ashramId"))
{
    ?>
    <script src="<?php
    echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
    <script src="<?php
    echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
    <script type = "text/javascript">
        function CopyToClipboard(containerid)
        {
            clearNotifications();
            var range = document.createRange();
            range.selectNode(document.getElementById(containerid));
            window.getSelection().addRange(range);
            document.execCommand("copy");
            showNotification("lime","Copied to clipboard");
        }

        var search_text = '';
        var search_col = '';
        var wild = '';
        var table = '';
        var status='';
        var from_date = '';
        var to_date = '';
        var search_col2='';
        var currency='';

        function search(flag)
        {
            /*clearNotifications();
            if(!$("#from_date").length || !$("#to_date").length || !$("#search_text").length || !$("#search_col").length || !$("#search_col2").length ||
            !$("#wild").length)
            {
                showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
                return;
            }
            if (flag == 0)
            {
                if ($("#from_date").length && $("#to_date").length && $("#search_text").length && 
                    $("#from_date").val().trim() == '' && $("#to_date").val().trim() == '' && $("#search_text").val().trim() == '') 
                {
                    showNotification('ruby','Please enter search keywords or select dates');
                    return false;
                }
                if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
                {
                    var frm=Date.parse($("#from_date").val());
                    var to=Date.parse($("#to_date").val());
                    if(frm>to)
                    {
                        showNotification('ruby','From date cannot be after To date');
                        return false
                    }
                }
            }
            $(".dataTables_processing").show();
            if($("#from_date").length)
                from_date = $("#from_date").val().trim();
            if($("#to_date").length)
                to_date = $("#to_date").val().trim();
            if($("#search_text").length)
                search_text = $("#search_text").val().trim();
            if($("#search_col").length)
                search_col = $("#search_col").val().trim();
            if($("#search_col2").length)
                search_col2 = $("#search_col2").val().trim();
            if($("#wild").length)
                wild = $("#wild").val().trim();
            if($("#status").length)
                status = $("#status").val();
            if($("#currency").length)
            currency=$("#currency").val();

            if (from_date != '' || to_date != '' || search_text != '')
                $("#searchClear").css("display", "inline-block");*/
            
            $(".search_form").submit();

        }

        function search_clear() 
        {
            $(".dataTables_processing").show();
            $("#search_text").val('');
            search_text = '';
            search_col = '';
            $("#search_col").val($("#search_col :first").val());
            search_col2='';
            $("#search_col2").val($("#search_col2 :first").val());
            wild = '';
            $("#from_date").val('');
            from_date = '';
            $("#to_date").val('');
            to_date = '';
            $("#searchClear").css("display", "none");
            status='';
            $("#status").val('');
            currency='';
            $("#currency").val($("#currency option:first").val());
            table.fnDraw();
        }

        var statusflag=0;
       
        $(document).ready(function()
        {
            table = $('#logs_table').dataTable({
                "processing": true,
                "language": {
                    "sProcessing": '<div class="spinnerspin"></div>',
                    "emptyTable": "No records found!"
                },
                "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
                "sPaginationType": "bootstrap",
                "serverSide": true,
                "iDisplayLength": 50,
                "order": [
                    [4, "desc"]
                ],
                "responsive": true,
                "lengthMenu": [
                    [20, 50, 100],
                    [20, 50, 100]
                ],
                "drawCallback": function(settings) 
                {
                    var api = this.api();
                    var totalrows = api.rows({
                        page: 'current'
                    }).data().context[0]._iRecordsTotal;
                    $("#total_records").html('(' + totalrows + ')');
                },
                "columns": [
                {
                    "width": "5%",
                    "orderable": false
                }, {
                    name: "tx",
                    width:'15%',
                    "orderable": true
                },
                {
                    name: "started_on",
                    width:'12%',
                    "orderable": true
                }, {
                    name:"created_on",
                    "width": "12%",
                    "orderable": true
                }, {
                    name:"modified_on",
                    "width": "12%",
                    "orderable": true
                }, {
                    "orderable": false
                }, {
                    name: "amount",
                    "width": "15%",
                    "orderable": true
                }],
                "ajax": {
                    url: '/orders/listtrans',
                    type: 'POST',
                    data: function(d) 
                    {
                        d.search_text = search_text;
                        d.search_col = search_col;
                        if (from_date != '')
                            d.from_date = from_date;
                        if (to_date != '')
                            d.to_date = to_date;
                        d.search_col2 = search_col2;
                        d.status = status;
                        d.wild = wild;
                        d.currency=currency
                    },
                    error: function (xhr, error, thrown) 
                    {
                        if(xhr.responseText=='login')
                        {
                            window.location="<?PHP echo base_url; ?>"
                        }
                        else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                        {
                           showNotification('ruby',"Invalid request");
                        }
                        $(".dataTables_processing").hide();
                        return false;
                    },
                    dataSrc:function(res)
                    {
                        if(res.data.length==0 && res.recordsTotal!=0)
                        {
                            table.fnDraw();
                        }
                        return res.data;
                    }
                },
                "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                    if(aData.trans_status==0)
                    {
                        $(nRow).addClass("fail");
                        $(nRow).find("td").addClass("fail");
                    }
                    if(aData.trans_status=='1')
                    {
                        $(nRow).addClass("success");
                        $(nRow).find("td").addClass("success");
                    }
                    if(aData.trans_status=='2')
                    {
                        $(nRow).addClass("init");
                        $(nRow).find("td").addClass("init");
                    }
                    var vis = true;
                    var ii = 0;
                    var sno = 0;

                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Tx ID");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Started on");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Tx date");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Modified on");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "User details");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Amount");
                        ii++;
                    }
                    return nRow;
                },
                "columnDefs":
                [
                    {
                        "render": function(data, type, row) {
                            return row.sno;
                        },
                        "targets": 0
                    }, {
                        "render": function(data, type, row) 
                        {
                            var str=row.tx+'<br>'+row.status;
                            if(row.trans_status==1)
                            {
                                str+='<br><a href="/orders/view/'+row.order_id+'" style="font-weight:bold;" target="_blank">View order <i class="fa fa-external-link"><i></a>';
                            }
                            return str;
                        },
                        "targets": 1
                    }, 
                    <?PHP
                    $cc=2;
                    ?>
                    {
                        "render": function(data, type, row) 
                        {
                            return row.started_on;
                        },
                        "targets": <?PHP echo $cc++; ?>
                    }, {
                        "render": function(data, type, row) 
                        {
                            return row.created_on;
                        },
                        "targets": <?PHP echo $cc++; ?>
                    }, {
                        "render": function(data, type, row) {
                            return row.modified_on;
                        },
                        "targets": <?PHP echo $cc++; ?>
                    }, {
                        "render": function(data, type, row) {
                            return row.firstname;
                        },
                        "targets": <?PHP echo $cc++; ?>,
                    }, {
                        "render": function(data, type, row) {
                            return row.amount;
                        },
                        "targets": <?PHP echo $cc++; ?>
                    }
                ]
            });

            $('.columnhide').on('click', function(e) 
            {
                var column = table.api().column( $(this).attr('data-column') );
                var cnum=$(this).attr('data-column');
                
                column.visible( ! column.visible(),true );
                var bVis = table.fnSettings().aoColumns[cnum].bVisible;
                var title = table.fnSettings().aoColumns[cnum].sTitle;
                
                var visibility=table.api().column(cnum).visible();
                table.api().column(cnum).nodes().to$().attr("data-title",title);
                if (visibility == false) 
                {
                    $(this).removeClass('blue').addClass('red');
                }
                else 
                {
                    $(this).removeClass('red').addClass('blue');
                }
            });
        });
        $("#excelButton").on("click",function()
        {
            var sortindex=table.fnSettings().aaSorting[0][0];
            var order_by=table.fnSettings().aoColumns[sortindex].name;
            var dir=table.fnSettings().aaSorting[0][1];
            $.post('/orders/listtrans/1',
            {
                status:status,search_text:search_text,wild:wild,search_col:search_col,order_by:order_by,dir:dir,search_col2:search_col2,from_date:from_date,to_date:to_date,currency:currency
            },
                function(res)
                {
                    var r=$.parseJSON(res);
                    if(r.flag==1)
                    {
                        window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
                    }
                    if(r.flag==2)
                    {
                        showNotification("ruby","Sorry! You have already requested the same report.");
                    }
                }
            );
        });
    </script>
     <?PHP
}
?>