<style type="text/css">
    .modal-body .block
    {
        margin:0px;
        padding: 0px 0px 10px 0px;
    }
    .help-block
    {
        color: #a94442;
        font-weight: bold;
        font-size: 13px;
    }
    #pet-lookup
    {
        height: 80%;
    }
    #pet-lookup .modal-body
    {
        overflow: auto;
    }
    .search_form .col-md-2
    {
        padding-left: 0px;
        padding-right: 5px;
        margin-bottom: 10px;
    }
    form .col-md-2 .input-inline
    {
        width: 100%;
    }
</style>
<div id="pet-lookup" class="modal fade in container">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
        <h4 class="modal-title" style="color:#fff;">Pets <span id="pet_total_records">0</span></h4>
    </div>
    <div class="modal-body no-more-tables">
            <form class="search_form">
                <div class="col-md-2">
                    <select name="photo_status" id="photo_status"  class="input-inline form-control custom-input" onchange="searchp(1)">
                        <option value="">All Photo Status</option>
                        <option value="1">With Photo</option>
                        <option value="0">Without Photo</option>
                    </select>
                </div>
                <br style="clear:both;" class="hidden-sm hidden-xs">
                <div class="col-md-2">
                    <input  type="text" id="search_textp" class="form-control input-inline custom-input"
                        placeholder="Type keyword to search..." style="border:1px solid skyblue;" />
                </div>
                <div class="col-md-2">
                    <select id="search_colp" class="form-control input-inline custom-input">
                        <option value="pet_name">Name</option>
                        <option value="pet_species">Species</option>
                        <option value="pet_type">Type</option>
                        <option value="pet_serial_number">Serial No.</option>
                    </select>
                </div>
               <!--  <div class="col-md-2">
                    <select id="wildp" class="form-control input-inline custom-input">
                        <option value="contains">Contains</option>
                        <option value="starts">Starts With</option>
                        <option value="ends">Ends With</option>
                    </select>
                </div> -->

                <button id="searchButtonp" class="btn btn-xs blue tooltips" onClick="searchp(0)"
                    type="button" data-container="body" data-placement="bottom" data-original-title="Search">
                    <i class="fa fa-search"></i>
                </button>
                <button id="clear_buttonp" class="btn btn-xs red display-hide tooltips" onClick="search_clearp()"
                    type="button" data-container="body" data-placement="bottom" data-original-title="Clear">
                    <i class="fa fa-search-minus"></i>
                </button>
            </form>
            <div class="clearfix margin-bottom-20"></div>

            <table id="pettable" class="display table-bed table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                <thead>
                    <tr>
                        <th width="70">S. No.</th>
                        <th width="20%">Serial No.</th>
                        <th width="8%">Photo</th>
                        <th>Name</th>
                        <th width="20%">Species</th>
                        <th width="10%">Type</th>
                        <th width="7%">Actions</th>
                    </tr>
                </thead>
                
            </table>
    </div>
    <div class="modal-footer">
        <input type="hidden" name="row_key" id="row_key">
        <button type="button" data-dismiss="modal" class="btn btn-xs default">
        <i class="fa fa-remove"></i> Close</button>
    </div>
</div>

<script type="text/javascript">
var search_text = '';
var search_col = '';
var tablep = '';
var country='';
var photo_status='';

function searchp(flag) 
{
    clearNotifications();
    if(!$("#search_textp").length || !$("#search_colp").length ||
        !$("#photo_status").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {
        if ($("#search_textp").val().trim() == '')
        {
            showNotification('ruby','Please enter search keywords');
            return false;
        }
    }
    $(".loader_animation").show();
    if($("#search_textp").length)
        search_text = $("#search_textp").val().trim();
    if($("#search_colp").length)
        search_col = $("#search_colp").val().trim();
    if($("#photo_status").length)
        photo_status = $("#photo_status").val().trim();
    if (search_text != '')
        $("#clear_buttonp").css("display", "inline-block");
    
    tablep.fnDraw();
}

function search_clearp()
{
    $(".loader_animation").show();
    $("#search_textp").val('');
    $("#photo_status").val('');
    search_text = '';
    search_col = '';
    photo_status='';
    $("#clear_buttonp").css("display", "none");
    tablep.fnDraw();
}
var statusflag=0;


$(document).ready(function()
{
    $("#photo_status").val('');
    $("#search_textp").val('');
    $("#search_colp").val($("#search_colp option:first").val());

    tablep = $('#pettable').dataTable(
    {
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [1, "asc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#pet_total_records").html('(' + totalrows + ')');
            jQuery(".tooltips").tooltip();
            $(".loader_animation").hide();
        },
        "columns": [
        {
            "width": "40",
            "orderable": false
        }, {
            name: "pet_serial_number",
            "width": "20%",
            "orderable": true
        }, {
            "width": "8%",
            "orderable": false
        }, {
            name: "pet_name",
            "width": "30%",
            "orderable": true
        }, {
            name: "pet_species",
            "width": "20%",
            "orderable": true
        }, {
            name: "pet_type",
            "width": "10%",
            "orderable": true
        }, {
            width: "10%",
            "orderable": false
        }],
        "ajax": {
            url: '/petsadmin/listc',
            type: 'POST',
            data: function(d) 
            {
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
                d.photo_status=photo_status;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".loader_animation").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    tablep.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Serial Number");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Photo");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Name");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Species");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Type");
                ii++;
            }
            
            sno++;
            if (this.api().column(sno).visible())
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                return row.pet_serial_number;
            },
            "targets": 1
        }, {
            "render": function(data, type, row) 
            {
                var str = '<img src="'+row.pet_photo+'" style="max-width:100%;">';
                return str;
            },
            "targets": 2
        }, {
            "render": function(data, type, row) 
            {
                return row.pet_name;
            },
            "targets": 3
        }, {
            "render": function(data, type, row) 
            {
                return row.pet_species;
            },
            "targets": 4
        }, {
            "render": function(data, type, row) 
            {
                var str=row.pet_type;
                return str;
            },
            "targets": 5
        }, {
            "render": function(data, type, row) 
            {
                var str = '<a href="javascript:;" class="btn btn-xs blue choose-pet" data-id="'+row.id+'" data-oid="<?PHP echo $order_item_id; ?>"><i class="fa fa-check"></i> Choose</a>';
                return str;
            },
            "targets": 6
        }]
    });
});
</script>