<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" User Dashboard | My Japams | Mantra Japam Report" type="hidden">
<?PHP
    $this->load->view("japams/user/nav_buttons");
?>
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<h3 class="page-title">
    Mantra Japam Report
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/myaccount">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
        	Mantra Japam Report
        </li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->


<div class="row-fluid">
	
    <form action="" name="" style="margin:0px;" onsubmit="return false" novalidate="" class="form-horizontal row search_form">
        <div class="col-md-2">
            <select name="japam_id" id="japam_id" class="form-control input-inline custom-input" onchange="search(1)">
                <option value="">All Mantras</option>
                <?PHP
                foreach ($japams as $japamData)
                {
                    ?>
                    <option value="<?PHP echo $japamData->id; ?>"><?PHP echo htmlentities($japamData->name); ?></option>
                    <?PHP
                }
                ?>
            </select>
        </div>
        <div class="col-md-2">
            <select name="donor_id" id="donor_id" class="form-control input-inline custom-input" onchange="search(1)">
                <option value="">Select Performed by</option>
                <?PHP
                foreach ($family_donors as $key=>$donor_data)
                {
                    ?>
                    <option value="<?PHP echo $donor_data['donor_id']; ?>">
                    <?PHP echo $donor_data['donor_name']."( ".$donor_data['donor_relation']." )"; ?></option>
                    <?PHP
                }
                ?>
            </select>
        </div>
        <div class="col-md-2">
            <select name="group_by" id="group_by" class="form-control input-inline custom-input" onchange="search(1)">
                <option value="">Total By</option>
                <option value="japam_id">Mantra</option>
            </select>
        </div>
        <br style="clear:both;" class="hidden-sm hidden-xs">
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input" id="from_date" placeholder="From date"/>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input" id="to_date" placeholder="To date"/>
        </div>
        <button id="searchButton" class="btn btn-xs blue tooltips" onClick="search(0)"
            type="button" data-container="body" data-placement="bottom" data-original-title="Search">
            <i class="fa fa-search"></i> Search
        </button>
        <button id="searchClear" class="btn btn-xs red tooltips" style="display:none;" onClick="search_clear() "
            type="button" data-container="body" data-placement="bottom" data-original-title="Clear">
            <i class="fa fa-search-minus"></i> Clear
        </button>
        <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="portlet box blue">
		<div class="portlet-title">
			<div class="caption">Mantra Japam Report <span id="total_records"></span> </div>
			<div class="tools">
				<a href="javascript:;" class="collapse"></a>
			</div>
            
		</div>
        
		<div class="portlet-body no-more-tables">
            <div class="col-md-12 nopadding column-buttons">
                <a href="javascript:;" data-order="desc" data-column="2" class="sortcolumn btn btn-xs default">Sort by count <i class="fa fa-arrow-down"></i></a>
            </div>
            <table class="table table-striped table-bordered table-hover table-condensed" id="report_list" style="width:100%;">
                <thead>
                    <tr>
                        <th width="50">S. No.</th>
                        <th>Mantra Name</th>
                        <th>Japam Count</th>
                        <th>Performed by</th>
                        <th>Day</th>
                        <th>Date</th>
                    </tr>
                </thead>
            </table>
            <div style="clear:both;"></div>
        </div>
   </div>
   
   
</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">

var from_date = '';
var to_date = '';
var donor_id = "";
var japam_id='';
var table='';
var group_by='';
if($("#group_by").length)
    group_by = $("#group_by").val().trim();
function search(flag) 
{
    clearNotifications();
    if(!$("#to_date").length || !$("#from_date").length || !$("#japam_id").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {
        if ($("#from_date").val().trim() == '' && $("#to_date").val().trim() == '') 
        {
            showNotification('ruby','Please select Dates');
            return false;
        }
        if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
        {
            var frm=Date.parse($("#from_date").val());
            var to=Date.parse($("#to_date").val());
            if(frm>to)
            {
                showNotification('ruby','From date cannot be after To date');
                return false
            }
        }
    }
    $(".dataTables_processing").show();
    if($("#japam_id").length)
        japam_id = $("#japam_id").val().trim();
    if($("#from_date").length)
        from_date = $("#from_date").val().trim();
    if($("#to_date").length)
        to_date = $("#to_date").val().trim();

    if($("#group_by").length)
        group_by = $("#group_by").val().trim();
    if($("#donor_id").length)
        donor_id = $("#donor_id").val().trim();
    if (to_date != '' || from_date!='')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();
}
function search_clear() 
{
    $(".dataTables_processing").show();
    $("#from_date").val('');
    $("#to_date").val('');
    from_date = '';
    to_date = '';
    japam_id = '';
    group_by='';
    donor_id = "";
    $("#group_by").val('');
    $("#donor_id").val('');
    $("#searchClear").css("display", "none");
    table.fnDraw();
}
$(document).ready(function() 
{
    table= $('#report_list').dataTable(
    {
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "order": [
            [2, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [10, 20],
            [10, 20]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            $('.tooltips').tooltip();
            sortIdentify();
        },
        "columns": 
        [
            {
                "width": 60,
                "orderable": false
            },
            {
                'name':"japam_id",
                "orderable": false,
                "width": "30%"
            },
            {
                name:"count",
                "orderable": true,
                "width": "15%"
            },
            {
                "width": "20%",
                "orderable": false
            },
            {
                "width": "15%",
                "orderable": false
            },
            {
                'name':"ju.date",
                "width": "15%",
                "orderable": true
            }
        ],
        "ajax": 
        {
            <?PHP
                $tableUrl="/myjapams/listreport/";
            ?>
            url: '<?PHP echo $tableUrl; ?>',
            type: 'POST',
            data: function(d)
            {
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                d.japam_id = japam_id;
                d.donor_id=donor_id;
                d.group_by=group_by;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    oTable.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Mantra Name");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Japam Count");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Performed by");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Day");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Date");
                ii++;
            }
        },
        "columnDefs": 
        [
            {
                "render": function(data, type, row) 
                {
                    return row.sno;
                },
                "targets": 0
            }, {
                "render": function(data, type, row)
                {
                    return row.name;
                },
                "targets": 1
            },
            {
                "render": function(data, type, row)
                {
                    return row.count;
                },
                "targets": 2
            },
            {
                "render": function(data, type, row)
                {
                    if(row.donor_name != "" && row.donor_relation != "")
                        return "<b>"+row.donor_name+" ( "+row.donor_relation +" )</b>" ;
                    else
                        return "N/A";
                },
                "targets": 3
            },
            {
                "render": function(data, type, row) 
                {
                    return row.day;
                },
                "targets": 4
            },
            {
                "render": function(data, type, row)
                {
                    return row.jdate;
                },
                "targets": 5
            }
        ]
    });
    $(".sortcolumn").on("click",function()
    {
        var currentSort = table.api().rows().context[0].aLastSort[0];   
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(currentSort.col==cnum)
        {
            if(currentSort.dir!=corder)
            {
                table.fnSort([cnum,corder]);
            }
        }
        else
        {
            table.fnSort([cnum,corder]);
        }
        sortIdentify();
    });
});
function sortIdentify()
{
    var currentSort = table.api().rows().context[0].aLastSort[0];
    $(".sortcolumn").each(function(i,ele)
    {
        $(this).removeClass("blue").addClass("default");
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(cnum==currentSort.col)
        {
            $(this).removeClass("default").addClass("blue");
            if(currentSort.dir=='desc')
            {
                $(this).attr("data-order","asc");
                $(this).find("i").removeClass("fa-arrow-up").addClass("fa-arrow-down");
            }
            if(currentSort.dir=='asc')
            {
                $(this).attr("data-order","desc");
                $(this).find("i").removeClass("fa-arrow-down").addClass("fa-arrow-up");
            }
        }
    });
}
$("#excelButton").on("click",function()
{
    $(".loader_animation").show();
    var sortindex=table.fnSettings().aaSorting[0][0];
    var order_by=table.fnSettings().aoColumns[sortindex].name;
    var dir=table.fnSettings().aaSorting[0][1];
    $.post('/myjapams/listreport/1',
    {
        japam_id:japam_id,order_by:order_by,dir:dir,group_by:group_by,from_date:from_date,to_date:to_date,donor_id:donor_id
    },
        function(res)
        {
            var r=$.parseJSON(res);
            if(r.flag==1)
            {
                //showNotification("lime","Excel report request captured '"+r.unique_id+"'.");
                window.location='<?PHP echo base_url; ?>myexcelreports/download/'+r.report_id;
            }
            if(r.flag==2)
            {
                showNotification("ruby","Sorry! You have already requested the same report.");
            }
            $(".loader_animation").hide();
        }
    );
});
</script>
