<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | All Mantras | Mantra Japam Report" type="hidden">
<style type="text/css">
    @media only screen and (min-width: 992px) and (max-width: 1450px){
        .buttons{
            padding: 29px 0px 6px 0px;
        }
    }
    @media only screen 
  and (min-width: 834px) 
  and (max-width: 1219px) {
        .inline{ padding: 0px 282px 0px 0px; 
                    margin-top: 5px !important;
                    float:right;}
        .bar {
          visibility: hidden;
        }
    }
</style>
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
    $this->load->view("japams/admin/nav_buttons");
?>
<h3 class="page-title">
    Mantra Japam Report
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/japamadmin">All Mantras</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
        	Mantra Japam Report
        </li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->

<div class="row-fluid">
	
    <form action="" name="" style="margin:0px;" onsubmit="return false" novalidate="" class="form-horizontal row search_form">
        <div class="col-md-2">
            <select name="japam_id" id="japam_id" class="form-control input-inline custom-input" onchange="search(1)">
                <option value="">All Mantras</option>
                <?PHP
                foreach ($japams as $japamData)
                {
                    ?>
                    <option value="<?PHP echo $japamData->id; ?>"><?PHP echo htmlentities($japamData->name); ?></option>
                    <?PHP
                }
                ?>
            </select>
        </div>
        <div class="col-md-2">
            <select name="country_id" id="country_id" class="form-control input-inline custom-input" onchange="search(1)">
                <option value="">All Countries</option>
                <?PHP
                foreach ($japam_countries as $countryData)
                {
                    ?>
                    <option value="<?PHP echo $countryData->country_id; ?>"><?PHP echo htmlentities($countryData->country); ?></option>
                    <?PHP
                }
                ?>
            </select>
        </div>
        <div class="col-md-2">
            <input type="text" name="search_city" id="search_city" placeholder="Search for city..."
            class="input-inline form-control custom-input" />
        </div>
        <br style="clear:both;" class="hidden-sm hidden-xs">
        <div class="col-md-2">
            <select name="gender" id="gender" class="form-control input-inline custom-input" onchange="search(1)">
                <option value="">All Gender</option>
                <option>Male</option>
                <option>Female</option>
                <option>Others</option>
            </select>
        </div>
        <div class="col-md-2">
            <select name="group_by" id="group_by" class="form-control input-inline custom-input" onchange="search(1)">
                <option value="">Total by</option>
                <option value="japam_id">Mantra</option>
                <option value="j.country_id">Country</option>
                <option value="j.city">City</option>
                <option value="j.user_id">User</option>
            </select>
        </div>
        <!-- <div class="col-md-2">
            <select name="sort_column" id="sort_column" class="form-control input-inline custom-input" onchange="search(1)">
                <option value="count">Sort By - Count</option>
                <option value="date">Sort By - Date</option>
                <option value="country_id">Sort By - Country</option>
                <option value="city">Sort By - City</option>
                <option value="first_name">Sort By - Name (A-Z)</option>
            </select>
        </div> -->
        <br style="clear:both;" class="hidden-sm hidden-xs">
        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="input-inline form-control custom-input" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                <option value="username">User ID</option>
                <option value="firstname">User First Name</option>
                <option value="lastname">User Last Name</option>
                <option value="donor_name">Performed by</option>
            </select>
        </div>
        <div class="col-md-2" style="display:none">
            <select name="wild" id="wild" class="input-inline form-control custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts with</option>
                <option value="ends">Ends with</option>
            </select>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input" id="from_date" placeholder="From date"/>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input" id="to_date" placeholder="To date"/>
        </div>
        <div class="buttons">
            <button id="searchButton" class="btn btn-xs blue tooltips" onClick="search(0)"
                type="button" data-container="body" data-placement="bottom" data-original-title="Search">
                <i class="fa fa-search"></i> Search
            </button>
            <button id="searchClear" class="btn btn-xs red tooltips" style="display:none;" onClick="search_clear() "
                type="button" data-container="body" data-placement="bottom" data-original-title="Clear">
                <i class="fa fa-search-minus"></i> Clear
            </button>
            <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
        </div>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="portlet box blue">
		<div class="portlet-title">
			<div class="caption">Mantra Japam Report <span id="total_records"></span> </div>
			<div class="tools">
				<a href="javascript:;" class="collapse"></a>
			</div>
            
		</div>
        
		<div class="portlet-body no-more-tables">
            <div class="col-md-12 column-buttons">
                <a href="javascript:;" data-order="desc" data-column="8" class="sortcolumn btn btn-xs default">Sort by count <i class="fa fa-arrow-down"></i></a>
                <a href="javascript:;" data-order="desc" data-column="9" class="sortcolumn btn btn-xs default">Sort by date <i class="fa fa-arrow-down"></i></a>
                <a href="javascript:;" data-order="desc" data-column="6" class="sortcolumn btn btn-xs default">Sort by country <i class="fa fa-arrow-down"></i></a>
                <a href="javascript:;" data-order="desc" data-column="5" class="sortcolumn btn btn-xs default">Sort by city <i class="fa fa-arrow-down"></i></a>
                <a href="javascript:;" data-order="desc" data-column="4" class="sortcolumn btn btn-xs default">Sort by name <i class="fa fa-arrow-down"></i></a>
                <span style="margin: 0px 20px; display: inline-block;" class="hidden-xs bar">|</span>
                <div class="clearfix visible-xs"></div>
                <div class="inline">
                    <a href="javascript:;" data-column="3" class="columnhide btn btn-xs red">Gender</a>
                    <a href="javascript:;" data-column="4" class="columnhide btn btn-xs blue">Performed by</a>
                    <a href="javascript:;" data-column="6" class="columnhide btn btn-xs blue">Country</a>
                    <a href="javascript:;" data-column="7" class="columnhide btn btn-xs red">Submissions</a>
                </div>
                <div style="clear:both;"></div>
            </div>
        
            <table class="table table-striped table-bordered table-hover table-condensed" id="report_list" style="width:100%;">
                <thead>
                    <tr>
                        <th width="50">S. No.</th>
                        <th>Mantra Name</th>
                        <th>User</th>
                        <th>Gender</th>
                        <th>Performed by</th>
                        <th>City</th>
                        <th>Country</th>
                        <th>Submissions</th>
                        <th>Japam Count</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    
                </tbody>
            </table>
            <div class="clearfix"></div>
        </div>
   </div>
   
   
</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">

var from_date = '';
var to_date = '';
var japam_id='';
var table='';
var gender='';
var search_text = '';
var search_col = '';
var wild = '';
var search_city = "";
var country_id='';
var group_by='';
function search(flag) 
{
    clearNotifications();
    if(!$("#search_text").length || !$("#search_col").length || !$("#wild").length || !$("#to_date").length || !$("#from_date").length || !$("#japam_id").length || !$("#group_by").length || !$("#country_id").length || !$("#search_city").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {
        if ($("#search_text").length && $("#search_text").val().trim() == '' && $("#search_city").val().trim() == '' && $("#country_id").val().trim() == '' && $("#japam_id").val().trim() == '' && $("#group_by").val().trim() == '' && $("#from_date").val().trim() == '' && $("#to_date").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords or select dates');
            return false;
        }
        if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
        {
            var frm=Date.parse($("#from_date").val());
            var to=Date.parse($("#to_date").val());
            if(frm>to)
            {
                showNotification('ruby','From date cannot be after To date');
                return false
            }
        }
    }
    $(".dataTables_processing").show();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#search_city").length)
        search_city = $("#search_city").val().trim();
    if($("#search_col").length)
        search_col = $("#search_col").val().trim();
    if($("#wild").length)
        wild = $("#wild").val().trim();
    if($("#japam_id").length)
        japam_id = $("#japam_id").val().trim();
    if($("#gender").length)
        gender = $("#gender").val().trim();
    if($("#country_id").length)
        country_id = $("#country_id").val().trim();
    if($("#from_date").length)
        from_date = $("#from_date").val().trim();
    if($("#to_date").length)
        to_date = $("#to_date").val().trim();

    if($("#group_by").length)
        group_by = $("#group_by").val().trim();

    if (to_date != '' || from_date!='' || search_text != '' || search_city != '' || japam_id != '' || country_id != '' || gender != '' || group_by != '')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();
}
function search_clear() 
{
    $(".dataTables_processing").show();
    $("#from_date").val('');
    $("#to_date").val('');
    $("#gender").val('');
    from_date = '';
    to_date = '';
    japam_id = '';
    gender='';
    country_id='';
    group_by='';
    $("#search_text").val('');
    $("#search_city").val('');
    $("#search_col").val($("#search_col:first").val());
    $("#group_by").val($("#group_by:first").val());
    $("#country_id").val($("#country_id:first").val());
    $("#wild").val($("#wild:first").val());
    search_text = '';
    search_col = '';
    wild = '';
    $("#searchClear").css("display", "none");
    table.fnDraw();
}
$(document).ready(function() 
{
    table= $('#report_list').dataTable(
    {
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [7, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20,50,100],
            [20,50,100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            $('.tooltips').tooltip();
            sortIdentify();
        },
        "columns": 
        [
            {
                "width": "7%",
                "orderable": false
            },
            {
                "width": "17%",
                "orderable": false
            },
            {
                name:"username",
                "width": "15%",
                "orderable": false
            },
            {
                "width": "10%",
                "orderable": false
            },
            {
                name:"donor_name",
                "width": "16%",
                "orderable": true
            },
            {
                name:"city",
                "width": "11%",
                "orderable": false
            },
            {
                name:"country",
                "width": "11%",
                "orderable": false
            },
            {
                name:"Submissions",
                "width": "8%",
                "orderable": false
            },
            {
                name:"count",
                "width": "10%",
                "orderable": true
            },
            {
                name:"date",
                "width": "12%",
                "orderable": true
            }
        ],
        "ajax": 
        {
            <?PHP
                $tableUrl="/japamadmin/listreport/";
            ?>
            url: '<?PHP echo $tableUrl; ?>',
            type: 'POST',
            data: function(d)
            {
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                d.japam_id = japam_id;
                d.gender=gender;
                d.search_text=search_text;
                d.search_col=search_col;
                d.wild=wild;
                d.country_id=country_id;
                d.group_by=group_by;
                d.search_city=search_city;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    oTable.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Mantra Name");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "User");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Gender");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Performed by");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "City");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Country");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Submissions");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Japam Count");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Date");
                ii++;
            }
        },
        "columnDefs": 
        [
            {
                "render": function(data, type, row) 
                {
                    return row.sno;
                },
                "targets": 0
            }, {
                "render": function(data, type, row) 
                {
                    return '<b>'+row.name+'</b>';
                },
                "targets": 1
            }, {
                "render": function(data, type, row) 
                {
                    var str = '';
                    if(row.ustatus==1)
                    {
                        str+='<i class="fa fa-user pull-right tooltips" style="color:green; margin-top:3px;"\
                        data-original-title="Active" data-placement="bottom"></i>';
                    }
                    else if(row.ustatus==0)
                    {
                        str+='<i class="fa fa-user pull-right tooltips" style="color:orange; margin-top:3px;"\
                        data-original-title="Inactive" data-placement="bottom"></i>';
                    }
                    else if(row.ustatus==2)
                    {
                        str+='<i class="fa fa-user pull-right tooltips" style="color:red; margin-top:3px;"\
                        data-original-title="Suspended" data-placement="bottom"></i>';
                    }
                    if(row.username=='N/A')
                        str+= 'N/A';
                    else
                    {
                        if(japam_id != "")
                            str+= '<a href="/japamadmin/user_report/'+row.username+'?japam_id='+japam_id+'" target="_blank">'+row.username+'</a>';
                        else
                            str+= '<a href="/japamadmin/user_report/'+row.username+'" target="_blank">'+row.username+'</a>';
                    }
                    if(row.username != "N/A")
                    {
                        str+= "<br>"+row.firstname +" "+ row.lastname;
                    }

                    return str;
                },
                "targets": 2
            },  {
                "render": function(data, type, row) 
                {
                    return row.gender;
                },
                "targets": 3,
                'bVisible':false
            },{
                "render": function(data, type, row) 
                {
                    if(row.donor_name != "" && row.donor_relation != "" && row.date != "N/A")
                        return "<b>"+row.donor_name+"</b>";
                    else
                        return "N/A";
                },
                "targets": 4,
                'bVisible':true
            }, {
                "render": function(data, type, row) 
                {
                    return row.city;
                },
                "targets": 5,
                'bVisible':true
            },{
                "render": function(data, type, row) 
                {
                    return row.country;
                },
                "targets": 6,
                'bVisible':true
            },
            {
                "render": function(data, type, row) 
                {
                    return row.submissions;
                },
                "targets": 7,
                'bVisible':false
            }, {
                "render": function(data, type, row) 
                {
                    return '<b>'+row.count+'</b>';
                },
                "targets": 8
            }, {
                "render": function(data, type, row) 
                {
                    if(row.date == "N/A")
                    {
                        return "N/A";
                    }
                    else
                    {
                        var weekday = ["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];
                        var a = new Date(row.date);
                        var dayname = weekday[a.getDay()];

                        return row.date+'<br>'+'<span class = "error" style="color:black;font-weight: bold;">'+dayname+'</span>';
                    }
                },
                "targets": 9
            }
        ]
    });
    $('.columnhide').on('click', function(e) 
    {
        var column = table.api().column( $(this).attr('data-column') );
        var cnum=$(this).attr('data-column');
        
        column.visible( ! column.visible(),true );
        var bVis = table.fnSettings().aoColumns[cnum].bVisible;
        var title = table.fnSettings().aoColumns[cnum].sTitle;
        
        var visibility=table.api().column(cnum).visible();
        table.api().column(cnum).nodes().to$().attr("data-title",title);
        if (visibility == false) 
        {
            $(this).removeClass('blue').addClass('red');
        }
        else 
        {
            $(this).removeClass('red').addClass('blue');
        }
    });

    $(".sortcolumn").on("click",function()
    {
        var currentSort = table.api().rows().context[0].aLastSort[0];   
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(currentSort.col==cnum)
        {
            if(currentSort.dir!=corder)
            {
                table.fnSort([cnum,corder]);
            }
        }
        else
        {
            table.fnSort([cnum,corder]);
        }
        sortIdentify();
    });
});
function sortIdentify()
{
    var currentSort = table.api().rows().context[0].aLastSort[0];
    $(".sortcolumn").each(function(i,ele)
    {
        $(this).removeClass("blue").addClass("default");
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(cnum==currentSort.col)
        {
            $(this).removeClass("default").addClass("blue");
            if(currentSort.dir=='desc')
            {
                $(this).attr("data-order","asc");
                $(this).find("i").removeClass("fa-arrow-up").addClass("fa-arrow-down");
            }
            if(currentSort.dir=='asc')
            {
                $(this).attr("data-order","desc");
                $(this).find("i").removeClass("fa-arrow-down").addClass("fa-arrow-up");
            }
        }
    });
}
$("#excelButton").on("click",function()
{
    $(".loader_animation").show();
    var sortindex=table.fnSettings().aaSorting[0][0];
    var order_by=table.fnSettings().aoColumns[sortindex].name;
    var dir=table.fnSettings().aaSorting[0][1];
    $.post('/japamadmin/listreport/1',
    {
        japam_id:japam_id,group_by:group_by,country_id:country_id,gender:gender,search_col:search_col,search_text:search_text,wild:wild,
        from_date:from_date,to_date:to_date,order_by:order_by,dir:dir,search_city:search_city
    },
        function(res)
        {
            var r=$.parseJSON(res);
            if(r.flag==1)
            {
                window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
            }
            if(r.flag==2)
            {
                showNotification("ruby","Sorry! You have already requested the same report.");
            }
            $(".loader_animation").hide();
        }
    );
});
</script>
