<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" User Dashboard | My Greetings | Send Greeting Card" type="hidden">
<style type="text/css">
    .preview-sub
    {
        font-weight:bold;
        display:block;
    }
    .preview-content
    {
        margin-bottom:10px;
        display:block;
    }
</style>
<?PHP echo $this->general_model->help_link(); ?>
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<h3 class="page-title">
    Send Greeting Card
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/myaccount">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
            Send Greeting Card
        </li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->
<div class="row-fluid">
   <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption">Send Greeting Card</div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
            
        </div>
        
        <div class="portlet-body no-more-tables">
        
            <form action="/mygreetings/send?gid=<?PHP echo $_GET['gid']; ?>" method="post" class="greeting_send">
                <div class="form-group">
                    <label class="control-label">From
                    </label>
                    <div class="form-content">
                        <?PHP
                        echo htmlentities($this->currentUser->firstname)." ".
                                htmlentities($this->currentUser->middlename)." ".
                                htmlentities($this->currentUser->lastname)." (".
                                htmlentities($this->currentUser->email).")";
                        ?>
                    </div>
                </div>
                <div class="form-group">
                    <a href="#address_book_modal"  role="button" data-toggle="modal" class="btn btn-xs blue pull-right"
                        style="margin-top:-5px;">
                        <i class="fa fa-plus"></i> Add from Address Book
                    </a>
                    <label class="control-label">Recipients
                    </label>
                    <div class="form-content">
                        <textarea class="form-control" name="recipients" id="recipients" rows="4"
                            placeholder=" Ex: test@jdg.org, user@mail.com, test@jdg.com, user@mail.com"></textarea>
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label">Subject
                    </label>
                    <div class="form-content">
                        <input type="text" class="form-control" name="subject" id="subject" placeholder="Subject" />
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label">Greeting
                    </label>
                    <div class="form-content" align="center">
                        <img src="<?PHP echo aws_s3_base_url; ?>content/greetings/<?PHP echo $greetingData->filename; ?>"
                            style="max-width:100%;">
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label">Message
                    </label>
                    <div class="form-content">
                        <textarea class="form-control" name="message" id="message" rows="4"></textarea>
                    </div>
                </div>
                <div class="form-group">
                    <div class="form-content">
                        <button type="submit" disabled name="send_mail" class="btn btn-xs blue">
                            <i class="fa fa-check"></i> Send
                        </button>
                        <a href="javascript:;" class="btn btn-xs green" id="preview-button">
                            <i class="fa fa-eye"></i> Preview
                        </a>
                        <a href="/mygreetings" class="btn btn-xs red">
                            <i class="fa fa-ban"></i> Cancel
                        </a>
                    </div>
                </div>
            </form>
        </div>
   </div>
   
   
</div>
<div id="greeting-modal" class="modal fade container" tabindex="-1">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
        <h4 class="modal-title">Greeting Preview</h4>
    </div>
    <div class="modal-body">
        <div class="scroller" data-height="400px">
            <span class="preview-sub">From:</span>
            <span class="preview-content">
                <?PHP
                echo htmlentities($this->currentUser->firstname)." ".
                        htmlentities($this->currentUser->middlename)." ".
                        htmlentities($this->currentUser->lastname)." (".
                        htmlentities($this->currentUser->email).")";
                ?>
            </span>

            <span class="preview-sub">Subject:</span>
            <span class="preview-content" id="preview-subject">
            </span>

            <span class="preview-sub">Greeting:</span>
            <span class="preview-content">
                <div align="center">
                    <img border="0" src="<?PHP echo aws_s3_base_url."content/greetings/".$greetingData->filename; ?>"
                        style="max-width:100%;">
                </div>
                <br>
                <div id="preview-message">
                </div>

                <br><br>
                Regards<br>
                <?PHP
                echo htmlentities($this->currentUser->firstname)." ".
                        htmlentities($this->currentUser->middlename)." ".
                        htmlentities($this->currentUser->lastname);
                ?>

            </span>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" data-dismiss="modal" class="btn btn-xs red">
            <i class="fa fa-remove"></i> Close
        </button>
    </div>
</div>

<div id="address_book_modal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
        <h4 class="modal-title">Address Book</h4>
    </div>
    <div class="modal-body">
        <div class="scroller" data-height="200px">
            <table class="table-bordered table-condensed table dataTable table-hover" id="contact_list">
                <thead>
                    <tr>
                        <th><input type="checkbox" name="checkall" onchange="checkall2(this)" id="checkall" /></th>
                        <th align="left">Name/Email ID</th>
                    </tr>
                </thead>
                <tbody>
                    
                </tbody>
            </table>
            
        </div>
        <button type="button" class="btn btn-xs blue" id="add-recipients" style="margin-top:10px;">
            <i class="fa fa-plus"></i> Add to Send list
        </button>
        <hr style="margin:5px 0px !important;" />
        <h4>Add New Contact</h4>
        <form class="contact_form" id="contact_form" novalidate>
            <div class="form-group">
                <div class="form-content">
                    <input type="text" class="form-control" name="contact_name" id="contact_name" placeholder="Name" />
                </div>
            </div>

            <div class="form-group">
                <div class="form-content">
                    <input type="text" class="form-control" name="contact_email" id="contact_email" placeholder="Email ID" />
                </div>
            </div>

            <div class="form-group">
                <div class="form-content">
                    <button type="submit" class="btn btn-xs blue">
                        <i class="fa fa-plus"></i> Add
                    </button>
                   <span style="color:red;" id="cont_error"></span>
                   <span style="color:green;" id="cont_ok"></span>
                </div>
            </div>
        </form>


    </div>
    <div class="modal-footer">
        <button class="btn btn-xs red addclose" data-dismiss="modal">
            <i class="fa fa-remove"></i> Cancel
        </button>
    </div>
</div>

<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
CKEDITOR.env.isCompatible = true;
CKEDITOR.replace( 'message',
{
    height:'200px',
    toolbar :
    [
        { name: 'indent', items : [ 'Bold','Italic','Underline','NumberedList','BulletedList','Link','Unlink'] }
    ]
});
$("#preview-button").on("click",function()
{
    var message=CKEDITOR.instances.message.getData();
    $("#preview-subject").html($("#subject").val());
    $("#preview-message").html(message);
    $("#greeting-modal").modal("show");
});

$(document).ready(function()
{

    jQuery.validator.addMethod("multiemail",function (value, element)
    {
        var email = value.split(/[,]+/); // split element by , and ;
        if(email.length<=20)
        {
            valid = true;
            for (var i in email)
            {
                value = email[i];
                valid = valid && jQuery.validator.methods.email_validate.call(this, $.trim(value), element);
            }
            jQuery.validator.messages.multiemail = "Please enter valid Email IDs seperated with commas";
            return valid;
        }
        else
        {
            jQuery.validator.messages.multiemail = "Maximum of 20 Email IDs are allowed";
            return false;
        }
    },"Please enter valid Email IDs seperated with commas");

    jQuery.validator.addMethod("removeDuplicates",function (value, element)
    {
        var email = value.split(/[,]+/); // split element by , and ;
        var uniqueEmails = [];
        $.each(email, function(i, el)
        {
            if($.inArray(el.trim(), uniqueEmails) === -1) 
            {
                uniqueEmails.push(el)
            }
        });
        var neww=uniqueEmails.join(",");
        $("#recipients").val(neww);
        return true;
    },"");

    $('.greeting_send').validate(
    {
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
        onKeyUp: true,
        rules:
        {
            recipients: {
                required: true,
                multiemail:true,
                removeDuplicates:true
            },
            subject: {
                required: true,
                minlength:3,
                maxlength:200
            }
        },

        messages:
        {
            recipients:
            {
                required: "Please enter at least one Email ID"
            },
            subject:
            {
                required:"Please enter Subject"
            }
        },
        highlight: function (element)
        {
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label, element)
        {
            $(element).closest('.form-group').removeClass('has-error');
            label.remove();
        },
        errorPlacement: function (error, element)
        {
            error.addClass('help-small no-left-padding').insertAfter(element);
        },
        submitHandler:function()
        {
            CKEDITOR.instances.message.updateElement();
            $('.greeting_send').submit();
        }
    });

    $('#contact_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
        onkeyup: false,
        rules: {
            contact_name: {
                required: true,
                minlength:2,
                maxlength:50
            },
            contact_email: 
            {
                required:true,
                minlength:6,
                maxlength:100,
                email_validate:true
            }
        },

        messages: {
            contact_name: {
                required: "Please enter Name"
            },
            contact_email: {
                required: "Please enter Email ID"
            }
        },
        highlight: function (element)
        {
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label, element)
        {
            $(element).closest('.form-group').removeClass('has-error');
            label.remove();
        },
        errorPlacement: function (error, element)
        {
            error.addClass('help-small no-left-padding').insertAfter(element);
        },
        submitHandler:function()
        {
            $.post('/myaddress_book/add_contact_ajax/',$('#contact_form').serialize(), function(res) 
            {
                if(res==1)
                {
                    get_contacts();
                    showNotification("lime","Contact added successfully");
                    $('#contact_form')[0].reset();
                }
                else
                {
                    showNotification("ruby","Error adding contact. Please try later");
                }
            });
            return false;
        }
    });
});

function get_contacts()
{
    $(".loader_animation").show();
    $("#contact_list tbody").html('');
    $.post('/myaddress_book/listall/',{}, function(res) 
    {
        var contacts=$.parseJSON(res);
        $.each(contacts,function(index,contact)
        {
            var table='\
                <tr id="contact-'+contact.id+'">\
                    <td><input type="checkbox" value="'+contact.email+'" id="chk'+index+'" /></td>\
                    <td style="word-break:break-all;">\
                    <a href="javascript:;" class="delete-contact pull-right btn btn-xs red" data-id="'+contact.id+'">\
                        <i class="fa fa-trash"></i>\
                    </a>\
                    '+contact.name+'\
                    <br>'+contact.email+'\
                    </td>\
                </tr>';
            $("#contact_list tbody").append(table);
        });
        $(".loader_animation").hide();
    },'html');
}
get_contacts();
function checkall2(el)
{
    var ip=document.getElementsByTagName('input')
    var i = ip.length - 1;
    var name='';
    for (i; i > -1; --i)
    {
        name=ip[i].name
        
        if(ip[i].type && ip[i].type.toLowerCase() === 'checkbox')
        {
            ip[i].checked = el.checked;
        }
    }
}

$("#add-recipients").on("click",function()
{
    clearNotifications();
    var val='';
    var ip=document.getElementsByTagName('input')
    var i = ip.length - 1;
    var name='';
    for (i; i > -1; --i)
    {
        name=ip[i].name
        
        if(ip[i].type && ip[i].type.toLowerCase() === 'checkbox' && ip[i].checked==true && ip[i].value!='on')
        {
            if(val.trim()!='' && val.trim().length>0) val+=",";
            val+=ip[i].value;
        }
    }   
    if(val=='')
    {
        showNotification("ruby","Please select at least one contact");
        return false
    }
    
    var mto=$('#recipients').val().trim();
    if(val!='')
    {
        if(mto!='' && mto.length>0) val+=',';
        val+=mto;
    }
    else val=mto;

    
    var vl=val.split(",");
    var final=Array();
    var ii=0;
    vl.forEach(function(entry) 
    {
       if(entry.trim()!='') final[ii]=entry;
       ii++;
    });

    var uni=$.unique(final);
    $('#recipients').val(uni);
    $("#address_book_modal").modal("hide");
    showNotification("lime","Contacts added to Recipients");
});
var statusflag=0;
$(".delete-contact").live("click",function()
{
    if(statusflag==1)
        return false;
    statusflag=1;
    var self=this;
    var pid=$(this).attr("data-id");
    $(this).attr("disabled","disabled");
    $(".loader_animation").show();
    $.post('/myaddress_book/delete/'+ pid, {}, function(res) 
    {
        var r = $.parseJSON(res);
        if (r.flag == 1) 
        {
            showNotification('ruby', "Contact '" + r.name + "' deleted successfully.");
        }
        else 
        {
            showNotification("ruby", "Error occured. Please try again.");
            $(self).removeAttr("disabled");
        }
        $("#contact-"+pid).remove();
        $(".loader_animation").hide();
        statusflag=0;
    });

});
</script>
