<?PHP
$partHeader='Add FAQ';
if($id)
{
    $partHeader=htmlentities($faq_data->question);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | FAQs | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
    $this->load->view("faqs/admin/nav_buttons");
?>
<h3 class="page-title">
    <?PHP
        echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="<?PHP echo base_url; ?>admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/faqadmin">All FAQs</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("faq_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("faq_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>FAQ created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("faq_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="faq_form" name="faq_form" method="post">
					<div class="form-group">
		                <label class="control-label">FAQ Category
		                </label>
		                <div class="form-content">
	                        <select name="faq_category"  class="form-control" >
                                <option value="">Select a Category</option>
                                <?PHP
                                foreach($categories as $ct)
                                {
                                    ?>
                                    <option value="<?PHP echo $ct->id; ?>"
                                    <?PHP
                                    if($id)
                                    if($ct->id==$faq_data->faq_category) echo "selected";
                                    ?>
                                    ><?PHP echo $ct->category; ?></option>
                                   
                                    <?PHP
                                }
                                ?>
                              </select>
		                </div>
		            </div>

		            <div class="form-group">
		                <label class="control-label">FAQ
		                </label>
		                <div class="form-content">
                            <input type="text" class="form-control" name="faq" id="faq"
		                        value="<?PHP if($id) echo htmlentities($faq_data->question); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label">Answer
		                </label>
		                <div class="form-content">
                            <textarea class="form-control" name="answer" id="answer" rows="6"><?PHP 
		                        if($id) echo htmlentities($faq_data->answer); ?></textarea>
		                </div>
		            </div>
		            <div class="form-group">
						<div class="form-content">
							<button type="submit" name="add_faq" id="add_faq" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add FAQ"; ?></button>
							<a href="/faqadmin" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>


				</form>
			</div>
		</div>



    </div>
 
</div>

<script type="text/javascript">
				
$( document ).ready(function() 
{			
	$('#faq_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		 onkeyup: false,
       rules: {
            faq_category: {
                required: true
            },
			faq: {
                required: true,
                minlength:3,
                maxlength:100
				
            },
			answer: {
                required: true,
				minlength:10,
				maxlength:5000
            }
        },

        messages: {
            faq_category: {
                required: "Please select a category"
            },
			faq: {
                required: "Please enter FAQ"
				
            },
			answer: {
                required: "Please give answer"
				
            }
        },
    	highlight: function (element)
        {
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label, element)
        {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },
        errorPlacement: function (error, element)
        {
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });
});
</script>
