<style type="text/css">
    .modal-body .block
    {
        margin:0px;
        padding: 0px 0px 10px 0px;
    }
    .help-block
    {
        color: #a94442;
        font-weight: bold;
        font-size: 13px;
    }
    #donor-lookup1
    {
        width:100% !important;
        margin:0px !important;
        left:0px;
        height: 100%;
        top: 0;
    }
    #donor-lookup
    {
        height: 80%;
    }
    #donor-lookup .modal-body
    {
        overflow: auto;
    }
    .search_form .col-md-2
    {
        padding-left: 0px;
        padding-right: 5px;
        margin-bottom: 5px;
    }
    form .col-md-2 .input-inline
    {
        width: 100%;
    }
</style>
<div id="donor-lookup" class="modal fade in container">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
        <h4 class="modal-title" style="color:#fff;">Family / Donors <span id="total_records">0</span></h4>
    </div>
    <div class="modal-body">
        <div class="row-fluid">
            <div class="col-md-12 no-more-tables">
                <form class="search_form">
                    <div class="col-md-2">
                        <input  type="text" id="search_text" class="form-control input-inline custom-input"
                            placeholder="Type keyword to search..." style="border:1px solid skyblue;" />
                    </div>
                    <div class="col-md-2">
                        <select name="search_col" id="search_col" class="form-control input-inline custom-input">
                            <option value="donor_name">Name</option>
                            <option value="donor_phone">Phone</option>
                            <option value="donor_email">Email ID</option>
                        </select>
                    </div>
                  <!--   <div class="col-md-2">
                        <select name="wild" id="wild" class="form-control input-inline custom-input">
                            <option value="contains">Contains</option>
                            <option value="starts">Starts With</option>
                            <option value="ends">Ends With</option>
                        </select>
                    </div> -->

                    <button id="searchButton" class="btn btn-xs blue tooltips"
                        type="button" data-container="body" data-placement="bottom" data-original-title="Search">
                        <i class="fa fa-search"></i>
                    </button>
                    <button id="clear_button" class="btn btn-xs red display-hide tooltips"
                        type="button" data-container="body" data-placement="bottom" data-original-title="Clear">
                        <i class="fa fa-search-minus"></i>
                    </button>
                </form>

                <table id="donortable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                    <thead>
                        <tr>
                            <th width="8%">S. No.</th>
                            <th width="10%">Relation</th>
                            <th width="10%">Photo</th>
                            <th width="20%">Name</th>
                            <th width="10%">Phone</th>
                            <th width="20%">Email ID</th>
                            <th width="12%">DOB</th>
                            <th width="10%">Actions</th>
                        </tr>
                    </thead>
                </table>
                <div class="clearfix"></div>

            </div>
        </div>
    </div>
    <div class="modal-footer">
        <input type="hidden" name="row_key" id="row_key">
        <button type="button" data-dismiss="modal" class="btn btn-xs default">
        <i class="fa fa-remove"></i> Close</button>
    </div>
</div>

<script type="text/javascript">
$("#donor-lookup").on("shown.bs.modal",function()
{
    var height=$(this).height();
    $("#donor-lookup .modal-body").css("height",(height-100)+"px");
});
$(document).ready(function()
{
    var search_text='';
    var search_col='';
    $("#searchButton").click(function()
    {
        if($("#search_text").val().trim()=='')
        {
            clearNotifications();
            showNotification("ruby","Please enter keywords");
            $("#search_text").focus();
            return false;
        }
        if($("#search_text").length)
            search_text = $("#search_text").val().trim();
        if($("#search_col").length)
            search_col = $("#search_col").val().trim();

        table.fnDraw();
        $("#clear_button").show();
    });

    $("#clear_button").click(function()
    {
        search_text = '';
        search_col = '';
        $("#search_text").val('')
        $("#clear_button").hide()
        table.fnDraw();
    });
    var table = $('#donortable').dataTable(
    {
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 20,
        "order": [
            [1, "asc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            var height=$("#donor-lookup").height();
            $("#donor-lookup .modal-body").css("height",(height-100)+"px");
        },
        "columns": [
        {
            "width": "8%",
            "orderable": false
        },{
            "name":"donor_relation",
            "width": "10%",
            "orderable": true
        }, {
            "name":"photo",
            "width": "10%",
            "orderable": false
        }, {
            name: "donor_name",
            "width": "20%",
            "orderable": true
        }, {
            name: "donor_phone",
            "width": "10%",
            "orderable": false
        }, {
            name: "donor_email",
            "width": "20%",
            "orderable": false
        }, {
            name: "donor_dob_day",
            "width": "12%",
            "orderable": false
        }, {
            "width": "10%",
            "orderable": false
        }],
        "ajax": {
            url: '/donations/list_donors',
            type: 'POST',
            data: function(d) 
            {
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
                //d.country=country;
                //d.photo_status=photo_status;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Relation");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Photo");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Name");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Phone");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Email ID");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "DOB");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) {
                return row.sno;
            },
            "targets": 0
        },{
            "render": function(data, type, row) 
            {
                return '<span style="font-weight:bold;color:#f85050;">'+row.donor_relation+'<span>';
            },
            "targets": 1
        }, {
            "render": function(data, type, row) 
            {
                return '<img src="'+row.donor_photo+'" style="max-width:65px;">';
            },
            "targets": 2
        }, {
            "render": function(data, type, row) 
            {
                return '<b>'+row.donor_name+'</b>';
            },
            "targets": 3
        }, {
            "render": function(data, type, row) 
            {
                if(row.donor_phone == '')
                {
                    return '-';
                }
                return row.donor_phone;
            },
            "targets": 4
        }, {
            "render": function(data, type, row) 
            {
                if(row.donor_email == '')
                {
                    return '-';
                }
                var str=row.donor_email;
                return str;
            },
            "targets": 5
        }, {
            "render": function(data, type, row) 
            {
                if(row.donor_dob == '')
                {
                    return '-';
                }
                return row.donor_dob;
            },
            "targets": 6
        }, {
            "render": function(data, type, row) 
            {
                var str = '<a href="javascript:;" class="btn btn-xs blue choose-donor" data-id="'+row.id+'" data-key="<?PHP echo $row_key; ?>"><i class="fa fa-check"></i> Select</a>';

                return str;
            },
            "targets": 7
        }]
    });
});
</script>