<style type="text/css">
    .notification-time
    {
        text-align:right;
    }
    .notification-title
    {
        margin-right:0px !important;
    }
    .notification-title .desc
    {
        text-decoration:none !important;
    }
    .feeds li
    {
        -webkit-transition: all 200ms linear;
        -moz-transition: all 200ms linear;
        -ms-transition: all 200ms linear;
        -o-transition: all 200ms linear;
        transition: all 200ms linear;
    }
    .notification-close
    {
        cursor: pointer;
        padding: 1px 0px 0px 0px;
        position: absolute;
        right: -50px;
        -webkit-transition: all 200ms linear;
        -moz-transition: all 200ms linear;
        -ms-transition: all 200ms linear;
        -o-transition: all 200ms linear;
        transition: all 200ms linear;
    }
    .clear-all
    {
        margin:3px 10px 0px 0px !important;
        cursor: pointer;
        opacity:0.8;
        display:none;
    }
    .clear-all:hover
    {
        opacity:1;
    }
</style>
<!-- <a href="javascript:;" class="page-quick-sidebar-toggler"><i class="icon-close"></i></a> -->
<div class="page-quick-sidebar-wrapper">
    <div class="page-quick-sidebar">            
        <div class="nav-justified">
            <ul class="nav nav-tabs nav-justified">
               <!--  <li class="active">
                   <a href="#quick_sidebar_tab_1" data-toggle="tab">
                   Users <span class="badge badge-danger">2</span>
                   </a>
               </li> -->
                <li class="active">
                    <a href="#quick_sidebar_tab_2" data-toggle="tab">
                    Alerts
                        <div class="clear-all badge badge-danger" id="clear-all" >Clear All</div>
                     <!-- <span class="badge badge-success">7</span> -->
                    </a>
                </li>
                <!-- <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                    More<i class="fa fa-angle-down"></i>
                    </a>
                    <ul class="dropdown-menu pull-right" role="menu">
                        <li>
                            <a href="#quick_sidebar_tab_3" data-toggle="tab">
                            <i class="icon-bell"></i> Alerts </a>
                        </li>
                        <li>
                            <a href="#quick_sidebar_tab_3" data-toggle="tab">
                            <i class="icon-info"></i> Notifications </a>
                        </li>
                        <li>
                            <a href="#quick_sidebar_tab_3" data-toggle="tab">
                            <i class="icon-speech"></i> Activities </a>
                        </li>
                        <li class="divider">
                        </li>
                        <li>
                            <a href="#quick_sidebar_tab_3" data-toggle="tab">
                            <i class="icon-settings"></i> Settings </a>
                        </li>
                    </ul>
                </li> -->
            </ul>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function()
    {
        function getNotifications()
        {
            $.post("/getnotifications",{},function(res)
            {
                var ids=new Array();
                var i=0;
                $("#notification-container li").each(function(obj)
                {
                    if($(this).attr("data-id")!=undefined)
                    {
                        ids[i]=$(this).attr("data-id");
                        i++;
                    }
                });
                var r=$.parseJSON(res);
                var newNotifications=0;
                $.each(r,function(index,notification)
                {
                    if(i==0 || $.inArray(notification.id,ids)=== -1)
                    {
                        var link='javascript:;';
                        if(notification.link!='')
                            link=notification.link;
                        var template='<li data-id="'+notification.id+'"> \
                                    <div class="notification-close badge badge-danger" id="close'+notification.id+'" data-id="'+notification.id+'"><i class="fa fa-remove"></i></div> \
                                    <a href="'+link+'"> \
                                    <div class="col1"> \
                                        <div class="cont notification-title"> \
                                            <div class="cont-col1"> \
                                                <div class="label label-sm '+notification.icon_label+'"> \
                                                    <i class="'+notification.icon_class+'"></i> \
                                                </div> \
                                            </div> \
                                            <div class="cont-col2"> \
                                                <div class="desc"> \
                                                     '+notification.message+' \
                                                </div> \
                                            </div> \
                                        </div> \
                                    </div> \
                                    <div class="col1 notification-time"> \
                                        <div class="date timeago" title="'+notification.date+'" data-value="'+notification.date+'"> \
                                             20 mins \
                                        </div> \
                                    </div> \
                                    </a> \
                                </li>';
                        $("#notification-container").prepend(template);
                        if(notification.count_status==0)
                            newNotifications++;
                    }
                });
                $(".timeago").timeago();
                var oldNotifications=0;
                if($("#notification-badge").html()!='')
                {
                    oldNotifications=parseInt($("#notification-badge").html());
                }
                $("#notification-badge").html(oldNotifications+newNotifications);
                if(oldNotifications+newNotifications>0)
                $("#notification-badge").show();
                if($(".notification-close").length>0)
                    $("#clear-all").show();
                setTimeout(getNotifications, 30000);
            });
        }
        //getNotifications();

        $('.top-menu .dropdown-quick-sidebar-toggler a, .page-quick-sidebar-toggler').click(function (e)
        {
            $("#notification-badge").hide();
            $("#notification-badge").html('');
        });

    });
    $(".feeds li").live("mouseover",function()
    {
        var did=$(this).attr("data-id");
        $("#close"+did).css("right","12px");
    });
    $(".feeds li").live("mouseout",function()
    {
        var did=$(this).attr("data-id");
        $("#close"+did).css("right","-50px");
    });
    $(".notification-close").live("click",function()
    {
        var did=$(this).attr("data-id");
        var h=$("li[data-id='"+did+"']").height()+5;
        var w=$("li[data-id='"+did+"']").width()+20;
        $("li[data-id='"+did+"']").animate(
        {
            height:-h,
            opacity:0,
            width:-w
        },300,function()
        {
            $("li[data-id='"+did+"']").remove();
            if($(".notification-close").length==0)
                $("#clear-all").hide();
            $.post("/getnotifications/remove/"+did,{},function(res)
            {

            });
        });
    });
    $("#clear-all").live("click",function()
    {
        $(".notification-close").click();
        $(this).hide();
    });

</script>