<?PHP
$partHeader='Add Checklist';
if($id)
{
    $partHeader=htmlentities($checklistData->topic);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | All Checklists | <?PHP echo $partHeader; ?>" type="hidden">
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
    $this->load->view("checklists/admin/nav_buttons");
?>
<h3 class="page-title">
    <?PHP
        echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/checklistadmin">All Checklists</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
        	<?PHP echo $partHeader; ?>
        </li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->

<?PHP
if($this->session->flashdata("ck_created"))
{
    ?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Checklist created successfully.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("ck_saved"))
{
    ?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("ck_error"))
{
    ?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Invalid request.</strong>
    </div>
    <?PHP
}
?>
<div class="row-fluid">
	
                          
   <div class="portlet box blue">
		<div class="portlet-title">
			<div class="caption"><?PHP echo $partHeader; ?></div>
			<div class="tools">
				<a href="javascript:;" class="collapse"></a>
			</div>
            
		</div>
        
		<div class="portlet-body">
        
            <form action="" id="ck_form" name="ck_form" novalidate method="post">
                
                <div class="form-body">
                    
                    <div class="form-group">
                        <label class="control-label">Role <span class="required">* </span>
                        </label>
                        <div class="form-content">
                                <select name="role" id="role" class="form-control">
                                    <option value="">Select Role</option>
                                    <?PHP
                                    foreach ($roles as $role)
                                    {
                                        ?>
                                        <option value="<?PHP echo $role->id; ?>"
                                        <?PHP
                                            if($id)
                                            {
                                                if($checklistData->role==$role->id)
                                                {
                                                    echo "selected";
                                                }
                                            }
                                        ?>>
                                        <?PHP echo $role->role; ?></option>
                                        <?PHP
                                    }
                                    ?>
                                    
                                </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Topic
                        </label>
                        <div class="form-content">
                            <input type="text" class="form-control" name="topic" id="topic"
                                value="<?PHP
                                if($id)
                                echo htmlentities($checklistData->topic); ?>" placeholder="Enter Topic" >
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Content
                        </label>
                        <div class="form-content">
                            <textarea class="form-control" id="content" name="content" rows="6"><?PHP
                                if($id)
                                echo $checklistData->content; ?></textarea>
                        </div>
                    </div>
                    

                </div>
               

                <div class="form-actions fluid">
                    <label class="control-label"></label>
                    <div class="form-content">
                        <button type="submit" class="btn green btn-xs submit-button" name="ck_create">
                            <i class="fa fa-check"></i> 
                            <?PHP
                            if($id) echo "Save";
                            else
                                echo "Add Checklist";
                            ?>
                        </button>
                        <a href="/checklistadmin" class="btn btn-xs red">
                            <i class="fa fa-ban"></i> Cancel
                        </a>
                    </div>
                
                </div>

            </form>
            <div style="clear:both;"></div>
       
        </div>
   </div>
   
   
</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
CKEDITOR.env.isCompatible = true;
CKEDITOR.replace( 'content',
{
    height:'250px',
    toolbar :
        [
    { name: 'basicstyles', items : [ 'Bold','Italic','Underline'] },
    { name: 'paragraph', items : [ 'NumberedList','BulletedList'] },
    { name: 'links', items : [ 'Link','Unlink']}
    ]
});
$(document).ready(function()
{
    var form2 = $('#ck_form');

    form2.validate(
    {
        errorElement: 'span', //default input error message container
        errorClass: 'help-block help-block-error', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
        ignore: "",  // validate all fields including form hidden input
        rules: {
            role:
            {    
                required: true
            },
            topic:
            {    
                required: true,
                minlength: 6,
                maxlength:100
            }
        },
        messages:
        {
            role: {
                required: "Please select Role"
            },
            topic:
            {
                required: "Please enter Topic"
            }
        },
        errorPlacement: function (error, element)
        {
            error.addClass('help-small no-left-padding').insertAfter(element);
        },

        highlight: function (element)
        {
            $(element)
                .closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label, element)
        {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            label.remove();
        }
    });
})
</script>