<!-- BEGIN PAGE HEADER-->
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<input class="current-browser-title" data-title=" Admin Dashboard | Categories" type="hidden">
<style type="text/css">
    @media only screen and (max-width: 320px) and (max-width: 360px){
        #ashram_id{
            width : 75%;
        }
    }
</style>
<?PHP $this->load->view("categories/admin/nav_buttons"); ?>
<h3 class="page-title">
  All Categories
</h3>
<div class="page-bar">
  <ul class="page-breadcrumb">
    <li>
      <i class="fa fa-home"></i>
      <a href="<?PHP echo base_url; ?>admin">Dashboard</a>
      <i class="fa fa-angle-right"></i>
    </li>
    <li>All Categories
    </li>
  </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->
<!-- END PAGE HEADER-->
<?PHP
if($this->session->flashdata('category_error'))
{
?>
<div class="alert alert-danger">
  <button class="close" data-dismiss="alert"></button>
  <strong>Invalid request</strong>
</div>
<?PHP
}
if($this->session->flashdata('category_bulk_deleted'))
{
  ?>
  <div class="alert alert-danger">
    <button class="close" data-dismiss="alert"></button>
    <strong>'<?PHP echo $this->session->flashdata('category_num') ?>' Category(s) deleted successfully.</strong>
  </div>
  <?PHP
}
if($this->session->flashdata('category_deleted'))
{
?>
<div class="alert alert-danger">
  <button class="close" data-dismiss="alert"></button>
  <strong>Category '<?PHP echo htmlentities($this->session->flashdata('category_name')) ?>'  deleted successfully.</strong>
</div>

<?PHP
}
$categories=$this->categories_model->categoriesList['categories'];

?>
<div class="alert alert-info">
    <strong>Only global categories are displayed until Ashram selection</strong>
</div>
<div class="row-fluid">
  <div class="span12">
    <div class="portlet box blue">
      <div class="portlet-title">
        <div class="caption"> <i class="fa fa-list"></i> All Categories (<?PHP echo count($categories)/2;  ?>)</div>
        <div class="tools">
          <a href="javascript:;" class="collapse"></a>
        </div>
      </div>
      <div class="portlet-body no-more-tables" style="display: block;">
        <button type="button" id="excelButton" class="btn btn-xs green excelButton pull-right" ><i class="fa fa-file-excel-o"></i> Report</button>
        <form name="listcategories" action="/categoriesadmin/bulk"  method="post"
          style="margin:0px;">
            <?PHP
            if(in_array(global_site_flag, [2,4]))
            {
              ?>
              <input type="hidden" name="ashram_id" id="ashram_id" value="0">
              <?PHP
            }
            else if($this->currentUser->roles==1 || $this->currentUser->roles==7)
            {
                ?>
                <select name="ashram_id" id="ashram_id" onChange="switchAshram(this.value)" class="form-control custom-input input-inline">
                    <option value="0">Select Ashram</option>
                    <?PHP
                    foreach ($ashrams as $ashramData)
                    {
                        ?>
                        <option value="<?PHP echo $ashramData->id; ?>"
                        <?PHP
                        if($this->session->userdata("ashramId")==$ashramData->id)
                            echo " selected";
                        ?>
                        >
                            <?PHP echo $ashramData->name; ?>
                        </option>
                        <?PHP
                    }
                    ?>
                </select>
                <script>
                    function switchAshram(ashram_id)
                    {
                        $.post("/ashramadmin/switchashram/"+ashram_id,{},function(res)
                        {
                            window.location.reload();
                        });
                    }
                </script>
                <?PHP
            }
            ?>
          <div class="clearfix visible-xs visible-md"></div>
          <input type="hidden" name="action" id="action" value="" />
          <select name="action1" id="action1" class="form-control custom-input input-inline">
            <option value="">Bulk Actions</option>
            <option value="bulk_delete">Delete</option>
          </select>
          <button type="button" onclick="chk('bulk_delete1')" name="bulk_delete1" class="btn btn-xs blue">
          <i class="fa fa-check"></i> Apply</button>
          <span id="cat_error1" style="font-size:12px; color:red;"></span>
          <table class="table-bordered table-striped table table-condensed table-hover" id="tabledatalist">
            <thead class="cf">
              <tr>
                <th width="30" class="visible-md visible-lg">
                  <input type="checkbox" onchange="checkall(this)">
                </th>
                <th width="10%">Category ID</th>
                <?PHP
                if(!in_array(global_site_flag, [2,4]))
                {
                  ?>
                  <th width="20%">Ashram</th>
                  <?PHP
                }
                ?>
                <th width="20%">Category Name</th>
                <th width="20%">Slug</th>
                <th>Category Description</th>
                <th width="10%">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?PHP
              $i = 1;
              $this->categories_model->buildCategoryAdminList(0,1);
              if(count($this->categories_model->categoriesList['categories'])==0)
              {
                ?>
                <tr>
                  <td colspan="6">
                    No records found.
                  </td>
                </tr>
                <?PHP
              }
              ?>
            </tbody>
          </table>
          <select name="action2" id="action2" class="form-control input-inline custom-input">
            <option value="">Bulk Actions</option>
            <option value="bulk_delete">Delete</option>
          </select>
          <button type="button" onclick="chk('bulk_delete2')" name="bulk_delete2" class="btn btn-xs blue" >
          <i class="fa fa-check"></i> Apply</button>
          <span id="cat_error2" style="font-size:12px; color:red;"></span>
        </form>
      </div>
    </div>
  </div>
</div>
<div id="conf123" class="modal fade" role="dialog">
  <div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
    <h4 class="modal-title">Delete Confirmation</h4>
  </div>
  <div class="modal-body">
    <div class="pull-left" style="margin-right: 10px; margin-top: 8px;">
      <i class="fa fa-exclamation-triangle" style="color:red; font-size:36px; vertical-align:middle;"></i>
    </div>
    Do you really want to delete the Categories?
  </div>
  <div class="modal-footer">
    <button type="button" data-dismiss="modal" class="btn btn-xs close261">
    <i class="fa fa-remove"></i> Cancel</button>
    <a href="javascript:;" onclick="document.listcategories.submit();"
    class="btn btn-xs red"><i class="fa fa-trash"></i> Delete</a>
  </div>
</div>
<script type="text/javascript">
function chk(id)
{
    var chkd = '';
    var ip = document.getElementsByTagName('input')
    var i = ip.length - 1;
    var one = 0;
    for (i; i > -1; --i) {
        var nme = ip[i].name;
        if (ip[i].type && ip[i].type.toLowerCase() === 'checkbox' && nme != '' && nme != 'checkall') {
            if (ip[i].checked) {
                if (chkd != '') chkd += ',';
                chkd += ip[i].value;
                one++;
                break;
            }
        }
    }
    if (id == 'bulk_delete1') {
        if (document.getElementById('action1').value == '') {
            document.getElementById('cat_error1').innerHTML = 'Please select action';
            return false;
        } else if (one == 0) {
            document.getElementById('cat_error1').innerHTML = 'No category selected';
            return false;
        }
        document.getElementById('action').value = document.getElementById('action1').value
    }
    if (id == 'bulk_delete2') {
        if (document.getElementById('action2').value == '') {
            document.getElementById('cat_error2').innerHTML = 'Please select action';
            return false;
        } else if (one == 0) {
            document.getElementById('cat_error2').innerHTML = 'No category selected';
            return false;
        }
        document.getElementById('action').value = document.getElementById('action2').value
    }
    $("#conf123").modal();
    //document.listcategories.submit();
}

function checkall(el)
{
    var ip = document.getElementsByTagName('input')
    var i = ip.length - 1;
    var name = '';
    for (i; i > -1; --i) {
        name = ip[i].name
        if (ip[i].type && ip[i].type.toLowerCase() === 'checkbox') {
            ip[i].checked = el.checked;
        }
    }
}
$("#excelButton").on("click",function()
{
    $(".loader_animation").show();
    clearNotifications();
    $.post('/categoriesadmin/export_categories',
    {
    },
        function(res)
        {
            var r=$.parseJSON(res);
            if(r.flag==1)
            {
                window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
            }
            if(r.flag==2)
            {
                showNotification("ruby","Sorry! You have already requested the same report.");
            }
            if(r.flag==0)
            {
                showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
            }
            $(".loader_animation").hide();
        }
    );
});
</script>