<input class="current-browser-title" data-title="Calendar" type="hidden">
<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<style type="text/css">
	.event-name
	{
		color:#BC110A !important;
		font-size:16px;
		font-weight:500;
		display:block;
	}
</style>
<?PHP
$partHeader="Calendar";
if(isset($yearmonths['years'][0]))
    $currentYear=$yearmonths['years'][0];
else
{
    $currentYear=date("Y");
}
?>
<input class="current-browser-title" data-title="<?PHP echo $partHeader; ?>" type="hidden">
<div class="page-content">
	<!-- BEGIN PAGE HEADER-->
    <h3 class="page-title">
        <i class="icomoon-calendar6"></i>
        <span class="top-line">
            <?PHP echo $partHeader; ?>
            <span id="extra_title"><?PHP echo $currentYear; ?></span>
        </span>
        <br>
        <span class="caption">
            <?PHP echo site_short_name; ?> <?PHP echo $partHeader; ?>
        </span>
    </h3>
    <div class="clearfix"></div>
	<div class="page-bar">
		<ul class="page-breadcrumb">
			<li>
				<a href="/">Home</a>
				<i class="fa fa-angle-right"></i>
			</li>
			<li>
				Calendar
			</li>
		</ul>
	</div>
	<!-- END PAGE HEADER-->
    <div class="alert alert-info">
        <strong>Events public URL:</strong>
        <a href="<?php echo base_url. "events"; ?>" target="_blank">
        <?php echo base_url . "events"; ?></a>
    </div>
	<form action="" method="get" name="" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form margin-bottom-10">
        <input type="hidden" name="param" id="param"/>
        <input type="hidden" name="order" id="order"/>
        
        <div class="col-md-2">
            <select name="calendar" id="calendar" class="form-control input-sm">
                <option value="">All Calendar Types</option>
                <option value="1" <?PHP if(isset($_GET['type']) && $_GET['type']=='swamiji_calendar') echo 'selected'; ?>>Swamiji Calendar</option>
                <option value="2" <?PHP if(isset($_GET['type']) && $_GET['type']=='bala_swamiji_calendar') echo 'selected'; ?>>Bala Swamiji Calendar</option>
                <option value="3" <?PHP if(isset($_GET['type']) && $_GET['type']=='website_calendar') echo 'selected'; ?>><?PHP echo site_short_name; ?> Calendar</option>
            </select>
        </div>
        <div class="col-md-2">
            <select name="year" id="year" class="form-control input-sm">
            	<?PHP
            		foreach ($yearmonths['years'] as $year)
            		{
            			?>
            			<option value="<?PHP  echo $year; ?>" <?PHP if(isset($_GET['year']) && $_GET['year']==$year) echo 'selected'; ?>>
            				<?PHP  echo $year; ?>
            			</option>
            			<?PHP
            		}
            	?>
            </select>
        </div>
        <div class="col-md-2">
            <select name="month" id="month" onChange="search(1)" class="form-control input-sm">
            	<option value="">All Months</option>
            	<?PHP
            		
            		foreach ($this->months as $key=> $monthName)
            		{
                        if(!empty($yearmonths['months'][$currentYear]))
                			if(in_array($key,$yearmonths['months'][$currentYear]))
                			{
    	            			?>
    	            			<option value="<?PHP  echo $key; ?>" <?PHP if(isset($_GET['month']) && $_GET['month']==$key) echo 'selected'; ?>>
    	            				<?PHP  echo $monthName; ?>
    	            			</option>
    	            			<?PHP
                			}
            		}
            	?>
            </select>
        </div>
        <!-- <br style="clear:both;" class="hidden-sm hidden-xs"> -->
        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="form-control input-sm" value="<?PHP if(isset($_GET['text']) && $_GET['text']!='') echo $_GET['text']; ?>" />
        </div>
        <button type="button" id="searchButton" class="btn btn-sm blue searchButton"><i class="fa fa-search"></i> Search</button>
        <?PHP
        $showClearButton = 0;
        if((isset($_GET['type']) && $_GET['type']!="") || (isset($_GET['year']) && $_GET['year']!="") || (isset($_GET['month']) && $_GET['month']!="") || (isset($_GET['text']) && $_GET['text']!=""))
        {
            $showClearButton = 1;
        }
        ?>
        <a class="btn btn-sm red" id="searchClear" onClick="search_clear()" style="display:<?PHP if($showClearButton) echo 'inline-block;'; else echo 'none;';?>"><i class="fa fa-search-minus"></i> Clear</a>
    </form>

	<div class="row">
		<div class="col-md-12 no-more-tables">
			<table id="calendartable" class="display table-bordered table-striped table-condensed table" cellspacing="0" width="100%" >
                <thead>
                    <tr>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Event</th>
                    </tr>
                </thead>
                
            </table>
		</div>
	</div>
	<div class="clearfix">
	</div>
</div>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var table='';
var calendar=$("#calendar").val();
var month=$("#month").val();
var year=$("#year").val();
var search_text=$("#search_text").val().trim();
var yearmonths=new Array();
<?PHP
foreach ($yearmonths['years'] as $year)
{
	?>
	yearmonths[<?PHP echo $year; ?>]=new Array();
	<?PHP
	foreach ($yearmonths['months'][$year] as $key=> $month)
	{
		?>
		yearmonths[<?PHP echo $year; ?>][<?PHP echo $key ?>]=<?PHP echo $month; ?>;
		<?PHP
	}
}
?>
$("#calendar,#year,#month").on("change",function()
{
    goAndSearchUrl();
});
$("#searchButton").on("click",function()
{
    goAndSearchUrl();
});
function goAndSearchUrl()
{
    var searchType = $('#calendar').val();
    if(searchType==1)
    {
        searchType= 'swamiji_calendar';
    }
    if(searchType==2)
    {
        searchType= 'bala_swamiji_calendar';
    }
    if(searchType==3)
    {
        searchType= 'website_calendar';
    }
    var searchYear = $('#year').val();
    var searchMonth = $('#month').val();
    var searchText = $('#search_text').val();
    window.location="<?PHP echo base_url; ?>calendar?type="+searchType+"&year="+searchYear+"&month="+searchMonth+"&text="+searchText;
}
function search(flag) 
{
    clearNotifications();
     if(!$("#calendar").length || !$("#year").length || !$("#search_text").length || !$("#month").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {  
        if ($("#search_text").length && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords');
            return false;
        }
    }
    $(".dataTables_processing").show();
    if($("#calendar").length)
        calendar = $("#calendar").val();
    if($("#year").length)
        year = $("#year").val();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#month").length)
        month = $("#month").val();
    
    if (search_text != '')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();

}

function search_clear() 
{
    window.location="<?PHP echo base_url; ?>calendar";
}

table = $('#calendartable').dataTable(
		{
            "processing": true,
            "language": {
                "sProcessing": '<div class="spinnerspin"></div>',
                "emptyTable": "No records found!"
            },
            "sDom": "<'custom-clear visible-xs'>ptr<'clearfix'>p",
            "sPaginationType": "bootstrap",
            "serverSide": true,
            "iDisplayLength": 100,
            "order": [
                [0, "asc"]
            ],
            "responsive": true,
            "lengthMenu": [
                [20,50,100],
                [20,50,100]
            ],
            "drawCallback": function(settings)
            {
                var api = this.api();
                var totalrows = api.rows({
                    page: 'current'
                }).data().context[0]._iRecordsTotal;
                $('.tooltips').tooltip();
            },
            "columns": [
            {
                "width": "8%",
                "orderable": false
            }, {
            	"width": "8%",
                "orderable": false
            },
            {
                "orderable": false
            }],
            "ajax": {
                url: '/calendar/listc',
                type: 'POST',
                data: function(d) 
                {
                    d.calendar = calendar;
                    d.year=year;
                    d.month=month;
                    d.search_text=search_text;                    
                },
                error: function (xhr, error, thrown) 
                {
                    $(".dataTables_processing").hide();
                    return false;
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                var vis = true;
                var ii = 0;
                var sno = 0;

                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', 'Start Date');
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', 'End Date');
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', 'Event');
                    ii++;
                }
               
                return nRow;
            },
            "columnDefs": [{
                "render": function(data, type, row) 
                {
                	var str='<b>'+row.start_date+'</b><br>'+row.start_day;
                    return str;
                },
                "targets": 0
            },
            {
                "render": function(data, type, row) 
                {
                    var str='<b>'+row.end_date+'</b><br>'+row.end_day;
                    return str;
                },
                "targets": 1
            },
            {
                "render": function(data, type, row) 
                {
                	var str='';
                	str+='<span class="event-name">'+row.event_name+'</span>';
                	if(row.description!='')
                	{
                		str+=row.description;
                	}
                	else
                	{
                		str+='<div style="margin-bottom:10px;"></div>';	
                	}
                	str+='<div style="clear:both;"></div>';
                	if(row.swamiji==1)
                	{
                		str+='<span class="label label-success" style="background-color:orangered; margin-right:5px;">Swamiji Calendar</span>';
                	}
                	if(row.balaswamiji==1)
                	{
                		str+='<span class="label label-success" style="margin-right:5px;">Bala Swamiji Calendar</span>';
                	}
                	if(row.dattapeetham==1)
                	{
                		str+='<span class="label label-info" style="margin-right:5px;"><?PHP echo site_short_name; ?> Calendar</span>';
                	}
                    return str;
                },
                "targets": 2
            }]
        });
</script>