<?php
$cartItemsSessionData = $this->session->userdata("cart_items_from_seva_details");
$refund_validation_check = "";
if(!empty($cartItemsSessionData) && $this->session->userdata('temp_checkout_user')->id == $cartItemsSessionData["user_id"] && ($this->session->userdata("defaultCurrency") == $cartItemsSessionData["currency"]) && ($this->session->userdata("poojasCartAshramIdSelection") == $cartItemsSessionData["ashram_id"]) && $cartItemsSessionData["refund_failed_count"] >= 3)
{
    $cartTypecheck = 0;
    if($this->uri->segment(2) == "poojas" && $cartItemsSessionData["order_type"] == 1)
    {
        $cartTypecheck = 1;
    }
    else if($this->uri->segment(2) == "donations" && $cartItemsSessionData["order_type"] == 2)
    {
        $cartTypecheck = 1;
    }
    else if($this->uri->segment(2) == "store" && $cartItemsSessionData["order_type"] == 3)
    {
        $cartTypecheck = 1;
    }
    $orderData = $cartItemsSessionData["orderData"];
    $txData = $cartItemsSessionData["txData"];
    //$cartContents=$this->poojascart->contents();
    $cart_amount = $this->cart_model->getTotalPrice($this->poojascart);
    $re_amount = $cartItemsSessionData["total_amount"] - $cart_amount;
    if(($cartItemsSessionData["total_amount"] > $cart_amount) && $cartTypecheck == 1)
    {
        $refund_validation_check = 1;
        ?>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="portlet box red">
                    <div class="portlet-title">
                        <div class="caption portlrt-lg-ttl">
                            Process manual refund
                        </div>
                    </div>
                    <div class="portlet-body form-horizontal">
                        <input type="hidden" name="tx_id" id="tx_id" value="<?php echo $txData->tx;?>">
                        <input type="hidden" name="amount" id="amount" value="<?php echo $re_amount;?>">
                        <div class="row">
                            <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label">Amount</label>
                                <div>
                                    <?PHP echo strtoupper($orderData['order']->currency); ?>
                                    <span id="tx_amount"><?php echo $re_amount;?></span>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Tx ID</label>
                                <div>
                                    <span id="tx_id_text"><?php echo $txData->tx;?></span>
                                </div>
                            </div>
                            

                            <div class="form-group">
                                <label class="control-label">Payment mode</label>
                                <select class="form-control" name="payment_mode" id="t_payment_mode">
                                    <optgroup label="Offline">
                                        <option value="cash">Cash</option>
                                        <option value="cheque">Cheque</option>
                                        <option value="cashiers_check">Cashiers Check</option>
                                        <option value="dd">DD</option>
                                        <option value="mo">MO</option>
                                        <option value="cc">CC (Swipe)</option>
                                        <option value="dc">DC (Swipe)</option>
                                        <option value="neft">NEFT/IMPS</option>
                                    </optgroup>
                                </select>
                            </div>
                            <div class="form-group t-offline-block">
                                <label class="control-label">Status</label>
                                <select class="form-control" name="tx_status" id="tx_status">
                                    <option value="refund">Refunded</option>
                                </select>
                            </div>

                            <div id="t-extra-fields" class="t-offline-block" style="display:none;">
                            </div>
                            <div id="t-refund-fields" class="t-offline-block" style="display:none;">
                            </div>
                        </div>
                        <div class="col-md-6 t-offline-block">
                            <div class="form-group onetime-manual-payment-group">
                                <hr style="background: #000; height: 1px;" class="visible-xs onetime-manual-payment-group">
                                <label class="control-label" style="color:red;">
                                    <input type="checkbox" name="is_manual_payment" value="1" id="tx_is_manual_transaction">
                                    Manual transaction
                                </label>
                                <label>

                                </label>
                            </div>

                            <div class="form-group onetime-manual-tx-group" style="display: none;">
                                <label class="control-label">Receipt number</label>
                                <input type="text" class="form-control" placeholder="Enter receipt number"
                                    name="manual_receipt_number" id="onetime_manual_receipt_number">
                            </div>

                            <div class="form-group onetime-manual-tx-group" style="display: none;">
                                <label class="control-label">Receipt date</label>
                                <input type="text" class="form-control" placeholder="Select date"
                                    name="manual_receipt_date" id="onetime_manual_receipt_date">
                            </div>
                            <hr style="background: #000; height: 1px;" class="onetime-manual-payment-group">
                            <div class="form-group onetime-manual-payment-group">
                                <label class="control-label" style="color:red;">
                                    <input type="checkbox" name="is_foreign_payment" value="1" id="tx_is_foreign_payment">
                                    Foreign transaction
                                </label>
                            </div>

                            <div class="form-group onetime-foreigntx-group" style="display: none;">
                                <label class="control-label">Foreign currency</label>
                                <select class="form-control" name="foreign_currency" id="tx_foreign_currency">
                                    <?PHP
                                    $foreign_currencies=$this->foreign_currencies_model->getAll();
                                    foreach ($foreign_currencies as $foreign_currency)
                                    {
                                        if(strtolower($orderData['order']->currency)==strtolower($foreign_currency->currency))
                                            continue;
                                        ?>
                                        <option value="<?PHP echo strtolower($foreign_currency->currency); ?>">
                                            <?PHP echo $foreign_currency->description." (".strtoupper($foreign_currency->currency).")"; ?>
                                        </option>
                                        <?PHP
                                    }
                                    ?>
                                </select>
                            </div>
                            <div class="form-group onetime-foreigntx-group" style="display: none;">
                                <label class="control-label">Foreign amount</label>
                                <input type="text" class="form-control" placeholder="Enter amount"
                                    name="foreign_amount" id="onetime_foreign_amount">
                            </div>
                            <div class="form-group onetime-foreigntx-group" style="display: none;">
                                <label class="control-label">Realized amount in <?PHP echo strtoupper($orderData['order']->currency); ?></label>
                                <input type="text" class="form-control" placeholder="Enter amount"
                                    name="realized_amount" id="onetime_realized_amount">
                                <br>
                                <div class="alert alert-info">
                                    <strong>Note: Leave Realized amount empty to update later</strong>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group t-offline-block">
                                <label class="control-label">Note</label>
                                <textarea class="form-control" placeholder="Enter note" rows="6"
                                    name="tx_note" id="tx_note"></textarea>
                            </div>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
        </div>
        <script type="text/javascript"> 
        $('body').on('click','.change-payment-status',function()
        {
            $("#tx_id").val($(this).data("id"));
            $("#tx_amount").html($(this).data("amount"));
            $("#tx_id_text").html($(this).data("tx"));
            $("#tx-payment-status-modal").modal("show");
            $("#tx-payment-status-modal #current_status").val($(this).data("status"));
            $("#tx-payment-status-modal #item_one_time_pay").val($(this).attr("data-itemOneTimePay"));

            //if($(this).data("mode")=='cheque')
            if($(this).data("mode")=='cheque' && $(this).data("status")!='bounced' && $(this).data("status")!='refund' && $(this).data("status")!='pending')
            {
                $("#t_payment_mode").html('\
                    <option value="cheque">Cheque</option>\
                    ');
                $(".onetime-manual-payment-group").hide();
                $(".onetime-foreigntx-group").hide();
                $(".onetime-manual-tx-group").hide();
            }
            else
            {
                if($(this).data("status")=='paid')
                {
                    if($(this).data("mode")=='cash')
                    {
                        $("#t_payment_mode").html('\
                            <option value="cash">Cash</option>\
                            ');
                    }
                    else if($(this).data("mode")=='cheque')
                    {
                        $("#t_payment_mode").html('\
                            <option value="cheque">Cheque</option>\
                            ');
                    }
                    else if($(this).data("mode")=='cashiers_check')
                    {
                        $("#t_payment_mode").html('\
                            <option value="cashiers_check">Cashiers Check</option>\
                            ');
                    }
                    else if($(this).data("mode")=='dd')
                    {
                        $("#t_payment_mode").html('\
                            <option value="dd">DD</option>\
                            ');
                    }
                    else if($(this).data("mode")=='cc')
                    {
                        $("#t_payment_mode").html('\
                            <option value="cc">CC (Swipe)</option>\
                            ');
                    }
                    else if($(this).data("mode")=='dc')
                    {
                        $("#t_payment_mode").html('\
                            <option value="dc">DC (Swipe)</option>\
                            ');
                    }
                    else if($(this).data("mode")=='mo')
                    {
                        $("#t_payment_mode").html('\
                            <option value="mo">MO</option>\
                            ');
                    }
                    else if($(this).data("mode")=='neft')
                    {
                        $("#t_payment_mode").html('\
                            <option value="neft">NEFT/IMPS</option>\
                            ');
                    }
                    else if($(this).data("mode")=='paypal')
                    {
                        $("#t_payment_mode").html('\
                            <option value="paypal">Paypal</option>\
                            ');
                    }
                    else if($(this).data("mode")=='razorpay')
                    {
                        $("#t_payment_mode").html('\
                            <option value="razorpay">Razorpay</option>\
                            ');
                    }
                    else if($(this).data("mode")=='payu')
                    {
                        $("#t_payment_mode").html('\
                            <option value="payu">PayU</option>\
                            ');
                    }
                    else if($(this).data("mode")=='stripe')
                    {
                        $("#t_payment_mode").html('\
                            <option value="stripe">Stripe</option>\
                            ');
                    }
                    else if($(this).data("mode")=='authorize.net')
                    {
                        $("#t_payment_mode").html('\
                            <option value="authorize.net">Authorize.net</option>\
                            ');
                    }
                }
                else
                {
                    $("#t_payment_mode").html('\
                        <option value="cash">Cash</option>\
                        <option value="cheque">Cheque</option>\
                        <option value="dd">DD</option>\
                        <option value="mo">MO</option>\
                        <option value="cc">CC (Swipe)</option>\
                        <option value="dc">DC (Swipe)</option>\
                        <option value="cashiers_check">Cashiers Check</option>\
                        <option value="neft">NEFT/IMPS</option>\
                    ');
                }
                if($(this).data("status")!='paid')
                {
                    $(".onetime-manual-payment-group").show();
                    $("#tx_is_manual_transaction").prop("checked",false);
                    $("#tx_is_foreign_payment").prop("checked",false);
                }
                else
                {
                    $(".onetime-manual-payment-group").hide();
                }
            }
            $("#t_payment_mode").trigger("change");
        });

        $("#t_payment_mode").on("change",function()
        {
            var status=$("#current_status").val();
            if($(this).val()=="cash")
            {
                $("#t-extra-fields").hide();
                $("#t-extra-fields").html('');
            }
            else if($(this).val()=="cheque")
            {
                var fields='\
                <div class="form-group">\
                    <label class="control-label">Cheque number</label>\
                    <input type="text" class="form-control" placeholder="Enter cheque number"\
                        name="offline_number" id="t_offline_number">\
                </div>\
                <div class="form-group">\
                    <label class="control-label">Cheque date</label>\
                    <input type="text" class="form-control" placeholder="Select cheque date"\
                        name="offline_date" id="t_offline_date">\
                </div>\
                <div class="form-group">\
                    <label class="control-label">Bank name</label>\
                    <input type="text" class="form-control" placeholder="Enter bank name"\
                        name="offline_bank" id="t_offline_bank">\
                </div>';
                $("#t-extra-fields").html(fields);
                $("#t-extra-fields").show();
                $("#t_offline_date").datepicker(
                {
                    format: 'dd M yyyy',
                    autoclose:true
                });
            }
            else if($(this).val()=="dd")
            {
                var fields='\
                <div class="form-group">\
                    <label class="control-label">DD number</label>\
                    <input type="text" class="form-control" placeholder="Enter DD number"\
                        name="offline_number" id="t_offline_number">\
                </div>\
                <div class="form-group">\
                    <label class="control-label">DD date</label>\
                    <input type="text" class="form-control" placeholder="Select DD date"\
                        name="offline_date" id="t_offline_date">\
                </div>\
                <div class="form-group">\
                    <label class="control-label">Bank name</label>\
                    <input type="text" class="form-control" placeholder="Enter bank name"\
                        name="offline_bank" id="t_offline_bank">\
                </div>';
                $("#t-extra-fields").html(fields);
                $("#t-extra-fields").show();
                $("#t_offline_date").datepicker(
                {
                    format: 'dd M yyyy',
                    autoclose:true
                });
            }
            else if($(this).val()=="mo")
            {
                var fields='\
                <div class="form-group">\
                    <label class="control-label">MO number</label>\
                    <input type="text" class="form-control" placeholder="Enter MO number"\
                        name="offline_number" id="t_offline_number">\
                </div>\
                <div class="form-group">\
                    <label class="control-label">MO date</label>\
                    <input type="text" class="form-control" placeholder="Select MO date"\
                        name="offline_date" id="t_offline_date">\
                </div>';
                $("#t-extra-fields").html(fields);
                $("#t-extra-fields").show();
                $("#t_offline_date").datepicker(
                {
                    format: 'dd M yyyy',
                    autoclose:true
                });
            }
            else if($(this).val()=="cc")
            {
                var fields='\
                <div class="form-group">\
                    <label class="control-label">Last 4 digits of card</label>\
                    <input type="text" class="form-control" placeholder="Enter last 4 digits"\
                        name="offline_number" id="t_offline_number">\
                </div>\
                <div class="form-group">\
                    <label class="control-label">Bank name</label>\
                    <input type="text" class="form-control" placeholder="Enter bank name"\
                        name="offline_bank" id="t_offline_bank">\
                </div>';
                $("#t-extra-fields").html(fields);
                $("#t-extra-fields").show();
            }
            else if($(this).val()=="dc")
            {
                var fields='\
                <div class="form-group">\
                    <label class="control-label">Last 4 digits of card</label>\
                    <input type="text" class="form-control" placeholder="Enter last 4 digits"\
                        name="offline_number" id="t_offline_number">\
                </div>\
                <div class="form-group">\
                    <label class="control-label">Bank name</label>\
                    <input type="text" class="form-control" placeholder="Enter bank name"\
                        name="offline_bank" id="t_offline_bank">\
                </div>';
                $("#t-extra-fields").html(fields);
                $("#t-extra-fields").show();
            }
            else if($(this).val()=="cashiers_check")
            {
                var fields='\
                <div class="form-group">\
                    <label class="control-label">CC number</label>\
                    <input type="text" class="form-control" placeholder="Enter CC number"\
                        name="offline_number" id="t_offline_number">\
                </div>\
                <div class="form-group">\
                    <label class="control-label">CC date</label>\
                    <input type="text" class="form-control" placeholder="Select CC date"\
                        name="offline_date" id="t_offline_date">\
                </div>\
                <div class="form-group">\
                    <label class="control-label">Bank name</label>\
                    <input type="text" class="form-control" placeholder="Enter bank name"\
                        name="offline_bank" id="t_offline_bank">\
                </div>';
                $("#t-extra-fields").html(fields);
                $("#t-extra-fields").show();
                $("#t_offline_date").datepicker(
                {
                    format: 'dd M yyyy',
                    autoclose:true
                });
            }
            else
            {
                $("#t-extra-fields").hide();
                $("#t-extra-fields").html('');
            }
        });
    $(document).ready(function() 
    {  
        $('.tx-status-form').validate({
            errorElement: 'span', //default input error message container
            errorClass: 'help-block', // default input error message class
            focusInvalid: true, // do not focus the last invalid input
            rules: {
                tx_note: {
                    //required: true,
                    minlength:10,
                    maxlength:1000
                },
                manual_receipt_number:
                {
                    required:true,
                    maxlength:100
                },
                manual_receipt_date:
                {
                    required:true
                },
                offline_number:
                {
                    required:true,
                    maxlength:100
                },
                offline_date:
                {
                    required:true
                },
                offline_bank:
                {
                    required:true,
                    maxlength:100
                },
                foreign_amount:
                {
                    required:true,
                    digits:true,
                    maxlength:20
                },
                foreign_currency:
                {
                    required:true
                },
                realized_amount:
                {
                    digits:true,
                    maxlength:20
                },
                refund_reference:
                {
                    required:true,
                    maxlength:100
                },
                refund_date:
                {
                    required:true
                },
                refund_mode:
                {
                    required:true
                }
            },

            messages: {
                tx_note: {
                    required: "Please enter note"
                },
                manual_receipt_number:
                {
                    required:"Please enter receipt number"
                },
                manual_receipt_date:
                {
                    required:"Please select receipt date"
                },
                offline_number:
                {
                    required:"Please enter the value"
                },
                offline_date:
                {
                    required:"Please select a date"
                },
                offline_bank:
                {
                    required:"Please enter bank name"
                },
                foreign_amount:
                {
                    required:"Please enter amount"
                },
                foreign_currency:
                {
                    required:"Please select currency"
                },
                refund_reference:
                {
                    required:"Please enter reference number"
                },
                refund_date:
                {
                    required:"Please select refund date"
                },
                refund_mode:
                {
                    required:"Please select refund mode"
                }
            },
            highlight: function(element)
            {
                $(element).closest('.form-group').addClass('has-error');
            },
            success: function(label)
            {
                label.closest('.form-group').removeClass('has-error');
                label.remove();
            },
            errorPlacement: function(error, element)
            {
                error.insertAfter(element);
                error.addClass('help-small no-left-padding').insertAfter(element);
            },

            submitHandler: function(form)
            {
                $(".loader_animation").show();
                $.post('/orders/update_manual_refund/<?PHP echo $orderData['order']->id ?>',$('.tx-status-form').serialize(),
                function(res)
                {
                    if(res.flag==1)
                    {
                        window.location="/orders/view/<?PHP echo $orderData['order']->id; ?>?tab=transactions-tab";
                    }
                    if(res.flag==0)
                    {
                        showNotification("ruby","Invalid request");
                    }
                    $(".loader_animation").hide();
                });
                return false;
            }
        });
    });
    $("#tx_is_manual_transaction").on("change",function()
    {
        if($(this).prop("checked"))
        {
            $(".onetime-manual-tx-group").show();
            $("#onetime_manual_receipt_date").datepicker(
            {
                format: 'dd M yyyy',
                autoclose:true
            });
        }
        else
        {
            $(".onetime-manual-tx-group").hide();
        }
    });
    $("#tx_is_foreign_payment").on("change",function()
    {
        if($(this).prop("checked"))
        {
            $(".onetime-foreigntx-group").show();
        }
        else
        {
            $(".onetime-foreigntx-group").hide();
        }
    });
    </script>
        <?php
    }
}
?>