
<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<style type="text/css">
	.event-name
	{
		color:#BC110A !important;
		font-size:16px;
		font-weight:500;
		display:block;
	}
</style>
<?PHP
$partHeader=htmlentities($ashramData->name)." - Calendar";
if(count($yearmonths['years']))
{
    $currentYear=$yearmonths['years'][0];
}
else
$currentYear=date("Y");
?>
<input class="current-browser-title" data-title="Ashrams | <?PHP echo $partHeader; ?>" type="hidden">
<div class="page-content">
	<!-- BEGIN PAGE HEADER-->
	<h3 class="page-title">
        <i class="subicon icomoon-library"></i>
		<?PHP echo $partHeader; ?>
		<span id="extra_title"><?PHP echo $currentYear; ?></span>
	</h3>
	<div class="page-bar">
		<ul class="page-breadcrumb">
			<li>
				<a href="/">Home</a>
				<i class="fa fa-angle-right"></i>
			</li>
            <li>
                <a href="<?PHP echo base_url; ?>ashrams">
                    Ashrams
                </a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li>
                <a href="<?PHP echo base_url; ?>ashrams/<?PHP  echo $ashramData->slug; ?>">
                    <?PHP echo word_limiter(htmlentities($ashramData->name),4); ?>
                </a>
                <i class="fa fa-angle-right"></i>
            </li>
			<li class="active">
				Calendar
			</li>
		</ul>
	</div>
	<!-- END PAGE HEADER-->
	<form action="" method="get" name="" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form margin-bottom-10">
        
        <div class="col-md-2 col-sm-3">
            <select name="year" id="year" class="form-control input-sm">
            	<?PHP
            		foreach ($yearmonths['years'] as $year)
            		{
            			?>
            			<option>
            				<?PHP  echo $year; ?>
            			</option>
            			<?PHP
            		}
                    if(empty($yearmonths['years']))
                    {
                        ?>
                        <option><?PHP echo $currentYear; ?></option>
                        <?PHP
                    }
            	?>
            </select>
        </div>
        <div class="col-md-2 col-sm-3">
            <select name="month" id="month" onChange="search(1)" class="form-control input-sm">
            	<option value="">All Months</option>
            	<?PHP
            		
            		foreach ($this->months as $key=> $monthName)
            		{
            			if( isset($yearmonths['months'][$currentYear]) && is_array($yearmonths['months'][$currentYear]) && in_array($key,$yearmonths['months'][$currentYear]) )
            			{
	            			?>
	            			<option value="<?PHP  echo $key; ?>">
	            				<?PHP  echo $monthName; ?>
	            			</option>
	            			<?PHP
            			}
            		}
            	?>
            </select>
        </div>
        <div class="col-md-3 col-sm-3">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="form-control input-sm" />
        </div>
        <button type="button" id="searchButton" class="btn btn-sm blue searchButton"
        onClick="search(0)"><i class="fa fa-search"></i> Search</button>
        <a class="btn btn-sm red" id="searchClear" onClick="search_clear()"
        style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
    </form>

	<div class="row">
		<div class="col-md-12 no-more-tables">
			<table id="calendartable" class="display table-bordered table-striped table-condensed table" cellspacing="0" width="100%" >
                <thead>
                    <tr>
                        <th>Start Date</th>
                        <th>End Date</th>
                        <th>Event</th>
                    </tr>
                </thead>
                
            </table>
		</div>
	</div>
	<div class="clearfix">
	</div>
</div>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var table='';
var calendar='';
var month='';
var year=$("#year").val();
var search_text='';
var yearmonths=new Array();
<?PHP
foreach ($yearmonths['years'] as $year)
{
	?>
	yearmonths[<?PHP echo $year; ?>]=new Array();
	<?PHP
	foreach ($yearmonths['months'][$year] as $key=> $month)
	{
		?>
		yearmonths[<?PHP echo $year; ?>][<?PHP echo $key ?>]=<?PHP echo $month; ?>;
		<?PHP
	}
}
?>
$("#year").on("change",function()
{
    changeMonths($(this).val());
});
function changeMonths(tempyear)
{
	var monthsArray={1:"January",2:"February",3:"March",4:"April",5:"May",6:"June",7:"July",8:"August",9:"September",10:"October",11:"November",12:"December"};
	$("#extra_title").html(tempyear);
	
    document.getElementById("month").options.length=0;
	document.getElementById("month").options[0] = new Option ("All Months","");
	var cnt=1;
    $.each(monthsArray,function(i,monthVal)
    {
    	i=parseInt(i);
    	if($.inArray(i,yearmonths[tempyear])!=-1)
    	{
    		document.getElementById("month").options[cnt] = new Option (monthVal,i);
    		cnt++;
    	}
    });
    search(1);
}
function search(flag) 
{
    clearNotifications();
     if(!$("#year").length || !$("#search_text").length || !$("#month").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {  
        if ($("#search_text").length && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords');
            return false;
        }
    }
    $(".dataTables_processing").show();
  
    if($("#year").length)
        year = $("#year").val();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#month").length)
        month = $("#month").val();
    
    if (search_text != '')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();

}

function search_clear() 
{
    $(".dataTables_processing").show();
    $("#year").val($("#year option:first").val());
    year = $("#year").val();
    $("#search_text").val('');
    search_text = '';
    $("#month").val($("#month option:first").val());
    month = '';
    $("#searchClear").css("display", "none");
    changeMonths($("#year").val());
    table.fnDraw();
}

table = $('#calendartable').dataTable(
		{
            "processing": true,
            "language": {
                "sProcessing": '<div class="spinnerspin"></div>',
                "emptyTable": "No records found!"
            },
            "sDom": "<'custom-clear visible-xs'>ptr<'clearfix'>p",
            "sPaginationType": "bootstrap",
            "serverSide": true,
            "iDisplayLength": 100,
            "order": [
                [0, "asc"]
            ],
            "responsive": true,
            "lengthMenu": [
                [20,50,100],
                [20,50,100]
            ],
            "drawCallback": function(settings)
            {
                var api = this.api();
                var totalrows = api.rows({
                    page: 'current'
                }).data().context[0]._iRecordsTotal;
                $('.tooltips').tooltip();
            },
            "columns": [
            {
                "width": "15%",
                "orderable": false
            }, {
            	"width": "15%",
                "orderable": false
            },
            {
                "orderable": false
            }],
            "ajax": {
                url: '/ashrams/listcalendar/<?PHP echo $ashramData->slug; ?>',
                type: 'POST',
                data: function(d) 
                {
                    d.year=year;
                    d.month=month;
                    d.search_text=search_text;                    
                },
                error: function (xhr, error, thrown) 
                {
                    $(".dataTables_processing").hide();
                    return false;
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                var vis = true;
                var ii = 0;
                var sno = 0;

                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', 'Start Date');
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', 'End Date');
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', 'Event');
                    ii++;
                }
               
                return nRow;
            },
            "columnDefs": [{
                "render": function(data, type, row) 
                {
                	var str='<b>'+row.start_date+'</b><br>'+row.start_day;
                    return str;
                },
                "targets": 0
            },
            {
                "render": function(data, type, row) 
                {
                    var str='<b>'+row.end_date+'</b><br>'+row.end_day;
                    return str;
                },
                "targets": 1
            },
            {
                "render": function(data, type, row) 
                {
                	var str='';
                	str+='<span class="event-name">'+row.event_name+'</span>';
                	if(row.description!='')
                	{
                		str+=row.description;
                	}
                	else
                	{
                		str+='<div style="margin-bottom:10px;"></div>';	
                	}
                	str+='<div style="clear:both;"></div>';
                    return str;
                },
                "targets": 2
            }]
        });
</script>