<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | Ashram Admin | All Items" type="hidden">
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
    $this->load->view("ashrams/admin/store_nav_buttons");
?>
<h3 class="page-title">
All Items
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>All Items</li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->

<div class="row-fluid">
    <div class="alert alert-info">
        <strong>Store public URL:</strong>
        <a href="<?php echo base_url. "store"; ?>" target="_blank">
        <?php echo base_url . "store"; ?></a>
    </div>
    <form action="" method="get" name="" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form">
        
        <?PHP
        if(is_single_ashram_site)
        { 
        ?>
            <input type="hidden" name="ashram_id" id="ashram_id" value="<?php echo default_ashram_id; ?>">
        <?PHP
        }
        else if($this->currentUser->roles==1)
        {
            ?>
            <div class="col-md-2">
                <select name="ashram_id" id="ashram_id" onChange="switchAshram(this.value)" class="form-control input-inline custom-input">
                    <option value="0">Select Ashram</option>
                    <?PHP
                    foreach ($ashrams as $ashramData)
                    {
                        ?>
                        <option value="<?PHP echo $ashramData->id; ?>"
                        <?PHP
                        if($this->session->userdata("ashramId")==$ashramData->id)
                            echo " selected";
                        ?>
                        >
                            <?PHP echo $ashramData->name; ?>
                        </option>
                        <?PHP
                    }
                    ?>
                </select>
            </div>
            <script>
                function switchAshram(ashram_id)
                {
                    $.post("/ashramadmin/switchashram/"+ashram_id,{},function(res)
                    {
                        window.location.reload();
                    });
                }
            </script>
            <?PHP
        }
        if($this->session->userdata("ashramId"))
        {
            ?>
            <div class="col-md-2">
                <select name="status" id="status" class="input-inline form-control custom-input" onchange="search(1)">
                    <option value="">All Status</option>
                    <option value="1" selected="selected">Active</option>
                    <option value="0">Inactive</option>
                </select>
            </div>
            <div class="col-md-2">
                <select name="shipping" id="shipping" class="input-inline form-control custom-input" onchange="search(1)">
                    <option value="">All shipping status</option>
                    <option value="1">Yes</option>
                    <option value="0">No</option>
                </select>
            </div>
            <div class="col-md-2">
                <select name="item_type" id="item_type" class="input-inline form-control custom-input" onchange="search(1)">
                    <option value="">All Types</option>
                    <?PHP
                    foreach ($types as $itemType)
                    {
                        ?>
                        <option value="<?PHP echo $itemType->id; ?>">
                            <?PHP echo $itemType->name; ?>
                        </option>
                        <?PHP
                    }
                    ?>
                </select>
            </div>
            <div class="col-md-2">
                <select name="category" id="category" class="input-inline form-control custom-input" onchange="search(1)">
                    <option value="">All Categories</option>
                    <?PHP
                    foreach ($categories as $category)
                    {
                        ?>
                        <option value="<?PHP echo $category->id; ?>"><?PHP echo $category->name; ?></option>
                        <?PHP
                    }
                    ?>
                </select>
            </div>
            <br style="clear:both;" class="hidden-sm hidden-xs">
            
            <div class="col-md-2">
                <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
                class="input-inline form-control custom-input" />
            </div>
            <div class="col-md-2">
                <select name="search_col" id="search_col" class="input-inline form-control custom-input">
                    <option value="item_name">Item Name</option>
                </select>
            </div>
            <div class="col-md-2" style="display:none">
                <select name="wild" id="wild" class="input-inline form-control custom-input">
                    <option value="contains">Contains</option>
                    <option value="starts">Starts with</option>
                    <option value="ends">Ends with</option>
                </select>
            </div>
            
            <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
            onClick="search(0)"><i class="fa fa-search"></i> Search</button>
            <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
            style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
            <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
             <?PHP
        }
        
        ?>
    </form>
    <?PHP
    if($this->session->userdata("ashramId"))
    {
        ?>
        <br class="hidden-lg hidden-md">
        
        <div class="portlet box blue">
            <div class="portlet-title">
                <div class="caption"> <i class="fa fa-list"></i> All Store Items <span id="total_records"></span></div>
                <div class="tools">
                    <a href="javascript:;" class="collapse"></a>
                </div>
            </div>
            
            <div class="portlet-body no-more-tables">
                <table id="itemstable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Item Name</th>
                            <th>Type</th>
                            <?PHP
                            foreach ($GLOBALS['currencies'] as $currencyData)
                            {
                                ?>
                                <th>
                                    <?PHP echo $currencyData['currency']." (".$currencyData['symbol'].")"; ?>
                                </th>
                                <?PHP
                            }
                            ?>
                            <th>Category</th>
                            <th>Public Display</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    
                </table>
                <div style="clear:both;"></div>
            </div>
        </div>
        <?PHP
    }
    else
    {
        ?>
        <div class="alert alert-danger">
            Please select Ashram
        </div>
        <?PHP
    }
    ?>
</div>

<?PHP
if($this->session->userdata("ashramId"))
{
    ?>
    <script src="<?php
    echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
    <script src="<?php
    echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
    <script type = "text/javascript">
        
        var search_text = '';
        var search_col = '';
        var wild = '';
        var table = '';
        var status=1;
        var item_type='';
        var category='';
        var shipping='';

        function search(flag)
        {
            clearNotifications();
            if(!$("#search_text").length || !$("#search_col").length || !$("#wild").length || !$("#status").length || !$("#item_type").length)
            {
                showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
                return;
            }
            if (flag == 0)
            {  
                if ($("#search_text").length && $("#search_text").val().trim() == '') 
                {
                    showNotification('ruby','Please enter search keywords');
                    return false;
                }
            }
            $(".dataTables_processing").show();
            if($("#search_text").length)
                search_text = $("#search_text").val().trim();
            if($("#search_col").length)
                search_col = $("#search_col").val().trim();
            if($("#wild").length)
                wild = $("#wild").val().trim();
            if($("#status").length)
                status = $("#status").val();

            if($("#item_type").length)
                item_type = $("#item_type").val();
            if($("#category").length)
                category=$("#category").val();
            if($("#shipping").length)
                shipping=$("#shipping").val();

            if (search_text != '')
                $("#searchClear").css("display", "inline-block");
            
            table.fnDraw();

        }

        function search_clear() 
        {
            $(".dataTables_processing").show();
            $("#search_text").val('');
            search_text = '';
            search_col = '';
            $("#search_col").val($("#search_col option:first").val());
            wild = '';
            $("#wild").val($("#wild option:first").val());
            $("#searchClear").css("display", "none");
            shipping='';
            $("#shipping").val($("#shipping option:first").val());
            status=1;
            $("#status").val(1);
            item_type='';
            category='';
            $("#category").val('');
            $("#item_type").val('');
            table.fnDraw();
        }

        var statusflag=0;
        function deleteItem(id)
        {
            if(statusflag==1)
                return false;
            statusflag=1;
            $(".dataTables_processing").show();
            $.post('/storeadmin/delete/' + id , {}, function(res) 
            {
                if(res=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                if(res=='access_denied')
                {
                    showNotification('ruby',"Access Denied");
                    $(".dataTables_processing").hide();
                    $("#item" + id).modal('toggle');
                    statusflag=0;
                    return;
                }
                var r = $.parseJSON(res);
                $(".dataTables_processing").hide();
                if (r.flag == 1)
                {
                    table.fnSettings.bResetDisplay  =false;
                    table.fnDraw(table.fnSettings);
                    showNotification('ruby', "Item '" + r.item_name + "' has been deleted successfully ");
                }
                else if (r.flag == 2)
                {
                    showNotification('ruby', "Item '" + r.item_name + "' cannot be deleted. Some of its files are used.");
                }
                else
                {
                    showNotification("ruby", "Error occured. Please try again.");
                }
                $("#item" + id).modal('toggle');
                statusflag=0;
            });
        }

        function changeStatus(id,status)
        {
            if(statusflag==1)
                return false;
            statusflag=1;
            $(".dataTables_processing").show();
            $.post('/storeadmin/changestatus/' + id , {status:status}, function(res) 
            {
                if(res=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                if(res=='access_denied')
                {
                    showNotification('ruby',"Access Denied");
                    $(".dataTables_processing").hide();
                    statusflag=0;
                    return;
                }
                var r = $.parseJSON(res);
                $(".dataTables_processing").hide();
                if (r.flag == 1) 
                {
                    table.fnSettings.bResetDisplay  =false;
                    table.fnDraw(table.fnSettings);
                    if(status==1)
                        showNotification('lime', "Item '" + r.item_name + "' activated successfully ");
                    else
                        showNotification('ruby', "Item '" + r.item_name + "' deactivated successfully ");
                }
                else if (r.flag == 2)
                {
                    if(status==1)
                        showNotification('ruby', "Item '" + r.item_name + "' already activated ");
                    else
                        showNotification('ruby', "Item '" + r.item_name + "' already deactivated ");
                }
                else
                {
                    if(r.error!='')
                        showNotification("ruby",r.error);
                    else
                        showNotification("ruby", "Error occured. Please try again.");
                }
                statusflag=0;
            });
        }

        $(document).ready(function()
        {
            $("#search_text").val('');
            $("#status").val(1);
            $("#item_type").val($("#item_type option:first").val());
            $("#wild").val($("#wild option:first").val());
            $("#search_col").val($("#search_col option:first").val());
            $("#category").val($("#category option:first").val());
            $("#shipping").val($("#shipping option:first").val());

            table = $('#itemstable').dataTable({
                "processing": true,
                "language": {
                    "sProcessing": '<div class="spinnerspin"></div>',
                    "emptyTable": "No records found!"
                },
                "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
                "sPaginationType": "bootstrap",
                "serverSide": true,
                "iDisplayLength": 50,
                "order": [
                    [1, "asc"]
                ],
                "responsive": true,
                "lengthMenu": [
                    [20, 50, 100],
                    [20, 50, 100]
                ],
                "drawCallback": function(settings) 
                {
                    var api = this.api();
                    var totalrows = api.rows({
                        page: 'current'
                    }).data().context[0]._iRecordsTotal;
                    $("#total_records").html('(' + totalrows + ')');
                    $('.tooltips').tooltip();
                },
                "columns": [
                {
                    "width": "5%",
                    "orderable": false
                }, {
                    name: "item_name",
                    "orderable": true
                },
                {
                    name: "item_type",
                    "width":"10%",
                    "orderable": false
                },
                <?PHP
                    foreach ($GLOBALS['currencies'] as $currencyData)
                    {
                        ?>
                        {
                            name: "price_<?PHP echo strtolower($currencyData['currency']); ?>",
                            "width":"10%",
                            "orderable": true
                        },
                        <?PHP
                    }
                ?>
                {
                    "width": "15%",
                    "name":"category",
                    "orderable": false
                }, 
                {
                    name: "public_display",
                    "width": "9%",
                    "orderable": true
                }, {
                    width: "10%",
                    "orderable": false
                }],
                "ajax": {
                    url: '/storeadmin/listc',
                    type: 'POST',
                    data: function(d) 
                    {
                        d.search_text = search_text;
                        d.search_col = search_col;
                        d.status = status;
                        d.wild = wild;
                        d.item_type=item_type;
                        d.category=category;
                        d.shipping=shipping;
                    },
                    error: function (xhr, error, thrown) 
                    {
                        if(xhr.responseText=='login')
                        {
                            window.location="<?PHP echo base_url; ?>"
                        }
                        else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                        {
                           showNotification('ruby',"Invalid request");
                        }
                        $(".dataTables_processing").hide();
                        return false;
                    },
                    dataSrc:function(res)
                    {
                        if(res.data.length==0 && res.recordsTotal!=0)
                        {
                            table.fnDraw();
                        }
                        return res.data;
                    }
                },
                "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                    var vis = true;
                    var ii = 0;
                    var sno = 0;

                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Item Name");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Type");
                        ii++;
                    }
                    <?PHP
                    foreach ($GLOBALS['currencies'] as $currencyData)
                    {
                        ?>
                        sno++;
                        if (this.api().column(sno).visible()) {
                            $('td:eq(' + ii + ')', nRow).attr('data-title', "<?PHP echo $currencyData['currency']." (".$currencyData['symbol'].")"; ?>");
                            ii++;
                        }
                        <?PHP
                    }
                    ?>
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Category");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Public Display");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible())
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
                    return nRow;
                },
                "columnDefs":
                [
                    {
                        "render": function(data, type, row) {
                            return row.sno;
                        },
                        "targets": 0
                    }, {
                        "render": function(data, type, row) 
                        {
                            var str = '';
                            if(row.shipping==1)
                            {
                                str+='<i class="fa fa-shopping-cart pull-right tooltips" style="color:green;" data-placement="bottom"\
                            data-original-title="Shippable"></i>';
                            }
                            if(row.shipping==0)
                            {
                                str+='<i class="fa fa-shopping-cart pull-right tooltips" style="color:red;" data-placement="bottom"\
                            data-original-title="Not shippable"></i>';
                            }
                            str += "<a href='/storeadmin/add_edit_item/" + row.id + "' target='_blank'>"+row.item_name + '</a>';

                            if(row.status==1)
                            {
                                str+='<br><span class="label label-success">Active</span>';
                            }
                            else
                            {
                                str+='<br><span class="label label-danger">Inactive</span>';
                            }
                            return str;
                            return str;
                        },
                        "targets": 1
                    }, {
                        "render": function(data, type, row) 
                        {
                            return row.item_type;
                        },
                        "targets": 2
                    }, 
                    <?PHP
                    $cc=3;
                    foreach ($GLOBALS['currencies'] as $currencyData)
                    {
                        ?>
                        {
                            "render": function(data, type, row) 
                            {
                                return '<span style="font-weight:bold; color:<?PHP echo $currencyData['color']; ?>">'+row.price_<?PHP echo strtolower($currencyData['currency']); ?>+'</span>';
                            },
                            "targets": <?PHP echo $cc++; ?>
                        },
                        <?PHP
                    }
                    ?>
                    {
                        "render": function(data, type, row) 
                        {
                            var str = row.category_name;
                            return str;
                        },
                        "targets":  <?PHP echo $cc++; ?>
                    },
                    {
                        "render": function(data, type, row) {
                           var pdisplay = "";
                            if(row.is_public_display == 1){
                                pdisplay = "Yes";
                            } else {
                                pdisplay = "No";
                            }
                            return pdisplay;
                        },
                        "targets": <?PHP echo $cc++; ?>
                    }, {
                        "render": function(data, type, row) 
                        {
                            var str = '<div class="btn-group" id="actions' + row.id + '">' +
                                '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                                '<i class="fa fa-angle-down"></i></a>' +
                                '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                                '<li><a href="/storeadmin/add_edit_item/' + row.id + '" target="_blank"><i class="fa fa-pencil"></i> Edit</a></li>';
                            if(row.status==1)
                            {
                                str+='<li><a href="javascript:;" onClick="changeStatus('+row.id+',0)"><i class="fa fa-ban"></i> Deactivate</a></li>';
                            }
                            else
                            {
                                str+='<li><a href="javascript:;" onClick="changeStatus('+row.id+',1)"><i class="fa fa-check"></i> Activate</a></li>';
                            }
                            str += '<li><a href="#item' + row.id + '" role="button" data-toggle="modal">' +
                                '<i class="fa fa-trash-o"></i> Delete</a></li>' +

                                '<div id="item' + row.id + '" class="modal fade" tabindex="-1">' +
                                '<div class="modal-header">' +
                                '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                                '<h4 class="modal-title">Delete Confirmation</h4>' +
                                '</div>' +
                                '<div class="modal-body"><div class="pull-left delete-confirmation-icon"' +
                                '><i class="fa fa-exclamation-triangle"></i></div>' +
                                'Do you really want to delete the Item: ' +
                                '<span style="color:red; font-weight:bold;">' + row.item_name + '</span>?' +
                                '</div>' +
                                '<div class="modal-footer">' +
                                '<button type="button" data-dismiss="modal" class="btn btn-xs close' + row.id + '">' +
                                '<i class="fa fa-remove"></i> Cancel</button>' +
                                '<a onClick="deleteItem(' + row.id + ')" class="btn btn-xs red">' +
                                '<i class="fa fa-trash"></i> Delete</a>' +
                                '</div>' +
                                '</div>';

                            return str;
                        },
                        "targets": <?PHP echo $cc++; ?>
                    }
                ]
            });

            $('.columnhide').on('click', function(e) 
            {
                var column = table.api().column( $(this).attr('data-column') );
                var cnum=$(this).attr('data-column');
                
                column.visible( ! column.visible(),true );
                var bVis = table.fnSettings().aoColumns[cnum].bVisible;
                var title = table.fnSettings().aoColumns[cnum].sTitle;
                
                var visibility=table.api().column(cnum).visible();
                table.api().column(cnum).nodes().to$().attr("data-title",title);
                if (visibility == false) 
                {
                    $(this).removeClass('blue').addClass('red');
                }
                else 
                {
                    $(this).removeClass('red').addClass('blue');
                }
            });
        });
        $("#excelButton").on("click",function()
        {
            $(".loader_animation").show();
            clearNotifications();
            var sortindex=table.fnSettings().aaSorting[0][0];
            var order_by=table.fnSettings().aoColumns[sortindex].name;
            var dir=table.fnSettings().aaSorting[0][1];
            $.post('/storeadmin/listc/1',
            {
                item_type:item_type,search_text:search_text,wild:wild,search_col:search_col,
                status:status,order_by:order_by,dir:dir,category:category
            },
                function(res)
                {
                    var r=$.parseJSON(res);
                    if(r.flag==1)
                    {
                        window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
                    }
                    if(r.flag==2)
                    {
                        showNotification("ruby","Sorry! You have already requested the same report.");
                    }
                    if(r.flag==0)
                    {
                        showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
                    }
                    $(".loader_animation").hide();
                }
            );
        });
    </script>
     <?PHP
}
?>