<style type="text/css">
    .grid_title {
        background-color: #eee;
        height: 15px;
        line-height: 15px;
        margin-bottom: 15px;
    }
    .grid_title h3 {
        padding-right: 10px;
        font-size: 16px;
        height: 15px;
        line-height: 15px;
        text-transform: uppercase;
        background-color: #fff;
        display: inline-block;
        margin: 0;
        font-weight: bold;
    }
    #basicTrustDescriptionCont,
    #basicTrustYestCont
    {
        height: 125px;
        overflow-y: scroll;
    }
    @media (max-width: 767px)
    {
        #basicTrustDescriptionCont,
        #basicTrustYestCont
        {
            height: auto;
            overflow-y: unset;
        }
    }
</style>
<?PHP
$partHeader='Add Trust - Trust Settings';
if($id)
{
    $partHeader=htmlentities($trustData->trust_name)." - Trust Settings";
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Ashram Admin | <?PHP echo $partHeader; ?>" type="hidden">
<h3 class="page-title">
    <?PHP
        echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/ashramadmin/settings">Ashram Settings</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("trust_error"))
{
    ?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("trust_created"))
{
    ?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Trust created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("trust_saved"))
{
    ?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Trust saved successfully.</strong>
    </div>
    <?PHP
}
?>
<link rel="stylesheet" href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/tabs/styles/jquery.sliderTabs.css">
<script src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/tabs/jquery.sliderTabs.js"></script>
<div class="row-fluid">
    <div id="settings-tabs">
        <ul class="hidden-print">
            <li class="active">
                <a href="#trustSettings" data-toggle="tab"> 
                    Trust Settings
                </a>
            </li>
            <?PHP
            if($id && strtolower($trustData->currency)=='inr')
            {
                ?>
                <li class="active">
                    <a href="#trust80G" data-toggle="tab"> 
                        80G Settings
                    </a>
                </li>
                <?PHP
            }
            ?>
        </ul>
        <div id="trustSettings" class="no-more-tables">
            <form action="" id="trust_form" name="trust_form" method="post" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Ashram Name<span class="required">*</span>
                            </label>
                            <div class="form-content">
                                <?PHP if(isset($ashramData->name)) echo $ashramData->name; ?>
                                <input type="hidden" name="name" id="name" value="<?PHP if(isset($ashramData->name)) echo $ashramData->name; ?>">
                            </div>
                        </div>
                        
                        <?PHP
                        if($id)
                        {
                            ?>
                            <div class="form-group">
                                <label class="control-label">Currency
                                </label>
                                <div class="form-content">
                                    <?PHP if(isset($trustData->currency)) echo strtoupper($trustData->currency); ?>
                                    <input type="hidden" class="form-control" name="currency" id="currency" value="<?PHP if($id) echo $trustData->currency; ?>">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Trust A/C for
                                </label>
                                <div class="form-content">
                                    <?PHP
                                    if($id && $trustData->account_for==1)
                                    {
                                        echo "Poojas";
                                    } else if($id && $trustData->account_for==2)
                                    {
                                        echo "Donations";
                                    } else if($id && $trustData->account_for==3)
                                    {
                                        echo "Store";
                                    } else if($id && $trustData->account_for==4)
                                    {
                                        echo "Subscriptions";
                                    }
                                    ?>
                                    <input type="hidden" class="form-control" name="trustaccfor" id="trustaccfor" value="<?PHP if($id) echo $trustData->account_for; ?>">
                                </div>
                            </div>
                            <?PHP
                        }
                        else
                        {
                            ?>
                            <div class="form-group">
                                <label class="control-label">
                                    Currency<span class="required">*</span>
                                </label>
                                <div class="form-content">
                                    <?PHP echo strtoupper($this->session->userdata("trustCurrency")); ?>
                                    <input type="hidden" class="form-control" name="currency" id="currency" value="<?PHP echo $this->session->userdata("trustCurrency") ?>">
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">
                                    Trust A/C for<span class="required">*</span>
                                </label>
                                <div class="form-content">
                                     <select name="trustaccfor" id="trustaccfor" class="form-control">
                                        <option value="">Select</option>
                                        <option value="1" <?PHP if($id && $trustData->account_for==1) echo "selected"; ?>>Poojas</option>
                                        <option value="2" <?PHP if($id && $trustData->account_for==2) echo "selected"; ?>>Donations</option>  
                                        <option value="3" <?PHP if($id && $trustData->account_for==3) echo "selected"; ?>>Store</option> 
                                        <option value="4" <?PHP if($id && $trustData->account_for==4) echo "selected"; ?>>Subscriptions</option>  
                                    </select>
                                </div>
                            </div>
                            <?PHP
                        }
                        ?>

                        <div class="form-group">
                            <label class="control-label">
                                Basic Trust Details<span class="required">*</span>
                            </label>
                            <div class="form-content">
                                <?PHP
                                if(isset($trustBasicData->trust_name))
                                {
                                    echo $trustBasicData->trust_name;
                                    echo '<input type="hidden" name="trust_basic_id" value="'.$trustData->trust_basic_id.'">';
                                }
                                else
                                {
                                    ?>
                                     <select name="trust_basic_id" id="trust_basic_id" class="form-control"  onChange="changeBasicTrust(this.value)">
                                        <option value="">Select Basic Trust</option>
                                        <?PHP
                                        if(isset($basicTrusts) && !empty($basicTrusts))
                                        {
                                            foreach($basicTrusts as $basicTrust)
                                            {
                                                ?>
                                                <option value="<?PHP echo $basicTrust->trust_basic_id; ?>" <?PHP if($id && $trustData->trust_basic_id==$basicTrust->trust_basic_id) echo "selected"; ?>><?PHP echo $basicTrust->trust_name; ?></option>
                                                <?PHP
                                            }
                                        }
                                        ?>  
                                    </select>
                                    <?PHP
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">
                                        Logo
                                    </label>
                                    <div class="form-content" id="basicTrustLogoCont">
                                        <?PHP
                                        $trustlogo = "";
                                        if(isset($trustBasicData->logo))
                                        {
                                            $trustlogo = aws_s3_base_url."images/trusts/trust_images/thumb_".$trustBasicData->logo;
                                        }
                                        else
                                        {
                                            $trustlogo = aws_s3_base_url."images/site_assets/global_site_images/no-image.png";
                                        }
                                        ?>
                                        <img src="<?PHP echo $trustlogo; ?>" alt="" style="width: 100px;">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label">
                                        Trust Contact Person
                                    </label>
                                    <div class="form-content" id="basicTrustContactNameCont">
                                        <?PHP if(isset($trustBasicData->contact_person)) { echo $trustBasicData->contact_person; } ?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label">
                                        Trust Address
                                    </label>
                                    <div class="form-content" id="basicTrustAddressCont">
                                        <?PHP if(isset($trustBasicData->address)) { echo $trustBasicData->address; } ?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label">
                                        Trust Receipt Footer
                                    </label>
                                    <div class="form-content" id="basicTrustFooterCont">
                                        <?PHP if(isset($trustBasicData->trust_footer)) { echo $trustBasicData->trust_footer; } ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label">
                                        Trust Description
                                    </label>
                                    <div class="form-content" id="basicTrustDescriptionCont">
                                        <?PHP if(isset($trustBasicData->description)) { echo $trustBasicData->description; } ?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label">
                                        Year End Statement Text
                                    </label>
                                    <div class="form-content" id="basicTrustYestCont">
                                        <?PHP if(isset($trustBasicData->year_end_statement_text)) { echo $trustBasicData->year_end_statement_text; } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>                   

                </div>
                    
                <div class="row-fluid">
                    <div class="portlet-body no-more-tables">
                        <div style="border:1px solid #CCC; padding:15px 5px 0px 5px; margin-top:10px;">
                            <div class="grid_title">
                                <h3>Paypal Payflow Gateway</h3>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Payflow Partner
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="payflowpartner" id="payflowpartner" value="<?PHP if(!empty($trustData->payflow_partner) && $trustData->payflow_partner!="null") echo htmlentities($trustData->payflow_partner); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Payflow Vendor
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="payflowvendor" id="payflowvendor" value="<?PHP if(!empty($trustData->payflow_vendor) && $trustData->payflow_vendor!="null") echo htmlentities($trustData->payflow_vendor); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Payflow User
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="payflowuser" id="payflowuser" value="<?PHP if(!empty($trustData->payflow_user)) echo htmlentities($trustData->payflow_user); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Payflow Password
                                        </label>
                                        <div class="form-content">
                                            <input type="password" class="form-control" name="payflowpassword" id="payflowpassword" value="<?PHP if(!empty($trustData->payflow_pwd)) echo htmlentities($trustData->payflow_pwd); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Paypal Email
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="paypalemail" id="paypalemail" value="<?PHP if(!empty($trustData->paypal_email)) echo htmlentities($trustData->paypal_email); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Payflow URL
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="payflowurl" id="payflowurl" value="<?PHP if(!empty($trustData->payflow_url)) echo htmlentities($trustData->payflow_url); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div style="border:1px solid #CCC; padding:15px 5px 0px 5px; margin-top:10px;">
                            <div class="grid_title">
                                <h3>Razorpay Gateway</h3>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Razorpay Key
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="razorpaykey" id="razorpaykey" value="<?PHP if(!empty($trustData->razorpay_key)) echo htmlentities($trustData->razorpay_key); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Razorpay Secret
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="razorpaysecret" id="razorpaysecret" value="<?PHP if(!empty($trustData->razorpay_secret)) echo htmlentities($trustData->razorpay_secret); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Razorpay Webhook Secret
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="razorpaywebhooksecretkey" id="razorpaywebhooksecretkey" value="<?PHP if(!empty($trustData->razorpay_webhook_secret_key)) echo htmlentities($trustData->razorpay_webhook_secret_key); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Razorpay Failed Tx Report Emails
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="razorpayfailedtxreportemails" id="razorpayfailedtxreportemails" value="<?PHP if(!empty($trustData->razorpay_failed_tx_report_emails)) echo htmlentities($trustData->razorpay_failed_tx_report_emails); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div style="border:1px solid #CCC; padding:15px 5px 0px 5px; margin-top:10px;">
                            <div class="grid_title">
                                <h3>Stripe Gateway</h3>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Stripe Public Key
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="stripepublickey" id="stripepublickey" value="<?PHP if(!empty($trustData->stripe_public_key)) echo htmlentities($trustData->stripe_public_key); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Stripe Secret Key
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="stripesecretkey" id="stripesecretkey" value="<?PHP if(!empty($trustData->stripe_secret_key)) echo htmlentities($trustData->stripe_secret_key); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Stripe INR Webhook Secret Key
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="stripewebhooksecretkeyinr" id="stripewebhooksecretkeyinr" value="<?PHP if(!empty($trustData->stripe_webhook_secret_key_inr)) echo htmlentities($trustData->stripe_webhook_secret_key_inr); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">Stripe USD Webhook Secret Key
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="stripewebhooksecretkeyusd" id="stripewebhooksecretkeyusd" value="<?PHP if(!empty($trustData->stripe_webhook_secret_key_usd)) echo htmlentities($trustData->stripe_webhook_secret_key_usd); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div style="border:1px solid #CCC; padding:15px 5px 0px 5px; margin-top:10px;">
                            <div class="grid_title">
                                <h3>PayU Gateway</h3>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">PayU Merchant Key
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="payumerchantkey" id="payumerchantkey" value="<?PHP if(!empty($trustData->payu_merchantkey)) echo htmlentities($trustData->payu_merchantkey); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">PayU Salt
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="payusalt" id="payusalt" value="<?PHP if(!empty($trustData->payu_salt)) echo htmlentities($trustData->payu_salt); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">PayU URL
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="payuurl" id="payuurl" value="<?PHP if(!empty($trustData->payu_url)) echo htmlentities($trustData->payu_url); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">PayU Get URL
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="payugeturl" id="payugeturl" value="<?PHP if(!empty($trustData->payu_get_url)) echo htmlentities($trustData->payu_get_url); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">PayU Authentication Key
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="payuauthkey" id="payuauthkey" value="<?PHP if(!empty($trustData->payu_auth_key)) echo htmlentities($trustData->payu_auth_key); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div style="border:1px solid #CCC; padding:15px 5px 0px 5px; margin-top:10px;">
                            <div class="grid_title">
                                <h3>Authorizenet Gateway</h3>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Authorize.net User
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="authorizeuser" id="authorizeuser" value="<?PHP if(!empty($trustData->authorizenet_login)) echo htmlentities($trustData->authorizenet_login); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">Authorize.net Key
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="authorizekey" id="authorizekey" value="<?PHP if(!empty($trustData->authorizenet_key)) echo htmlentities($trustData->authorizenet_key); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div style="border:1px solid #CCC; padding:15px 5px 0px 5px; margin-top:10px;">
                            <div class="grid_title">
                                <h3>CCAvenue Gateway</h3>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">CCAvenue Merchant Id
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="ccavenuemerchantid" id="ccavenuemerchantid" value="<?PHP if(!empty($trustData->ccavenue_merchant_id)) echo htmlentities($trustData->ccavenue_merchant_id); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="control-label">CCAvenue Working Key
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="ccavenueworkingkey" id="ccavenueworkingkey" value="<?PHP if(!empty($trustData->ccavenue_working_key)) echo htmlentities($trustData->ccavenue_working_key); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label">CCAvenue Access Code
                                        </label>
                                        <div class="form-content">
                                            <input type="text" class="form-control" name="ccavenueaccesscode" id="ccavenueaccesscode" value="<?PHP if(!empty($trustData->ccavenue_access_code)) echo htmlentities($trustData->ccavenue_access_code); ?>">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <br>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <div class="form-content">
                                <button name="save_trust" class="btn btn-xs blue" type="submit" id="save_trust">
                                    <i class="fa fa-check"></i> 
                                    <?PHP
                                        if($id) echo "Save";
                                        else
                                            echo "Create";
                                    ?>
                                </button>
                                <a href="#" class="btn btn-xs red">
                                    <i class="fa fa-ban"></i> Cancel
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <?PHP
        if($id && strtolower($trustData->currency)=='inr')
        {
            ?>
            <div id="trust80G" class="no-more-tables">
                <?PHP
                $yearData = [];
                $y=date("Y");
                $y = ($y+1);
                for($i=2016;$i<=$y;$i++)
                {
                    if(date("Y") == $i && date('m')>=4)
                    {
                        $inrstartdate = $i."-".financial_year_start_month_date;
                        $inrstartdateStr = date("jS M Y", strtotime($inrstartdate));
                        $inrenddate = ($i+1)."-".financial_year_end_month_date;
                        $inrenddateStr = date("jS M Y", strtotime($inrenddate));
                        $yearData[$inrstartdate."_to_".$inrenddate] = $inrstartdateStr." - ".$inrenddateStr;

                        $inrstartdate = ($i-1)."-".financial_year_start_month_date;
                        $inrstartdateStr = date("jS M Y", strtotime($inrstartdate));
                        $inrenddate = ($i)."-".financial_year_end_month_date;
                        $inrenddateStr = date("jS M Y", strtotime($inrenddate));
                        $yearData[$inrstartdate."_to_".$inrenddate] = $inrstartdateStr." - ".$inrenddateStr;
                    }
                    else
                    {
                        $inrstartdate = ($i-1)."-".financial_year_start_month_date;
                        $inrstartdateStr = date("jS M Y", strtotime($inrstartdate));
                        $inrenddate = ($i)."-".financial_year_end_month_date;
                        $inrenddateStr = date("jS M Y", strtotime($inrenddate));
                        $yearData[$inrstartdate."_to_".$inrenddate] = $inrstartdateStr." - ".$inrenddateStr;
                    }
                }
                ?>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group" id="trust80gYeardiv">
                            <label class="control-label" style="color: red;">Trust 80G Year<span class="required">*</span>
                            </label>
                            <div class="form-content">
                                <select name="trust80g_year" id="trust80g_year" class="form-control" onChange="changeTrust80gYear(<?PHP echo $trustData->trust_basic_id; ?>, this.value)">
                                    <option value="">Select Trust 80G Year</option>
                                    <?PHP
                                    foreach($yearData as $key => $thisYear)
                                    {
                                        ?>
                                        <option value="<?PHP echo $key; ?>" <?PHP if(isset($trustData->trust_80g_year) && $trustData->trust_80g_year==$key) { echo "selected"; } ?>><?PHP echo $thisYear; ?></option>
                                        <?PHP
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group" id="trust80gdiv">
                            <label class="control-label">Trust 80G / 501c3 Note <span class="required">*</span>
                            </label>
                            <div class="form-content" id="trust_80g_note">
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?PHP
        }
        ?>
    </div>
</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<!-- The File Upload user interface plugin -->
<script type="text/javascript">
var slider = $("#settings-tabs").sliderTabs();
$( document ).ready(function()
{
    $('#trust_form').validate(
        {
            errorElement: 'label', //default input error message container
            errorClass: 'help-inline', // default input error message class
            focusInvalid: true, // do not focus the last invalid input
            onkeyup: false,
            ignore: ':hidden:not(.do-not-ignore)', 
            rules:
            {
                currency:
                {
                    required: true
                },
                trust_basic_id:
                {
                    required: true
                },
                trustaccfor:
                {
                    required: true,
                    remote:{
                        url: "/ashramadmin/sevaCheck/",
                        type: "post",
                        data:
                        {
                            currency: function()
                            {
                                return $( "#currency" ).val();
                            }
                        }
                    }
                },
                razorpaysecret: {
                    required:function(element){
                        return ($("#razorpaykey").is(':filled') || $("#razorpaywebhooksecretkey").is(':filled') || $("#razorpayfailedtxreportemails").is(':filled'));
                     }
                },
                razorpaykey: {
                    required:function(element){
                        return ($("#razorpaysecret").is(':filled') || $("#razorpaywebhooksecretkey").is(':filled') || $("#razorpayfailedtxreportemails").is(':filled'));
                     }
                },
                razorpaywebhooksecretkey: {
                    required:function(element){
                        return ($("#razorpaysecret").is(':filled') || $("#razorpaykey").is(':filled') || $("#razorpayfailedtxreportemails").is(':filled'));
                     }
                },
                razorpayfailedtxreportemails: {
                    required:function(element){
                        return ($("#razorpaysecret").is(':filled') || $("#razorpaykey").is(':filled') || $("#razorpaywebhooksecretkey").is(':filled'));
                     }
                },
                stripepublickey: {
                    required:function(element){
                        return ($("#stripesecretkey").is(':filled') || $("#stripewebhooksecretkeyinr").is(':filled') || $("#stripewebhooksecretkeyusd").is(':filled'));
                     }
                },
                stripesecretkey: {
                    required:function(element){
                        return ($("#stripepublickey").is(':filled') || $("#stripewebhooksecretkeyinr").is(':filled') || $("#stripewebhooksecretkeyusd").is(':filled'));
                     }
                },
                stripewebhooksecretkeyinr: {
                    required:function(element){
                        return ($("#stripepublickey").is(':filled') || $("#stripesecretkey").is(':filled') || $("#stripewebhooksecretkeyusd").is(':filled'));
                     }
                },
                stripewebhooksecretkeyusd: {
                    required:function(element){
                        return ($("#stripepublickey").is(':filled') || $("#stripesecretkey").is(':filled') || $("#stripewebhooksecretkeyinr").is(':filled'));
                     }
                },
                payumerchantkey: {
                    required:function(element){
                        return ($("#payusalt").is(':filled') || $("#payuurl").is(':filled') || $("#payugeturl").is(':filled') || $("#payuauthkey").is(':filled'));
                     }
                },
                payusalt: {
                    required:function(element){
                        return ($("#payumerchantkey").is(':filled') || $("#payugeturl").is(':filled') || $("#payuurl").is(':filled') || $("#payuauthkey").is(':filled'));
                    }
                },
                payuurl:
                {
                    required:function(element){
                        return ($("#payumerchantkey").is(':filled') || $("#payusalt").is(':filled') || $("#payugeturl").is(':filled') || $("#payuauthkey").is(':filled'));
                    }
                },
                payugeturl:
                {
                    required:function(element){
                        return ($("#payumerchantkey").is(':filled') || $("#payusalt").is(':filled') || $("#payuurl").is(':filled') || $("#payuauthkey").is(':filled'));
                    }
                },
                payuauthkey:
                {
                    required:function(element){
                        return ($("#payumerchantkey").is(':filled') || $("#payusalt").is(':filled') || $("#payuurl").is(':filled') || $("#payugeturl").is(':filled'));
                    }
                },
                authorizeuser: {
                    required:function(element){
                        return ($("#authorizekey").is(':filled'));
                     }
                },
                authorizekey: {
                    required:function(element){
                        return ($("#authorizeuser").is(':filled'));
                     }
                },
                ccavenuemerchantid: {
                    required:function(element){
                        return ($("#ccavenueworkingkey").is(':filled') || $("#ccavenueaccesscode").is(':filled'));
                     }
                },
                ccavenueworkingkey: {
                    required:function(element){
                        return ($("#ccavenuemerchantid").is(':filled') || $("#ccavenueaccesscode").is(':filled'));
                     }
                },
                ccavenueaccesscode: {
                    required:function(element){
                        return ($("#ccavenuemerchantid").is(':filled') || $("#ccavenueworkingkey").is(':filled'));
                     }
                },
                payflowpartner: {
                    required:function(element){
                        return ($("#payflowvendor").is(':filled') || $("#payflowuser").is(':filled') || $("#payflowpassword").is(':filled') || $("#paypalemail").is(':filled')  || $("#payflowurl").is(':filled'));
                     }
                },
                payflowvendor: {
                    required:function(element){
                        return ($("#payflowpartner").is(':filled') || $("#payflowuser").is(':filled') || $("#payflowpassword").is(':filled') || $("#paypalemail").is(':filled')  || $("#payflowurl").is(':filled'));
                     }
                },
                payflowuser: {
                    required:function(element){
                        return ($("#payflowpartner").is(':filled') || $("#payflowvendor").is(':filled') || $("#payflowpassword").is(':filled') || $("#paypalemail").is(':filled')  || $("#payflowurl").is(':filled'));
                     }
                },
                payflowpassword: {
                    required:function(element){
                        return ($("#payflowpartner").is(':filled') || $("#payflowvendor").is(':filled') || $("#payflowuser").is(':filled') || $("#paypalemail").is(':filled')  || $("#payflowurl").is(':filled'));
                     }
                },
                payflowurl: {
                    required:function(element){
                        return ($("#payflowpartner").is(':filled') || $("#payflowvendor").is(':filled') || $("#payflowuser").is(':filled') || $("#paypalemail").is(':filled'));
                     },
                     url:true
                },
                paypalemail: {
                    // required:function(element){
                    //     return ($("#payflowpartner").is(':filled') || $("#payflowvendor").is(':filled') || $("#payflowuser").is(':filled') || $("#payflowpassword").is(':filled'));
                    //  },
                     email:true
                }
            },
            messages:
            {
                currency:
                {
                    required: "Please select Currency"
                },
                trust_basic_id:
                {
                    required: "Please select Basic Trust Details"
                },
                razorpaykey:
                {
                    required: "Please enter Razorpay Key"
                },
                razorpaysecret:
                {
                    required: "Please enter Razorpay Secret"
                },
                razorpaywebhooksecretkey:
                {
                    required: "Please enter Razorpay Web Secret"
                },
                razorpayfailedtxreportemails:
                {
                    required: "Please enter Razorpay Failed Transaction Report Emails"
                },
                stripepublickey:
                {
                    required: "Please enter Stripe Public Key"
                },
                stripesecretkey:
                {
                    required: "Please enter Stripe Secret Key"
                },
                stripewebhooksecretkeyinr: {
                    required: "Please enter Stripe INR Webhook Secret Key"
                },
                stripewebhooksecretkeyusd: {
                    required: "Please enter Stripe USD Webhook Secret Key"
                },
                payumerchantkey:
                {
                    required: "Please enter PayU Merchant Key"
                },
                payusalt:
                {
                    required: "Please enter PayU Salt"
                },
                payuurl:
                {
                    required: "Please enter PayU URL"
                },
                payugeturl:
                {
                    required: "Please enter PayU Get URL"
                },
                payuauthkey:
                {
                    required: "Please enter PayU Authentication Key"
                },
                authorizeuser:
                {
                    required: "Please enter Authorize.net User"
                },
                authorizekey:
                {
                    required: "Please enter Authorize Key"
                },
                ccavenuemerchantid:
                {
                    required: "Please enter CCAvenue Merchant Id"
                },
                ccavenueworkingkey:
                {
                    required: "Please enter CCAvenue Working Key"
                },
                ccavenueaccesscode:
                {
                    required: "Please enter CCAvenue Access Code"
                },
                payflowpartner:
                {
                    required: "Please enter Paypal Payflow Partner Name"
                },
                payflowvendor:
                {
                    required: "Please enter Paypal Payflow Vendor Name"
                },
                payflowuser:
                {
                    required: "Please enter Paypal Payflow User"
                },
                payflowpassword:
                {
                    required: "Please enter Paypal Payflow Password"
                },
                payflowurl:
                {
                    required: "Please enter valid Payflow URL"
                },
                // paypalemail:
                // {
                //     required: "Please enter Paypal Email"
                // }
            },
            highlight: function (element)
            {
                $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
            },
            success: function (label, element)
            {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
                label.remove();
            },
            errorPlacement: function (error, element)
            { 
                error.addClass('help-small no-left-padding').insertAfter(element);
            },
            submitHandler: function(form) 
            {
                $('#save_trust').hide();
                form.submit();
            }
    });
});

function changeTrust80gYear(trust_basic_id,trust_80g_year)
{
    $.ajax({
        type: "POST",
        url: '/ashramadmin/getTrust80gByTrustIdAndYear',
        data:{'trust_basic_id':trust_basic_id, 'trust_80g_year':trust_80g_year},
        success: function (resdata)
        {
            var r=$.parseJSON(resdata);
            if(r.flag==1)
            {
                $('#trust_80g_note').html(r.year_note);
            }
            else
            {
                $('#trust_80g_note').html('');
            }
        }
    });
}

function changeBasicTrust(trust_basic_id)
{
    $.ajax({
        type: "POST",
        url: '/ashramadmin/getTrustBasicDetails',
        data:{'trust_basic_id':trust_basic_id},
        success: function (resdata)
        {
            var r=$.parseJSON(resdata);
            if(r.flag==1)
            {
                $('#basicTrustContactNameCont').html(r.trustBasicData.trust_name);
                $('#basicTrustAddressCont').html(r.trustBasicData.address);
                $('#basicTrustFooterCont').html(r.trustBasicData.trust_footer);
                $('#basicTrustDescriptionCont').html(r.trustBasicData.description);
                $('#basicTrustYestCont').html(r.trustBasicData.year_end_statement_text);
                $("#basicTrustLogoCont img").attr("src",r.trustBasicData.logo);
            }
            else
            {
                $('#basicTrustContactNameCont').html('');
                $('#basicTrustAddressCont').html('');
                $('#basicTrustFooterCont').html('');
                $('#basicTrustDescriptionCont').html('');
                $('#basicTrustYestCont').html('');
            }
        }
    });
}
</script>