<?PHP
$partHeader='Add Group';
if($id)
{
    $partHeader=htmlentities($groupData->name);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Donations | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
    $this->load->view("ashrams/admin/donations_nav_buttons");
?>
<h3 class="page-title">
	<?PHP
    	echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/donationsadmin">All Donations</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/donationsadmin/groups">All Groups</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("group_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("group_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Group created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("group_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>
<link rel="stylesheet" href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/tabs/styles/jquery.sliderTabs.css">
<script src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/tabs/jquery.sliderTabs.js"></script>
<link href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/bootstrap-editable/bootstrap-editable/css/bootstrap-editable.css" rel="stylesheet" />
<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<div class="row-fluid">
    <div id="donationGroupsTabs">
        <ul class="hidden-print">
            <li class="active">
                <a href="#groupDetails" data-toggle="tab"> 
                    Details
                </a>
            </li>
            <?PHP
            if($id)
            {
                ?>
                <li class="active">
                    <a href="#groupItems" data-toggle="tab"> 
                        Items
                    </a>
                </li>
                <?PHP
            }
            ?>
        </ul>
        <div id="groupDetails" class="no-more-tables">
			<form action="" id="group_form" name="group_form" method="post">
				<div class="row">
					<div class="col-md-6">
                        
                        <?PHP
                        if(is_single_ashram_site)
                        { 
                        ?>
                            <input type="hidden" name="ashram_id" id="ashram_id" value="<?php echo default_ashram_id; ?>">
                        <?PHP
                        }
                        else if($this->currentUser->roles==1 && $id==0)
                        {
                            ?>
                        <div class="form-group">
                            <label class="control-label">Ashram Name
                            </label>
                            <div class="form-content">
                                <select name="ashram_id" id="ashram_id" onChange="switchAshram(this.value)" class="form-control">
                                    <option value="0">Select Ashram</option>
                                    <?PHP
                                    foreach ($ashrams as $ashramData)
                                    {
                                        ?>
                                        <option value="<?PHP echo $ashramData->id; ?>"
                                        <?PHP
                                        if($this->session->userdata("ashramId")==$ashramData->id)
                                            echo " selected";
                                        ?>
                                        >
                                            <?PHP echo $ashramData->name; ?>
                                        </option>
                                        <?PHP
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                            <script>
                                function switchAshram(ashram_id)
                                {
                                    $.post("/ashramadmin/switchashram/"+ashram_id,{},function(res)
                                    {
                                        window.location.reload();
                                    });
                                }
                            </script>
                            <?PHP
                            } else if($id>0) { ?>
                            <div class="form-group">
                                <label class="control-label">Ashram Name
                                </label>
                                <div class="form-content">
                                    <?PHP echo htmlentities($groupData->group_ashram_name); ?>
                                </div>
                            </div>
                            <?PHP } else { ?>
                            <div class="form-group">
                                <label class="control-label">Ashram Name
                                </label>
                                <div class="form-content">
                                    <?PHP echo htmlentities($ashramData->name); ?>
                                </div>
                            </div>
                            <?PHP } ?>
                            
			            <div class="form-group">
			                <label class="control-label">Group Name
			                </label>
			                <div class="form-content">
			                    <input type="text" class="form-control" name="name" id="name"
			                        value="<?PHP if($id) echo htmlentities($groupData->name); ?>">
			                </div>
			            </div>
			            <div class="form-group">
                            <label class="control-label">
                                Display Group to Guest/User?
                            </label>
                            <div class="form-content">
                                <select class="form-control" name="allow_public_display" id="allow_public_display">
                                    <option value="1" <?PHP if($id && $groupData->allow_public_display==1) echo "selected"; ?>>Yes</option>
                                    <option value="0" <?PHP if($id && $groupData->allow_public_display==0) echo "selected"; ?>>No</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label"> Group Key </label>
                            <div class="form-content">
                                <?PHP
                                if(isset($groupData->group_key) && $groupData->group_key!='')
                                {
                                    $groupKey = $groupData->group_key;
                                }
                                else
                                {
                                    $groupKey  = random_string('alnum',16);
                                }
                                ?>
                                <input type="text" class="form-control" name="group_key" id="group_key" value="<?PHP echo $groupKey; ?>">
                            </div>
                            <span class="col-md-12 text inrGroupKeyLinkRw" style="padding: 0;font-size: 10px;margin: 5px 0;">
                                <?PHP
                                $inrGroupKeyLink = base_url()."donations?ashram_id=".$this->session->userdata("ashramId")."&currency=inr&view=listView&group_key=".$groupKey;
                                ?>
                                <a href="javascript:;" onClick="CopyToClipboard('inrGroupLinkCopy')">
                                    <i class="fa fa-copy" style="color:#000; margin: 0px 10px 0px 0px;"></i>
                                </a>
                                <a id="inrGroupLinkCopy" href="<?PHP echo htmlspecialchars($inrGroupKeyLink); ?>" target="_blank" style="color: #000;">
                                    <?PHP echo htmlspecialchars($inrGroupKeyLink); ?>
                                </a>
                            </span>
                            <span class="col-md-12 usdGroupKeyLinkRw" style="padding: 0;font-size: 10px;margin: 5px 0;margin-bottom: 10px;">
                                <?PHP
                                $usdGroupKeyLink = base_url()."donations?ashram_id=".$this->session->userdata("ashramId")."&currency=usd&view=listView&group_key=".$groupKey;
                                ?>
                                <a href="javascript:;" onClick="CopyToClipboard('usdGroupLinkCopy')">
                                    <i class="fa fa-copy" style="color:#a94442; margin: 0px 10px 0px 0px;"></i>
                                </a>
                                <a id="usdGroupLinkCopy" href="<?PHP echo htmlspecialchars($usdGroupKeyLink); ?>" target="_blank" style="color: #a94442;">
                                    <?PHP echo htmlspecialchars($usdGroupKeyLink); ?>
                                </a>
                            </span>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">
                                Display description to Guest/User?
                            </label>
                            <div class="form-content">
                                <select class="form-control" name="allow_public_description_display" id="allow_public_description_display">
                                    <option value="0" <?PHP if($id && $groupData->allow_public_description_display==0) echo "selected"; ?>>No</option>
                                    <option value="1" <?PHP if($id && $groupData->allow_public_description_display==1) echo "selected"; ?>>Yes</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">
                                Description
                            </label>
                            <div class="form-content">
                                <textarea class="form-control do-not-ignore" name="description" id="description" rows="4"
                                    ><?PHP if($id) echo $groupData->description; ?></textarea>
                            </div>
                        </div>
			            <div class="form-group">
							<div class="form-content pull-right">
								<a href="/donationsadmin/groups" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
								<button type="submit" name="add_group" id="add_group" class="btn btn-xs blue"> 
								<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Group"; ?></button>
							</div>
						</div>
					</div>
				</div>

			</form>
		</div>

        <?PHP
        if($id)
        {
            ?>
            <div id="groupItems" class="no-more-tables">
                <table id="txtable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                    <thead>
                        <tr>
                            <th width="60">S. No.</th>
                            <th width="100">Order</th>
                            <th>Donation Name</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?PHP
                        if(isset($donationItems) && !empty($donationItems))
                        {
                            $sno=1;
                            foreach($donationItems as $thisDonation)
                            {
                                ?>
                                <tr>
                                    <td data-title="S. No.">
                                        <?PHP echo $sno++; ?>
                                    </td>
                                    <td data-title="Order">
                                        <a href="javascript:;" data-type="text" data-pk="<?PHP echo $thisDonation->id; ?>" data-original-title="Enter Order" data-name="Order" class="editable editable-click update-donation-order" style="display: inline;">
                                            <?PHP echo $thisDonation->order; ?>
                                        </a>
                                    </td>
                                    <td data-title="Donation Name">
                                        <?PHP echo $thisDonation->donation_name; ?>
                                    </td>
                                </tr>
                                <?PHP
                            }
                        }
                        else
                        {
                            ?>
                            <tr>
                                <td colspan="3">
                                    There is no Donations in this group
                                </td>
                            </tr>
                            <?PHP
                        }
                        ?>
                    </tbody>
                </table>
            </div>
            <?PHP
        }
        ?>

    </div>
</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-editable/bootstrap-editable/js/bootstrap-editable.min.js"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var slider = $("#donationGroupsTabs").sliderTabs();
CKEDITOR.env.isCompatible = true;
CKEDITOR.replace( 'description',
{
    height:'200px',
    toolbar :
    [
        { name: 'indent', items : [ 'Bold','Italic','Underline','Link','Unlink'] }
    ],
    enterMode: CKEDITOR.ENTER_BR,
});	

function CopyToClipboard(containerid)
{
    clearNotifications();
    var range = document.createRange();
    range.selectNode(document.getElementById(containerid));
    window.getSelection().addRange(range);
    document.execCommand("copy");
    window.getSelection().removeAllRanges();
    showNotification("lime","Copied to clipboard");
}

$("#group_key").on("keypress change",function()
{
    var groupKey = $(this).val();
    var inrGroupKeyLink = "<?PHP echo base_url(); ?>donations?ashram_id=<?PHP echo $this->session->userdata("ashramId"); ?>&currency=inr&view=listView&group_key="+groupKey;
    $(".inrGroupKeyLinkRw").empty().append("<a href='"+inrGroupKeyLink+"' target='_blank' style='color: #000;'>"+inrGroupKeyLink+"</a>");
    var usdGroupKeyLink = "<?PHP echo base_url(); ?>donations?ashram_id=<?PHP echo $this->session->userdata("ashramId"); ?>&currency=inr&view=listView&group_key="+groupKey;
    $(".usdGroupKeyLinkRw").empty().append("<a href='"+usdGroupKeyLink+"' target='_blank' style='color: #a94442;'>"+usdGroupKeyLink+"</a>");
});

$( document ).ready(function() 
{
    $.fn.editable.defaults.mode = 'inline';
    $.fn.editable.defaults.inputclass = 'form-control';
    $.fn.editableform.buttons = '<button type="submit" disabled class="btn btn-xs blue editable-submit"><i class="fa fa-check"></i> Save</button>';
    $.fn.editableform.buttons += '<button type="button" class="btn btn-xs red editable-cancel"><i class="fa fa-remove"></i> Cancel</button>';

	jQuery.validator.addMethod("pcheck", function(value, element) 
	{ 
		$.ajaxSetup({async: false});
		var rr=true;
        $.post('/donationsadmin/groupcheckname/<?PHP echo $id; ?>', {name:$('#name').val()}, function(res) 
		{
			if(res==0)
			{
				$.validator.messages.pcheck='Please try another group name';
				rr=false;
			}
			if(res==2)
			{
				$.validator.messages.pcheck='Group already exists';
				rr=false;
			}
		});
		return rr;
	}, "Please try another group name");

	$('#group_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules: {
            name: {
                required: true,
                minlength:3,
                maxlength:100,
                pcheck:true
            },
            group_key:
            {
                required:true,
                minlength:2,
                maxlength:64,
                alphanumeric_undrscore_dash:true
            }
        },

        messages:
        {
            name:
            {
                required: "Please enter group name"
            },
            group_key:
            {
                required:"Please enter Group Key",
            }
        },
    	highlight: function (element)
    	{
            $(element)
                .closest('.form-group').removeClass("has-success").addClass('has-error');
        },
         success: function (label, element)
         {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },

         errorPlacement: function (error, element) { // render error placement for each input type
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });

});

function initEdit()
{
    $('.update-donation-order').editable(
    {
        url: '/donationsadmin/donation_updateorder',
        type: 'text',
        title: 'Enter Order',
        send: 'always',
        validate: function(value)
        {
            var vInt=parseInt(value);
            if($.trim(value) == '')
            {
                return 'Enter Order';
            }
            var testRegex=/^\d+$/.test($.trim(value));
            if(testRegex==false)
            {
                return 'Enter only digits';
            }
            if(vInt.length!=undefined && $.trim(value).length!=vInt.length)
            {
                return 'Enter valid number';
            }
            if($.trim(value).length>3)
            {
                return 'Max 3 digits allowed';
            }
        },
        success: function(response, newValue)
        {
            if(response==0)
            {
                return "Something wrong, please refresh the page and try again.";
            }
        }
    });
}
</script>
