<?PHP
$partHeader='Add Category';
if($id)
{
    $partHeader=htmlentities($categoryData->name);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Donations | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
    $this->load->view("ashrams/admin/donations_nav_buttons");
?>
<h3 class="page-title">
	<?PHP
    	echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/donationsadmin">All Donations</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/donationsadmin/categories">All Categories</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("cat_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("cat_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Category created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("cat_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>
<link rel="stylesheet" href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/tabs/styles/jquery.sliderTabs.css">
<script src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/tabs/jquery.sliderTabs.js"></script>
<link href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/bootstrap-editable/bootstrap-editable/css/bootstrap-editable.css" rel="stylesheet" />
<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<div class="row-fluid">
    <div id="donationCategoriesTabs">
        <ul class="hidden-print">
            <li class="active">
                <a href="#categoryDetails" data-toggle="tab"> 
                    Details
                </a>
            </li>
            <?PHP
            if($id)
            {
                ?>
                <li class="active">
                    <a href="#categoryItems" data-toggle="tab"> 
                        Items
                    </a>
                </li>
                <?PHP
            }
            ?>
        </ul>
        <div id="categoryDetails" class="no-more-tables">
			<form action="" id="cat_form" name="cat_form" method="post">
				<div class="row">
					<div class="col-md-6">
                        
                        <?PHP
                        if(is_single_ashram_site)
                        { 
                        ?>
                            <input type="hidden" name="ashram_id" id="ashram_id" value="<?php echo default_ashram_id; ?>">
                        <?PHP
                        }
                        else if($this->currentUser->roles==1 && $id==0)
                        {
                            ?>
                        <div class="form-group">
                            <label class="control-label">Ashram Name
                            </label>
                            <div class="form-content">
                                <select name="ashram_id" id="ashram_id" onChange="switchAshram(this.value)" class="form-control">
                                    <option value="0">Select Ashram</option>
                                    <?PHP
                                    foreach ($ashrams as $ashramData)
                                    {
                                        ?>
                                        <option value="<?PHP echo $ashramData->id; ?>"
                                        <?PHP
                                        if($this->session->userdata("ashramId")==$ashramData->id)
                                            echo " selected";
                                        ?>
                                        >
                                            <?PHP echo $ashramData->name; ?>
                                        </option>
                                        <?PHP
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                            <script>
                                function switchAshram(ashram_id)
                                {
                                    $.post("/ashramadmin/switchashram/"+ashram_id,{},function(res)
                                    {
                                        window.location.reload();
                                    });
                                }
                            </script>
                            <?PHP
                            } else if($id>0) { ?>
                            <div class="form-group">
                                <label class="control-label">Ashram Name
                                </label>
                                <div class="form-content">
                                    <?PHP echo htmlentities($categoryData->category_ashram_name); ?>
                                </div>
                            </div>
                            <?PHP } else { ?>
                            <div class="form-group">
                                <label class="control-label">Ashram Name
                                </label>
                                <div class="form-content">
                                    <?PHP echo htmlentities($ashramData->name); ?>
                                </div>
                            </div>
                            <?PHP } ?>
                            
			            <div class="form-group">
			                <label class="control-label">Category Name
			                </label>
			                <div class="form-content">
			                    <input type="text" class="form-control" name="name" id="name"
			                        value="<?PHP if($id) echo htmlentities($categoryData->name); ?>">
			                </div>
			            </div>
			            <div class="form-group">
                            <label class="control-label">
                                Display description to Guest/User?
                            </label>
                            <div class="form-content">
                                <select class="form-control" name="allow_public_display" id="allow_public_display">
                                    <option value="0" <?PHP if($id && $categoryData->allow_public_display==0) echo "selected"; ?>>No</option>
                                    <option value="1" <?PHP if($id && $categoryData->allow_public_display==1) echo "selected"; ?>>Yes</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">
                                Description
                            </label>
                            <div class="form-content">
                                <textarea class="form-control do-not-ignore" name="description" id="description" rows="4"
                                    ><?PHP if($id) echo $categoryData->description; ?></textarea>
                            </div>
                        </div>
			            <div class="form-group">
							<div class="form-content">
								<button type="submit" name="add_category" id="add_category" class="btn btn-xs blue"> 
								<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Category"; ?></button>
								<a href="/donationsadmin/categories" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
							</div>
						</div>
					</div>
				</div>

			</form>

        </div>

        <?PHP
        if($id)
        {
            ?>
            <div id="categoryItems" class="no-more-tables">
                <table id="txtable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                    <thead>
                        <tr>
                            <th width="60">S. No.</th>
                            <th width="100">Order</th>
                            <th>Donation Name</th>
                            <th>Group Name</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?PHP
                        if(isset($donationItems) && !empty($donationItems))
                        {
                            $sno=1;
                            foreach($donationItems as $thisDonation)
                            {
                                ?>
                                <tr>
                                    <td data-title="S. No.">
                                        <?PHP echo $sno++; ?>
                                    </td>
                                    <td data-title="Order">
                                        <a href="javascript:;" data-type="text" data-pk="<?PHP echo $thisDonation->id; ?>" data-original-title="Enter Order" data-name="Order" class="editable editable-click update-donation-order" style="display: inline;">
                                            <?PHP echo $thisDonation->order; ?>
                                        </a>
                                    </td>
                                    <td data-title="Donation Name">
                                        <?PHP echo $thisDonation->donation_name; ?>
                                    </td>
                                    <td data-title="Group Name">
                                        <?PHP echo $thisDonation->group_name; ?>
                                    </td>
                                </tr>
                                <?PHP
                            }
                        }
                        else
                        {
                            ?>
                            <tr>
                                <td colspan="4">
                                    There is no Donations in this category
                                </td>
                            </tr>
                            <?PHP
                        }
                        ?>
                    </tbody>
                </table>
            </div>
            <?PHP
        }
        ?>

    </div>

</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-editable/bootstrap-editable/js/bootstrap-editable.min.js"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var slider = $("#donationCategoriesTabs").sliderTabs();
CKEDITOR.env.isCompatible = true;
CKEDITOR.replace( 'description',
{
    height:'200px',
    toolbar :
    [
        { name: 'indent', items : [ 'Bold','Italic','Underline','Link','Unlink'] }
    ],
    enterMode: CKEDITOR.ENTER_BR,
});

$( document ).ready(function() 
{
    $.fn.editable.defaults.mode = 'inline';
    $.fn.editable.defaults.inputclass = 'form-control';
    $.fn.editableform.buttons = '<button type="submit" disabled class="btn btn-xs blue editable-submit"><i class="fa fa-check"></i> Save</button>';
    $.fn.editableform.buttons += '<button type="button" class="btn btn-xs red editable-cancel"><i class="fa fa-remove"></i> Cancel</button>';

	jQuery.validator.addMethod("pcheck", function(value, element) 
	{ 
		$.ajaxSetup({async: false});
		var rr=true;
        $.post('/donationsadmin/categorycheckname/<?PHP echo $id; ?>', {name:$('#name').val()}, function(res) 
		{
			if(res==0)
			{
				$.validator.messages.pcheck='Please try another category name';
				rr=false;
			}
			if(res==2)
			{
				$.validator.messages.pcheck='Category already exists';
				rr=false;
			}
		});
		return rr;
	}, "Please try another category name");

	$('#cat_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules: {
            name: {
                required: true,
                minlength:3,
                maxlength:100,
                pcheck:true
            }
        },

        messages:
        {
            name:
            {
                required: "Please enter category name"
            }
        },
    	highlight: function (element)
    	{
            $(element)
                .closest('.form-group').removeClass("has-success").addClass('has-error');
        },
         success: function (label, element)
         {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },

         errorPlacement: function (error, element) { // render error placement for each input type
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });

});

function initEdit()
{
    $('.update-donation-order').editable(
    {
        url: '/donationsadmin/donation_updateorder',
        type: 'text',
        title: 'Enter Order',
        send: 'always',
        validate: function(value)
        {
            var vInt=parseInt(value);
            if($.trim(value) == '')
            {
                return 'Enter Order';
            }
            var testRegex=/^\d+$/.test($.trim(value));
            if(testRegex==false)
            {
                return 'Enter only digits';
            }
            if(vInt.length!=undefined && $.trim(value).length!=vInt.length)
            {
                return 'Enter valid number';
            }
            if($.trim(value).length>3)
            {
                return 'Max 3 digits allowed';
            }
        },
        success: function(response, newValue)
        {
            if(response==0)
            {
                return "Something wrong, please refresh the page and try again.";
            }
        }
    });
}
</script>
