<?PHP
class website_backup_model extends CI_Model
{
	var $tableName='website_backup';
	function __construct()
	{
        parent::__construct();
	}
	function fileData($id)
	{
		$this->db->where("id",$id);
		$query = $this->db->get($this->tableName);
		return $query->row();
	}
	public function getList()
	{
		$i=0;
		$query1=$this->db;
		$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns'])
		 && in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),"after");
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),'before');
			}
			else
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
			}
		}
		if(isset($_POST['backup_type']) && $_POST['backup_type']!='')
		{
			$query1->where('backup_type',$_POST['backup_type']);
		}
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('date',$dir);
		}
		else
		{
			$query1->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		$dir=exec("cd ..; cd website_backups; pwd");
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y h:i A",strtotime($rtn['data'][$c]['date']));
			$fpath=$dir."/".$rtn['data'][$c]['filename'];
			$size='';
			if(file_exists($fpath))
			{
				$sz= filesize($fpath);
				$size=$sz/1024;
				if($size<1) $size=$sz." Bytes";
				else
				{
					if($size<1000) $size= round($size,2)." KB";
					else
					{
						$size=$size/1024;
						if($size<1000) $size= round($size,2)." MB";
						else
						{
							$size=$size/1024;
							$size= round($size,2)." GB";
						}
					}
				}
				$rtn['data'][$c]['size']=$size;
				$rtn['data'][$c]['status']=1;
			}
			else
			{
				$rtn['data'][$c]['size']='N/A';
				$rtn['data'][$c]['status']=0;
			}

			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	public function doFileBackup()
	{
		$f1=exec("cd ..; cd website_backups; pwd");
				
		$bk_name = $f1."/file_backup_".date('Y-m-d-His').".tar.gz";
		$src_name = dirname($_SERVER['SCRIPT_FILENAME']);
		$bk_dir = $f1;
		$exclude = $bk_dir;
		
		//$exar=array('backups','nbproject','svnrepos','software','user_guide','admin_includes','admin_personal_files');
		$ex_str='';
		
		//echo $ex_str;
		$dir=dirname($_SERVER['SCRIPT_FILENAME'])."/";
		$f=scandir($dir);
		
		$diff=array_diff($f,$_POST['exc']);
		
		foreach($diff as $exx)
		{
			$ext = pathinfo($exx, PATHINFO_EXTENSION);
			if($ext!='') continue;
			
			if($exx!='.' && $exx!='..')
			$ex_str.=' --exclude='.$exx;
		}
		
		$command = "tar cvfz $bk_name --exclude=$exclude  $ex_str $src_name ";
		//echo $command;
		
		$this->session->set_flashdata("file_backup_processing","1");
		$this->db->insert($this->tableName,
						array("date"=>date("Y:m:d H:i:s"),
								"backup_type"=>'file',
								"filename"=>basename($bk_name)
							));
		exec("cd ..; ".$command . " > /dev/null &");
	}
	public function doDbBackup($dbarray,$dbGroups)
	{
		foreach ($dbarray as $dbName)
		{
			if(in_array($dbName,$this->excludeDbArray)) continue;

			$databaseName=$dbGroups[$dbName]['database'];
			$databaseUserName=$dbGroups[$dbName]['username'];
			$databasePassword=$dbGroups[$dbName]['password'];
			$databaseHostName=$dbGroups[$dbName]['hostname'];

			$f1=exec("cd ..; cd website_backups; pwd");
			
			$bk_dir = $f1;
			$base_bk_command = "mysqldump --single-transaction -u ".$databaseUserName." -p'".$databasePassword."' ".$databaseName." -h ".$databaseHostName;
			$db_bk_file = $bk_dir . "/db_backup_".$dbName."_".date('Y-m-d_His').".sql.gz";
			
			$command = $base_bk_command . " | gzip -c > $db_bk_file ";
			if($_POST['do'])
			
			{
				$this->session->set_flashdata("db_backup_processing","1");
				$this->db->insert($this->tableName,
							array("date"=>date("Y:m:d H:i:s"),
									"backup_type"=>'sql',
									"filename"=>basename($db_bk_file)
								));
				exec("cd ..; cd website_backups; ".$command);
			}
		}
	}
	public function delete($id,$fileData)
	{
		$bk_dir = exec("cd ..; cd website_backups; pwd");
		if(file_exists($bk_dir."/".$fileData->filename))
		{
			unlink($bk_dir."/".$fileData->filename);	
		}
		$this->db->where("id",$id);
		$this->db->delete($this->tableName);
	}
}
?>