<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class User_devices_model extends CI_Model
{
	var $tableName="user_devices";
	public function __construct()
	{
		parent::__construct();
	}
	public function deviceDataByPlayerID($player_id)
	{
		$this->db->where("player_id",$player_id);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}
	public function devicesByID($user_id)
	{
		$this->db->where("user_id",$user_id);
		$q=$this->db->get($this->tableName);
		return $q->result();
	}
	public function add($playerData)
	{
		$this->db->insert($this->tableName,
                array(
                	'player_id'=>$playerData->id,
                	'device' => $playerData->device_model,
					'platform' => $playerData->device_os,
					'user_id' => $this->currentUser->id,
					'first_active' => date("Y:m:d H:i:s",$playerData->last_active),
					'last_active' => date("Y:m:d H:i:s",$playerData->created_at),
					'app_version'=>$playerData->game_version
					)
				);
	}
	public function update($playerData)
	{
		$this->db->where("player_id",$playerData->id);
		$this->db->update($this->tableName,
                array(
					'user_id' => $this->currentUser->id
					)
				);
	}
	public function remove($playerData)
	{
		$this->db->where("player_id",$playerData->id);
		$this->db->delete($this->tableName);
	}
}
?>