<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Password_changing_history_model extends CI_Model 
{
	var $tableName='password_changing_history';
	public function __construct() 
	{
		if(isset($this->agent))
		{
			if ($this->agent->is_browser())
			{
				$this->bagent = $this->agent->browser().' '.$this->agent->version();
			}
			elseif ($this->agent->is_robot())
			{
				$this->bagent= $this->agent->robot();
			}
			elseif ($this->agent->is_mobile())
			{
				$this->bagent= $this->agent->mobile();
			}
			else
			{
				$this->bagent= 'Unidentified User Agent';
			}
		}
		else
		{
			$this->bagent= 'Unidentified User Agent';
		}
		
		parent::__construct();
    }

    public function save($userId)
    {
    	$this->db->where("id",$userId);
    	$q=$this->db->get("users");
    	if($q->num_rows())
    	{
    		$r=$q->row();
    		$email = !empty($r->email)?$r->email:"";
    		$phone = !empty($r->phoneno)?$r->phoneno:"";
    		$this->db->insert($this->tableName,
		                            array('user_id' => $userId,
										'username' => $r->username,
										'email'=>$email,
										'user_id' => $userId,
										'modified_on' => date("Y:m:d H:i:s"),
										'ip_address'=>$_SERVER['REMOTE_ADDR'],
										'useragent'=>$_SERVER['HTTP_USER_AGENT'],
										'phone'=>$phone
									)
									);
    	}
    }
    public function listAdmin($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(pass.id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("pass.*,u.status,u.email_verified,u.firstname,u.lastname,middlename,u.registered_on,u.registered_site,u.address,u.address1,u.address2,city,state,country_id,country,u.deleted");
		}
		$query1->where("u.id !=",0);

		$query1->from($this->tableName . " As pass");
		$query1->join("users as u","u.id = pass.user_id");

		$preData="Search Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			if($_POST['search_col'] =="firstname" || $_POST['search_col'] == "lastname")
			{
				$search_col = "u.".$_POST['search_col'];
			}
			else
			{
				$search_col = "pass.".$_POST['search_col'];
			}
			$query1->like($search_col,trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($search_col,trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($search_col,trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($search_col,trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nCountry: ";

		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$preData.=$countryData->country_name;
				$query1->where("country_id",$_POST['country']);
			}
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(modified_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(modified_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('username',$_POST['dir']);
				else
					$query1->order_by('username',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","user/password_changing_history_model",$sql,$this->currentUser,"default",$_POST,"All Users Password History",$preData);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('username',$dir);
		}
		else
		{
			$query1->order_by('username',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			if($row['country_id']!='')
			{
				$cntid=$row['country_id'];
				$rtn['data'][$c]['isd_code']=$countries[$cntid]->isd_code;
			}
			if($row['phone'] == "")
			{
				$rtn['data'][$c]['phone'] = "N/A";
			}
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['registered_on']=date("d M Y",strtotime($row['registered_on']));
			$rtn['data'][$c]['modified_on']=date("d M Y h:i A",strtotime($row['modified_on']));
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}


	public function excelReport($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User UID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Password Modified Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"IP Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID verified?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Middle Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address Line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address Line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address Line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Registered On");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Registered Site");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->user_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->modified_on)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ip_address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$status="Inactive";
			if($reportrow->status==1)
				$status="Active";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$emailVerified="No";
			if($reportrow->email_verified==1)
				$emailVerified="Yes";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$emailVerified);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->middlename);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);

			$isd_code='';
			if($reportrow->country_id!='')
			{
				$cid=$reportrow->country_id;
				$isd_code=" +".$countries[$cid]->isd_code;
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country.$isd_code);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->registered_on)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->registered_site);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>