<?PHP
class Newsletters_Model extends CI_Model 
{
	var $tableName="newsletters";
	public function __construct()
	{
		parent::__construct();
	}
	public function newsletterData($id)
	{
		$this->db->where("id",$id);
		$query = $this->db->get($this->tableName);
		return $query->row();
	}
	public function listNewsletters($excel=0)
	{

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);


		$preData="\nSearch Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns'])
		 && in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nStatus: ";

		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(1,2)))
		{
			$query1->where("status",$_POST['status']);
			if($_POST['status']==1)
			{
				$preData.="Created";
			}
			else
			{
				$preData.="Sent";
			}
		}
		else
		{
			$preData.="All Status";
		}

		/*if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(created_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(created_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
		}*/

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('created_on',$_POST['dir']);
				else
					$query1->order_by('created_on',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","subscriptions/newsletters_model",$sql,$this->currentUser,"default",$_POST,"All Newsletters",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('created_on',$dir);
		}
		else
		{
			$query1->order_by('created_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['created_on']));
			if($rtn['data'][$c]['sent_on'])
				$rtn['data'][$c]['sent_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['sent_on']));
			else
				$rtn['data'][$c]['sent_on']="N/A";
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function save($id)
	{
		$content='';
		if($this->input->post("type")==1)
			$content=$this->general_model->filtertext(trim($_POST["content"]));

		if($this->input->post("type")==2)
			$content=$_POST["message"];

		if(!$id)
		{
			
			$q=$this->db->insert($this->tableName,
                                array(
                                	'subject' =>$this->general_model->filtertext(trim($_POST["subject"])),
									'content' =>$content,
									'created_on' => date("Y:m:d H:i:s"),
									'type'=>$this->input->post("type"),
									'created_by'=>$this->currentUser->id
								)
								);
			$idd=$this->db->insert_id();
			$nid="ESNL-".date("Ymd")."-".$idd;
			$this->db->where('id', $idd);
			$q=$this->db->update($this->tableName,
                                array("unique_id"=>$nid));
		}
		else
		{
			$this->db->where('id', $id);
			$q=$this->db->update($this->tableName,
                                array(
                                	'subject' =>$this->general_model->filtertext(trim($_POST["subject"])),
									'content' =>$content,
									'type'=>$this->input->post("type"),
									'modified_on' => date("Y:m:d H:i:s"),
									'modified_by'=>$this->currentUser->id
								)
							);
			
			$idd=$id;
		}

		$this->load->helper("simple_html_dom");
		$dom=new simple_html_dom();
		$tempContent=trim($_POST['content']);
		$contentDom=$dom->load($tempContent);
		$images=$contentDom->find('img');
		if(count($images))
		{
			if($id)
			{
				$existingImages=$this->newsletter_images_model->getImagesByNewsletterId($id);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$eArray[$eimage->filename]=$eimage->id;
				}
				$editorImages=[];
				foreach ($images as $img_dom) 
				{
					$pathText=$img_dom->attr['src'];
					if(preg_match('/amazon/i',$pathText))
					{
						$editorImages[basename($pathText)]=basename($pathText);
					}
				}
				$diff=array_diff_key($eArray,$editorImages);

				if(count($diff))
				{
					foreach($diff as $ikey)
					$this->newsletter_images_model->deleteImage($id,$ikey);
				}

			}

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="content/newsletter/";
			foreach ($images as $img_dom) 
			{
				$pathText=$img_dom->attr['src'];
				if(preg_match('/amazon/i',$pathText))
					continue;

				$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
				if(file_exists($path))
				{
					$fname=basename($path);
					$newFileName=$idd."_".$fname;
					$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
					$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
					unlink($path);

					$imageData=array('filename' => $newFileName,
									'newsletter_id' =>$idd,
									'created_on' =>date("Y:m:d H:i:s")
									);
					$this->newsletter_images_model->insert($imageData);
				}
			}
			$this->db->where("id",$idd);
			$this->db->update($this->tableName,array("content"=>$tempContent));
		}
		else
		{
			if($id)
			{
				$existingImages=$this->newsletter_images_model->getImagesByNewsletterId($id);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$this->newsletter_images_model->deleteImage($id,$eimage->id);
				}
			}
		}

		if($q) return $idd;
		else return 0;
	}
	public function sendNewsletter($id)
	{
		$newsletterData=$this->newsletterData($id);
		$searchData["email_verified"]=1;

		$userIdsArray=array();
		
		//====================================================================
		$this->db->select("*");
		$this->db->where("email_verified",1);
		$subscribers=$this->db->get("subscriptions_email");

		$cnt=0;
		if($subscribers->num_rows())
		{
			$this->session->set_flashdata("newsletter_subject", $newsletterData->subject);
			
			$sent=0;
			
			$fail=0;
			foreach($subscribers->result() as $recipient)
			{
				/*if($recipient->email!='dattapeetham@dattapeetham.org')
					continue;*/
				
				$subject= $newsletterData->subject;
				$content= $newsletterData->content;

				$nData=array('mail_to' => $recipient->email,
										'mail_subject' => "[Newsletter] - ".$subject,
										'mail_content' =>$content,
										'date' => date("Y:m:d H:i:s"),
										'newsletter_id' => $newsletterData->id,
										'user_id' => $recipient->id,
										'type'=>3
									);
				$this->db->insert('newsletters_que',$nData);
				$sent_id=$this->db->insert_id();
				$cnt++;
				
			}
			$this->session->set_flashdata("newsletter_recipients", $cnt);
		}
		else
			$this->session->set_flashdata("newsletter_recipients_no",1);

		$this->db->where("id",$id);
			$this->db->update($this->tableName,
									array(
										'sent_on' =>date("Y:m:d H:i:s"),
										'status'=>2,
										'total_recipients'=>$cnt
									)
								);
		return 20;
	}
	public function delete($id,$newsletterData)
	{
		$existingImages=$this->newsletter_images_model->getImagesByNewsletterId($id);
		$eArray=[];
		foreach ($existingImages as $eimage)
		{
			$this->newsletter_images_model->deleteImage($id,$eimage->id);
		}
		$this->db->where("id",$id);
		$query = $this->db->delete($this->tableName);
		if($query) return 1;
		else return 0;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Newsletter ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subject");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"To (Email IDs)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Created");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Sent");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->unique_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->subject);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,abs($reportrow->total_recipients));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));
			if($reportrow->sent_on!='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->sent_on)));
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			
			$status="Created";
			if($reportrow->status==2)
				$status="Sent";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>