<?PHP
class Techsupport_Model extends CI_Model 
{
	var $tableName="techsupport";
	var $siteServicesDb='';
    function __construct()
    {
        parent::__construct();
        $this->siteServicesDb=$this->load->database("site_services",true,false);
    }
    public function getCount()
	{
		$this->siteServicesDb->select('count(id) as c');
		$this->siteServicesDb->where_in('fstatus',array(1));
		$q=$this->siteServicesDb->get($this->tableName)->row();
		return $q->c;

	}
    public function post($vars,$app=0)
	{
		$referer='';
		if(isset($_SERVER['HTTP_REFERER']))
			$referer=$_SERVER['HTTP_REFERER'];
		$name='';
		$email='';
		$uuid=0;
		$admin=0;

		if($app==1)
		{
			if($this->access_token_present==0)
			{
				$name=$this->general_model->filtertext($vars['support_name']);
				$email=$this->general_model->filtertext($vars['support_email']);
			}
			else
			{
				$name=$this->currentUser->firstname." ".$this->currentUser->lastname;
				$email=$this->currentUser->email;
				$uuid=$this->currentUser->id;
			}
		}
		else
		{
			if($this->session->userdata("loggedIn"))
			{
				if(isset($vars['support_user_name']) && $vars['support_user_name']!='')
				{
					$uuid=$this->general_model->filtertext($vars['support_user_id']);
					$username=$this->general_model->filtertext($vars['support_user_name']);
					$name=$this->general_model->filtertext($vars['support_name']);
					$email=$this->general_model->filtertext($vars['support_email']);
					$admin=1;
				}
				else if($this->session->userdata("id"))
				{
					$name=$this->session->userdata("admin_data")->firstname." ".$this->session->userdata("admin_data")->lastname;
					$email=$this->session->userdata("admin_data")->email;
					$uuid=$this->session->userdata("id");
					$username=$this->session->userdata("admin_data")->username;
					$admin=1;
				}
				else
				{
					$name=$this->session->userdata("user_data")->firstname." ".$this->session->userdata("user_data")->lastname;
					$email=$this->session->userdata("user_data")->email;
					$uuid=$this->session->userdata("user_id");
					$username=$this->session->userdata("user_data")->username;
				}
			}
			else
			{
				$username='guest';
				$name=$this->general_model->filtertext($vars['support_name']);
				$email=$this->general_model->filtertext($vars['support_email']);
			}
		}
		$isd_code = "";
		if(!empty($vars['country_code']))
		{
			$countryData=$this->locations_model->getCountryByCode($vars['country_code']);
			$isd_code = $countryData->isd_code;
		}
		$app=0;
		if(isset($GLOBALS['app']) && $GLOBALS['app']==1)
		{
			$app=1;
		}
		$supportKey = substr(substr(md5(mt_rand()), 0, 16), 0, 16);
		$TsCreatedDate = date("Y:m:d H:i:s");
		$this->siteServicesDb->insert($this->tableName,
                                array('name' => $name,
										'email' => $email,
										'content' => $this->general_model->filtertext(trim($vars["support_msg"])),
										'phone' => $vars["support_phone"],
										'purpose'=>$vars['purpose'],
										'country_code'=>$vars['country_code'],
										'ip_address' => $_SERVER['REMOTE_ADDR'],
										'user_agent' => $_SERVER['HTTP_USER_AGENT'],
										'isd_code'=>$isd_code,
										'url' => $referer,
										'user_id' => $uuid,
										'username'=>$username,
										'date' =>$TsCreatedDate,
										'modified_on' =>$TsCreatedDate,
										'app'=>$app,
										'admin'=>$admin,
										'support_key' => $supportKey
									)
								);
		 
		$ffid=$this->siteServicesDb->insert_id();
		
		$fid="TS-".date("ymd")."-".$ffid;

		$file1name = ''; 
		$file2name = ''; 
		$file3name = ''; 
		//file
		if(isset($_FILES['file1']) || isset($_FILES['file2']) || isset($_FILES['file3']))
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
			if(isset($_FILES['file1']))
			{
				$fname=$_FILES['file1']['name'];
				$ext=pathinfo ($_FILES['file1']['name'],PATHINFO_EXTENSION);
				$ext = strtolower($ext);
				$newname='support_'.$ffid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
				$tempPath=$_FILES['file1']['tmp_name'];
				$tempName=basename($_FILES['file1']['tmp_name']);
				$amazonUri="support/".date("Y")."/";
				$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
				$this->siteServicesDb->where("id",$ffid);
				$this->siteServicesDb->update($this->tableName, array( "file"=>$newname ));
				$file1name = $newname;
			}
			if(isset($_FILES['file2']))
			{
				$fname=$_FILES['file2']['name'];
				$ext=pathinfo ($_FILES['file2']['name'],PATHINFO_EXTENSION);
				$ext = strtolower($ext);
				$newname='support_'.$ffid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
				$tempPath=$_FILES['file2']['tmp_name'];
				$tempName=basename($_FILES['file2']['tmp_name']);
				$amazonUri="support/".date("Y")."/";
				$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
				$this->siteServicesDb->where("id",$ffid);
				$this->siteServicesDb->update($this->tableName, array( "file2"=>$newname ));
				$file2name = $newname;
			}
			if(isset($_FILES['file3']))
			{
				$fname=$_FILES['file3']['name'];
				$ext=pathinfo ($_FILES['file3']['name'],PATHINFO_EXTENSION);
				$ext = strtolower($ext);
				$newname='support_'.$ffid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
				$tempPath=$_FILES['file3']['tmp_name'];
				$tempName=basename($_FILES['file3']['tmp_name']);
				$amazonUri="support/".date("Y")."/";
				$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
				$this->siteServicesDb->where("id",$ffid);
				$this->siteServicesDb->update($this->tableName, array( "file3"=>$newname ));
				$file3name = $newname;
			}
		}
		//file

		$this->siteServicesDb->where("id",$ffid);
		$this->siteServicesDb->update($this->tableName,array("techsupport_id"=>$fid));

		$this->load->model("email_extension_model");
		$settings=$this->email_extension_model->getSettingsByService('techsupport');
		$phone = $vars["support_phone"];
		if(!empty($isd_code))
		{
			$phone = "+".$isd_code." ".$vars["support_phone"];

			$phone = htmlentities("+". $isd_code." ".$vars["support_phone"]);
    		$phonehref = htmlentities("+". $isd_code."".$vars["support_phone"]);
    		
    		$phone = '<a href="tel:'.$phonehref.'">'.$phone.'</a>';
		}
		$tempdata['name']=$name;
		$tempdata['email']=$email;
		$tempdata['phone']=$phone;
		$tempdata['purpose']=$vars['purpose'];
		$tempdata['created_date']=$TsCreatedDate;
		$tempdata['content']=$vars['support_msg'];
		$tempdata['app']=$app;
		$tempdata['id']=$ffid;
		$tempdata['techsupport_id']=$fid;
		$tempdata['file1name']=$file1name;
		$tempdata['file2name']=$file2name;
		$tempdata['file3name']=$file3name;
		$tempdata['username']=$username;
		$tempdata['support_key']=$supportKey;
		$tempdata['is_admin_created']=$admin;
        $content=$this->load->view("common/public/_techsupport_email",$tempdata,true);


        $adminemailsarr = techsupport_cc_emails;
        if(techsupport_admin_email && techsupport_admin_email!='')
        {
        	array_push($adminemailsarr,techsupport_admin_email);
        }
        foreach($adminemailsarr as $this_aminemail)
        {
			$this->email_extension->sendMailGuest('techsupport',"Admin",$this_aminemail, site_name_string1." - New TechSupport request: ".$fid,$content,"",1);
		}
		$subject=site_name_string1." - Your TechSupport request: ".$fid;
		$data['techsupportData']=$tempdata;
		ob_start();
		$this->load->view("techsupport/admin/_email_posted",$data);
		$content=ob_get_clean();
		if($username == 'guest')
		{
			$this->email_extension->sendMailGuest('techsupport',$name,$email, $subject,$content,"",1);
		}
		else
		{	
			$this->email_extension->sendMail('techsupport',$uuid,$subject,$content);
		}
	}

	public function uploadthreadattachments($ffid)
	{
		$uploaded = 0;
		if(isset($_FILES['file1']) || isset($_FILES['file2']) || isset($_FILES['file3']))
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
			if(isset($_FILES['file1']) && $_FILES['file1']['name']!='')
			{
				$fname=$_FILES['file1']['name'];
				$ext=pathinfo ($_FILES['file1']['name'],PATHINFO_EXTENSION);
				$ext = strtolower($ext);
				$newname='support_'.$ffid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
				$tempPath=$_FILES['file1']['tmp_name'];
				$tempName=basename($_FILES['file1']['tmp_name']);
				$amazonUri="support/".date("Y")."/";
				$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
				$this->siteServicesDb->where("id",$ffid);
				$this->siteServicesDb->update($this->tableName, array( "file"=>$newname ));
				$uploaded = 1;
			}
			if(isset($_FILES['file2']) && $_FILES['file2']['name']!='')
			{
				$fname=$_FILES['file2']['name'];
				$ext=pathinfo ($_FILES['file2']['name'],PATHINFO_EXTENSION);
				$ext = strtolower($ext);
				$newname='support_'.$ffid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
				$tempPath=$_FILES['file2']['tmp_name'];
				$tempName=basename($_FILES['file2']['tmp_name']);
				$amazonUri="support/".date("Y")."/";
				$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
				$this->siteServicesDb->where("id",$ffid);
				$this->siteServicesDb->update($this->tableName, array( "file2"=>$newname ));
				$uploaded = 1;
			}
			if(isset($_FILES['file3']) && $_FILES['file3']['name']!='')
			{
				$fname=$_FILES['file3']['name'];
				$ext=pathinfo ($_FILES['file3']['name'],PATHINFO_EXTENSION);
				$ext = strtolower($ext);
				$newname='support_'.$ffid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
				$tempPath=$_FILES['file3']['tmp_name'];
				$tempName=basename($_FILES['file3']['tmp_name']);
				$amazonUri="support/".date("Y")."/";
				$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
				$this->siteServicesDb->where("id",$ffid);
				$this->siteServicesDb->update($this->tableName, array( "file3"=>$newname ));
				$uploaded = 1;
			}
		}
		return $uploaded;
	}

	public function sendTo($id,$to,$techsupportData)
	{
		$settings=$this->email_extension_model->getSettingsByService('techsupport');
		$subject = "Fwd:".site_name_string1 ."  - TechSupport Request - ".$techsupportData->techsupport_id;
		$this->load->library("email_extension");
        $data['techsupportData']=$techsupportData;
        $data['repliesData']=$this->techsupport_admin_user_replies_model->getReplies($techsupportData->id);
        $content = $this->load->view("techsupport/admin/_email_send_to",$data, true);
        $this->email_extension->sendMailGuest('techsupport',$settings->from_name,$to, $subject,$content,"",1);
	}

	public function listUsersAjax($excel=0)
	{
		$i=0;
		$query1=$this->siteServicesDb;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*,group_concat(fstatus) as c,max(modified_on) as mdate");
		}
		$query1->from($this->tableName);

		$preData='';
		$search_keywords='';
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$search_keywords=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
				$search_keywords.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),"after");
				$search_keywords.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),'before');
				$search_keywords.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
				$search_keywords.=" containing ";
			} */
			$search_keywords.='"'.$_POST['search_text'].'"';
		}
		else
		{
			unset($_POST['search_text']);
			unset($_POST['search_col']);
			unset($_POST['wild']);
		}

		$preData.="Search Keywords: ".$search_keywords;
		
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.="\nFrom Date: ".$_POST['from_date'];
		}
		else
		{
			unset($_POST['from_date']);
			$preData.="\nFrom Date:";
		}
		
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.="\nTo Date: ".$_POST['to_date'];
		}
		else
		{
			unset($_POST['to_date']);
			$preData.="\nTo Date:";
		}
		$query1->group_by("user_id");

		

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();
			$requestResp=$this->excel_exports_model->makeRequest('techsupport',"model","techsupport/techsupport_model",$sql,$this->currentUser,"site_services",$_POST,"Tech Support Admin",$preData);

			return $requestResp;
		}
		if($i==1)
		{
			$temp_result = $query1->get()->num_rows();
			$rtn['recordsTotal'] = $temp_result;
			$rtn['recordsFiltered'] = $temp_result;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('mdate',$dir);
		}
		else
		{
			$query1->order_by('mdate',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['mdate']=date("d M Y h:i A",strtotime($row['mdate']));
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['pending']=0;
			$rtn['data'][$c]['opened']=0;
			$rtn['data'][$c]['closed']=0;
			$rtn['data'][$c]['all']=0;
			$tempC=explode(",",$row['c']);
			foreach ($tempC as $tempvalue) 
			{
				if($tempvalue==0)
				{
					$rtn['data'][$c]['pending']++;
				}
				else if($tempvalue==1)
				{
					$rtn['data'][$c]['opened']++;
				}
				else if($tempvalue==2)
				{
					$rtn['data'][$c]['closed']++;
				}
				$rtn['data'][$c]['all']++;
			}
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		end:
		return $rtn;
	}

	public function listMessagesAjax($userId,$excel=0)
	{
		$userData=$this->techsupport_model->getTechsupportByUserId($userId);

		$i=0;
		$query1=$this->siteServicesDb;
		if($excel==0)
		{
			$query1->select("id,techsupport_id,name,email,phone,purpose,content,ip_address,date,fstatus,count,read,read_user,admin");
		}
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		if($this->currentUser->admin==0)
		{
			$query1->where("user_id",$userId);
		}
		$query1->from($this->tableName);
				
		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nStatus: ";
		if(isset($_POST['fstatus']) && in_array($_POST["fstatus"],array(1,2,3,4)))
		{
			if($_POST['fstatus']==1)
			{
				$query1->where("fstatus",1);
				$preData.="Opened Msgs.";
			}
			else if($_POST['fstatus']==2)
			{
				$query1->where("fstatus",2);
				$preData.="Waiting Admin";
			}
			else if($_POST['fstatus']==3)
			{
				$query1->where("fstatus",3);
				$preData.="Waiting User";
			}
			else if($_POST['fstatus']==4)
			{
				$query1->where("fstatus",4);
				$preData.="Closed Msgs.";
			}
		}
		else
		{
			$preData.="All (Except Closed)";
			$query1->where("fstatus !=",4);
		}


		$preData.="\nUsers: ";
		if(isset($_POST['guests']) && in_array($_POST["guests"],array(1,2,3,4)))
		{
			if($_POST['guests']==2)
			{
				$query1->where("user_id !=",0);
				$query1->where("admin ",1);
				$preData.="Created by Admin";
			}
			else if($_POST['guests']==3)
			{
				$query1->where("user_id !=",0);
				$query1->where("admin ",0);
				$preData.="Created by User";
			}
			else if($_POST['guests']==4)
			{
				$query1->where("user_id",0);
				$preData.="Created by Guest";
			}
			else
			{
				$preData.="All Users";
			}
		}

		$preData.="\nPurpose: ";
		if(isset($_POST['purpose']) && in_array($_POST["purpose"],array_keys($this->purposeArray)))
		{
			$query1->where("purpose",$_POST['purpose']);
			$preData.=$this->purposeArray[$_POST['purpose']];
		}
		else
		{
			$preData.="All Purposes";
		}

		$preData.="\nSource: ";
		if(isset($_POST['app']) && is_numeric($_POST['app']) && in_array($_POST['app'],array(0,1)))
		{
			$query1->where("app",$_POST['app']);
			if($_POST['app']==1)
				$preData.="App";
			else
				$preData.="Website";
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('modified_on',$_POST['dir']);
				else
					$query1->order_by('modified_on',"desc");
			}
			
			$pageNumber=1;
			if($this->currentUser->admin==0)
			{
				$pagename='My Tech Support Messages';
			}
			else
			{
				$pagename='Tech Support Messages';
				$pageNumber=2;
			}
			$sql=$query1->get_compiled_select();
			
			$requestResp=$this->excel_exports_model->makeRequest('techsupport',"model","techsupport/techsupport_model",$sql,$this->currentUser,"site_services",$_POST,$pagename,$preData,$pageNumber);

			return $requestResp;
		}

		if($i==1)
		{
			$tq=$query1->get();
			$temp_result = $tq->num_rows();
			$rtn['recordsTotal'] = $temp_result;
			$rtn['recordsFiltered'] = $temp_result;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('modified_on',$dir);
		}
		else
		{
			$query1->order_by('modified_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['date']=date("d M Y h:i A",strtotime($row['date']));
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['content']=$row['content'];
			$rtn['data'][$c]['purpose']=$this->purposeArray[$row['purpose']];
			$rtn['data'][$c]['modified_on']=date("d M Y h:i A",strtotime($row['modified_on']));
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function listMessagesAjaxUser($userId,$excel=0)
	{
		$userData=$this->techsupport_model->getTechsupportByUserId($userId);

		$i=0;
		$query1=$this->siteServicesDb;
		if($excel==0)
		{
			$query1->select("*");
		}
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("id,techsupport_id,name,email,phone,purpose,content,ip_address,date,fstatus,count,read,read_user,admin");
		}
		$query1->where("user_id",$userId);
		$query1->from($this->tableName);
				
		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns'])
		 && in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			}
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nStatus: ";
		if(isset($_POST['fstatus']) && in_array($_POST["fstatus"],array(1,2,3,4)))
		{
			if($_POST['fstatus']==1)
			{
				$query1->where("fstatus",1);
				$preData.="Opened Msgs.";
			}
			else if($_POST['fstatus']==2)
			{
				$query1->where("fstatus",2);
				$preData.="Waiting Admin";
			}
			else if($_POST['fstatus']==3)
			{
				$query1->where("fstatus",3);
				$preData.="Waiting User";
			}
			else if($_POST['fstatus']==4)
			{
				$query1->where("fstatus",4);
				$preData.="Closed Msgs.";
			}
		}
		else
		{
			$preData.="All (Except Closed)";
			$query1->where("fstatus !=",4);
		}


		$preData.="\nUsers: ";
		if(isset($_POST['guests']) && in_array($_POST["guests"],array(1,2)))
		{
			if($_POST['guests']==2)
			{
				$query1->where("user_id",0);
				$preData.="All Guests";
			}
			else
			{
				$preData.="All Guests";
			}
		}

		$preData.="\nPurpose: ";
		if(isset($_POST['purpose']) && in_array($_POST["purpose"],array_keys($this->purposeArray)))
		{
			$query1->where("purpose",$_POST['purpose']);
			$preData.=$this->purposeArray[$_POST['purpose']];
		}
		else
		{
			$preData.="All Purposes";
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('modified_on',$_POST['dir']);
				else
					$query1->order_by('modified_on',"desc");
			}
			
			$pageNumber=1;
			if($this->currentUser->admin==0)
			{
				$pagename='My Tech Support Messages';
			}
			else
			{
				$pagename='Tech Support Messages by "'.$userData->username.'"';
				$pageNumber=2;
			}
			$sql=$query1->get_compiled_select();
			
			$requestResp=$this->excel_exports_model->makeRequest('techsupport',"model","techsupport/techsupport_model",$sql,$this->currentUser,"site_services",$_POST,$pagename,$preData,$pageNumber);

			return $requestResp;
		}

		if($i==1)
		{
			$tq=$query1->get();
			$temp_result = $tq->num_rows();
			$rtn['recordsTotal'] = $temp_result;
			$rtn['recordsFiltered'] = $temp_result;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('modified_on',$dir);
		}
		else
		{
			$query1->order_by('modified_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['date']=date("d M Y",strtotime($row['date']));
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['purpose']=$this->purposeArray[$row['purpose']];
			$sno++;
			$c++;
		}
		return $rtn;
	}
	public function messageRead($id,$read=1)
	{
		$updateData['read']=$read;
		if($read==0)
		{
			$updateData['modified_on']=date("Y:m:d H:i:s");
			$updateData['read_user']=1;
		}
		$this->siteServicesDb->where("id",$id);
		$this->siteServicesDb->update($this->tableName,$updateData);
	}
	public function messageReadUser($id,$read=1)
	{
		$updateData['read_user']=$read;
		if($read==0)
		{
			$updateData['modified_on']=date("Y:m:d H:i:s");
			$updateData['read']=1;
		}
		$this->siteServicesDb->where("id",$id);
		$this->siteServicesDb->update($this->tableName,$updateData);
	}
	public function updateCount($id,$count)
	{
		$updateData['count']=$count;
		$this->siteServicesDb->where("id",$id);
		$this->siteServicesDb->update($this->tableName,$updateData);
	}
	public function checkIn($id)
	{
		$updateData['checked_in_time']=date("Y:m:d H:i:s");
		$updateData['checked_in_username']=$this->currentUser->email;
		$updateData['checked_in_user_id']=$this->currentUser->id;
		$updateData['checked_in']=1;
		$this->siteServicesDb->where("id",$id);
		$this->siteServicesDb->where("checked_in",0);
		$this->siteServicesDb->where_in("fstatus",array(1,2,3));
		$this->siteServicesDb->update($this->tableName,$updateData);
	}

	public function checkOut($id)
	{
		$updateData['checked_in_time']='';
		$updateData['checked_in_username']='';
		$updateData['checked_in_user_id']=0;
		$updateData['checked_in']=0;
		$this->siteServicesDb->where("id",$id);
		$this->siteServicesDb->where("checked_in_user_id",$this->currentUser->id);
		$this->siteServicesDb->where("checked_in",1);
		$this->siteServicesDb->where_in("fstatus",array(1,2,3));
		$this->siteServicesDb->update($this->tableName,$updateData);
	}

	public function checkOutAll()
	{
		$updateData['checked_in_time']='';
		$updateData['checked_in_username']='';
		$updateData['checked_in_user_id']=0;
		$updateData['checked_in']=0;
		$this->siteServicesDb->where("checked_in",1);
		$this->siteServicesDb->update($this->tableName,$updateData);
	}

	public function techsupportData($id)
	{
		$this->siteServicesDb->where("id",$id);
		$tech=$this->siteServicesDb->get($this->tableName);
		return $tech->row();
	}
	public function getTechsupportByUserId($userId)
	{
		$this->siteServicesDb->where("user_id",$userId);
		$this->siteServicesDb->limit(1);
		$tech=$this->siteServicesDb->get($this->tableName);
		return $tech->row();
	}
	private function delete($techsupportData)
	{
		$this->techsupport_admin_user_replies_model->delete($techsupportData->id);
		$this->siteServicesDb->where("id",$techsupportData->id);
		$this->siteServicesDb->delete($this->tableName);
	}
	public function changeStatus($fid,$techsupportData,$newStatus)
	{
		$this->siteServicesDb->where("id",$fid);
		$this->siteServicesDb->update($this->tableName,
							array(
									'fstatus'=>$newStatus
								)
						);
		$this->sendStatusChangeMail($techsupportData,$newStatus,$techsupportData->fstatus);
		return 1;
	}
	private function sendStatusChangeMail($techsupportData,$newStatus,$oldStatus=0)
	{
		$this->load->library("email_extension");
		if($newStatus==4)
		{
			$subject="Your TechSupport request: ".$techsupportData->techsupport_id." is now closed";
			$data['techsupportData']=$techsupportData;
			ob_start();
			$this->load->view("techsupport/admin/_email_closed",$data);
			$content=ob_get_clean();
			if(@$techsupportData->username == 'guest')
			{
				$this->email_extension->sendMailGuest('techsupport',$techsupportData->name,$techsupportData->email, $subject,$content,"",1);
			}
			else
			{
				$this->email_extension->sendMail($this->service,$techsupportData->user_id,$subject,$content);
			}
		}
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==1)
		{
			$objResp=$this->excelReportUsers($excelData,$objPHPExcel);
		}
		if($excelData->page_number==2)
		{
			$objResp=$this->excelReportUserMessages($excelData,$objPHPExcel);
		}
		return $objResp;
	}
	private function excelReportUsers($excelData,$objPHPExcel)
	{

		$q=$this->siteServicesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());


		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"UserID");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Pending Msgs.");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Open Msgs.");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Closed Msgs.");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"All Msgs.");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			if($reportrow->username!='')
				$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->username);
			else
				$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,"Guest");
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->name);
			$pending=0;
			$opened=0;
			$closed=0;
			$all=0;
			$tempC=explode(",",$reportrow->c);
			foreach ($tempC as $tempvalue) 
			{
				if($tempvalue==0)
				{
					$pending++;
				}
				else if($tempvalue==1)
				{
					$opened++;
				}
				else if($tempvalue==2)
				{
					$closed++;
				}
				$all++;
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$pending);
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$opened);
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$closed);
			$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,$all);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
	private function excelReportUserMessages($excelData,$objPHPExcel)
	{
		$purposeArray=array(
								1=>"Office/Billing",
								2=>"Contact",
								3=>"Abuse",
								4=>"Complaint",
								5=>"Question",
								6=>"Technical Support",
								7=>"Other"
								);
		$statusArray=array(1=>"Open",
							2=>"Waiting Admin",
							3=>"Waiting User",
							4=>"Closed");
		$q=$this->siteServicesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());


		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Tech Support ID");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Purpose");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Tech Support Message");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"Date");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$j,"Last Update");
		$objPHPExcel->getActiveSheet()->getStyle('H'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('I'.$j,"CheckedIn");
		$objPHPExcel->getActiveSheet()->getStyle('I'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('J'.$j,"Req. Status");
		$objPHPExcel->getActiveSheet()->getStyle('J'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->techsupport_id);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$purposeArray[$reportrow->purpose]);
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,htmlspecialchars_decode($reportrow->content));
			$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i,date("d M Y h:i A",strtotime($reportrow->modified_on)));
			$objPHPExcel->getActiveSheet()->SetCellValue('I'.$i,$reportrow->checked_in_username);
			$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i,$statusArray[$reportrow->fstatus]);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
	public function excelReportUser($excelData,$objPHPExcel)
	{
		$purposeArray=array(
							1=>"Office/Billing",
							2=>"Contact",
							3=>"Abuse",
							4=>"Complaint",
							5=>"Question",
							6=>"Technical Support",
							7=>"Other"
							);
		$statusArray=array(1=>"Open",
							2=>"Waiting Admin",
							3=>"Waiting User",
							4=>"Closed");
		$q=$this->siteServicesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Tech Support ID");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Purpose");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Tech Support Message");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Date");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Req. Status");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->techsupport_id);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$purposeArray[$reportrow->purpose]);
			
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,htmlspecialchars_decode($reportrow->content));
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$statusArray[$reportrow->fstatus]);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>