<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Subscription_groups_model extends CI_Model 
{
    var $siteServicesDb = "";
    function __construct()
    {
        parent::__construct();
        $this->siteServicesDb = $this->load->database("site_services",true,false);
    }
    /**
     * @name string TABLE_NAME Holds the name of the table in use by this model
     */
    const TABLE_NAME = 'subscription_groups';

    /**
     * @name string PRI_INDEX Holds the name of the tables' primary index used in this model
     */
    const PRI_INDEX = 'id';

    /**
     * Retrieves record(s) from the database
     *
     * @param mixed $group_ids Optional. Retrieves only the records matching given criteria, or all records if not given.
     *                      If associative array is given, it should fit field_name=>value pattern.
     *                      If string, value will be used to match against PRI_INDEX
     * @return mixed Single record if ID is given, or array of results
     */
    public function getGroupNames($group_ids = null)
    {
        if($group_ids)
        {
            $group_ids = explode(",", $group_ids);
            $q = $this->siteServicesDb->select('group_name')->from(self::TABLE_NAME)->where_in('id',$group_ids)->get();
            if($q->num_rows() > 0)
            {
                $result = $q->result_array();
                foreach ($result as $key => $value) 
                {
                    $results[] = $value['group_name'];
                }
                $group_names = implode(",",$results);
                return $group_names;
            }
        }
        else
        {
            return false;
        }
    }

    public function getGroupNamesbyIds($group_ids = null)
    {
        if($group_ids)
        {
            $q = $this->siteServicesDb->select('id,group_name')->from(self::TABLE_NAME)->where_in('id',$group_ids)->get();
            if($q->num_rows() > 0)
            {
                $result = $q->result();
                return $result;
            }
        }
        else
        {
            return false;
        }
    }

    public function getAllGroups()
    {
        $q = $this->siteServicesDb->select('group_name,status,id')->from(self::TABLE_NAME)->get();
        if($q->num_rows() > 0)
        {
            $result = $q->result();
            return $result;
        }
        else
        {
            return array();
        }
    }

    /**
     * Inserts new data into database
     *
     * @param Array $data Associative array with field_name=>value pattern to be inserted into database
     * @return mixed Inserted row ID, or false if error occured
     */
    public function insert(Array $data) {
        if ($this->siteServicesDb->insert(self::TABLE_NAME, $data)) {
            return $this->siteServicesDb->insert_id();
        } else {
            return false;
        }
    }

    public function insertupdategroup($data=null)
    {
        if($data)
        {
            foreach ($data as $key => $value) 
            {
                $existedGroup = $this->checkgroup($value);
                if($existedGroup)
                    $exist[] = $existedGroup;
                if(!$existedGroup)
                {
                    $slug=strtolower(url_title($value));
                    $sare = $this->insert(array('group_name' => trim($value),'group_slug'=>$slug,'created_on'=>date('Y-m-d H:i:s')));
                    $exist[] = $sare;
                }
            }
            return $exist;
        }
    }

    public function checkgroup($name)
    {
        $q = $this->siteServicesDb->select("id")->from(self::TABLE_NAME)->where('group_name',$name)->get();
        if($q->num_rows() > 0)
        {
            return $q->result()[0]->id;
        }
        else
        {
            return false;
        }
    }

    public function getGroupById($id)
    {
        $q = $this->siteServicesDb->select("*")->from(self::TABLE_NAME)->where('id',$id)->get();
        if($q->num_rows() > 0)
        {
            return $q->result()[0];
        }
        else
        {
            return false;
        }
    }

    //------------------------------------------------
    function saveGroup($id)
    {
        $slug=strtolower(url_title($_POST['group_name']));
        if($id==0)
        {
            $query=$this->siteServicesDb->insert(self::TABLE_NAME,
                            array('group_name' =>trim($_POST["group_name"]),
                                  'group_slug'=>$slug,
                                  'created_by'=>$this->currentUser->id,
                                  'created_on'=>date("Y:m:d H:i:s"),
                            )
                            );
            $idd=$this->siteServicesDb->insert_id();
        }
        else
        {
            $this->siteServicesDb->where("id",$id);
            $query = $this->siteServicesDb->update(self::TABLE_NAME,
                                array(
                                'group_name'=>trim($_POST['group_name']),
                                'group_slug'=>$slug,
                                'modified_on'=>date("Y:m:d H:i:s"),
                                'created_by'=>$this->currentUser->id,
                                ));
            $idd=$id;
        }
        if($query)
            return $idd;
        else return 0;
    }

    //------------------------------------------------
    public function groupexistCheck($group_name,$groupID)
    {
        /*$slug=url_title($group_name);
        if(strlen($slug)<3)
            return 2;*/

        $this->siteServicesDb->where("id !=",$groupID);
        $this->siteServicesDb->where("group_name",$group_name);
        $ee=$this->siteServicesDb->get(self::TABLE_NAME);
        if($ee->num_rows())
        return 0;//exists
        else return 1;//does not exist
    }

    /**
     * [groupvalidation description]
     * @param  [type] $groupString [description]
     * @return [type]              [description]
     */
    public function groupvalidation($groupString)
    {
        if($groupString)
        {
            $groups = explode(",", $groupString);
            foreach ($groups as $key => $value) 
            {
                if(!$this->getGroupById($value))
                    return true;
            }
        }
    }

    public function subsmsDatabyGroupId($categoryId)
    {
        $this->siteServicesDb->where("FIND_IN_SET(".$categoryId.",group_id) >",0);
        $q=$this->siteServicesDb->get('subscriptions_sms');
        if($q->num_rows())
        {
            return true;
        }
        return false;
    }

    public function subemailDatabyGroupId($categoryId)
    {
        $this->siteServicesDb->where("FIND_IN_SET(".$categoryId.",group_id) >",0);
        $q=$this->siteServicesDb->get('subscriptions_email');
        if($q->num_rows())
        {
            return true;
        }
        return false;
    }

    public function delete($id)
    {
        $this->siteServicesDb->where("id",$id);
        $this->siteServicesDb->delete(self::TABLE_NAME);
        return true;
    }

    /**
     * Updates selected record in the database
     *
     * @param Array $data Associative array field_name=>value to be updated
     * @param Array $where Optional. Associative array field_name=>value, for where condition. If specified, $id is not used
     * @return int Number of affected rows by the update query
     */
    public function update(Array $data, $where = array()) {
            if (!is_array($where)) {
                $where = array(self::PRI_INDEX => $where);
            }
        $this->siteServicesDb->update(self::TABLE_NAME, $data, $where);
        return $this->siteServicesDb->affected_rows();
    }

    public function getList($excel=0)
    {
        $i=0;
        $query1=$this->siteServicesDb;
        if($excel==0)
            $query1->select("count(id) as c");
        step1:
        $i++;
        if($i==2 || $excel==1)
        {
            $query1->select("*");
        }
        $query1->from(self::TABLE_NAME);

        $preData="Search Keywords: ";

        
        if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
        {
            $query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
            $preData.=" containing ";
            /* if($_POST['wild']=='starts')
            {
                $query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),"after");
                $preData.=" starting with ";
            }
            else if($_POST['wild']=='ends')
            {
                $query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])),'before');
                $preData.=" ending with ";
            }
            else
            {
                $query1->like($_POST['search_col'],$this->siteServicesDb->escape_str(trim($_POST['search_text'])));
                $preData.=" containing ";
            } */
            $preData.='"'.$_POST['search_text'].'"';
        }

        if($excel==1)
        {
            if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
            {
                if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
                    $query1->order_by($_POST['order_by'],$_POST['dir']);
                else
                    $query1->order_by($_POST['order_by'],'desc');
            }
            else
            {
                if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
                    $query1->order_by('created_on',$_POST['dir']);
                else
                    $query1->order_by('created_on',"desc");
            }
            $sql=$query1->get_compiled_select();

            $requestResp=$this->excel_exports_model->makeRequest('default',"model","subscriptions/Subscription_groups_model",$sql,$this->currentUser,"site_services",$_POST,"Subscription Groups",$preData);
            return $requestResp;
        }

        if($i==1)
        {
            $temp_result = $query1->get()->row();
            $rtn['recordsTotal'] = $temp_result->c;
            $rtn['recordsFiltered'] = $temp_result->c;
            goto step1;
        }

        $dir='desc';

        if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
            $dir=$_POST['order'][0]['dir'];

        $order_by='';
        if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
        {
            $col_num=round(abs($_POST['order'][0]['column']));
            $col_name=$_POST['columns'][$col_num]['name'];
            if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
                $query1->order_by($col_name,$dir);
            else
                $query1->order_by('created_on',$dir);
        }
        else
        {
            $query1->order_by('created_on',$dir);
        }

        $start=0;
        $length=10;
        if(isset($_POST['start']) && is_numeric($_POST['start']))
        {
            if(round(abs($_POST['start']))%10==0)
            $start=round(abs($_POST['start']));
        }
        if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
        {
            $length=abs($_POST['length']);
            if(!$length)
                $length=10;
        }

        $query1->limit($length,$start);

        $rtn['data']=$query1->get()->result_array();
        $temp=array();
        $sno=$start+1;
        $c=0;
        foreach ($rtn['data'] as $row) 
        {
            $rtn['data'][$c]=$row;
            $rtn['data'][$c]['sno']=$sno;
            if($rtn['data'][$c]['created_on'])
                $rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['created_on']));
            else
                $rtn['data'][$c]['created_on']="N/A";
            $sno++;
            $c++;
        }
        $rtn['page_records']=$c;
        return $rtn;
    }

    public function excelReport($excelData,$objPHPExcel)
    {

        $q=$this->siteServicesDb->query($excelData->query);

        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

        $styleArray = array(
                            'font' => array(
                            'bold' => true
                            )
                        );

        $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

        $objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

        $j=3;
        $pre_data=explode("\n",$excelData->pre_data);
        foreach ($pre_data as $filter)
        {
            $objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
            $j++;
        }

        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

        $requestData=unserialize($excelData->request_data);

        $j=$j+2;

        $alpha="A";
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Group ID");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Group Name");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Group Slug");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $alpha++;
        $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date");
        $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

        $i=$j+1;
        $sno=1;
        foreach ($q->result() as $reportrow)
        {
            $alpha="A";
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->group_name);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->group_slug);
            $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));
            
            $i++;
            $sno++;
        }
        return $objPHPExcel;
    }
}
