<?PHP
class Donors_model extends CI_Model 
{
	var $tableName="donors";
	var $auth_check="";
	var $siteServicesDB = "";
	public function __construct()
	{
		parent::__construct();
		$this->auth_check=$this->load->database("sso_auth",true);
		$this->siteServicesDB = $this->load->database("site_services",true,false);
	}
	public function getCount()
	{
		return $this->auth_check->get($this->tableName)->num_rows();
	}
	public function donorData($id)
	{
		$this->auth_check->where("id",$id);
		$q=$this->auth_check->get($this->tableName);
		return $q->row();
	}

	public function donorsByIds($ids)
	{
		$this->auth_check->where_in("id",$ids);
		$q=$this->auth_check->get($this->tableName)->result();

		$result=array();
		foreach ($q as $row)
		{
			$result[$row->id]=$row;
		}
		return $result;
	}


	public function firstDonor($userId)
	{
		//step1:
		$this->auth_check->where("user_id",$userId);
		$this->auth_check->where("donor_relation","Self");
		//$this->auth_check->where("is_user",1);
		$q=$this->auth_check->get($this->tableName);
		$resultDonor = $q->row();
		if(empty($resultDonor))
		{
			$this->auth_check->where("user_id",$userId);
			$q=$this->auth_check->get($this->tableName);
			$resultDonor = $q->row();
			// $this->createDefault($userId);
			// goto step1;
		}
		return $resultDonor;
	}

	public function getDefault($userId)
	{
		$this->auth_check->where("user_id",$userId);
		$this->auth_check->where("is_user",1);
		return $this->auth_check->get($this->tableName)->row();
	}

	public function createDefault($userId)
	{
		$userData=$this->users_model->ssouserData($userId);
		if(!empty($userData))
		{
			$defaultDonor=$this->getDefault($userId);
			if(empty($defaultDonor))
			{
				$userData=(array)$userData;
				$dAddress=$userData['address'];
				if($userData['address1']!='')
					$dAddress.="\n".$userData['address1'];
				if($userData['address2']!='')
					$dAddress.="\n".$userData['address2'];
				if($userData['city']!='')
					$dAddress.="\n".$userData['city'];
				if($userData['state']!='')
					$dAddress.="\n".$userData['state'];

				$dob_day=1;
				$dob_month=1;
				if($userData['dob']!='')
				{
					$dob_day=date("d",strtotime($userData['dob']));
					$dob_month=date("m",strtotime($userData['dob']));
				}
				$phone='9999999999';
				if($userData['phoneno']!='')
				{
					$phone=$userData['phoneno'];
				}

				if(empty($userData['country_id']))
				{
					$countryData=$this->locations_model->getCountryByCode("IN");
				} else {
					$countryData=$this->locations_model->getCountryByCode($userData['country_id']);
				}
				$this->auth_check->insert($this->tableName,
		            array(
		            	'donor_relation' => 'Self',
		            	'donor_name' => ucwords(strtolower($userData['firstname']." ".$userData['lastname'])),
		            	'donor_email' => $userData['email'],
		            	'donor_address' => $userData['address'],
		            	'donor_address1' => !empty($userData['address1']) ? $userData['address1'] : '',
		            	'donor_address2' => !empty($userData['address2']) ? $userData['address2'] : '',
		            	'donor_city' => !empty($userData['city']) ? $userData['city'] : '',
		            	'donor_state' => !empty($userData['state']) ? $userData['state'] : '',
		            	'donor_address_country_id' => !empty($userData['country_id']) ? $userData['country_id'] : 'IN',
		            	'donor_address_country' => $countryData->country_name,
		            	'donor_zipcode' => !empty($userData['zipcode']) ? $userData['zipcode'] : '',
						'donor_country_id' => !empty($userData['country_id']) ? $userData['country_id'] : 'IN',
						'donor_country_isd' => $countryData->isd_code,
						'donor_country'=> $countryData->country_name,
						'donor_star' => !empty($userData['birthstar']) ? $userData['birthstar'] : '',
						'donor_phone' => $phone,
						'donor_raasi' => !empty($userData['raasi']) ? $userData['raasi'] : '',
						'donor_profession' => !empty($userData['profession']) ? $userData['profession'] : '',
						'donor_dob_day' => $dob_day,
						'donor_dob_month' => $dob_month,
						'is_user'=>1,
						'user_id'=>$userId,
						'created_on'=>date("Y:m:d H:i:s"),
						'modified_on'=>date("Y:m:d H:i:s")
					)
				);
			} else {
				$this->updateDefault($userId);
			}
		}
	}

	public function updateDefault($userId)
	{
		$userData=$this->users_model->ssouserData($userId);
		$defaultDonor=$this->getDefault($userId);
		if(!empty($userData))
		{
			if(empty($defaultDonor))
			{
				$this->createDefault($userId);
				return 1;
			}
			$userData=(array)$userData;
			$dAddress=$userData['address'];
			if($userData['address1']!='')
				$dAddress.="\n".$userData['address1'];
			if($userData['address2']!='')
				$dAddress.="\n".$userData['address2'];
			if($userData['city']!='')
				$dAddress.="\n".$userData['city'];
			if($userData['state']!='')
				$dAddress.="\n".$userData['state'];

			$dob_day=1;
			$dob_month=1;
			if($userData['dob']!='')
			{
				$dob_day=date("d",strtotime($userData['dob']));
				$dob_month=date("m",strtotime($userData['dob']));
			}
			$phone='9999999999';
			if($userData['phoneno']!='')
			{
				$phone=$userData['phoneno'];
			}

			$countryData=$this->locations_model->getCountryByCode($userData['country_id']);
			$this->auth_check->where("user_id",$userId);
			$this->auth_check->where("is_user",1);
			$this->auth_check->update($this->tableName,
	            array(
	            	'donor_name' => ucwords(strtolower($userData['firstname']." ".$userData['lastname'])),
	            	'donor_email' => $userData['email'],
	            	'donor_address' =>$dAddress,
					'donor_country_id' => $userData['country_id'],
					'donor_country_isd' => $countryData->isd_code,
					'donor_country'=>$countryData->country_name,
					'donor_star' => $userData['birthstar'],
					'donor_phone' => $phone,
					'donor_raasi' => $userData['raasi'],
					'donor_profession' => $userData['profession'],
					'donor_dob_day' => $dob_day,
					'donor_dob_month' => $dob_month,
					'donor_photo'=>$userData['profilepic'],
					'is_user'=>1,
					'user_id'=>$userId,
					'created_on'=>date("Y:m:d H:i:s"),
					'modified_on'=>date("Y:m:d H:i:s")
				)
			);
		}
	}

	public function updateJapamUser($donor_id,$donor_relation,$donor_name,$donor_city)
	{
		$this->siteServicesDB->where("donor_id",$donor_id);
		$this->siteServicesDB->update("japam_user",
            array(
            	'donor_relation' => $this->general_model->filtertext(trim($donor_relation)),
                'donor_name' => ucwords(strtolower($this->general_model->filtertext(trim($donor_name)))),
                'city'=>$donor_city
			)
		);
	}
	public function getCountByUser($userId)
	{
		$this->auth_check->select("count(id) as c");
		$this->auth_check->where("user_id",$userId);
		$q=$this->auth_check->get($this->tableName)->row();
		return $q->c;
	}


	public function getMyDonors($userData,$excel=0)
	{
		$i=0;
		$query1=$this->auth_check;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}

		$query1->from($this->tableName);

		$query1->where('user_id',$userData->sso_user_id);

		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			//$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],$this->auth_check->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->auth_check->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->auth_check->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->auth_check->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}
		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('donor_name',$_POST['dir']);
				else
					$query1->order_by('donor_name',"asc");
			}
			$requestResp=$this->excelexport_model->makeRequest($this->service,"model","donors_model",$query1,$this->currentUser,"default",$_POST,"All Donors",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('id',$dir);
		}
		else
		{
			$query1->order_by('id',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['donor_phone']="+".$row['donor_country_isd']." ".$row['donor_phone'];
			$rtn['data'][$c]['donor_dob']=date("d M",strtotime($row['donor_dob_day']."-".$row['donor_dob_month']."-2000"));
			if($row['donor_photo']!='')
				$rtn['data'][$c]['donor_photo']=sso_aws_s3_base_url."users_profiles/".$userData->username[0]."/".md5($userData->sso_user_id)."/thumb_".$row['donor_photo'];
			else
				$rtn['data'][$c]['donor_photo']=aws_s3_base_url."images/site_assets/global_site_images/no-image.png";
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function listAdmin($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		$i=0;
		$query1=$this->auth_check;
		if($excel==0)
			$query1->select("count(d.id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*,d.id as did");
		}

		$query1->from($this->tableName." as d");
		$query1->join("users as u","u.id=d.user_id","left");
		$query1->where("u.site_flag_".global_site_flag,1);
		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$query1->like($_POST['search_col'],$this->auth_check->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->auth_check->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->auth_check->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->auth_check->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}
		if($this->input->post("user_id")!='')
		{
			$query1->where("u.id",$this->input->post("user_id"));
		}

		$preData.="\nPhoto status: ";
		if(isset($_POST['photo_status']) && is_numeric($_POST['photo_status']) && in_array($_POST['photo_status'],array(0,1)))
		{
			if($_POST['photo_status']==1)
			{
				$query1->where("donor_photo !=",'');
				$preData.="With Photo";
			}
			else
			{
				$query1->where("donor_photo",null);
				$preData.="Without Photo";
			}
		}

		$preData.="\nCountry: ";

		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$preData.=$countryData->country_name;
				$query1->where("donor_country_id",$_POST['country']);
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('donor_name',$_POST['dir']);
				else
					$query1->order_by('donor_name',"asc");
			}
			$sql=$query1->get_compiled_select();
			$requestResp=$this->excel_exports_model->makeRequest('default',"model","donors_model",$sql,$this->currentUser,"sso_auth",$_POST,"All Donors",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('d.id',$dir);
		}
		else
		{
			$query1->order_by('d.id',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			if(isset($countries[$row['country_id']]))
			$rtn['data'][$c]['user_isd']=$countries[$row['country_id']]->isd_code;
			else
				$rtn['data'][$c]['user_isd']="";
			$rtn['data'][$c]['donor_phone']="+".$row['donor_country_isd']." ".$row['donor_phone'];
			$rtn['data'][$c]['donor_dob']=date("d M",strtotime($row['donor_dob_day']."-".$row['donor_dob_month']."-2000"));
			if($row['donor_photo']!='')
				$rtn['data'][$c]['donor_photo']=sso_aws_s3_base_url."users_profiles/".$row['username'][0]."/".md5($row['user_id'])."/thumb_".$row['donor_photo'];
			else
				$rtn['data'][$c]['donor_photo']=aws_s3_base_url."images/site_assets/global_site_images/no-image.png";
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function save($id,$donorData,$userData)
	{
		$userId=$userData->id;
		$countryData=$this->locations_model->getCountryByCode($_POST['donor_country_code']);
		if(!isset($_POST['donor_address_country_id']) && ($_POST['donor_address_country_id']==''))
		{
			$_POST['donor_address_country_id'] = "IN";
		}
		if(isset($_POST['donor_address_country_id']) && ($_POST['donor_address_country_id']!=''))
		{
			$addressCountryData=$this->locations_model->getCountryByCode($_POST['donor_country_code']);
		}
		if(!$id)
		{
			$q=$this->auth_check->insert($this->tableName,
                                array(
                                	'donor_relation' => $this->general_model->filtertext(trim($_POST["donor_relation"])),
                                	'donor_name' => ucwords(strtolower($this->general_model->filtertext(trim($_POST["donor_name"])))),
                                	'donor_email' => trim($_POST["donor_email"]),
									'donor_country_id' => $_POST["donor_country_code"],
									'donor_country_isd' => $countryData->isd_code,
									'donor_country'=>$countryData->country_name,
									'donor_star' => $this->general_model->filtertext(trim($_POST["donor_star"])),
									'donor_phone' => $this->general_model->filtertext(trim($_POST["donor_phone"])),
									'donor_raasi' => $this->general_model->filtertext(trim($_POST["donor_raasi"])),
									'donor_profession' => $this->general_model->filtertext(trim($_POST["donor_profession"])),
									'donor_dob_day' => $this->general_model->filtertext(trim($_POST["donor_dob_day"])),
									'donor_dob_month' => $this->general_model->filtertext(trim($_POST["donor_dob_month"])),
                                	'donor_address' => $this->general_model->filtertext(trim($_POST["donor_address"])),
                                	'donor_address1' => $this->general_model->filtertext(trim($_POST["donor_address1"])),
					            	'donor_address2' => $this->general_model->filtertext(trim($_POST["donor_address2"])),
					            	'donor_city' => $this->general_model->filtertext(trim($_POST["donor_city"])),
					            	'donor_state' => $this->general_model->filtertext(trim($_POST["donor_state"])),
					            	'donor_address_country_id' => $this->general_model->filtertext(trim($_POST["donor_address_country_id"])),
					            	'donor_address_country' => @$addressCountryData->country_name,
					            	'donor_zipcode' => $this->general_model->filtertext(trim($_POST["donor_zipcode"])),
									'user_id'=>$userData->sso_user_id,
									'created_on'=>date("Y:m:d H:i:s"),
									'modified_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$this->auth_check->insert_id();
		}
		else
		{
			$this->auth_check->where("id",$id);
			$q=$this->auth_check->update($this->tableName,
                                array(
                                	'donor_relation' => $this->general_model->filtertext(trim($_POST["donor_relation"])),
                                	'donor_name' => ucwords(strtolower($this->general_model->filtertext(trim($_POST["donor_name"])))),
                                	'donor_email' => trim($_POST["donor_email"]),
									'donor_country_id' => $_POST["donor_country_code"],
									'donor_country_isd' => $countryData->isd_code,
									'donor_country'=>$countryData->country_name,
									'donor_star' => $this->general_model->filtertext(trim($_POST["donor_star"])),
									'donor_phone' => $this->general_model->filtertext(trim($_POST["donor_phone"])),
									'donor_raasi' => $this->general_model->filtertext(trim($_POST["donor_raasi"])),
									'donor_profession' => $this->general_model->filtertext(trim($_POST["donor_profession"])),
									'donor_dob_day' => $this->general_model->filtertext(trim($_POST["donor_dob_day"])),
									'donor_dob_month' => $this->general_model->filtertext(trim($_POST["donor_dob_month"])),
									'donor_address' => $this->general_model->filtertext(trim($_POST["donor_address"])),
                                	'donor_address1' => $this->general_model->filtertext(trim($_POST["donor_address1"])),
					            	'donor_address2' => $this->general_model->filtertext(trim($_POST["donor_address2"])),
					            	'donor_city' => $this->general_model->filtertext(trim($_POST["donor_city"])),
					            	'donor_state' => $this->general_model->filtertext(trim($_POST["donor_state"])),
					            	'donor_address_country_id' => $this->general_model->filtertext(trim($_POST["donor_address_country_id"])),
					            	'donor_address_country' => @$addressCountryData->country_name,
					            	'donor_zipcode' => $this->general_model->filtertext(trim($_POST["donor_zipcode"])),
									'modified_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$id;
			$this->updateJapamUser($idd,$_POST["donor_relation"],$_POST["donor_name"],$_POST["donor_city"]);
		}

		$uname=strtolower($userData->username);
		$first_letter=$uname[0];

		$this->load->library("s3",array("accessKey"=>sso_aws_s3_access_key,
											"secretKey"=>sso_aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		if($id)
		{
			if(($donorData->donor_photo!='' && !isset($_POST['donor_imgupl'])) || 
				($donorData->donor_photo!='' && isset($_FILES['donor_profile_image']) && $_FILES['donor_profile_image']['name']!='') )
			{
				$this->auth_check->where("id",$idd);
				$this->auth_check->update($this->tableName,array('donor_photo'=>''));
				
				$uname=strtolower($userData->username);
				$first_letter=$uname[0];
				$userId=$userData->sso_user_id;

				$amazonUri="users_profiles/$first_letter/".md5($userId)."/".$donorData->donor_photo;
				$amazonUriThumb="users_profiles/$first_letter/".md5($userId)."/thumb_".$donorData->donor_photo;
				$amazonUriThumb50="users_profiles/$first_letter/".md5($userId)."/thumb50_".$donorData->donor_photo;
				$this->s3->deleteObject(sso_aws_s3_bucket_name,$amazonUri);
				$this->s3->deleteObject(sso_aws_s3_bucket_name,$amazonUriThumb);
				$this->s3->deleteObject(sso_aws_s3_bucket_name,$amazonUriThumb50);
			}
		}

		if(isset($_FILES['donor_profile_image']))
		if($_FILES['donor_profile_image']['name']!='')
		{
			$this->load->helper('image');
			$name=$_FILES['donor_profile_image']['name'];
			$pre=explode(".",$name);
			$ncnt=count($pre);
			$ext=$pre[$ncnt-1];
			
			$filename=substr(md5(mt_rand()), 0, 16).".".$ext;

			$basePath=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/";
			if(!is_dir($basePath))
			{
				mkdir($basePath,0777,true);
			}
			
			$path=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".$filename;
			$tpath=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/thumb_".$filename;
			$tpath50=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/thumb50_".$filename;
			
			
			move_uploaded_file($_FILES['donor_profile_image']['tmp_name'],$path);
			
			$this->general_model->create_thumb_150($path,$tpath);
			$this->general_model->create_thumb50($path,$tpath50);

			$image = new SimpleImage();
			$image->load($path);
			$img_width=$image->getWidth();
	    	$img_height=$image->getHeight();
	    	$ratio=$img_width/$img_height;
	      
			if($ratio>=1)
			{
				if($img_width>800)
					$image->resizeToWidth(800);
			}
			else
			{
				if($img_height>800)
					$image->resizeToHeight(800);
			}
			$image->save($path);
			
			$amazonUri="users_profiles/$first_letter/".md5($userData->sso_user_id)."/".$filename;
			$amazonUriThumb="users_profiles/$first_letter/".md5($userData->sso_user_id)."/thumb_".$filename;
			$amazonUriThumb50="users_profiles/$first_letter/".md5($userData->sso_user_id)."/thumb50_".$filename;

			$this->s3->putObjectFile($path,sso_aws_s3_bucket_name,$amazonUri,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($tpath,sso_aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());
			$this->s3->putObjectFile($tpath50,sso_aws_s3_bucket_name,$amazonUriThumb50,S3::ACL_PUBLIC_READ, array(), array());

			unlink($path);
			unlink($tpath);
			unlink($tpath50);
			
			$this->auth_check->where("id",$idd);
			$this->auth_check->update($this->tableName,array('donor_photo'=>$filename));
		}

		if(isset($_POST['updateSelfProfile']) && $_POST['updateSelfProfile']=="Yes")
		{
			$this->updateSelfProfile($userData->sso_user_id);
		}
		return $idd;
	}

	public function updateSelfProfile($userId)
    {
    	$this->auth_check->where("user_id",$userId);
		$uq = $this->auth_check->get($this->tableName);
		$donorData=$uq->row();
		if(isset($donorData->donor_relation) && $donorData->donor_relation=="Self")
		{

			$userUpdateData = [];
			if(isset($donorData->donor_phone) && $donorData->donor_phone!="")
			{
				$userUpdateData['phoneno'] = $donorData->donor_phone;
			}
			if(isset($donorData->donor_star) && $donorData->donor_star!="")
			{
				$userUpdateData['birthstar'] = $donorData->donor_star;
			}
			if(isset($donorData->donor_raasi) && $donorData->donor_raasi!="")
			{
				$userUpdateData['raasi'] = $donorData->donor_raasi;
			}
			if(isset($donorData->donor_address) && $donorData->donor_address!="")
			{
				$userUpdateData['address'] = $donorData->donor_address;
			}
			if(isset($donorData->donor_address1) && $donorData->donor_address1!="")
			{
				$userUpdateData['address1'] = $donorData->donor_address1;
			}
			if(isset($donorData->donor_address2) && $donorData->donor_address2!="")
			{
				$userUpdateData['address2'] = $donorData->donor_address2;
			}
			if(isset($donorData->donor_city) && $donorData->donor_city!="")
			{
				$userUpdateData['city'] = $donorData->donor_city;
			}
			if(isset($donorData->donor_state) && $donorData->donor_state!="")
			{
				$userUpdateData['state'] = $donorData->donor_state;
			}
			if(isset($donorData->donor_country) && $donorData->donor_country!="")
			{
				$userUpdateData['country'] = $donorData->donor_country;
			}
			if(isset($donorData->donor_zipcode) && $donorData->donor_zipcode!="")
			{
				$userUpdateData['zipcode'] = $donorData->donor_zipcode;
			}
			if(isset($donorData->donor_country_id) && $donorData->donor_country_id!="")
			{
				$userUpdateData['country_id'] = $donorData->donor_country_id;
			}
			if(isset($donorData->donor_profession) && $donorData->donor_profession!="")
			{
				$userUpdateData['profession'] = $donorData->donor_profession;
			}

			if(!empty($userUpdateData))
			{
				$this->db->where("sso_user_id",$userId)->update("users", $userUpdateData);

				$this->load->library("dattaid_api");
	        	$response = $this->dattaid_api->call($userId);
	        }
		}
    }

	public function delete($id,$donorData,$userData)
	{
		$this->auth_check->where("id",$id);
		$this->auth_check->delete($this->tableName);

		$this->load->library("s3",array("accessKey"=>sso_aws_s3_access_key,
											"secretKey"=>sso_aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		$uname=strtolower($userData->username);
		$first_letter=$uname[0];
		$userId=$userData->id;

		$amazonUri="users_profiles/$first_letter/".md5($userId)."/".$donorData->donor_photo;
		$amazonUriThumb="users_profiles/$first_letter/".md5($userId)."/thumb_".$donorData->donor_photo;
		$amazonUriThumb50="users_profiles/$first_letter/".md5($userId)."/thumb50_".$donorData->donor_photo;
		$this->s3->deleteObject(sso_aws_s3_bucket_name,$amazonUri);
		$this->s3->deleteObject(sso_aws_s3_bucket_name,$amazonUriThumb);
		$this->s3->deleteObject(sso_aws_s3_bucket_name,$amazonUriThumb50);
		return 1;
	}

	public function getCountries()
	{
		$this->auth_check->select("donor_country_id as country_id,donor_country as country");
		$this->auth_check->from($this->tableName);
		$this->auth_check->group_by("donor_country_id");
		$this->auth_check->where("donor_country !=",'');
		$this->auth_check->where("donor_country_id !=",'');
		$q=$this->auth_check->get();
		return $q->result();
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->auth_check->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donor Relation");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donor Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donor Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donor Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Donor DOB");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$user_phone='';
			if(isset($countries[$reportrow->country_id]->isd_code) && !empty($reportrow->phoneno))
				$user_phone="+".$countries[$reportrow->country_id]->isd_code." ".$reportrow->phoneno;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$user_phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->donor_relation);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->donor_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$reportrow->donor_country_isd." ".$reportrow->donor_phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->donor_email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M",strtotime($reportrow->donor_dob_day."/".$reportrow->donor_dob_month."/2000")));
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function getUserUnhideDonors($userId = 0)
	{
		$query1=$this->auth_check;
		$query1->select("donor_name, donor_relation, id as donor_id");
		$query1->from('donors');
		$query1->where('user_id',$userId);
		$query1->where('is_hidden',0);
		$query1->order_by('id','ASC');
		return $query1->get()->result_array();
	}

	public function getUserDonors($userId = 0)
	{
		$query1=$this->auth_check;
		$query1->select("donor_name, donor_relation, id as donor_id");
		$query1->from('donors');
		$query1->where('user_id',$userId);
		$query1->order_by('id','ASC');
		return $query1->get()->result_array();
	}

	public function getUserSelfDonors($userId = 0)
	{
		$query1=$this->auth_check;
		$query1->select("donor_name, donor_relation, id as donor_id");
		$query1->from('donors');
		$query1->where('user_id',$userId);
		$query1->where('donor_relation',"self");
		$query1->order_by('id','ASC');
		$result = $query1->get();
		if($result->num_rows() > 0)
		{
			return 1;
		}
		return 2;
	}

	public function getUserDonorsWithFullData($userId = 0)
	{
		$query1=$this->auth_check;
		$query1->select("*");
		$query1->from('donors');
		$query1->where('user_id',$userId);
		$query1->order_by('id','ASC');
		return $query1->get()->result_array();
	}

	public function updateHideUnhideDonorStatus($id, $status)
	{
		if($id>0 && ($status==0 || $status==1) )
        {
        	$query1=$this->auth_check;
        	$query1->where('id',$id);
			$query1->update('donors', array('is_hidden'=>$status));
            return true;
        }
        else
        {
            return false;
        }
		
	}

	public function getUserDonorIds($userId = 0)
	{
		//Getting donors list as per page
		$query1=$this->auth_check;
		$query1->select("GROUP_CONCAT(id) as donor_ids");
		$query1->from('donors');
		$query1->where('user_id',$userId);
		$query1->where('is_hidden',0);
		$query1->order_by('id','asc');
		$query1->group_by('user_id');
		$c = $query1->get();
		
		if(!$c->num_rows()){
			return array();
		}
		//Preparing response data
		$donor_ids_str = $c->row_array();
		$donor_ids = explode(',', $donor_ids_str['donor_ids']);
		return $donor_ids;
	}
}
?>