<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Satsangpage_images_model extends CI_Model
{
	var $tableName="satsangpage_images";
	public function __construct()
	{
		parent::__construct();
	}
	public function insert($data)
	{
		$this->db->insert($this->tableName,$data);
	}
	
	public function getImagesBySatsangId($satsangId,$multiple=false,$columns=array())
	{
		if(empty($columns))
			$this->db->select("*");
		else
			$this->db->select(implode(",", $columns));
		$this->db->from($this->tableName);
		if($multiple==true)
			$this->db->where_in("satsang_id",$satsangId);
		else
		$this->db->where("satsang_id",$satsangId);
		$q=$this->db->get();
		return $q->result();
	}
	public function deleteImage($satsangId,$imageId)
	{
		$this->db->where(array("id"=>$imageId,"satsang_id"=>$satsangId));
		$query = $this->db->get($this->tableName);
		if($query->num_rows())
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$r=$query->row();
			$file=$r->filename;
			$amazonUri="content/satsangs/".$satsangId."/";
			$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri.$r->filename);

			$this->db->where(array("id"=>$imageId,"satsang_id"=>$satsangId));
			$this->db->delete($this->tableName);
			return 1;
		}
		else
			return 0;
	}
}
?>