<?PHP
class Satsang_members_Model extends CI_Model 
{
	var $tableName="satsang_members";
	public function __construct()
	{
		parent::__construct();
	}
	public function listAdmin($excel=0)
	{
		$satsangData=$this->satsangs_model->satsangData($this->session->userdata("satsangId"));

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(s.id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("s.id as id,user_id,username,email,phoneno,firstname,middlename,lastname,deleted,status,country,state,city,member_status,s.receive_newsletters");
		}
		$query1->from($this->tableName." as s");
		$query1->join("users as u","u.id=s.user_id");
		$query1->where("s.satsang_id",$this->session->userdata("satsangId"));

		$preData="Satsang Name: ".$satsangData->name;

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nCountry: ";
		if(isset($_POST['country']))
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$query1->where("country_id",$_POST['country']);
				$preData.=$countryData->country_name;
			}
			else
				$preData.="All Countries";
		}
		else
		{
			$preData.="All Countries";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('username',$_POST['dir']);
				else
					$query1->order_by('username',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","satsangs/satsang_members_model",$sql,$this->currentUser,"default",$_POST,"All Members",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('username',$dir);
		}
		else
		{
			$query1->order_by('username',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function getMember($satsangId,$userId)
	{
		$this->db->where("satsang_id",$satsangId);
		$this->db->where("user_id",$userId);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}
	public function getMemberById($id)
	{
		$this->db->where("id",$id);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}
	public function deleteMember($memberData,$userData)
	{
		$this->db->where("id",$memberData->id);
		$this->db->delete($this->tableName);

		$satsangData=$this->satsangs_model->satsangData($memberData->satsang_id);

		$subject=$satsangData->name." membership terminated: ".$userData->username;
		$emailData['satsangData']=$satsangData;
		$content=$this->load->view("satsangs/admin/_email_deleted",$emailData,true);
		$this->email_extension->sendMail("satsang_".$satsangData->id,$userData->id,$subject,$content,1);
	}
	public function addMember($satsangId,$userId)
	{
		$this->db->insert($this->tableName,array("satsang_id"=>$satsangId,"user_id"=>$userId));
	}

	public function searchUsers($str)
	{
		$this->db->select("u.id as uid,u.username as uusername,email,phoneno,firstname,lastname,profilepic,status,role,sso_user_id");
		$this->db->where("deleted",0);
		$this->db->where("u.status",1);
		$this->db->where("admin",0);
		$this->db->group_start();
			$this->db->like("u.username",$str);
			$this->db->or_like("u.firstname",$str,'match');
			$this->db->or_like("u.lastname",$str,'match');
			$this->db->or_like("email",$str,'match');
			$this->db->or_like("phoneno",$str,'match');
		$this->db->group_end();
		$this->db->where("email_verified",1);
		$this->db->where("m.member_status",1);
		$this->db->where("m.satsang_id",$this->session->userdata("satsangId"));
		$this->db->from("satsang_members as m");
		$this->db->join("users as u",'u.id=m.user_id');
		$this->db->limit(10);

		return $this->db->get()->result_array();

	}

	public function validateUsers($userlistString)
	{
		$usersList=array_filter(explode(",",$userlistString));

			$this->db->select("u.id as uid,u.username as uusername,email,phoneno,firstname,lastname,profilepic,status,role");
			$this->db->where("deleted",0);
			$this->db->where("u.status",1);
			$this->db->where("admin",0);
			$this->db->where_in("email",$usersList);
			$this->db->where("email_verified",1);
			$this->db->where("m.member_status",1);
			$this->db->where("m.satsang_id",$this->session->userdata("satsangId"));
			$this->db->from("satsang_members as m");
			$this->db->join("users as u",'u.id=m.user_id');
			
		$q=$this->db->get()->result();

		$users=array();
		foreach ($q as $row)
		{
			$users[]=array("id"=>$row->uid,"text"=>$row->firstname." ".$row->lastname." (".$row->uusername.")");
		}
		return $users;
	}

	//=====================================================================================================
	public function byId($ids,$userId)
	{
		$this->db->where_in("satsang_id",$ids);
		$this->db->where_in("user_id",$userId);
		$q=$this->db->get($this->tableName);

		$subArray=array();
		foreach ($q->result() as $row)
		{
			$subArray[$row->satsang_id]=$row;
		}

		$finalArray=array();
		foreach ($ids as $id)
		{
			$finalArray[$id]=-1;
			if(isset($subArray[$id]))
			{
				$finalArray[$id]=$subArray[$id]->member_status;
			}
		}
		return $finalArray;
	}


	public function receiveNewslettersbyId($ids,$userId)
	{
		$this->db->where_in("satsang_id",$ids);
		$this->db->where_in("user_id",$userId);
		$this->db->where("receive_newsletters",1);
		$q=$this->db->get($this->tableName);

		$subArray=array();
		foreach ($q->result() as $row)
		{
			$subArray[$row->satsang_id]=$row;
		}

		$finalArray=array();
		foreach ($ids as $id)
		{
			$finalArray[$id]=-1;
			if(isset($subArray[$id]))
			{
				$finalArray[$id]=$subArray[$id]->member_status;
			}
		}
		return $finalArray;
	}

	public function checkInvite($id,$userId)
	{
		$this->db->where("satsang_id",$id);
		$this->db->where_in("user_id",$userId);
		$q=$this->db->get($this->tableName)->row();
		if(!empty($q))
			return $q->member_status;
		else
			return -1;
	}
	public function acceptInvite($id,$userId)
	{
		$this->load->model("user/users_model");
		$userData=$this->users_model->userData($userId);
		$this->db->where("satsang_id",$id);
		$this->db->where_in("user_id",$userId);
		$this->db->update($this->tableName,array("member_status"=>1));

		$satsangData=$this->satsangs_model->satsangData($id);

		$subject="Welcome to ".$satsangData->name.": ".$userData->username;
		$emailData['satsangData']=$satsangData;
		$content=$this->load->view("satsangs/admin/_email_accepted",$emailData,true);
		$this->email_extension->sendMail("satsang_".$satsangData->id,$userData->id,$subject,$content,1);
	}
	public function join($id,$userId)
	{
		$this->db->insert($this->tableName,
							array
							(
								"member_status"=>2,
								'satsang_id'=>$id,
								'user_id'=>$userId
							)
						);
	}
	public function unjoin($id,$userId)
	{
		$this->db->where("satsang_id",$id);
		$this->db->where_in("user_id",$userId);
		$this->db->delete($this->tableName);
	}

	public function subscribe($id,$userId)
	{
		$subscribedMember=$this->getMember($id,$userId);
		$iData['user_id']=$userId;
		$iData["satsang_id"]=$id;
		$iData["receive_newsletters"]=1;
		if(isset($subscribedMember->id) && $subscribedMember->id>0)
		{
			$this->db->where("id", $subscribedMember->id);
			$this->db->update($this->tableName,$iData);	
		}
		else {
			$iData["member_status"]=2;
			$this->db->insert($this->tableName,$iData);
		}
		
	}
	public function unsubscribe($id,$userId)
	{
		$iData["receive_newsletters"]=0;
		$this->db->where("satsang_id",$id);
		$this->db->where_in("user_id",$userId);
		$this->db->update($this->tableName,$iData);
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Middle Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Member Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Receive Newsletters");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$status="Inactive";
			if($reportrow->status==1)
				$status="Active";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->middlename);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->phoneno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
			$mstatus="Invited";
			if($reportrow->member_status==1)
				$mstatus="Active";
			if($reportrow->member_status==2)
				$mstatus="Requested";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$mstatus);

			$nstatus="Subscribed";
			if($reportrow->receive_newsletters==0)
				$nstatus="Unsubscribed";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$nstatus);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function getMemberDetailsById($id)
	{
		$this->db->select("a.*, u.username, u.email, u.phoneno, u.firstname, u.middlename");
		$this->db->from($this->tableName." as a");
		$this->db->join("users as u","u.id=a.user_id");
		$this->db->where("a.id",$id);
		$q=$this->db->get();
		return $q->row();
	}

	public function updateReceiveNewslettersStatus($id, $status)
	{
		if($id>0 && ($status==0 || $status==1) )
        {
        	$this->db->where('id',$id);
			$this->db->update($this->tableName, array('receive_newsletters'=>$status));
            return true;
        }
        else
        {
            return false;
        }
		
	}
}
?>