<?PHP
class Register_model extends CI_Model 
{
	var $tableName="register";
	var $siteServivcesDb = "";
    function __construct()
    {
        parent::__construct();
        $this->siteServivcesDb = $this->load->database("site_services",true,false);
    }
    public function getCount()
	{
		return $this->siteServivcesDb->get($this->tableName)->num_rows();
	}
    public function listAdmin($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		$categoriesR=$this->register_categories_model->getCategories();
		$categories=array();
		foreach ($categoriesR as $category_row)
		{
			$categories[$category_row->id]=$category_row;
		}
		$i=0;
		$query1=$this->siteServivcesDb;
		if($excel==0)
			$query1->select("count(p.id) as c");
		step1:
		$i++;
		if($excel==1 || $i==2)
		{
			$query1->select("*,c.name as purpose,p.name as name,p.id as pid,p.status as pstatus");
		}
		$query1->from($this->tableName." as p");
		$query1->join("register_categories as c","c.id=p.purpose");

		$preData="Search Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nSource: ";
		if(isset($_POST['app']) && is_numeric($_POST['app']) && in_array($_POST['app'],array(0,1)))
		{
			$query1->where("app",$_POST['app']);
			if($_POST['app']==1)
				$preData.="App";
			else
				$preData.="Website";
		}
		
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(created_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(created_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nPurpose: ";
		if(isset($_POST['purpose']) && $_POST['purpose']!='')
		{
			$query1->where("purpose",$_POST['purpose']);
			$preData.=$categories[$_POST['purpose']]->name;
		}

		$preData.="\nStatus: ";
		if(isset($_POST['status']) && $_POST['status']!='')
		{
			$query1->where("p.status",$_POST['status']);
			if($_POST['status']==0)
				$preData.='New';
			if($_POST['status']==1)
				$preData.='Pending';
			if($_POST['status']==2)
				$preData.='Completed';
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('order',$_POST['dir']);
				else
					$query1->order_by('order',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","registrations/register_model",$sql,$this->currentUser,"site_services",$_POST,"All Registrations",$preData);
			return $requestResp;
		}
		
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('created_on',$dir);
		}
		else
		{
			$query1->order_by('created_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$rtn['q']=$query1->last_query();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($row['created_on']));
			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	
	function registerData($id)
	{
		$this->siteServivcesDb->select("*,p.name as name,c.name as purpose,p.id as pid,p.status as pstatus");
		$this->siteServivcesDb->where("p.id",$id);
		$this->siteServivcesDb->from($this->tableName." as p");
		$this->siteServivcesDb->join("register_categories as c","c.id=p.purpose");
		$query = $this->siteServivcesDb->get();
		return $query->row();
	}
	
	public function save($info)
	{	
		$user_id=0;
		$username='';
		if($this->session->userdata('user_id'))
		{
		    $user_id=$this->session->userdata('user_id');
		    $username=$this->session->userdata('user_data')->username;
		}

		$users=$this->users_model->getUsersByEmails(array($info['email']));
		if(!empty($users))
		{
			$user_id=$users[0]->id;
		    $username=$users[0]->username;
		}
		$app=0;
		if(isset($GLOBALS['app']) && $GLOBALS['app']==1)
		{
			$app=1;
		}

		$countryData=$this->locations_model->getCountryByCode($info["country"]);
		$query=$this->siteServivcesDb->insert($this->tableName,
                                	array(
                                			'name' =>trim($info['name']),
                                			'email' =>trim($info['email']),
                                			'phone' =>trim($info['phone']),
                                			'notes' =>trim($info['notes']),
                                			'country' =>trim($info['country']),
                                			'country_name' =>$countryData->country_name,
                                			'purpose' =>trim($info['purpose']),
                                			'address' =>trim($info['address']),
                                			'user_id'=>$user_id,
                                			'username'=>$username,
                                			'app'=>$app,
                                			'created_on'=>date("Y:m:d H:i:s")
										)
								);
		if($query)
		{
			$last_id=$this->siteServivcesDb->insert_id();
			$pid="RGN-".date("Y")."-".date("m")."-100".$last_id;
			$this->siteServivcesDb->where("id",$last_id);
			$this->siteServivcesDb->update($this->tableName,
							array("register_id"=>$pid)
						);

			return 1;
		}
		else return 0;
	}

	public function updateAdminNotes($id,$value)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array('admin_notes'=>$value));
	}
	public function changeStatus($id,$status)
	{
		$this->siteServivcesDb->where("id",$id);
		$this->siteServivcesDb->update($this->tableName,array('status'=>$status));
	}

	public function getRegistrationsByCategory($catId)
	{
		$this->siteServivcesDb->where("purpose",$catId);
		$q=$this->siteServivcesDb->get($this->tableName);
		return $q->result();
	}
	
	function delete($id,$catData)
	{
		$this->siteServivcesDb->where("id",$id);
		$query = $this->siteServivcesDb->delete($this->tableName);
		if($query) return 1;
		else return 0;
	}
	

	public function excelReport($excelData,$objPHPExcel)
	{

		$countries=$this->locations_model->getCountries(true);

		$q=$this->siteServivcesDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Registration ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Purpose");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Notes");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Admin notes");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"App?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->register_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->purpose);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));

			$status='New';
			if($reportrow->pstatus==1)
				$status="Pending";
			if($reportrow->pstatus==2)
				$status="Completed";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->notes);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->admin_notes);
			if($reportrow->app==1)
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"Yes");
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"No");

			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>