<?PHP
class Transaction_Model extends CI_Model 
{
	var $tableName="transaction";
	public function __construct()
	{
		parent::__construct();
	}

	public function listAdmin($excel=0)
	{
		$this->load->library('Common', NULL, 'common_library');
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			$ashramTrusts=$this->ashrams_trust_accounts_model->getAllTrustsBasicDetailsByAshramId($this->session->userdata("ashramId"));
			$ashramTrustsArray=array();
			foreach ($ashramTrusts as $ashramTrustData)
			{
				$ashramTrustsArray[$ashramTrustData->id]=$ashramTrustData;
			}
		}

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("t.tx, t.payment_mode, t.status, t.is_manual_payment, t.is_foreign_payment, t.started_on, t.created_on, t.modified_on, t.amount, t.order_id, t.order_id as primary_order_id, t.tx_order_type as order_type, t.tx_order_number as order_number, t.tx_order_date as order_date, t.tx_order_total_price as order_total_price, t.userid, t.firstname, t.lastname, t.address1, t.address2, t.address3, t.city, t.state, t.country, t.country_isd_code, t.zipcode, t.email, t.phone, t.currency, t.note, t.tx_pan_number as pan_number, t.tx_username as username, t.status as trans_status, t.tx_aadhaar_number, t.tx_tin_number, t.tx_passport_number, t.tx_voter_epic_number, t.tx_driving_license_number, t.tx_ration_card_number, t.started_on, t.tx_partial_payments_allowed, t.sub_transaction, t.sub_tx, t.refund_date, t.refunded_amount");
			// $query1->select("t.*, usr.pan_number as pan_number, usr.username");
		}
		if(isset($_POST['pagenum']) && $_POST['pagenum']==6)
		{
			$query1->select("ordr.paid_tx_ids, ordr.refunded_tx_ids, ordr.failed_tx_ids, ordr.cancelled_tx_ids, ordr.inprocess_tx_ids, ordr.bounced_tx_ids, ordr.total_price, ordr.total_paid, ordr.created_by, ordr.payment_status, ordr.tokens, ordr.dispatch_status, ordr.app,");
			$query1->join("orders as ordr",'ordr.id=t.order_id');
		}

		$query1->from($this->tableName." as t");
		// if($i==2 || $excel==1)
		// {
		// 	$query1->join("users as usr",'usr.id=t.userid');
		// }
		// if(isset($_POST['pagenum']) && $_POST['pagenum']==6)
		// {
		// 	$query1->join("orders as ordr",'ordr.id=t.order_id');
		// }
		if(isset($_POST['pagenum']) && in_array($_POST['pagenum'], array(7,8)))
		{
			$query1->select("oi.item_name, oi.price as item_price, oi.quantity as item_quantity, oi.status as item_status, oi.onetime_charge, oi.shipping_price");
			if(isset($_POST['pagenum']) && in_array($_POST['pagenum'], array(8)))
			{
				$query1->join("order_items as oi",'oi.id=t.order_item_id');
			}
			else
			{
				$query1->join("order_items as oi",'oi.order_id=t.order_id');
			}

			if(isset($_POST['pagenum']) && in_array($_POST['pagenum'], array(8)))
			{
				$query1->select("count(t.tx) as payment_items_count");
				$query1->join("subscription_payments as sp","sp.tx=t.tx AND sp.tx!=''",'left');
				$query1->join("onetime_payments_transaction_map as optm",'optm.tx_id=t.id','left');
			}
		}
		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("t.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nTrust(s): ";
			if(isset($_POST['trust_ids']) && $_POST['trust_ids']!='')
			{
				if(is_array($_POST['trust_ids']))
				{
					$query1->where_in("trust_id",$_POST['trust_ids']);
					$pii=0;
					foreach ($_POST['trust_ids'] as $trust_ids)
					{
						if($pii) $preData.=", ";
						$preData.=$ashramTrustsArray[$trust_ids]->trust_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("trust_id",$_POST['trust_ids']);
					$preData.=$ashramTrustsArray[$_POST['trust_ids']]->trust_name;
				}
			}
			else
			{
				$preData.="All Trusts";
			}
		}

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) &&  trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if($_POST['search_col'] == 'order_id')
			{
				$preData.= 'Seva ID';
			}
			else
			{
				$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			}
			$query1->like('t.'.$_POST['search_col'],trim($_POST['search_text']));
			$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like('t.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like('t.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like('t.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='' && isset($_POST['search_col2']))
		{
			if(in_array($_POST['search_col2'],$GLOBALS['current_acl']['search_columns']))
			{
				if($_POST['search_col2'] == 'created_on')
				{
					if(isset($_POST['currency']) && $_POST['currency']=='usd')
					{
						$searchFromDate = $this->common_library->convertCentralTimeToKolkattaTime(date("Y-m-d H:i:s",strtotime($_POST['from_date'])), "Y-m-d H:i:s");
						$query1->where("t.".$_POST['search_col2']." >=",$searchFromDate);
					}
					else{
						$query1->where("date(t.".$_POST['search_col2'].") >=",date("Y-m-d",strtotime($_POST['from_date'])));
					}
				}
				else
				{
					if(isset($_POST['currency']) && $_POST['currency']=='usd')
					{
						$searchFromDate = $this->common_library->convertCentralTimeToKolkattaTime(date("Y-m-d H:i:s",strtotime($_POST['from_date'])), "Y-m-d H:i:s");
						$query1->where($_POST['search_col2']." >=",$searchFromDate);
					}
					else{
						$query1->where("date(".$_POST['search_col2'].") >=",date("Y-m-d",strtotime($_POST['from_date'])));
					}
				}
				$preData.=$_POST['from_date'];
				$preData.=" (".$GLOBALS['current_acl']['excel_columns'][$_POST['search_col2']].")";
			}
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='' && isset($_POST['search_col2']))
		{
			if(in_array($_POST['search_col2'],$GLOBALS['current_acl']['search_columns']))
			{
				if($_POST['search_col2'] == 'created_on')
				{
					if(isset($_POST['currency']) && $_POST['currency']=='usd')
					{
						$postTodateTime = $_POST['to_date']." 23:59:59";
						$searchToDate = $this->common_library->convertCentralTimeToKolkattaTime(date("Y-m-d H:i:s",strtotime($postTodateTime)), "Y-m-d H:i:s");
						$query1->where("t.".$_POST['search_col2']." <=",$searchToDate);
					}
					else{
						$query1->where("date(t.".$_POST['search_col2'].") <=",date("Y-m-d",strtotime($_POST['to_date'])));
					}
				}
				else
				{
					if(isset($_POST['currency']) && $_POST['currency']=='usd')
					{
						$postTodateTime = $_POST['to_date']." 23:59:59";
						$searchToDate = $this->common_library->convertCentralTimeToKolkattaTime(date("Y-m-d H:i:s",strtotime($postTodateTime)), "Y-m-d H:i:s");
						$query1->where($_POST['search_col2']." <=",$searchToDate);
					}
					else{
						$query1->where("date(".$_POST['search_col2'].") <=",date("Y-m-d",strtotime($_POST['to_date'])));
					}
				}
				$preData.=$_POST['to_date'];
				$preData.=" (".$GLOBALS['current_acl']['excel_columns'][$_POST['search_col2']].")";
			}
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("t.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}
		$preData.="\nSeva Type:";
		if(isset($_POST['pagenum']) && $_POST['pagenum']==7)
		{
			if(isset($_POST['order_type']) && is_numeric($_POST['order_type']) && in_array($_POST['order_type'],array(1,2,3)))
			{
				if($_POST['order_type']==1)
				{
					$query1->where("tx_order_type",1);
					$preData.=" Poojas";
				}
				else if($_POST['order_type']==2)
				{
					$query1->where("tx_order_type",2);
					$preData.=" Donations";
				}
				else if($_POST['order_type']==3)
				{
					$query1->where("tx_order_type",3);
					$preData.=" Store";
				}
			}
			else
			{
				$query1->where_in("tx_order_type",array(1,2,3));
				$preData.=" Poojas, Donations and Store";
			}
		}
		else if(isset($_POST['pagenum']) && $_POST['pagenum']==8)
		{
			$query1->where_in("tx_order_type",array(4));
			$preData.=" Subscriptions";
		}
		else if(isset($_POST['order_type']) && is_numeric($_POST['order_type']) && in_array($_POST['order_type'],array(1,2,3,4)))
		{
			if($_POST['order_type']==1)
			{
				$query1->where("tx_order_type",1);
				$preData.=" Poojas";
			}
			else if($_POST['order_type']==2)
			{
				$query1->where("tx_order_type",2);
				$preData.=" Donations";
			}
			else if($_POST['order_type']==3)
			{
				$query1->where("tx_order_type",3);
				$preData.=" Store";
			}
			else if($_POST['order_type']==4)
			{
				$query1->where("tx_order_type",4);
				$preData.=" Subscriptions";
			}
		}
		else
		{
			$preData.=" All";
		}

		$preData.="\nSource: ";
		if(isset($_POST['app']) && is_numeric($_POST['app']) && in_array($_POST['app'],array(0,1)))
		{
			$query1->where("tx_app",$_POST['app']);
			if($_POST['app']==1)
				$preData.="App";
			else
				$preData.="Website";
		}
		else
		{
			$preData.=" All";
		}
		
		$preData.="\nPayment Mode:";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			if($_POST['payment_mode']=='paypal')
			{
				$query1->where("t.payment_mode",'paypal');
				$preData.=" Paypal";
			}
			else if($_POST['payment_mode']=='stripe')
			{
				$query1->where("t.payment_mode",'stripe');
				$preData.=" Stripe";
			}
			else if($_POST['payment_mode']=='razorpay')
			{
				$query1->where("t.payment_mode",'razorpay');
				$preData.=" Razorpay";
			}
			else if($_POST['payment_mode']=='authorize.net')
			{
				$query1->where("t.payment_mode",'authorize.net');
				$preData.=" Authorize.net";
			}
			else if($_POST['payment_mode']=='payu')
			{
				$query1->where("t.payment_mode",'payu');
				$preData.=" PayU";
			}
			else if($_POST['payment_mode']=='cash')
			{
				$query1->where("t.payment_mode",'cash');
				$preData.=" Cash";
			}
			else if($_POST['payment_mode']=='cc')
			{
				$query1->where("t.payment_mode",'cc');
				$preData.=" CC";
			}
			else if($_POST['payment_mode']=='dd')
			{
				$query1->where("t.payment_mode",'dd');
				$preData.=" DD";
			}
			else if($_POST['payment_mode']=='dc')
			{
				$query1->where("t.payment_mode",'dc');
				$preData.=" DC";
			}
			else if($_POST['payment_mode']=='cheque')
			{
				$query1->where("t.payment_mode",'cheque');
				$preData.=" Cheque";
			}
			else if($_POST['payment_mode']=='mo')
			{
				$query1->where("t.payment_mode",'mo');
				$preData.=" MO";
			}
			else if($_POST['payment_mode']=='cashiers_check')
			{
				$query1->where("t.payment_mode",'cashiers_check');
				$preData.=" Cashiers Check";
			}
			else
			{
				$query1->where("t.payment_mode",'');
			}
		}
		else
		{
			$preData.=" All";
		}


		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_type']) && $_POST['payment_type']!='')
		{

			if($_POST['payment_type'] == '0')
			{
				$query1->where_in("t.payment_mode",array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc'));
				$preData.='Offline';
			}
			else
			{
				$query1->where_in("t.payment_mode",array('paypal','razorpay','payu','authorize.net','stripe'));
				$preData.="Online";
			}
		}
		else
		{
			$preData.=" All";
		}

		$preData.="\nCheque Status:";
		if(isset($_POST['cheque_status']) && in_array($_POST['cheque_status'],array('inprocess','pending','bounced','paid')))
		{
			$query1->where("t.status",$_POST['cheque_status']);
			$preData.=$_POST['cheque_status'];
		}
		else
		{
			$preData.=" All Cheque status";
		}

		$preData.="\nPayment Status:";
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1,2,3)))
		{
			if($_POST['status']==1)
			{
				$query1->group_start();
					$query1->where_in("t.status",$this->payment_success_statuses);
					//$query1->or_where("status","refund");
				$query1->group_end();
				$preData.=" Success";
			}
			else if($_POST['status']==0)
			{
				$query1->where_in("t.status",array('user cancelled','failure','failed','aborted'));
				$preData.=" Failed";
			}
			else if($_POST['status']==3)
			{
				$query1->where("t.status","refund");
				$preData.=" Failed";
			}
			else
			{
				$query1->where_in("t.status",array("initiated","pending"));
				$preData.=" Pending/Initiated";
			}
		}
		else
		{
			$preData.=" All Tx Payment Status";
		}

		$preData.="\nCreated By:";
		if(isset($_POST['created_by']) && is_numeric($_POST['created_by']) && in_array($_POST['created_by'],array(0,1,2)))
		{
			if($_POST['created_by']==0)
			{
				$query1->where("tx_created_by",0);
				$preData.=" Guest";
			}
			else if($_POST['created_by']==1)
			{
				$query1->where("tx_created_by",1);
				$preData.=" Admin";
			}
			else
			{
				$query1->where("tx_created_by",2);
				$preData.=" User";
			}
		}
		else
		{
			$preData.=" All";
		}

		if(isset($_POST['pagenum']) && in_array($_POST['pagenum'], array(8)))
		{

		}
		else
		{
			$query1->where("t.sub_transaction!=",1);
		}

		$query1->where("t.amount>",0);
		$query1->where("t.flag!=",1);
		$query1->where("t.tx!=","");
        $query1->where("t.tx!=",NULL);
		$whereCondition = "1 = CASE
					              WHEN `t`.`payment_mode`='cash' AND `t`.`status`='pending' THEN 0 
					              ELSE 1
					           END";
		// $whereCondition = " t.flag!=1 AND CASE WHEN `t`.`payment_mode`='cash' AND `t`.`status`='pending' THEN 0 ELSE 1 END)";
		// $whereCondition = " t.flag!=1 AND ( t.payment_mode = 'cash' AND t.status != 'pending' )";
       	$query1->where($whereCondition);
		// $query1->where("t.flag!=",1);


		if($excel==1)
		{
			if(isset($_POST['pagenum']) && $_POST['pagenum']==6 && isset($_POST['currency']) && $_POST['currency']=='usd')
			{
				$query1->order_by('t.created_on','ASC');
			}
			else
			{
				if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
				{
					if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
						$query1->order_by($_POST['order_by'],$_POST['dir']);
					else
						$query1->order_by($_POST['order_by'],'desc');
				}
				else
				{
					if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
						$query1->order_by('t.created_on',$_POST['dir']);
					else
						$query1->order_by('t.created_on',"desc");
				}
			}

			if(isset($_POST['pagenum']) && in_array($_POST['pagenum'], array(7)))
			{
				$query1->group_by('oi.id, t.tx');
			}
			if(isset($_POST['pagenum']) && in_array($_POST['pagenum'], array(8)))
			{
				$query1->group_by('oi.id, t.tx, sp.tx');

				$query1->group_start();
					$query1->group_start();
						$query1->where("optm.tx_id !=",null);
						$query1->where("optm.flag",0);
					$query1->group_end();
					$query1->or_group_start();
						$query1->where("optm.tx_id",null);
					$query1->group_end();
				$query1->group_end();

			}
			$sql=$query1->get_compiled_select();

			if(isset($_POST['pagenum']) && $_POST['pagenum']==6)
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/transaction_model",$sql,$this->currentUser,"default",$_POST,"All Transactions Tax Report",$preData,$_POST['pagenum']);
			}
			else if(isset($_POST['pagenum']) && $_POST['pagenum']==7)
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/transaction_model",$sql,$this->currentUser,"default",$_POST,"Sevas Tally Report",$preData,$_POST['pagenum']);
			}
			else if(isset($_POST['pagenum']) && $_POST['pagenum']==8)
			{
				$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/transaction_model",$sql,$this->currentUser,"default",$_POST,"Subscriptions Tally Report",$preData,$_POST['pagenum']);
			}
			else
			{
				$requestResp=$this->excel_exports_model->makeRequest('default',"model","orders/transaction_model",$sql,$this->currentUser,"default",$_POST,"All Transactions",$preData);
			}
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('t.created_on',$dir);
		}
		else
		{
			$query1->order_by('t.created_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		 //echo $query1->last_query(); exit;
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if($rtn['data'][$c]['order_date']!='')
			{
				$rtn['data'][$c]['seva_date']=date("d M Y",strtotime($rtn['data'][$c]['order_date']));
			}
			$rtn['data'][$c]['started_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['started_on']));
			$rtn['data'][$c]['modified_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['modified_on']));
			if($row['created_on'])
				$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['created_on']));
			else
				$rtn['data'][$c]['created_on']='NA';
			if(preg_grep('/'.$row['status'].'/i', array('failure','aborted','failed','user cancelled', 'refund', 'bounced')))
				$rtn['data'][$c]['trans_status']=0;

			if(preg_grep('/'.$row['status'].'/i', array('completed','approved','success','paid','captured')))
				$rtn['data'][$c]['trans_status']=1;

			if(in_array($row['status'],array('initiated', 'inprocess','pending')))
				$rtn['data'][$c]['trans_status']=2;

			$rtn['data'][$c]['amount_num']=abs($row['amount']);
			if(empty($row['amount']))
			{
				$row['amount']=0;
			}
			if($row['currency']=='usd')
			{
				$rtn['data'][$c]['amount']="<span style='color:red; font-weight:bold;'>".strtoupper($row['currency'])." ".$row['amount']."</span>";
				$rtn['data'][$c]['refunded_amount']="<span style='color:red; font-weight:bold;'>".strtoupper($row['currency'])." ".$row['refunded_amount']."</span>";
			}
			else
			{
				$rtn['data'][$c]['amount']="<span style='font-weight:bold;'>".strtoupper($row['currency'])." ".$row['amount']."</span>";
				$rtn['data'][$c]['refunded_amount']="<span style='font-weight:bold;'>".strtoupper($row['currency'])." ".$row['refunded_amount']."</span>";
			}

			if($row['refund_date'])
				$rtn['data'][$c]['refund_date']=date("d M Y h:i A",strtotime($rtn['data'][$c]['refund_date']));
			else
				$rtn['data'][$c]['refund_date']='NA';

			if($rtn['data'][$c]['note'] == "")
			{
				$rtn['data'][$c]['note'] = "N/A";
			}
			else
			{
				$rtn['data'][$c]['note'] = nl2br($rtn['data'][$c]['note']);
			}
			$rtn['data'][$c]['username'] = $row['username'];
			$rtn['data'][$c]['user_id'] = $row['userid'];
			$rtn['data'][$c]['firstname']=$row['firstname']." ".$row['lastname']."<br>".
											$row['city']."<br>".
											$row['state'].", ".$row['country']."<br>".
											"<span style='font-weight:bold;'>".$row['email']."</span><br>".
											"<span style='font-weight:bold; color:red;'>+".$row['country_isd_code']." ".$row['phone']."</span>";
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function getDonationDeclarations($get_only_count=0)
	{
		if($get_only_count == 1)
			$this->db->select("count(t.id) as total_records");
		else
			$this->db->select('t.*,o.country,o.order_number,o.firstname,o.lastname,o.currency,o.trust_name,o.address1,o.address2,o.address3,o.city,o.state,o.zipcode,o.isd_code,o.phone,o.pan_or_aadhaar,o.order_pan_number,o.order_aadhaar_number,o.order_tin_number,o.order_passport_number,o.order_voter_epic_number,o.order_driving_license_number,o.order_ration_card_number,o.email,o.donation_initials');
        $this->db->from("transaction as t");
        if($get_only_count != 1)
        	$this->db->join("orders as o","o.id=t.order_id","left");
        $this->db->where_in('t.status',array("completed",'success','release payment','Release Payment','approved','captured','paid'));
        $this->db->where('t.amount>',"0");
        $this->db->where('t.is_manual_payment',0);
        if(isset($_GET["ashram_id"]) &&  $_GET["ashram_id"] != "")
        {
        	$this->db->where("t.ashram_id",$_GET['ashram_id']);
        }
        if(isset($_GET["from_date"]) &&  $_GET["from_date"] != "")
        {
        	$this->db->where("date(t.created_on) >=",date("Y-m-d",strtotime($_GET['from_date'])));
        }
        if(isset($_GET["to_date"]) &&  $_GET["to_date"] != "")
        {
        	$this->db->where("date(t.created_on) <=",date("Y-m-d",strtotime($_GET['to_date'])));
        }
        if(isset($_GET["currency"]) &&  $_GET["currency"] != "" && in_array($_GET["currency"], ['inr','usd']))
        {
        	$this->db->where("t.currency", strtolower($_GET["currency"]));
        }
        if(isset($_GET["payment_mode"]) &&  $_GET["payment_mode"] != "")
        {
        	if($_GET["payment_mode"] == "all")
        	{

        	}
        	else if(in_array(strtolower($_GET["payment_mode"]),array("cash",'razorpay','neft','cc','dc','rtgs','cash','cheque','dd','paypal','stripe','authorize.net','payu')))
        	{
        		$this->db->where('t.payment_mode',$_GET["payment_mode"]);
        	}
        }
        if($get_only_count==1)
		{
			$temp_result = $this->db->get()->row();
			$totalRecords = $temp_result->total_records;
			return $totalRecords;
		}
        $this->db->group_by('t.id');
        $this->db->order_by('t.id', 'DESC');
		if(isset($_GET["length"]) &&  $_GET["length"] >0 && isset($_GET["start"]) &&  $_GET["start"] >=0)
        {
			$this->db->limit($_GET["length"],$_GET["start"]);
		}
        $q = $this->db->get();
        if($q->num_rows() > 0)
        {
        	$r = $q->result();
        	return $r;
        }
        return false;
	}

	public function getDonationDeclarations_old()
	{
		$this->db->select('*');
        $this->db->from("transaction");
        $this->db->where_in('status',array("completed",'success','release payment','Release Payment','approved','captured','paid'));
        $this->db->where('amount>',"0");
        $this->db->where('is_manual_payment',0);
        if(isset($_GET["ashram_id"]) &&  $_GET["ashram_id"] != "")
        {
        	$this->db->where("ashram_id",$_GET['ashram_id']);
        }
        if(isset($_GET["from_date"]) &&  $_GET["from_date"] != "")
        {
        	$this->db->where("date(created_on) >=",date("Y-m-d",strtotime($_GET['from_date'])));
        }
        if(isset($_GET["to_date"]) &&  $_GET["to_date"] != "")
        {
        	$this->db->where("date(created_on) <=",date("Y-m-d",strtotime($_GET['to_date'])));
        }
        if(isset($_GET["currency"]) &&  $_GET["currency"] != "" && in_array($_GET["currency"], ['inr','usd']))
        {
        	$this->db->where("currency", strtolower($_GET["currency"]));
        }
        if(isset($_GET["payment_mode"]) &&  $_GET["payment_mode"] != "")
        {
        	if($_GET["payment_mode"] == "all")
        	{

        	}
        	else if(in_array(strtolower($_GET["payment_mode"]),array("cash",'razorpay','neft','cc','dc','rtgs','cash','cheque','dd','paypal','stripe','authorize.net','payu')))
        	{
        		$this->db->where('payment_mode',$_GET["payment_mode"]);
        	}
        }
        $q = $this->db->get();
        if($q->num_rows() > 0)
        {
        	$r = $q->result();
        	return $r;
        }
        return false;
	}

	public function getofflineTotalPaid($order_id = 0)
	{
		$q = $this->db->select("sum(amount) as total_paid")->from($this->tableName)->where("order_id",$order_id)->where_in("status",array('success','approved','completed','captured','paid'))->group_by("order_id")->get();
		if($q->num_rows() > 0)
		{
			$total_paid = $q->row()->total_paid;
			return $total_paid;
		}
		else
		{
			return "0";
		}
	}

	public function getofflineTotalPaidInprocess($order_id = 0)
	{
		$q = $this->db->select("sum(amount) as total_paid")->from($this->tableName)->where("order_id",$order_id)->where_in("status",array('inprocess'))->group_by("order_id")->get();
		if($q->num_rows() > 0)
		{
			$total_paid = $q->row()->total_paid;
			return $total_paid;
		}
		else
		{
			return "0";
		}
	}

	/**
	 * listAdminOfflineTrans
	 * @param  		integer $excel [1 Indecates Function beahve to give excel report]
	 * @return 		var
	 * @version   	1.1 [27 June 2019]
	 * @author    	Baji Shaik <bajidotwork@gmail.com>
	 */
	public function listAdminOfflineTrans($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
		}
		$i=0;
		$query1=$this->db;
		
		if($excel==0)
			$query1->select("count(t.id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("case when t.tx='' then t2.tx else t.tx end as tx
						,t2.id as t2id
						,case when t.order_item_id='' or t.order_item_id is null then null else t.order_item_id end as order_item_id
						,t.order_id as order_id
						,case when t2.note='' or t2.note is null then t.note else t2.note end as note
						,case when t2.started_on='' or t2.started_on is null then t.started_on else t2.started_on end as date
						,case when t2.status='' or t2.status is null then t.status else t2.status end as status
						,t.amount as amount
						,case when t2.payment_mode='' or t2.payment_mode is null then t.payment_mode else t2.payment_mode end as payment_mode
						,t.id as id
						,t2.status as tx_status
						,case when t2.created_on='' or t2.created_on is null then t.created_on else t2.created_on end as created_on
						,t.sub_tx as sub_tx
						,t.sub_transaction as sub_transaction
						,t.currency as currency
						,case when t2.flag='' or t2.flag is null then t.flag else t2.flag end as flag
						,t2.tx as t2tx
						,t.subscription as subscription
						,t2.payment_mode as pm
						,t2.amount as t2amount
						,case when t2.ip_address='' or t2.ip_address is null then t.ip_address else t2.ip_address end as ip_address
						,t.firstname as firstname
						,t.lastname as lastname
						,case when t2.is_manual_payment='' or t2.is_manual_payment is null then t.is_manual_payment else t2.is_manual_payment end as is_manual_payment
						,case when t2.manual_receipt_number='' or t2.manual_receipt_number is null or t2.manual_receipt_number = 0 then t.manual_receipt_number else t2.manual_receipt_number end as manual_receipt_number
						,case when t2.manual_receipt_date='' or t2.manual_receipt_date is null then t.manual_receipt_date else t2.manual_receipt_date end as manual_receipt_date
						,case when t2.offline_number='' or t2.offline_number is null then t.offline_number else t2.offline_number end as offline_number
						,case when t2.offline_date='' or t2.offline_date is null then t.offline_date else t2.offline_date end as offline_date
						,case when t2.offline_bank='' or t2.offline_bank is null then t.offline_bank else t2.offline_bank end as offline_bank
						,case when t2.is_foreign_payment='' or t2.is_foreign_payment is null then t.is_foreign_payment else t2.is_foreign_payment end as is_foreign_payment
						,case when t2.foreign_currency='' or t2.foreign_currency is null then t.foreign_currency else t2.foreign_currency end as foreign_currency
						,case when t2.foreign_amount='' or t2.foreign_amount is null then t.foreign_amount else t2.foreign_amount end as foreign_amount
						,case when t2.realized_amount='' or t2.realized_amount is null then t.realized_amount else t2.realized_amount end as realized_amount
						,case when t2.refund_mode='' or t2.refund_mode is null then t.refund_mode else t2.refund_mode end as refund_mode
						,case when t2.refund_reference='' or t2.refund_reference is null then t.refund_reference else t2.refund_reference end as refund_reference
						,case when t2.refund_date='' or t2.refund_date is null then t.refund_date else t2.refund_date end as refund_date
						,t.started_on,t.modified_on,t.created_on,t.city,t.email,t.phone,t.country_isd_code,t.state,t.country,t.order_id, t2.userid, usr.username");
		}

		$query1->from($this->tableName . " As t");
		$this->db->group_start();
			$this->db->group_start();
				$this->db->where("optm.tx_id !=",null);
				$this->db->where("optm.flag",0);
			$this->db->group_end();
			$this->db->or_group_start();
				$this->db->where("optm.tx_id",null);
			$this->db->group_end();
		$this->db->group_end();
		$this->db->order_by("t2.id","desc");
		$this->db->join("onetime_payments_transaction_map as optm","optm.tx_id=t.id","left");
		$this->db->join("transaction as t2","t2.tx=optm.tx","left");
		$this->db->join("users as usr",'usr.id=t2.userid');
		$query1->where_not_in("t.payment_mode",array("paypal","stripe","payu","razorpay"));
		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("t.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}
		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='' && isset($_POST['search_col2']))
		{
			if(in_array($_POST['search_col2'],$GLOBALS['current_acl']['search_columns']))
			{
				$query1->where("date(".$_POST['search_col2'].") >=",date("Y-m-d",strtotime($_POST['from_date'])));
				$preData.=$_POST['from_date'];
				$preData.=" (Tx ".$GLOBALS['current_acl']['excel_columns'][$_POST['search_col2']].")";
			}
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='' && isset($_POST['search_col2']))
		{
			if(in_array($_POST['search_col2'],$GLOBALS['current_acl']['search_columns']))
			{
				$query1->where("date(".$_POST['search_col2'].") <=",date("Y-m-d",strtotime($_POST['to_date'])));
				$preData.=$_POST['to_date'];
				$preData.=" (Tx ".$GLOBALS['current_acl']['excel_columns'][$_POST['search_col2']].")";
			}
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("t.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		$preData.="\nSeva Type:";
		if(isset($_POST['order_type']) && is_numeric($_POST['order_type']) && in_array($_POST['order_type'],array(1,2,3)))
		{
			if($_POST['order_type']==1)
			{
				$query1->where("order_type",1);
				$preData.=" Poojas";
			}
			else if($_POST['order_type']==2)
			{
				$query1->where("order_type",2);
				$preData.=" Donations";
			}
			else
			{
				$query1->where("order_type",3);
				$preData.=" Store";
			}
		}
		else
		{
			$preData.=" All";
		}

		$preData.="\nPayment Mode:";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			if($_POST['payment_mode']=='paypal')
			{
				$query1->where("t.payment_mode",'paypal');
				$preData.=" Paypal";
			}
			else if($_POST['payment_mode']=='stripe')
			{
				$query1->where("t.payment_mode",'stripe');
				$preData.=" Stripe";
			}
			else if($_POST['payment_mode']=='razorpay')
			{
				$query1->where("t.payment_mode",'razorpay');
				$preData.=" Razorpay";
			}
			else if($_POST['payment_mode']=='authorize.net')
			{
				$query1->where("t.payment_mode",'authorize.net');
				$preData.=" Authorize.net";
			}
			else if($_POST['payment_mode']=='payu')
			{
				$query1->where("t.payment_mode",'payu');
				$preData.=" PayU";
			}
			else if($_POST['payment_mode']=='dd')
			{
				$query1->where("t.payment_mode",'dd');
				$preData.=" DD";
			}
			else if($_POST['payment_mode']=='cash')
			{
				$query1->where("t.payment_mode",'cash');
				$preData.=" Cash";
			}
			else if($_POST['payment_mode']=='cc')
			{
				$query1->where("t.payment_mode",'cc');
				$preData.=" CC";
			}
			else if($_POST['payment_mode']=='dc')
			{
				$query1->where("t.payment_mode",'dc');
				$preData.=" DC";
			}
			else if($_POST['payment_mode']=='dd')
			{
				$query1->where("t.payment_mode",'dd');
				$preData.=" DD";
			}
			else if($_POST['payment_mode']=='cheque')
			{
				$query1->where("t.payment_mode",'cheque');
				$preData.=" Cheque";
			}
			else if($_POST['payment_mode']=='mo')
			{
				$query1->where("t.payment_mode",'mo');
				$preData.=" MO";
			}
			else if($_POST['payment_mode']=='cashiers_check')
			{
				$query1->where("t.payment_mode",'cashiers_check');
				$preData.=" Cashiers Check";
			}else if($_POST['payment_mode']=='neft')
			{
				$query1->where("t.payment_mode",'neft');
				$preData.=" NEFT/IMPS";
			}
			else
			{
				$query1->where("t.payment_mode",'');
			}
		}
		else
		{
			$preData.=" All";
		}


		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_type']) && $_POST['payment_type']!='')
		{

			if($_POST['payment_type'] == '0')
			{
				$query1->where_in("t.payment_mode",array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc'));
				$preData.='Offline';
			}
			else
			{
				$query1->where_in("t.payment_mode",array('paypal','razorpay','payu','authorize.net','stripe'));
				$preData.="Online";
			}
		}
		else
		{
			$preData.=" All";
		}

		$preData.="\nPayment Status:";
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1,2,3)))
		{
			if($_POST['status']==1)
			{
				$query1->where_in("t.status",array('success','approved','completed','captured','paid'));
				$preData.=" Success";
			}
			else if($_POST['status']==0)
			{
				$query1->where_in("t.status",array('user cancelled','failure','failed','aborted'));
				$preData.=" Failed / Cancelled";
			}
			else if($_POST['status']==3)
			{
				$query1->where_in("t.status",array('refund'));
				$preData.=" Refunded";
			}
			else
			{
				$query1->where_in("t.status",array('initiated','pending'));
				$preData.=" Pending / Initiated";
			}
		}
		else
		{
			$preData.=" All status";
		}

		$preData.="\nManual Tx:";
		if(isset($_POST['manual_trans']) && is_numeric($_POST['manual_trans']) && in_array($_POST['manual_trans'],array(0,1)))
		{
			if($_POST['manual_trans']==1)
			{
				$query1->where("t.is_manual_payment",$_POST['manual_trans']);
				$preData.=" Yes";
			}
			else if($_POST['manual_trans']==0)
			{
				$query1->where("t.is_manual_payment",$_POST['manual_trans']);
				$preData.=" No";
			}
		}
		else
		{
			$preData.=" All Manual status";
		}

		$preData.="\nCheque Status:";
		if(isset($_POST['cheque_status']) && in_array($_POST['cheque_status'],array('inprocess','pending','bounced','paid')))
		{
			$query1->where("t.status",$_POST['cheque_status']);
			$preData.=$_POST['cheque_status'];
		}
		else
		{
			$preData.=" All Cheque status";
		}

		$preData.="\nForeign Tx:";
		if(isset($_POST['foreign_trans']) && is_numeric($_POST['foreign_trans']) && in_array($_POST['foreign_trans'],array(0,1)))
		{
			if($_POST['foreign_trans']==1)
			{
				$query1->where("t.is_foreign_payment",$_POST['foreign_trans']);
				$preData.=" Yes";
			}
			else if($_POST['foreign_trans']==0)
			{
				$query1->where("t.is_foreign_payment",$_POST['foreign_trans']);
				$preData.=" No";
			}
		}
		else
		{
			$preData.=" All Foreign status";
		}
		$preData.="\nOffline Tx:";
		if(isset($_POST['offline_trans']) && is_numeric($_POST['offline_trans']) && in_array($_POST['offline_trans'],array(0,1)))
		{
			if($_POST['offline_trans']==1)
			{
				$query1->where_in("t.payment_mode",array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc'));
				$preData.=" Yes";
			}
			else if($_POST['offline_trans']==0)
			{
				$query1->where_in("t.payment_mode",array('paypal','razorpay','payu','authorize.net','stripe'));
				$preData.=" No";
			}
		}
		else
		{
			$preData.=" All Offline status";
		}


		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('t.modified_on',$_POST['dir']);
				else
					$query1->order_by('t.modified_on',"desc");
			}
			$sql=$query1->get_compiled_select();
			
			$requestResp=$this->excel_exports_model->makeRequest('default',"model","orders/transaction_model",$sql,$this->currentUser,'default',$_POST,"All Offline/Manual Transactions",$preData,5);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('modified_on',$dir);
		}
		else
		{
			$query1->order_by('modified_on',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$query1->group_by("tx");
		$query1->order_by("id","desc");
		$rtn['data']=$query1->get()->result_array();
		
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['started_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['started_on']));
			$rtn['data'][$c]['modified_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['modified_on']));
			$rtn['data'][$c]['note']=nl2br($rtn['data'][$c]['note']);
			$tx_details="";
			if($row['created_on'])
			$rtn['data'][$c]['created_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['created_on']));
			else
				$rtn['data'][$c]['created_on']='NA';
			if(preg_grep('/'.$row['status'].'/i', array('failure','aborted','failed','user cancelled')))
				$rtn['data'][$c]['trans_status']=0;

			if(preg_grep('/'.$row['status'].'/i', array('completed','approved','success','paid','captured')))
				$rtn['data'][$c]['trans_status']=1;

			if(in_array($row['status'],array('initiated')))
				$rtn['data'][$c]['trans_status']=2;

			$rtn['data'][$c]['amount_num']=abs($row['amount']);
			if(empty($row['amount']))
			{
				$row['amount']=0;
			}
			if($row['is_manual_payment'] == 1)
			{
				if($row['manual_receipt_date'])
					$rec_date = date("d M Y",strtotime($row['manual_receipt_date']));
				else
					$rec_date = "N/A";

				$tx_details="<span style='color:red; font-weight:bold;'>Manual TX:</span> Yes<br>"."<span style='color:red; font-weight:bold;'>Reciept No:</span><br> ".$row['manual_receipt_number']."<br>"."<span style='color:red; font-weight:bold;'>Reciept Date:</span><br> ".$rec_date."<br>";
			}
			if($row['payment_mode'] != "paypal" && $row['payment_mode'] != "payu" && $row['payment_mode'] != "razorpay")
			{
				if($row['payment_mode'] == "cheque")
				{
					if($row['offline_date'])
						$offline_date = date("d M Y h:i A",strtotime($row['offline_date']));
					else
						$offline_date = "N/A";

					$tx_details.="<span style='color:red; font-weight:bold;'>Cheque No:</span><br> ".$row['offline_number']."<br>"."<span style='color:red; font-weight:bold;'>Cheque Date:</span><br> ".$offline_date."<br>". "<span style='color:red; font-weight:bold;'>Bank:</span><br> ".$row['offline_bank'];
				}
				if($row['payment_mode'] == "dd")
				{
					if($row['offline_date'])
						$offline_date = date("d M Y h:i A",strtotime($row['offline_date']));
					else
						$offline_date = "N/A";

					$tx_details.="<span style='color:red; font-weight:bold;'>DD No:</span><br> ".$row['offline_number']."<br>"."<span style='color:red; font-weight:bold;'>DD Date:</span><br> ".$offline_date."<br>". "<span style='color:red; font-weight:bold;'>Bank:</span><br> ".$row['offline_bank'];
				}
				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "mo" )
				{
					if($row['offline_date'])
						$offline_date = date("d M Y h:i A",strtotime($row['offline_date']));
					else
						$offline_date = "N/A";

					$tx_details.="<span style='color:red; font-weight:bold;'>MO No:</span><br> ".$row['offline_number']."<br>"."<span style='color:red; font-weight:bold;'>MO Date:</span><br> ".$offline_date;
				}
				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "cc" )
				{
					if($row['offline_date'])
						$offline_date = date("d M Y h:i A",strtotime($row['offline_date']));
					else
						$offline_date = "N/A";

					$tx_details.="<span style='color:red; font-weight:bold;'>Last 4 Digits Of Card:</span><br> ".$row['cardnum']."<br>"."<span style='color:red; font-weight:bold;'>CC Date:</span><br> ".$offline_date."<br>"."<span style='color:red; font-weight:bold;'>Bank Name:</span><br> ".$row['offline_bank'];
				}

				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "dc" )
				{
					if($row['offline_date'])
						$offline_date = date("d M Y h:i A",strtotime($row['offline_date']));
					else
						$offline_date = "N/A";

					$tx_details.="<span style='color:red; font-weight:bold;'>Last 4 Digits Of Card:</span><br> ".$row['cardnum']."<br>"."<span style='color:red; font-weight:bold;'>DC Date:</span><br> ".$offline_date."<br>"."<span style='color:red; font-weight:bold;'>Bank Name:</span><br> ".$row['offline_bank'];
				}

				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "cashiers_check" )
				{
					if($row['offline_date'])
						$offline_date = date("d M Y h:i A",strtotime($row['offline_date']));
					else
						$offline_date = "N/A";

					$tx_details.="<span style='color:red; font-weight:bold;'>Cheque No:</span><br> ".$row['offline_number']."<br>"."<span style='color:red; font-weight:bold;'>Cheque Date:</span><br> ".$offline_date."<br>". "<span style='color:red; font-weight:bold;'>Bank:</span><br> ".$row['offline_bank'];
				}

				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "neft" )
				{
					if($row['offline_date'])
						$offline_date = date("d M Y h:i A",strtotime($row['offline_date']));
					else
						$offline_date = "N/A";

					$tx_details.="<span style='color:red; font-weight:bold;'>NEFT/IMPS Ref. No:</span><br> ".$row['offline_number']."<br>"."<span style='color:red; font-weight:bold;'>Date:</span><br> ".$offline_date."<br>". "<span style='color:red; font-weight:bold;'>Bank:</span><br> ".$row['offline_bank'];
				}
			}
			if($row['currency']=='usd')
				$rtn['data'][$c]['amount']="<span style='color:red; font-weight:bold;'>".strtoupper($row['currency'])." ".$row['amount']."</span>";
			else
				$rtn['data'][$c]['amount']="<span style='font-weight:bold;'>".strtoupper($row['currency'])." ".$row['amount']."</span>";

			$rtn['data'][$c]['username'] = $row['username'];
			$rtn['data'][$c]['user_id'] = $row['userid'];
			$rtn['data'][$c]['firstname']=$row['firstname']." ".$row['lastname']."<br>".
											$row['city']."<br>".
											$row['state'].", ".$row['country']."<br>".
											"<span style='font-weight:bold;'>".$row['email']."</span><br>".
											"<span style='font-weight:bold; color:red;'>+".$row['country_isd_code']." ".$row['phone']."</span>";
			
			if($rtn['data'][$c]['note'] == "" && $tx_details == "")
			{
				$tx_details = "N/A";
				$rtn['data'][$c]['note'] = "N/A";
			}
			if($rtn['data'][$c]['note'] != "" && $tx_details == "")
			{
				$tx_details= nl2br($rtn['data'][$c]['note']);
			}
			$rtn['data'][$c]['tx_details'] = $tx_details;
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function getorderPayments($order_id,$refund_amount)
	{
		$q = $this->db->select("*")->from("transaction")->where("order_id",$order_id)->where("system_generated",0)->where_in("status",array("completed",'success','release payment','Release Payment','approved','captured','cash_pending','paid'))->order_by("id","desc")->get();
		if($q->num_rows() > 0)
		{
			$r = $q->result_array();
			{
				foreach ($r as $key => $value) 
				{
					$Remaining_amount = $value["amount"] - $value["refunded_amount"];
					$contans = 0;
					if($Remaining_amount >= $refund_amount)
					{
						$contans = 1;
						$q = $this->db->select("*")->from("transaction")->where("id",$value["id"])->get();
						if($q->num_rows() > 0)
						{
							$r = $q->row();
							return $r;
						}
					}
				}
			}
		}
		return false;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->poojasExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==3)
		{
			$objPHPExcel=$this->donationsExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==4)
		{
			$objPHPExcel=$this->poojasPrasadamExcelReportAdmin($excelData,$objPHPExcel);
			//$objPHPExcel=$this->poojasPrasadamExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		if($excelData->page_number==5)
		{
			$objPHPExcel=$this->ManualTxexcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		if($excelData->page_number==6)
		{
			$objPHPExcel=$this->AllTransactionsTxexcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		if($excelData->page_number==7)
		{
			$objPHPExcel=$this->sevasTallyReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		if($excelData->page_number==8)
		{
			$objPHPExcel=$this->subscriptionsTallyReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		if($excelData->page_number==9)
		{
			$objPHPExcel=$this->AllTransactionReconciliationReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Created Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Started Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$trans_status=0;
			if(preg_grep('/'.$reportrow->status.'/i', array('failure','aborted','failed','user cancelled', 'refund', 'bounced')))
				$trans_status=0;

			if(preg_grep('/'.$reportrow->status.'/i', array('completed','approved','success', 'paid', 'captured')))
				$trans_status=1;

			if(in_array($reportrow->status,array('initiated', 'inprocess', 'pending')))
				$trans_status=2;

			$alpha="A";
			if($trans_status==0)
				$objPHPExcel->getActiveSheet()->getStyle($i)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFCECE');
			if($trans_status==2)
				$objPHPExcel->getActiveSheet()->getStyle($i)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FAF67D');
			$txnote = "";
			if($reportrow->note != "")
			{
				$txnote = nl2br($reportrow->note);
				$txnote = strip_tags($txnote);
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);

			if($reportrow->created_on)
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');

			$amountalpha=$alpha++;
			if($reportrow->currency=='usd')
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			}
			else
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($amountalpha.$i,strtoupper($reportrow->currency)." ".$reportrow->amount);
			$objPHPExcel->getActiveSheet()->getStyle($amountalpha.$i)->applyFromArray($styleArray);

			$txidalpha=$alpha++;
			$styleArray = array(
		    	'font'  => array(
		        'bold'  => true
		    ));
			$objPHPExcel->getActiveSheet()->SetCellValue($txidalpha.$i,$reportrow->tx);
			$objPHPExcel->getActiveSheet()->getStyle($txidalpha.$i)->applyFromArray($styleArray);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->order_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,base_url."orders/view/".$reportrow->order_id);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->started_on)));
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);

			$emailalpha=$alpha++;
			$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			$objPHPExcel->getActiveSheet()->SetCellValue($emailalpha.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->getStyle($emailalpha.$i)->applyFromArray($styleArray);
			$phonealpha=$alpha++;
			$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			$objPHPExcel->getActiveSheet()->SetCellValue($phonealpha.$i,"+".$reportrow->country_isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);
			$objPHPExcel->getActiveSheet()->getStyle($phonealpha.$i)->applyFromArray($styleArray);

			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$txnote);
			


			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	/**
	 * listAdminOfflineTrans
	 * @param 		[var] $excelData [ExcelData]
	 * @param 		[var] $objPHPExcel ExcelObject
	 * @return 		var
	 * @version   	1.1 [27 June 2019]
	 * @author    	Baji Shaik <bajidotwork@gmail.com>
	 */
	public function ManualTxexcelReportAdmin($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);
		
		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		//echo $_POST['offline_trans'];exit();
		if($_POST['payment_mode'] == "cashiers_check" || $_POST['payment_mode'] == "dd" || $_POST['payment_mode'] == "cc" || $_POST['payment_mode'] == "dc" || $_POST['payment_mode'] == "cheque" || $_POST['payment_mode'] == "cash" || $_POST['payment_mode'] == "mo" || $_POST['payment_mode'] == "neft")
		{
			if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "cheque" )
			{
				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cheque No");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cheque Date");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			}

			if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "dd" )
			{
				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"DD No");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"DD Date");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			}

			if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "mo" )
			{
				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"MO No");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"MO Date");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			}

			if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "cc" )
			{
				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last 4 Digits of Card");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			}

			if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "dc" )
			{
				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last 4 Digits of Card");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
				
				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
			}

			if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "cashiers_check" )
			{
				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"CC Number");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"CC Date");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
			}

			if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "neft" )
			{
				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"NEFT/IMPS Ref. No");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

				$alpha++;
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
				$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
			}
		}
		else
		{
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cheque No");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cheque Date");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"DD No");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"DD Date");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"MO No");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"MO Date");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last 4 Digits of Card(CC)");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
			
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last 4 Digits of Card(DC)");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
			
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
			
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"CC Number");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"CC Date");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"NEFT/IMPS Ref. No");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bank Name");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		}

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Processed");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Is Manual Transaction");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if(isset($_POST['manual_trans']) && $_POST['manual_trans'] != "")
		{
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Reciept No");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Reciept Date");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		}

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Is Foreign Transaction");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		if(isset($_POST['foreign_trans']) && $_POST['foreign_trans'] != "")
		{
			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Foreign Currency");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Foreign Amount");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

			$alpha++;
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Realized Amount");
			$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		}

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Is Offline Transaction");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Initiated");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Modified");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$trans_status=0;
			if(preg_grep('/'.$reportrow->status.'/i', array('failure','aborted','failed','user cancelled')))
				$trans_status=0;

			if(preg_grep('/'.$reportrow->status.'/i', array('completed','approved','success')))
				$trans_status=1;

			if(in_array($reportrow->status,array('initiated')))
				$trans_status=2;

			$alpha="A";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->tx);

			$amountalpha=$alpha++;

			if($reportrow->currency=='usd')
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			}
			else
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($amountalpha.$i,strtoupper($reportrow->currency)." ".$reportrow->amount);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			if($_POST['payment_mode'] == "cashiers_check" || $_POST['payment_mode'] == "dd" || $_POST['payment_mode'] == "cc" || $_POST['payment_mode'] == "dc" || $_POST['payment_mode'] == "cheque" || $_POST['payment_mode'] == "cash" || $_POST['payment_mode'] == "mo" || $_POST['payment_mode'] == "neft")
			{
				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "cheque" )
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_number);
					if($reportrow->offline_date)
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->offline_date)));
					else
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_bank);
				}

				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "dd" )
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_number);
					if($reportrow->offline_date)
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->offline_date)));
					else
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_bank);
				}

				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "mo" )
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_number);
					if($reportrow->offline_date)
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->offline_date)));
					else
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
				}

				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "cc" )
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cardnum);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_bank);
				}

				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "dc" )
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cardnum);
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_bank);
				}

				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "cashiers_check" )
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_number);
					if($reportrow->offline_date)
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->offline_date)));
					else
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_bank);
				}

				if(isset($_POST['payment_mode']) && $_POST['payment_mode'] != "" && $_POST['payment_mode'] == "neft" )
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_number);
					if($reportrow->offline_date)
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->offline_date)));
					else
						$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_bank);
				}
			}
			else
			{
				$cheque_no = "";
				$cashiers_check_no = "";
				$dd_no = "";
				$mo_no = "";
				$bank_cheque = "";
				$cashiers_check_bank = "";
				$mo_bank = "";
				$dd_bank = "";
				$cheque_date = "";
				$dd_date = "";
				$mo_date = "";
				$cashiers_check_date = "";
				$cc_crad_num = "";
				$cc_bank = "";
				$dc_bank = "";
				$dc_card_num = "";
				$neft_no = "";
				$neft_bank = "";
				$neft_date = "";
				if($reportrow->payment_mode == "cheque")
				{
					$cheque_no = $reportrow->offline_number;
					$bank_cheque = $reportrow->offline_bank;
					$cheque_date = $reportrow->offline_date;
				}
				if($reportrow->payment_mode == "cashiers_check")
				{
					$cashiers_check_no = $reportrow->offline_number;
					$cashiers_check_bank = $reportrow->offline_bank;
					$cashiers_check_date = $reportrow->offline_date;
				}
				if($reportrow->payment_mode == "mo")
				{
					$mo_no = $reportrow->offline_number;
					$mo_bank = $reportrow->offline_bank;
					$mo_date = $reportrow->offline_date;
				}
				if($reportrow->payment_mode == "dd")
				{
					$dd_no = $reportrow->offline_number;
					$dd_bank = $reportrow->offline_bank;
					$dd_date = $reportrow->offline_date;
				}
				if($reportrow->payment_mode == "cc")
				{
					$cc_crad_num = $reportrow->offline_number;
					$cc_bank = $reportrow->offline_bank;
				}
				if($reportrow->payment_mode == "dc")
				{
					$dc_card_num = $reportrow->offline_number;
					$dc_bank = $reportrow->offline_bank;
				}
				if($reportrow->payment_mode == "neft")
				{
					$neft_no = $reportrow->offline_number;
					$neft_bank = $reportrow->offline_bank;
					$neft_date = $reportrow->offline_date;
				}


				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$cheque_no);
				if($cheque_date)
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($cheque_date)));
				else
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');

				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$bank_cheque);
				
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$dd_no);
				if($dd_date)
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($dd_date)));
				else
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$dd_bank);

				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$mo_no);
				if($mo_date)
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($mo_date)));
				else
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');

				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$dc_card_num);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$dc_bank);

				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$cc_crad_num);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$cc_bank);

				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$cashiers_check_no);
				if($cashiers_check_date)
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($cashiers_check_date)));
				else
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$cashiers_check_bank);

				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$neft_no);
				if($neft_date)
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($neft_date)));
				else
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$neft_bank);
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strip_tags($reportrow->note));
			if($reportrow->created_on)
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->status);

			$reportrow->manual_trans = "No";
			if($reportrow->is_manual_payment == "1")
			{
				$reportrow->manual_trans = "Yes";
			}
			$reportrow->foreign_trans = "No";
			if($reportrow->is_foreign_payment == "1")
			{
				$reportrow->foreign_trans = "Yes";
			}
			/*$reportrow->offline_trans = "No";
			if($reportrow->offline_number != "")
			{
				$reportrow->offline_trans = "Yes";
			}*/
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->manual_trans);

			if(isset($_POST['manual_trans']) && $_POST['manual_trans'] != "")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->manual_receipt_number);
				if($reportrow->manual_receipt_date)
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->manual_receipt_date)));
				else
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->foreign_trans);

			if(isset($_POST['foreign_trans']) && $_POST['foreign_trans'] != "")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->foreign_currency);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->foreign_amount);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->realized_amount);
			}

			if(in_array($reportrow->payment_mode, array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc')))
			{
				$offlne_trans_mode = "Yes";
			}
			else
			{
				$offlne_trans_mode = "No";
			}

			// if($_POST['offline_trans']==1)
			// {
			// 	$query1->where_in("t.payment_mode",array('cash','cashiers_check','cheque','dd','mo','neft','rtgs','cc','dc'));
			// 	$preData.=" Yes";
			// }
			// else if($_POST['offline_trans']==0)
			// {
			// 	$query1->where_not_in("t.payment_mode",array('paypal','razorpay','payu','authorize.net','stripe'));
			// 	$preData.=" No";
			// }

			//$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->offline_trans);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$offlne_trans_mode);
			
			if($trans_status==1)
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,base_url."orders/view/".$reportrow->order_id);
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->started_on)));
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->modified_on)));
			$emailalpha=$alpha++;
			$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			$objPHPExcel->getActiveSheet()->SetCellValue($emailalpha.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->getStyle($emailalpha.$i)->applyFromArray($styleArray);
			$phonealpha=$alpha++;
			$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			$objPHPExcel->getActiveSheet()->SetCellValue($phonealpha.$i,"+".$reportrow->country_isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->getStyle($phonealpha.$i)->applyFromArray($styleArray);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
			
			$objPHPExcel->getActiveSheet()->getStyle($amountalpha.$i)->applyFromArray($styleArray);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function getTransactionsByOrder($orderId,$subscriptions_include=0,$flag=0,$api=0)
    {
    	if($api==1)
    	{
    		$this->db->select("
    						id
    						,tx
    						,ashram_id
    						,status
    						,amount
    						,currency
    						,subscription
    						,subscription_payment_id
    						,date
    						,note
    						,created_on
    						,payment_mode
    						,system_generated
    						,flag

						");
    	}
    	else
    	{
    		$this->db->select("
							case when t.tx='' then t2.tx else t.tx end as tx
							,t2.id as t2id
							,case when t.order_item_id='' or t.order_item_id is null then null else t.order_item_id end as order_item_id
							,t.order_id as order_id
							,case when t2.note='' or t2.note is null then t.note else t2.note end as note
							,case when t2.started_on='' or t2.started_on is null then t.started_on else t2.started_on end as date
							,case when t2.status='' or t2.status is null then t.status else t2.status end as status
							,t.amount as amount
							,case when t2.payment_mode='' or t2.payment_mode is null then t.payment_mode else t2.payment_mode end as payment_mode
							,t.id as id
							,t2.status as tx_status
							,t2.system_generated
							,case when t2.created_on='' or t2.created_on is null then t.created_on else t2.created_on end as created_on
							,t.sub_tx as sub_tx
							,t2.amount as t2amount
							,t.sub_transaction as sub_transaction
							,t.currency as currency
							,case when t2.flag='' or t2.flag is null then t.flag else t2.flag end as flag
							,case when t2.tx='' or t2.tx is null then t.tx else t2.tx end as t2tx
							,t.subscription as subscription
							,case when t2.ip_address='' or t2.ip_address is null then t.ip_address else t2.ip_address end as ip_address
							,t.firstname as firstname
							,t.lastname as lastname
							,case when t2.is_manual_payment='' or t2.is_manual_payment is null then t.is_manual_payment else t2.is_manual_payment end as is_manual_payment
							,case when t2.manual_receipt_number='' or t2.manual_receipt_number is null then t.manual_receipt_number else t2.manual_receipt_number end as manual_receipt_number
							,case when t2.manual_receipt_date='' or t2.manual_receipt_date is null then t.manual_receipt_date else t2.manual_receipt_date end as manual_receipt_date
							,case when t2.offline_number='' or t2.offline_number is null then t.offline_number else t2.offline_number end as offline_number
							,case when t2.offline_date='' or t2.offline_date is null then t.offline_date else t2.offline_date end as offline_date
							,case when t2.offline_bank='' or t2.offline_bank is null then t.offline_bank else t2.offline_bank end as offline_bank
							,case when t2.is_foreign_payment='' or t2.is_foreign_payment is null then t.is_foreign_payment else t2.is_foreign_payment end as is_foreign_payment
							,case when t2.foreign_currency='' or t2.foreign_currency is null then t.foreign_currency else t2.foreign_currency end as foreign_currency
							,case when t2.foreign_amount='' or t2.foreign_amount is null then t.foreign_amount else t2.foreign_amount end as foreign_amount
							,case when t2.realized_amount='' or t2.realized_amount is null then t.realized_amount else t2.realized_amount end as realized_amount
							,case when t2.refund_mode='' or t2.refund_mode is null then t.refund_mode else t2.refund_mode end as refund_mode
							,case when t2.refund_reference='' or t2.refund_reference is null then t.refund_reference else t2.refund_reference end as refund_reference
							,case when t2.refund_date='' or t2.refund_date is null then t.refund_date else t2.refund_date end as refund_date
						");
    	}

    	$this->db->from("transaction as t");
		$this->db->where("t.order_id",$orderId);
		if($flag==1 || $flag==0)
			$this->db->where("t.flag",$flag);

		$this->db->order_by("t.created_on","desc");
		$this->db->join("onetime_payments_transaction_map as optm","optm.tx_id=t.id","left");
		$this->db->join("transaction as t2","t2.tx=optm.tx","left");
		if($subscriptions_include==0)
		{
			$this->db->where("t.subscription",0);
		}
		$transaction=$this->db->get();
		return $transaction->result();
    }

    public function getTransactionsByOrderAlt($orderId,$subscriptions_include=0,$flag=0)
    {
		$this->db->select("
						case when t.tx='' then t2.tx else t.tx end as tx
						,t2.id as t2id
						,case when t.order_item_id='' or t.order_item_id is null then null else t.order_item_id end as order_item_id
						,t.order_id as order_id
						,case when t2.note='' or t2.note is null then t.note else t2.note end as note
						,case when t2.started_on='' or t2.started_on is null then t.started_on else t2.started_on end as date
						,case when t2.status='' or t2.status is null then t.status else t2.status end as status
						,t.amount as amount
						,case when t2.payment_mode='' or t2.payment_mode is null then t.payment_mode else t2.payment_mode end as payment_mode
						,t.id as id
						,t2.status as tx_status
						,case when t2.created_on='' or t2.created_on is null then t.created_on else t2.created_on end as created_on
						,t.sub_tx as sub_tx
						,t.sub_transaction as sub_transaction
						,t.currency as currency
						,case when t2.flag='' or t2.flag is null then t.flag else t2.flag end as flag
						,t2.tx as t2tx
						,t.subscription as subscription
						,t2.payment_mode as pm
						,t2.amount as t2amount
						,case when t2.ip_address='' or t2.ip_address is null then t.ip_address else t2.ip_address end as ip_address
						,t.firstname as firstname
						,t.lastname as lastname
						,case when t2.is_manual_payment='' or t2.is_manual_payment is null then t.is_manual_payment else t2.is_manual_payment end as is_manual_payment
						,case when t2.manual_receipt_number='' or t2.manual_receipt_number is null then t.manual_receipt_number else t2.manual_receipt_number end as manual_receipt_number
						,case when t2.manual_receipt_date='' or t2.manual_receipt_date is null then t.manual_receipt_date else t2.manual_receipt_date end as manual_receipt_date
						,case when t2.offline_number='' or t2.offline_number is null then t.offline_number else t2.offline_number end as offline_number
						,case when t2.offline_date='' or t2.offline_date is null then t.offline_date else t2.offline_date end as offline_date
						,case when t2.offline_bank='' or t2.offline_bank is null then t.offline_bank else t2.offline_bank end as offline_bank
						,case when t2.is_foreign_payment='' or t2.is_foreign_payment is null then t.is_foreign_payment else t2.is_foreign_payment end as is_foreign_payment
						,case when t2.foreign_currency='' or t2.foreign_currency is null then t.foreign_currency else t2.foreign_currency end as foreign_currency
						,case when t2.foreign_amount='' or t2.foreign_amount is null then t.foreign_amount else t2.foreign_amount end as foreign_amount
						,case when t2.realized_amount='' or t2.realized_amount is null then t.realized_amount else t2.realized_amount end as realized_amount
						,case when t2.refund_mode='' or t2.refund_mode is null then t.refund_mode else t2.refund_mode end as refund_mode
						,case when t2.refund_reference='' or t2.refund_reference is null then t.refund_reference else t2.refund_reference end as refund_reference
						,case when t2.refund_date='' or t2.refund_date is null then t.refund_date else t2.refund_date end as refund_date
						,t.declaration_type
						,t.declaration_template
						,t.system_generated
					");

    	$this->db->from("transaction as t");
		$this->db->where("t.order_id",$orderId);
		if($flag==1 || $flag==0)
			$this->db->where("t.flag",$flag);

		$this->db->group_start();
			$this->db->group_start();
				$this->db->where("optm.tx_id !=",null);
				$this->db->where("optm.flag",0);
			$this->db->group_end();
			$this->db->or_group_start();
				$this->db->where("optm.tx_id",null);
			$this->db->group_end();
		$this->db->group_end();
		$this->db->order_by("t2.id","desc");
		$this->db->join("onetime_payments_transaction_map as optm","optm.tx_id=t.id","left");
		$this->db->join("transaction as t2","t2.tx=optm.tx","left");
		//$this->db->limit("1");
		//$this->db->group_by("t.tx");
		if($subscriptions_include==0)
		{
			$this->db->where("t.subscription",0);
		}
		$transaction=$this->db->get();
		return $transaction->result();
    }

    public function getTransactionsByOrderItem($orderItemId,$subscriptions_include=0,$flag=0,$api=0)
    {
    	if($api==1)
    	$this->db->select("
    						id
    						,tx
    						,ashram_id
    						,status
    						,amount
    						,currency
    						,subscription
    						,subscription_payment_id
    						,date
    						,note
    						,created_on
    						,payment_mode
    						,flag

						");
		$this->db->where("order_item_id",$orderItemId);
		$this->db->where("amount >",0);
		/*if($flag==1 || $flag==0)
			$this->db->where("flag",$flag);*/

		$this->db->order_by("created_on","desc");
		if($subscriptions_include==0)
		{
			$this->db->where("subscription",0);
		}
		$transaction=$this->db->get("transaction");
		return $transaction->result();
    }

    public function getTransactionIdsByOrder($orderId,$subscriptions_include=0,$flag=0,$api=0)
    {
    	$this->db->select("group_concat(tx) as txids");
		$this->db->where("order_id",$orderId);
		if($flag==1 || $flag==0)
			$this->db->where("flag",$flag);

		$this->db->order_by("created_on","desc");
		if($subscriptions_include==0)
		{
			$this->db->where("subscription",0);
		}
		$transaction=$this->db->get("transaction");
		return $transaction->row()->txids;
    }

    public function getTransactionByID($id)
    {
		$this->db->where("id",$id);
		$transaction=$this->db->get("transaction");
		return $transaction->row();
    }
    public function getTransactionByTx($tx)
    {
		$this->db->where("tx",$tx);
		$transaction=$this->db->get("transaction");
		$txrow=$transaction->row();

		if(empty($txrow))
			return array();

		if($txrow->sub_transaction==1)
		{
			$this->db->select("
								*
								,t2.amount as amount
								,t2.id as id
							");
			$this->db->from("transaction as t");
			$this->db->join("transaction as t2","t.tx=t2.sub_tx");
			$this->db->where("t.tx",$txrow->sub_tx);
			$this->db->where("t2.tx",$tx);

			$transaction=$this->db->get();
			$txrow=$transaction->row();
		}
		return $txrow;
    }
    public function update($id,$status,$note,$paymentMode)
    {
    	$txData=$this->getTransactionByID($id);

    	if($txData->payment_mode=='cheque' && ($txData->status=='inprocess' || $txData->status=='paid'))
		{
			$paymentMode='cheque';
		}

		//Conditions for CHEQUE
		if($paymentMode=='cheque')
		{
			if($txData->status=='pending' || $txData->status=='cash_pending' || $txData->status=='bounced' || $txData->status=='refund') // If pending or bounced
			{
				if($status!='inprocess') //Allow only inprocess status
				{
					return 0;
				}
			}
			if($txData->status=='inprocess')
			{
				if($status!='paid' && $status!='bounced') //Allow only paid and bounced status
				{
					return 0;
				}
			}
			if($txData->status=='paid')
			{
				if($status!='bounced' && $status!='refund') //Allow only bounced and refund status
				{
					return 0;
				}
			}
		}
		else //Remaining all payment modes
		{
			if($txData->status=='pending' || $txData->status=='cash_pending' || $txData->status=='bounced' || $txData->status=='refund') //Allow from pending and bounced
			{
				if($status!='paid') //Allow only paid status
				{
					return 0;
				}
			}
			else if(in_array($txData->status,$this->payment_success_statuses))
			{
				if($status!='refund') //Allow only refund status
				{
					return 0;
				}
			}
			else //Dont allow for any other existing statuses
			{
				return 0;
			}
		}

		$is_manual_payment=0;
		$is_foreign_payment=0;
		$orderData=$this->orders_model->orderData($txData->order_id);
		if(($txData->status!='pending' && $txData->status!='cash_pending') && 
			(($paymentMode=='cheque' && $status=='inprocess') || ($paymentMode!='cheque' && $status=='paid')))
		{
			//Create transaction and attach
			// $txnote="<b>".date("d M Y h:i A")."</b> (".$status.")\n".$note;
			$txnote="<b>".date("d M Y h:i A")."</b> (".$status.")\n".$note;
			$txid=$this->transaction_model->createCashTransaction($orderData,$txData->amount,$paymentMode,$txnote);
			//$this->updateDetails($txid,array("status"=>$status));

			$this->updateDetails($txid,
								array(
										'status'=>$status,
										"is_manual_payment"=>empty($this->input->post("is_manual_payment"))?0:$this->input->post("is_manual_payment"),
										"is_foreign_payment"=>empty($this->input->post("is_foreign_payment"))?0:$this->input->post("is_foreign_payment"),
										"manual_receipt_number"=>empty($this->input->post("manual_receipt_number"))?null:$this->input->post("manual_receipt_number"),
										"manual_receipt_date"=>empty($this->input->post("manual_receipt_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("manual_receipt_date"))),
										"offline_number"=>empty($this->input->post("offline_number"))?null:$this->input->post("offline_number"),
										"offline_bank"=>empty($this->input->post("offline_bank"))?null:$this->input->post("offline_bank"),
										"offline_date"=>empty($this->input->post("offline_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("offline_date"))),
										"foreign_currency"=>empty($this->input->post("foreign_currency"))?0:$this->input->post("foreign_currency"),
										"foreign_amount"=>empty($this->input->post("foreign_amount"))?0:$this->input->post("foreign_amount"),
										"realized_amount"=>empty($this->input->post("realized_amount"))?0:$this->input->post("realized_amount"),
										"order_item_id"=>$txData->order_item_id?$txData->order_item_id:0
									));
			if(!empty($this->input->post("is_manual_payment")))
				$is_manual_payment=1;
			if(!empty($this->input->post("is_foreign_payment")))
				$is_foreign_payment=1;

			$transaction_created=1;

			if($txData->sub_transaction==1)
			{
				$this->db->where("tx",$txData->sub_tx);
				$this->db->update($this->tableName,array(
										"flag"=>1
									));
			}
			else
			{
				$this->db->where("tx",$txData->tx);
				$this->db->update($this->tableName,array(
										"flag"=>1
								));
			}

			/*$updateData=array();
			$updateData['status']=$status;
			$updateData['sub_transaction']=1;
			$updateData['sub_tx']=$txid;
			$updateData['date']=date("Y:m:d H:i:s");
			$updateData['payment_mode']=$paymentMode;
			$updateData['note']=date("d M Y h:i A")."</b> (".$status.")\n".$note;

			$this->db->where("id",$id);
			$this->db->update("transaction",$updateData);*/

		}
		else
		{
			if(($paymentMode=='cheque' && $status=='inprocess') ||
				($paymentMode!='cheque' && $status=='paid'))
			{
				$txUpdateData=array(
									"status"=>$status,
									//"payment_mode"=>$paymentMode,
									"is_manual_payment"=>empty($this->input->post("is_manual_payment"))?0:$this->input->post("is_manual_payment"),
									"is_foreign_payment"=>empty($this->input->post("is_foreign_payment"))?0:$this->input->post("is_foreign_payment"),
									"manual_receipt_number"=>empty($this->input->post("manual_receipt_number"))?null:$this->input->post("manual_receipt_number"),
									"manual_receipt_date"=>empty($this->input->post("manual_receipt_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("manual_receipt_date"))),
									"offline_number"=>empty($this->input->post("offline_number"))?null:$this->input->post("offline_number"),
									"offline_bank"=>empty($this->input->post("offline_bank"))?null:$this->input->post("offline_bank"),
									"offline_date"=>empty($this->input->post("offline_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("offline_date"))),
									"foreign_currency"=>empty($this->input->post("foreign_currency"))?0:$this->input->post("foreign_currency"),
									"foreign_amount"=>empty($this->input->post("foreign_amount"))?0:$this->input->post("foreign_amount"),
									"realized_amount"=>empty($this->input->post("realized_amount"))?0:$this->input->post("realized_amount")
								);
			}
			else
			{
				$txUpdateData=array(
									"status"=>$status,
									"payment_mode"=>$paymentMode);
			}
			
			if($txData->sub_tx!='')
			{
				$txid=$txData->sub_tx;
			}
			else
			{
				$txid=$txData->tx;
			}

			if($status=='refund')
			{
				$txUpdateData['refund_reference']=empty($this->input->post("refund_reference"))?null:$this->input->post("refund_reference");
				$txUpdateData['refund_date']=empty($this->input->post("refund_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("refund_date")));
				$txUpdateData['refund_mode']=empty($this->input->post("refund_mode"))?null:$this->input->post("refund_mode");
			}

			$this->db->where("tx",$txid);
			$this->db->update($this->tableName,$txUpdateData);

			//$is_manual_payment=$txData->is_manual_payment;
			$orig_txdata=$this->getTransactionByTx($txid);
			$orig_note=$orig_txdata->note;
			if($orig_note!='') $orig_note.="\n\n";

			$is_manual_payment=$orig_txdata->is_manual_payment;

			$this->db->where("tx",$txid);
			$this->db->update($this->tableName,array(
									"status"=>$status,
									"note"=>$orig_note."<b>".date("d M Y h:i A")."</b> (".$status.")\n".$note,

									"payment_mode"=>$paymentMode
								));


			//=================Related transactions===============//
			if($txData->sub_tx!='')
			{
				$this->db->select("group_concat(id) as ids,order_id");
				$this->db->where("tx",$txData->sub_tx);
				$related_ids=array_filter(explode(",",$this->db->get("subscription_payments")->row()->ids));

				$this->db->select("group_concat(id) as ids,note,order_id");
				$this->db->where("sub_tx",$txData->sub_tx);
				$dbrow=$this->db->get("transaction")->row();
				$related_txids=array_filter(explode(",",$dbrow->ids));


				$updateData=array();
				if($status=='paid')
				{
					$updateData['status']=8;
				}
				if($status=='bounced')
				{
					$updateData['status']=102;
				}
				if($status=='inprocess')
				{
					$updateData['status']=101;
				}
				if($status=='refund')
				{
					$updateData['status']=103;
				}

				if(isset($related_ids) && !empty($related_ids) && $status!='inprocess')
				{
					$this->db->where_in("id",$related_ids);
					$this->db->update("subscription_payments",$updateData);
				}

				if(isset($related_txids) && !empty($related_txids) && $status!='inprocess')
				{
					$updateData=array();
					$updateData['status']=$status;
					$updateData['modified_on']=date("Y:m:d H:i:s");
					$updateData['payment_mode']=$paymentMode;
					$txnote=$dbrow->note."\n\n<b>".date("d M Y h:i A")."</b> (".$status.")\n".$note;
					$updateData['note']=$txnote;
					$this->db->where_in("id",$related_txids);
					$this->db->update("transaction",$updateData);
				}
			}
			//=================Related transactions===============//
		}

		foreach ($orderData['order_items'] as $item)
		{
			$this->orders_model->calculateOrderItemDue($txData->order_id,$item->id);
		}

		if($is_manual_payment==0)
		{
			if($txData->subscription==1)
			{
				$this->orders_model->sendTransactionStatusEmail($txData->order_id,$txData->order_item_id,$txid);
				$this->orders_model->sendTransactionStatusEmailBCC($txData->order_id,$txData->order_item_id,$txid);
			}
			else
			{
				if(in_array(strtolower($status),$this->payment_success_statuses))
				{
					$this->orders_model->sendTransactionReceiptEmail($txData->order_id,$txid);
					//$this->orders_model->sendTransactionReceiptEmailBcc($txData->order_id,$txid);
					$this->orders_model->sendTransactionStatusEmailOffline($txData->order_id,$txid,0);
					$this->orders_model->sendTransactionStatusEmailOfflineBCC($txData->order_id,$txid);
					$this->payment_model->populateTransactionReport($txid);
					$this->payment_model->updateOrderTotalPaid($txData->order_id,$txData->amount,$txid);
				}
				else
				{
					$this->orders_model->sendTransactionStatusEmailOffline($txData->order_id,$txid);
					$this->orders_model->sendTransactionStatusEmailOfflineBCC($txData->order_id,$txid);
				}
			}
		}

		return 1;
    }

    public function updateDetails($tx,$data)
    {
    	unset($data['note']);
		$this->db->where("tx",$tx);
		$this->db->update($this->tableName,$data);
    }

    public function setNote($tx,$note)
    {
		$this->db->where("tx",$tx);
		$this->db->update($this->tableName,array(
								"note"=>$note
							));
    }

	public function createCashTransaction($orderData,$amount,$payment_mode,$note='')
    {
    	$countryData=$this->locations_model->getCountryByCode($orderData['order']->country);

    	$payment_status='paid';
    	if($payment_mode=='cheque')
    		$payment_status='pending';

    	if(isset($_SERVER['REMOTE_ADDR']))
    		$remote_addr=$_SERVER['REMOTE_ADDR'];
    	else
    		$remote_addr="127.0.0.1";

    	/*if($remote_addr=='127.0.0.1')
    		$remote_addr=shell_exec("hostname -i");*/

		$order_declaration_type = 'Donation';
		$order_selected_template = '';
		if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
		{
			$order_declaration_type = trim($orderData['order']->declaration_type);
		}
		if(isset($orderData['order']->declaration_template) && $orderData['order']->declaration_template!='' && $order_declaration_type=='Gift')
		{
			$order_selected_template = trim($orderData['order']->declaration_template);
		}

    	$txnid=substr(hash('sha256', mt_rand() . microtime()), 0, 20);
    	$q=$this->db->insert('transaction',
					              array(
					              	'started_on' => date("Y:m:d H:i:s"),
					              	// 'date' => date("Y:m:d H:i:s"),
					                'tx' =>  $txnid,
					                'userid' =>$orderData['order']->user_id,
					                'status'=>$payment_status,
					                't_status'=>1,
									'order_id'=>$orderData['order']->id,
									'amount'=>$amount,
									'payment_mode'=>$payment_mode,
									'currency'=>$orderData['order']->currency,
									'created_on'=>date("Y:m:d H:i:s"),
									'ashram_id'=>$orderData['order']->ashram_id,
									'trust_id'=>$orderData['order']->trust_id,
									'firstname'=>$orderData['order']->firstname,
									'lastname'=>$orderData['order']->lastname,
									'city'=>$orderData['order']->city,
									'state'=>$orderData['order']->state,
									'country'=>$orderData['order']->country,
									'email'=>$orderData['order']->email,
									'phone'=>$orderData['order']->phone,
									'country_isd_code'=>$countryData->isd_code,
									'note'=>$note,
									'ip_address'=>$remote_addr,
									'declaration_type'=>$order_declaration_type,
									'declaration_template'=>$order_selected_template,
					              )
              				);

    	if($orderData['order']->id>0)
        {
        	$orderDetails=$this->orders_model->orderData($orderData['order']->id);
        	if(isset($orderDetails['order']->partial_payments_allowed) && $orderDetails['order']->partial_payments_allowed!='')
            {
                $tData['tx_partial_payments_allowed'] = $orderDetails['order']->partial_payments_allowed;
            }
            if(isset($orderDetails['order']->order_number) && $orderDetails['order']->order_number!='')
            {
                $tData['tx_order_number'] = $orderDetails['order']->order_number;
            }
            if(isset($orderDetails['order']->order_type) && $orderDetails['order']->order_type!='')
            {
                $tData['tx_order_type'] = $orderDetails['order']->order_type;
            }
            if(isset($orderDetails['order']->date) && $orderDetails['order']->date!='')
            {
                $tData['tx_order_date'] = date('Y-m-d', strtotime($orderDetails['order']->date));
            }
            if(isset($orderDetails['order']->username) && $orderDetails['order']->username!='')
            {
                $tData['tx_username'] = $orderDetails['order']->username;
            }
            $this->load->model("user/users_model");
            $userDetails = $this->users_model->userData($orderDetails['order']->user_id);
            if(isset($orderDetails['order']->order_pan_number) && $orderDetails['order']->order_pan_number!='')
            {
                $tData['tx_pan_number'] = $orderDetails['order']->order_pan_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->pan_number) && $userDetails->pan_number!='')
                {
                    $tData['tx_pan_number'] = $userDetails->pan_number;
                }
            }
            if(isset($orderDetails['order']->order_aadhaar_number) && $orderDetails['order']->order_aadhaar_number!='')
            {
                $tData['tx_aadhaar_number'] = $orderDetails['order']->order_aadhaar_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->aadhaar_number) && $userDetails->aadhaar_number!='')
                {
                    $tData['tx_aadhaar_number'] = $userDetails->aadhaar_number;
                }
            }
            if(isset($orderDetails['order']->order_tin_number) && $orderDetails['order']->order_tin_number!='')
            {
                $tData['tx_tin_number'] = $orderDetails['order']->order_tin_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->tin_number) && $userDetails->tin_number!='')
                {
                    $tData['tx_tin_number'] = $userDetails->tin_number;
                }
            }
            if(isset($orderDetails['order']->order_passport_number) && $orderDetails['order']->order_passport_number!='')
            {
                $tData['tx_passport_number'] = $orderDetails['order']->order_passport_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->passport_number) && $userDetails->passport_number!='')
                {
                    $tData['tx_passport_number'] = $userDetails->passport_number;
                }
            }
            if(isset($orderDetails['order']->order_voter_epic_number) && $orderDetails['order']->order_voter_epic_number!='')
            {
                $tData['tx_voter_epic_number'] = $orderDetails['order']->order_voter_epic_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->voter_epic_number) && $userDetails->voter_epic_number!='')
                {
                    $tData['tx_voter_epic_number'] = $userDetails->voter_epic_number;
                }
            }
            if(isset($orderDetails['order']->order_driving_license_number) && $orderDetails['order']->order_driving_license_number!='')
            {
                $tData['tx_driving_license_number'] = $orderDetails['order']->order_driving_license_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->driving_license_number) && $userDetails->driving_license_number!='')
                {
                    $tData['tx_driving_license_number'] = $userDetails->driving_license_number;
                }
            }
            if(isset($orderDetails['order']->order_ration_card_number) && $orderDetails['order']->order_ration_card_number!='')
            {
                $tData['tx_ration_card_number'] = $orderDetails['order']->order_ration_card_number;
            }
            else if(isset($orderDetails['order']->user_id) && $orderDetails['order']->user_id>0)
            {
                if(isset($userDetails->ration_card_number) && $userDetails->ration_card_number!='')
                {
                    $tData['tx_ration_card_number'] = $userDetails->ration_card_number;
                }
            }
            if(isset($orderDetails['order']->total_price) && $orderDetails['order']->total_price>0)
            {
                $tData['tx_order_total_price'] = $orderDetails['order']->total_price;
            }
            if(isset($orderDetails['order']->app) && $orderDetails['order']->app>0)
            {
                $tData['tx_app'] = $orderDetails['order']->app;
            }
            if(isset($orderDetails['order']->created_by) && $orderDetails['order']->created_by>0)
            {
                $tData['tx_created_by'] = $orderDetails['order']->created_by;
            }
            if(isset($orderDetails['order']->address1) && $orderDetails['order']->address1!='')
            {
                $tData['address1'] = $orderDetails['order']->address1;
            }
            if(isset($orderDetails['order']->address2) && $orderDetails['order']->address2!='')
            {
                $tData['address2'] = $orderDetails['order']->address2;
            }
            if(isset($orderDetails['order']->address3) && $orderDetails['order']->address3!='')
            {
                $tData['address3'] = $orderDetails['order']->address3;
            }
            if(isset($orderDetails['order']->zipcode) && $orderDetails['order']->zipcode!='')
            {
                $tData['zipcode'] = $orderDetails['order']->zipcode;
            }

            $this->db->where("tx",$txnid);
			$this->db->update("transaction",$tData);
        }


    	return $txnid;
    }
    
    public function deleteCashTransaction($orderId)
    {
    	$this->db->where("order_id",$orderId);
    	$this->db->where("payment_mode","cash");
    	$this->db->delete("transaction");
    }

    public function AllTransactionsTxexcelReportAdmin($excelData,$objPHPExcel)
	{
		$this->load->library('Common', NULL, 'common_library');
		$countries=$this->locations_model->getCountries(true);
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date US Time Zone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Total Paid Till Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order link");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Started Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Started Date US Time Zone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Created Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Created Date US Time Zone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Note");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created By");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order all Paid Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order all Refunded Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order all Failed Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order all Cancelled Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order all Inprocess Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order all Bounced Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Addres");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens Issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Shipping Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"App?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Is Partial Payment");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		

		

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$txids = $reportrow->paid_tx_ids;

			$trans_status=0;
			if(preg_grep('/'.$reportrow->trans_status.'/i', array('failure','aborted','failed','user cancelled', 'refund', 'bounced')))
				$trans_status=0;

			if(preg_grep('/'.$reportrow->trans_status.'/i', array('completed','approved','success', 'paid', 'captured')))
				$trans_status=1;

			if(in_array($reportrow->trans_status,array('initiated', 'inprocess', 'pending')))
				$trans_status=2;

			$alpha="A";
			if($trans_status==0)
				$objPHPExcel->getActiveSheet()->getStyle($i)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFCECE');
			// if($trans_status==1)
			// 	$objPHPExcel->getActiveSheet()->getStyle($i)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('CEFFCE');
			if($trans_status==2)
				$objPHPExcel->getActiveSheet()->getStyle($i)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FAF67D');
			$txnote = "";
			if($reportrow->note != "")
			{
				$txnote = nl2br($reportrow->note);
				$txnote = strip_tags($txnote);
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);

			$txidalpha=$alpha++;
			$styleArray = array(
		    	'font'  => array(
		        'bold'  => true
		    ));
			$objPHPExcel->getActiveSheet()->SetCellValue($txidalpha.$i,$reportrow->tx);
			$objPHPExcel->getActiveSheet()->getStyle($txidalpha.$i)->applyFromArray($styleArray);

			$amountalpha=$alpha++;
			if($reportrow->currency=='usd')
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			}
			else
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($amountalpha.$i,strtoupper($reportrow->currency)." ".$reportrow->amount);
			$objPHPExcel->getActiveSheet()->getStyle($amountalpha.$i)->applyFromArray($styleArray);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->trans_status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->started_on)));
			$sevaDateUSTimeZone = $this->common_library->convertKolkattaTimeToCentralTime($reportrow->started_on, "d M Y H:i:s T");
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sevaDateUSTimeZone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_paid);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,base_url."orders/view/".$reportrow->order_id);

			if(isset($reportrow->primary_order_id) && $reportrow->primary_order_id!='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->primary_order_id);
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);

			$emailalpha=$alpha++;
			$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			$objPHPExcel->getActiveSheet()->SetCellValue($emailalpha.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->getStyle($emailalpha.$i)->applyFromArray($styleArray);
			$phonealpha=$alpha++;
			$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			$objPHPExcel->getActiveSheet()->SetCellValue($phonealpha.$i,"+".$reportrow->country_isd_code." ".$reportrow->phone);

			$otype="Poojas";
			if($reportrow->order_type==2)
				$otype="Donations";
			if($reportrow->order_type==3)
				$otype="Store";
			if($reportrow->order_type==4)
				$otype="Subscriptions";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->started_on)));
			$transactionDateUSTimeZone = $this->common_library->convertKolkattaTimeToCentralTime($reportrow->started_on, "d M Y H:i:s T");
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$transactionDateUSTimeZone);
			if($reportrow->created_on)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->created_on)));
				$transactionCreatedDateUSTimeZone = $this->common_library->convertKolkattaTimeToCentralTime($reportrow->created_on, "d M Y H:i:s T");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$transactionCreatedDateUSTimeZone);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$txnote);
			

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);

			$created_by="Admin";
			if($reportrow->created_by==2)
				$created_by="User";
			if($reportrow->created_by==0)
				$created_by="Guest";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$created_by);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refunded_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->failed_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cancelled_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->inprocess_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounced_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

			$pstatus="Pending";
			if($reportrow->payment_status==1)
				$pstatus="Paid";
			if($reportrow->payment_status==2)
				$pstatus="Partially Paid";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1." ".$reportrow->address2." ".$reportrow->address3);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);

			// $objPHPExcel->getActiveSheet()->getStyle($phonealpha.$i)->applyFromArray($styleArray);

			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);

			

			$ship_status="N/A";
			if($reportrow->dispatch_status==1)
				$ship_status="Pending";
			else if($reportrow->dispatch_status==2)
				$ship_status="Completed";
			else if($reportrow->dispatch_status==3)
				$ship_status="Returned";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$ship_status);

			if($reportrow->app==1)
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"Yes");
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"No");

			$isPartialPayment = 'No';
			if($reportrow->tx_partial_payments_allowed == 1)
			{
				$isPartialPayment = 'Yes';
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$isPartialPayment);
		

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function AllTransactionReconciliationReportAdmin($excelData,$objPHPExcel)
	{
		$reports_db=$this->load->database("reports",true,false);
		$this->load->library('Common', NULL, 'common_library');
		// $q=$this->db->query($excelData->query);
		$q=$reports_db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Gateway Tx Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Gateway Tx Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Gateway Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);


		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Gateway Tx Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User Full Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User Email");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"ISD Code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$trans_row_color="";
			if($reportrow->tx_id == "" || $reportrow->gateway_tx_id == "")
			{
				$trans_row_color = 'orange';
			}
			if($reportrow->tx_id_counts >1 || $reportrow->gateway_tx_id_counts >1)
			{
				$trans_row_color = 'blue';
			}
			if($reportrow->transaction_status == "Refunded")
			{
				$trans_row_color = 'red';
			}

			$reportSevaDate = "";
			$reportTxDate = "";
			$reportGatewayTxDate = "";
			if(trim($reportrow->seva_date)!='' && trim($reportrow->seva_date)!="NULL" && trim($reportrow->seva_date)!="null" && trim($reportrow->seva_date)!='0000-00-00 00:00:00')
			{
				$reportSevaDate = date("d M Y",strtotime($reportrow->seva_date));
			}
			if(trim($reportrow->tx_date)!='' && trim($reportrow->tx_date)!="NULL" && trim($reportrow->tx_date)!="null" && trim($reportrow->tx_date)!='0000-00-00 00:00:00')
			{
				$reportTxDate = date("d M Y",strtotime($reportrow->tx_date));
			}
			if(trim($reportrow->gateway_tx_date)!='' && trim($reportrow->gateway_tx_date)!="NULL" && trim($reportrow->gateway_tx_date)!="null" && trim($reportrow->gateway_tx_date)!='0000-00-00 00:00:00')
			{
				$reportGatewayTxDate = date("d M Y",strtotime($reportrow->gateway_tx_date));
			}

			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportSevaDate);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->seva_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportTxDate);

			$amountalpha=$alpha++;
			if($reportrow->currency=='usd')
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			}
			else
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			}
			$reportTxAmount = "";
			if(trim($reportrow->tx_amount)!="" && $reportrow->tx_amount!="null")
			{
				$reportTxAmount = strtoupper($reportrow->currency)." ".$reportrow->tx_amount;
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($amountalpha.$i,$reportTxAmount);
			$objPHPExcel->getActiveSheet()->getStyle($amountalpha.$i)->applyFromArray($styleArray);

			$txidalpha=$alpha++;
			$styleArray = array(
		    	'font'  => array(
		        'bold'  => true
		    ));

			if($reportrow->tx_id_counts>1)
			{
				$this->common_library->ecxelCellBackgroundColor($objPHPExcel, $txidalpha.$i, 'ff6347');
			}
			else if($reportrow->tx_id == "")
			{
				$this->common_library->ecxelCellBackgroundColor($objPHPExcel, $txidalpha.$i, 'FFA80a');
			}
			else if($reportrow->transaction_status=='Refunded')
			{
				$this->common_library->ecxelCellBackgroundColor($objPHPExcel, $txidalpha.$i, 'ff0000');
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($txidalpha.$i,$reportrow->tx_id);
			$objPHPExcel->getActiveSheet()->getStyle($txidalpha.$i)->applyFromArray($styleArray);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->transaction_status);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportGatewayTxDate);

			$gateway_amountalpha=$alpha++;
			if($reportrow->currency=='usd')
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true,
			        'color' => array('rgb' => 'FF0000')
			    ));
			}
			else
			{
				$styleArray = array(
			    'font'  => array(
			        'bold'  => true
			    ));
			}
			$reportGatewayTxAmount = "";
			if(trim($reportrow->gateway_tx_amount)!="" && trim($reportrow->gateway_tx_amount)!="null")
			{
				$reportGatewayTxAmount = strtoupper($reportrow->currency)." ".$reportrow->gateway_tx_amount;
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($gateway_amountalpha.$i,$reportGatewayTxAmount);
			$objPHPExcel->getActiveSheet()->getStyle($gateway_amountalpha.$i)->applyFromArray($styleArray);

			$gateway_txidalpha=$alpha++;
			$styleArray = array(
		    	'font'  => array(
		        'bold'  => true
		    ));

			if($reportrow->gateway_tx_id_counts>1)
			{
				$this->common_library->ecxelCellBackgroundColor($objPHPExcel, $gateway_txidalpha.$i, 'ff6347');
			}
			if($reportrow->gateway_tx_id == "")
			{
				$this->common_library->ecxelCellBackgroundColor($objPHPExcel, $gateway_txidalpha.$i, 'FFA80a');
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($gateway_txidalpha.$i,$reportrow->gateway_tx_id);
			$objPHPExcel->getActiveSheet()->getStyle($gateway_txidalpha.$i)->applyFromArray($styleArray);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->gateway_status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->user_id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->user_full_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->user_email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country_isd_code);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->user_phone);
		

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function sevasTallyReportAdmin($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"order date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Voucher Type Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order ID (unique)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"auto gen in tally");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID(Donor ID)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address 1, Address 2, Address 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Passport No");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Transaction ID(Alpha Numeric)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name of the Bank (through which bank)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Purpose");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Declaration");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"To keep this in the website");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Debit Ledger");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Credit Ledger");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item Price");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item Quantity");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Aadhaar Card");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"TIN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Passport Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Voter EPIC Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Driving License Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ration Card Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Is Partial Payment");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Shipping Cost");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";

			if(in_array($reportrow->trans_status, ['failure','aborted','failed','user cancelled', 'refund', 'bounced']))
				$objPHPExcel->getActiveSheet()->getStyle($i)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFCECE');

			if(in_array($reportrow->trans_status, ['initiated', 'inprocess', 'pending']))
				$objPHPExcel->getActiveSheet()->getStyle($i)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FAF67D');

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("j-M-y",strtotime($reportrow->order_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->tx);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

			$otype="Poojas";
			if($reportrow->order_type==2)
				$otype="Donations";
			if($reportrow->order_type==3)
				$otype="Store";
			if($reportrow->order_type==4)
				$otype="Subscriptions";
			if($otype == "Poojas")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			}
			$itemTotalAmount = $reportrow->item_price*$reportrow->item_quantity;
			if($reportrow->shipping_price>0)
			{
				$itemTotalAmount = $itemTotalAmount+$reportrow->shipping_price;
			}
			if($reportrow->tx_partial_payments_allowed == 1)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->amount);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$itemTotalAmount);
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'Yes');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'Individual');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_quantity);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_aadhaar_number);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_tin_number);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_passport_number);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_voter_epic_number);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_driving_license_number);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_ration_card_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("j-M-y",strtotime($reportrow->started_on)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->trans_status);

			$isPartialPayment = 'No';
			if($reportrow->tx_partial_payments_allowed == 1)
			{
				$isPartialPayment = 'Yes';
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$isPartialPayment);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->shipping_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function subscriptionsTallyReportAdmin($excelData,$objPHPExcel)
	{
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"order date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Voucher Type Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Order ID (unique)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"auto gen in tally");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID(Donor ID)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address 1, Address 2, Address 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Passport No");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Transaction ID(Alpha Numeric)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name of the Bank (through which bank)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Purpose");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Declaration");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"To keep this in the website");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Debit Ledger");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Credit Ledger");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item Price");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Item Quantity");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Aadhaar Card");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"TIN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Passport Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Voter EPIC Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Driving License Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ration Card Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Is Partial Payment");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";

			if(in_array($reportrow->trans_status, ['failure','aborted','failed','user cancelled', 'refund', 'bounced']))
				$objPHPExcel->getActiveSheet()->getStyle($i)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FFCECE');

			if(in_array($reportrow->trans_status, ['initiated', 'inprocess', 'pending']))
				$objPHPExcel->getActiveSheet()->getStyle($i)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setRGB('FAF67D');

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("j-M-y",strtotime($reportrow->order_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

			if(isset($reportrow->sub_transaction) && $reportrow->sub_transaction==1)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->sub_tx);
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->tx);
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

			$otype="Poojas";
			if($reportrow->order_type==2)
				$otype="Donations";
			if($reportrow->order_type==3)
				$otype="Store";
			if($reportrow->order_type==4)
				$otype="Subscriptions";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			// $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);
			// $itemTotalAmount = $reportrow->item_price*$reportrow->item_quantity;
			// if($reportrow->tx_partial_payments_allowed == 1)
			// {
			// 	$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->amount);
			// }
			// else
			// {
			// 	$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$itemTotalAmount);
			// }
			// $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->amount);
			if(isset($reportrow->sub_transaction) && $reportrow->sub_transaction==1)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->onetime_charge);
			}
			else
			{
				$itemTotalAmount = $reportrow->item_price*$reportrow->payment_items_count;
				if($reportrow->amount < $itemTotalAmount)
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->amount);
				}
				else
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$itemTotalAmount);
				}
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'Yes');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'Individual');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'');
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			if(isset($reportrow->sub_transaction) && $reportrow->sub_transaction==1)
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name." - One time payment");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->onetime_charge);
			}
			else
			{
				$itemTotalAmount = $reportrow->item_price*$reportrow->payment_items_count;
				if($reportrow->amount < $itemTotalAmount)
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name." - One time payment");
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->onetime_charge);
				}
				else
				{
					$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_price);
				}
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_items_count);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_aadhaar_number);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_tin_number);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_passport_number);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_voter_epic_number);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_driving_license_number);
			$objPHPExcel->getActiveSheet()->setCellValueExplicit($alpha++.$i,$reportrow->tx_ration_card_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("j-M-y",strtotime($reportrow->started_on)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->trans_status);

			$isPartialPayment = 'No';
			if($reportrow->tx_partial_payments_allowed == 1)
			{
				$isPartialPayment = 'Yes';
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$isPartialPayment);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function triggerFailedTransactions()
    {
        $yesterdayDate = date('Y-m-d',strtotime("-1 days"));
        $q = $this->db->select("t.id,t.ashram_id,t.started_on as date,t.status,o.order_number,t.currency,t.payment_mode,o.preferred_name,t.email,t.country_isd_code,t.phone,t.country,t.firstname,t.lastname,t.order_id,o.ashram_name,t.tx,t.amount,o.order_type")->from("transaction as t")->where("DATE_FORMAT(t.started_on,'%Y-%m-%d')",$yesterdayDate)->where("amount>",0)->where_in("t.status",array("failed","failure","bounced",'aborted','user cancelled'))->join("orders as o","o.id = t.order_id")->get();
        if($q->num_rows() > 0)
        {
            $failed_trans = $q->result_array();
            $failed_trans_by_ashram_currency = [];
            foreach($failed_trans as $thistrans)
            {
            	$currency_key = strtolower($thistrans['currency']);
                $failed_trans_by_ashram_currency[$thistrans['ashram_id']."_".$currency_key][] = $thistrans;
            }
            foreach ($failed_trans_by_ashram_currency as $key1 => $value1) 
            {
            	$keySet = explode("_", $key1);
            	$ashram_id = "";
            	$currency = "";
            	if(!empty($keySet[0]) && is_numeric($keySet[0]))
            		$ashram_id = $keySet[0];
            	if(!empty($keySet[1]) && in_array($keySet[1],array("inr","usd")))
            	{
            		$currency = $keySet[1];
            	}
            	if(!empty($ashram_id) && !empty($currency) && count($value1) > 0)
            	{
            		$ashramData=$this->ashrams_model->ashramData($ashram_id);
            		$service_slug = 'tx_failing_email_report_'.$ashram_id."_".strtolower($currency);
        			$this->db->like("service_slug",$service_slug);
					$settings=$this->db->get('email_settings')->row();

            		if(!empty($ashramData) && !empty($settings))
            		{
            			
						$emails = explode(",", $settings->report_emails);
						
            			$data['failed_trans'] = $value1;
	            		$data["failed_date"]  = date("d M Y, l",strtotime($yesterdayDate));
	            		$data["ashram_name"]  = $ashramData->name;
	            		$data["currency"]  = strtoupper($currency);
	            		
	            		$subject  = "Subscription & One-time failed transactions for ashram: ".$ashramData->name.", Currency: ".$currency.", Date: ".date("d M Y, l",strtotime($yesterdayDate));
	            		$body=$this->load->view("orders/public/_email_failed_transactions",$data,true);
	            		foreach ($emails as $key1 => $value1) 
						{
		            		$this->email_extension->sendMailGuest(
																'tx_failing_email_report_'.$ashram_id."_".strtolower($currency),
																"Admin",
																$value1,
																$subject,
																$body,
																'',
																1);
		            	}
            		}
            	}
            }
        }
    }

    public function triggerNoTXOrders()
    {
        $yesterdayDate = date('Y-m-d',strtotime("-1 days"));
        $q = $this->db->select("order_number,id,preferred_name,email,phone,country,ashram_id,currency,date,currency,payment_alt_mode,payment_mode,total_price,firstname,lastname,order_type,isd_code")->from("orders")->where("DATE_FORMAT(date,'%Y-%m-%d')",$yesterdayDate)->where("no_paid_transactions","Yes")->get();
        if($q->num_rows() > 0)
        {
            $no_trans = $q->result_array();
            $no_trans_by_ashram_currency = [];
            foreach($no_trans as $thistrans)
            {
            	$currency_key = strtolower($thistrans['currency']);
                $no_trans_by_ashram_currency[$thistrans['ashram_id']."_".$currency_key][] = $thistrans;
            }
            foreach ($no_trans_by_ashram_currency as $key1 => $value1) 
            {
            	$keySet = explode("_", $key1);
            	$ashram_id = "";
            	$currency = "";
            	if(!empty($keySet[0]) && is_numeric($keySet[0]))
            		$ashram_id = $keySet[0];
            	if(!empty($keySet[1]) && in_array($keySet[1],array("inr","usd")))
            	{
            		$currency = $keySet[1];
            	}
            	if(!empty($ashram_id) && !empty($currency) && count($value1) > 0)
            	{
            		$ashramData=$this->ashrams_model->ashramData($ashram_id);
            		$service_slug = 'orders_no_tx_email_report_'.$ashram_id."_".strtolower($currency);
        			$this->db->like("service_slug",$service_slug);
					$settings=$this->db->get('email_settings')->row();

            		if(!empty($ashramData) && !empty($settings))
            		{
            			$emails = explode(",", $settings->report_emails);
            			
            			$data['no_trans'] = $value1;
	            		$data["no_trans_date"]  = date("d M Y, l",strtotime($yesterdayDate));
	            		$data["ashram_name"]  = $ashramData->name;
	            		$data["currency"]  = strtoupper($currency);

	            		$subject  = "Sevas without paid transactions for ashram: ".$ashramData->name.", Currency: ".$currency.", Date: ".date("d M Y, l",strtotime($yesterdayDate));

	            		$body=$this->load->view("orders/public/_email_no_transaction_orders",$data,true);
	            		foreach ($emails as $key1 => $value1) 
						{
	            			$this->email_extension->sendMailGuest(
															'orders_no_tx_email_report_'.$ashram_id."_".strtolower($currency),
															"Admin",
															$value1,
															$subject,
															$body,
															'',
															1);
	            		}
            		}
            	}
            }
        }
    }

    public function captureEvents($fromDateTime,$toDateTime="",$fromOrderId="",$toOrderId="",$currencies="",$paymentModes="",$orderTypes="", $sendRetryMail="Yes")
    {
    	$this->db->select('id,date,currency,payment_mode,order_type');
        $this->db->from("orders");
        if($fromDateTime!='')
        {
        	$this->db->where('date >= "'.$fromDateTime.'"');
        }
        if($toDateTime!='')
        {
        	$this->db->where('date <= "'.$toDateTime.'"');
        }
        if($fromOrderId>0)
        {
        	$this->db->where('id >=',$fromOrderId);
        }
        if($toOrderId>0)
        {
        	$this->db->where('id <=',$toOrderId);
        }
        if($currencies!="")
        {
        	$currenciesarray = explode(",", $currencies);
        	$this->db->where_in('currency',$currenciesarray);
        }
        if($paymentModes!="")
        {
        	$paymentModesarray = explode(",", $paymentModes);
        	$this->db->where_in('payment_mode',$paymentModesarray);
        }

        if($orderTypes!="")
        {
        	$orderTypesarray = explode(",", $orderTypes);
        	$this->db->where_in('order_type',$orderTypesarray);
        }

        // $this->db->where('date >= DATE_SUB(NOW(),INTERVAL 1 HOUR)');
        // $this->db->where_in('payment_alt_mode',array("paypal","razorpay"));
        // $this->db->where_in('order_type',array(1,2,3));
        // $this->db->group_start();
        // $this->db->where('transaction_id!=',"");
        // $this->db->or_where('transaction_id!=',NULL);
        // $this->db->group_end();
        $this->db->where('no_paid_transactions!=',"Yes");
        $this->db->where('payment_status',1);
        $result = $this->db->get()->result_array();
        // echo '<pre>'; print_r($result); die();
        if (!empty($result))
        {
        	foreach ($result as $key => $value) 
        	{
        		$this->db->select('id');
		        $this->db->from("transaction");
		        $this->db->where('order_id',$value["id"]);
		        $this->db->where_in('status',array('success','Success','approved','completed','captured','paid','Release Payment'));
		        $this->db->where('amount>',"0");
		        if($paymentModes!="")
		        {
		        	$paymentModesarray = explode(",", $paymentModes);
		        	$this->db->where_in('payment_mode',$paymentModesarray);
		        }
		        // $this->db->where_in('payment_mode',array("paypal","razorpay"));
		        $results = $this->db->get()->row();
		        if(empty($results))
		        {
		        	$true = $this->updateOrderCancelFlag($value["id"]);
		        	if($true && $sendRetryMail=="Yes")
		        	{
		        		$this->orders_model->sendCollectPaymentEmail($value["id"]);
		        	}
		        }
        	}
        }
        else 
        {
            return false;
        }
    }

    public function updateOrderCancelFlag($order_id)
    {
        $orderData=$this->orders_model->orderData($order_id);
        if(!empty($orderData['order']))
        {
            $updateData = array(
                                "paid"=>0,
                                "total_paid"=>0,
                                "payment_status"=>0,
                                "no_paid_transactions"=>"Yes"
                                );
            $this->db->where(array('id'=>$order_id));
            $this->db->update('orders',$updateData);

            $this->db->where(array('order_id'=>$order_id));
            $this->db->update('order_items',array("status"=>0));

            return true;
        }
    }

	public function checkPaidTx($orderID)
	{
		$this->db->select('id');
        $this->db->from("transaction");
        $this->db->where('order_id',$orderID);
        $this->db->where_in('status',array('success','Success','approved','completed','captured','paid','Release Payment'));
        $this->db->where('amount>',"0");
        $q = $this->db->get();
        if($q->num_rows() > 0)
        {
        	return true;
        }
        return false;
	}

	public function listTransactionsReconciliationReportAdmin($excel=0)
	{
		$reconciliationTable = "";
		$reportCurrency = isset($_POST['currency']) ? $_POST['currency'] : "";
		$reportPaymentMode = isset($_POST['payment_mode']) ? $_POST['payment_mode'] : "";
		$reportTxDate = isset($_POST['tx_date']) ? $_POST['tx_date'] : "";

		if(strtolower($reportCurrency)=='inr' && $reportTxDate!='')
		{
			$reconciliationTable="tx_reconciliation_report_".strtolower($reportCurrency)."_";
			$monthOfCreated = date("m",strtotime($reportTxDate));
			$yearOfCreated = date("Y",strtotime($reportTxDate));
			if($monthOfCreated>=4)
			{
				$reconciliationTable .= $yearOfCreated."-".financial_year_start_month_date;
				$reconciliationTable .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
			}
			else
			{
				$reconciliationTable .= ($yearOfCreated-1)."-".financial_year_start_month_date;
				$reconciliationTable .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
			}
		}
		else if(strtolower($reportCurrency)=='usd' && $reportTxDate!='')
		{
			$reconciliationTable="tx_reconciliation_report_".strtolower($reportCurrency)."_".date('Y');
		}

		$reconciliationTable = str_replace("-","_",$reconciliationTable);

		$reportsDb=$this->load->database("reports",true,false);
		if(!$reportsDb->table_exists($reconciliationTable))
		{
			$toBeReturn = [
							"recordsTotal" => "0",
							"recordsFiltered" => "0",
							"data" => [],
							"page_records" => 0
						];
			return $toBeReturn;
		}

		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			$ashramTrusts=$this->ashrams_trust_accounts_model->getAllTrustsBasicDetailsByAshramId($this->session->userdata("ashramId"));
			$ashramTrustsArray=array();
			foreach ($ashramTrusts as $ashramTrustData)
			{
				$ashramTrustsArray[$ashramTrustData->id]=$ashramTrustData;
			}
		}
		$i=0;
		$query1=$reportsDb;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			// $query1->select("*, count(tx_id) as tx_id_counts, count(gateway_tx_id) as gateway_tx_id_counts");
			$query1->select("a.*, (SELECT COUNT(tx_id) FROM `".$reconciliationTable."` WHERE tx_id = a.tx_id) as tx_id_counts,
			(SELECT COUNT(gateway_tx_id) FROM `".$reconciliationTable."` WHERE gateway_tx_id = a.gateway_tx_id) as gateway_tx_id_counts");
		}

		$query1->from($reconciliationTable." as a");
		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nTrust(s): ";
			if(isset($_POST['trust_ids']) && $_POST['trust_ids']!='')
			{
				if(is_array($_POST['trust_ids']))
				{
					$query1->where_in("trust_id",$_POST['trust_ids']);
					$pii=0;
					foreach ($_POST['trust_ids'] as $trust_ids)
					{
						if($pii) $preData.=", ";
						$preData.=$ashramTrustsArray[$trust_ids]->trust_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("trust_id",$_POST['trust_ids']);
					$preData.=$ashramTrustsArray[$_POST['trust_ids']]->trust_name;
				}
			}
			else
			{
				$preData.="All Trusts";
			}
		}

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && 
			isset($_POST['wild']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']) && 
			in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			if($_POST['search_col'] == 'seva_id')
			{
				$preData.= 'Seva ID';
			}
			else
			{
				$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			}
			if($_POST['wild']=='contains')
			{
				$query1->like('a.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like('a.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like('a.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nTx Date: ";
		if(isset($_POST['tx_date']) && $_POST['tx_date']!='' && isset($_POST['search_col']))
		{
			if(in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
			{
				$query1->where("date(a.tx_date) =",date("Y-m-d",strtotime($_POST['tx_date'])));
				$preData.=$_POST['tx_date'];
				$preData.=" (".$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']].")";
			}
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}
		$preData.="\nSeva Type:";
		if(isset($_POST['order_type']) && is_numeric($_POST['order_type']) && in_array($_POST['order_type'],array(1,2,3,4)))
		{
			if($_POST['order_type']==1)
			{
				// $query1->where("tx_order_type",1);
				$preData.=" Poojas";
			}
			else if($_POST['order_type']==2)
			{
				// $query1->where("tx_order_type",2);
				$preData.=" Donations";
			}
			else if($_POST['order_type']==3)
			{
				// $query1->where("tx_order_type",3);
				$preData.=" Store";
			}
			else if($_POST['order_type']==4)
			{
				// $query1->where("tx_order_type",4);
				$preData.=" Subscriptions";
			}
		}
		else
		{
			$preData.=" All";
		}
		
		$preData.="\nPayment Source:";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			if($_POST['payment_mode']=='paypal')
			{
				$query1->where("payment_mode",'paypal');
				$preData.=" Paypal";
			}
			else if($_POST['payment_mode']=='stripe')
			{
				$query1->where("payment_mode",'stripe');
				$preData.=" Stripe";
			}
			else if($_POST['payment_mode']=='razorpay')
			{
				$query1->where("payment_mode",'razorpay');
				$preData.=" Razorpay";
			}
			else if($_POST['payment_mode']=='authorize.net')
			{
				$query1->where("payment_mode",'authorize.net');
				$preData.=" Authorize.net";
			}
			else if($_POST['payment_mode']=='payu')
			{
				$query1->where("payment_mode",'payu');
				$preData.=" PayU";
			}
			else
			{
				$query1->where("payment_mode",'');
			}
		}
		else
		{
			$preData.=" All";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('tx_date',$_POST['dir']);
				else
					$query1->order_by('tx_date',"desc");
			}
			$query1->group_by("tx_id,gateway_tx_id");
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest("default","model","orders/transaction_model",$sql,$this->currentUser,"reports",$_POST,"All Transaction Reconciliation Report",$preData,9);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('tx_date',$dir);
		}
		else
		{
			$query1->order_by('tx_date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		$query1->group_by("id");
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if($rtn['data'][$c]['seva_date']!='')
			{
				$rtn['data'][$c]['seva_date']=date("d M Y",strtotime($rtn['data'][$c]['seva_date']));
			}
			if($rtn['data'][$c]['tx_date']!='')
			{
				$rtn['data'][$c]['tx_date']=date("d M Y",strtotime($rtn['data'][$c]['tx_date']));
			}

			$rtn['data'][$c]['amount_num']=abs($row['tx_amount']);
			if(empty($row['tx_amount']))
			{
				$row['tx_amount']=0;
			}
			if($row['currency']=='usd')
				$rtn['data'][$c]['tx_amount']="<span style='color:red; font-weight:bold;'>".strtoupper($row['currency'])." ".$row['tx_amount']."</span>";
			else
				$rtn['data'][$c]['tx_amount']="<span style='font-weight:bold;'>".strtoupper($row['currency'])." ".$row['tx_amount']."</span>";

			
			$rtn['data'][$c]['username'] = $row['username'];
			$rtn['data'][$c]['user_id'] = $row['user_id'];
			$rtn['data'][$c]['user_details']=$row['user_full_name']."<br>".
											$row['user_email']."<br>".
											$row['user_phone']."<br>";
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function getReconciliationReportPaymentModesByDateCurrency($tx_date="", $tx_currency="")
	{
		if($tx_date=="" || $tx_currency=="" || !$this->session->userdata("ashramId"))
		{
			return array();
		}
		if(strtolower($tx_currency)=='inr' && $tx_date!='')
		{
			$reconciliationTable="tx_reconciliation_report_".strtolower($tx_currency)."_";
			$monthOfCreated = date("m",strtotime($tx_date));
			$yearOfCreated = date("Y",strtotime($tx_date));
			if($monthOfCreated>=4)
			{
				$reconciliationTable .= $yearOfCreated."-".financial_year_start_month_date;
				$reconciliationTable .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
			}
			else
			{
				$reconciliationTable .= ($yearOfCreated-1)."-".financial_year_start_month_date;
				$reconciliationTable .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
			}
		}
		else if(strtolower($tx_currency)=='usd' && $tx_date!='')
		{
			$reconciliationTable="tx_reconciliation_report_".strtolower($tx_currency)."_".date('Y');
		}
		$reconciliationTable = str_replace("-","_",$reconciliationTable);
		$reportsDb=$this->load->database("reports",true,false);
		if(!$reportsDb->table_exists($reconciliationTable))
		{
			return array();
		}
		$query1=$reportsDb;
		$query1->select("DISTINCT(payment_mode)");
		$query1->from($reconciliationTable);
		$query1->where('ashram_id', $this->session->userdata("ashramId"));
		$query1->where('currency', $tx_currency);
		return $query1->get()->result_array();
	}

	public function getTransactionsByOrderID($id)
    {
		$this->db->where("order_id",$id);
		$transaction=$this->db->get("transaction");
		return $transaction->result();
    }

    public function getTransactionsByTx($tx)
    {
		$this->db->where("tx",$tx);
		$transaction=$this->db->get("transaction");
		return $transaction->result();
    }
}
?>