<?PHP
class Subscription_payments_model extends CI_Model 
{
	var $tableName="subscription_payments";
	var $searchAliasNames = [
								"email" => "Email ID",
								"order_number" => "Seva ID",
								"username" => "User ID",
								"phone" => "Phone",
								"firstname" => "First Name",
								"lastname" => "Last Name",
								"order_number" => "Seva ID",
								"transaction_id" => "Tx ID",
								"t.tx" => "Tx ID",
								"t.note" => "Note",
								"t.order_id" => "Seva ID",
								"t.firstname" => "First name",
								"t.lastname" => "Last name",
								"t.email" => "Email ID",
								"t.phone" => "Phone",
								"t.city" => "City",
								"t.state" => "State",
								"o.order_number" => "Seva ID",
								"o.email" => "Email ID",
								"o.username" => "User ID",
								"o.phone" => "Phone",
								"o.firstname" => "First Name",
								"o.lastname" => "Last Name",
							];
	public function __construct()
	{
		parent::__construct();
	}

	public function getUsersubsfailedcount()
	{
		$this->db->from($this->tableName." as sp")->join("orders as o","o.id = sp.order_id");
		$this->db->where('user_id',$this->currentUser->id);
		$this->db->where('sp.status',1);
		return $this->db->get()->num_rows();
	}

	public function getnoTxCountUser()
	{
		$this->db->where('user_id',$this->currentUser->id);
		$this->db->where('no_paid_transactions',"Yes");
		return $this->db->get("orders")->num_rows();
	}

	public function getByOrderItem($orderItemId)
	{
		$this->db->select("
							s.tx as tx
							,s.order_item_id as order_item_id
							,s.order_id as order_id
							,note
							,s.payment_number as payment_number
							,s.retry_status as retry_status
							,s.date as date
							,s.status as status
							,s.amount as amount
							,t.payment_mode as payment_mode
							,s.id as id
							,t.status as tx_status
							,t.is_manual_payment as is_manual_payment
							,t.is_foreign_payment as is_foreign_payment
							,t.manual_receipt_number as manual_receipt_number
							,t.manual_receipt_date as manual_receipt_date
							,t.foreign_currency as foreign_currency
							,t.foreign_amount as foreign_amount
							,t.offline_date as offline_date
							,t.offline_number as offline_number
							,t.offline_bank as offline_bank
							,t.id as tid
							,t.realized_amount as realized_amount
							,t.refund_mode as refund_mode
							,t.refund_reference as refund_reference
							,t.refund_date as refund_date
							,t.system_generated
						");
		$this->db->where("s.order_item_id",$orderItemId);
		$this->db->order_by("s.payment_number","asc");
		$this->db->join("transaction as t","t.tx=s.tx and t.order_item_id = s.order_item_id","left");
		$payments=$this->db->get($this->tableName." as s");
		return $payments->result();
	}
	public function getAllByOrderItem($orderItemId)
	{
		
		$this->db->select("
							t.tx as tx
							,s.tx as stx
							,s.order_item_id as order_item_id
							,s.order_id as order_id
							,note
							,s.payment_number as payment_number
							,s.retry_status as retry_status
							,s.date as date
							,s.status as status
							,s.amount as amount
							,t.payment_mode as payment_mode
							,s.id as id
							,t.status as tx_status
							,t.created_on as created_on
							,t.is_manual_payment as is_manual_payment
							,t.is_foreign_payment as is_foreign_payment
							,t.manual_receipt_number as manual_receipt_number
							,t.manual_receipt_date as manual_receipt_date
							,t.foreign_currency as foreign_currency
							,t.foreign_amount as foreign_amount
							,t.offline_date as offline_date
							,t.offline_number as offline_number
							,t.offline_bank as offline_bank
							,t.id as tid
							,t.realized_amount as realized_amount
							,t.refund_mode as refund_mode
							,t.refund_reference as refund_reference
							,t.refund_date as refund_date
						");
		$this->db->where("s.order_item_id",$orderItemId);
		$this->db->order_by("s.payment_number","asc");
		$this->db->join("subscription_payments_transaction_map as sptm","sptm.subscription_payment_id=s.id","left");
		$this->db->join("transaction as t","t.tx=sptm.tx","left");
		$payments=$this->db->get($this->tableName." as s");
		//echo $this->db->last_query();
		//exit;
		return $payments->result();
	}

	public function getById($id)
	{
		if(!is_numeric($id)) return array();
		$this->db->where("id",$id);
		return $this->db->get($this->tableName)->row();
	}

	public function createRecords($orderItem)
	{
        $start=strtotime($orderItem['schedule_dates']);
        $frequency=$orderItem['frequency'];
        $expiration_method=$orderItem['expiration_method'];
        $expiry_date=strtotime($orderItem['expiry_date']);
        $period=$orderItem['period'];
        $num_of_payments=$orderItem['num_of_payments'];
        $given_expiry_date=$orderItem['given_expiry_date'];

        $hard_date=strtotime("+5 years",$start);
        $i=1;
        while(1)
        {
			$this->db->insert($this->tableName,array(
                            "order_item_id"=>$orderItem['id'],
                            "order_id"=>$orderItem['order_id'],
                            "payment_date"=>date("Y:m:d",$start),
                            "amount"=>$orderItem['price'],
                            //"date"=>date("Y:m:d",$start),
                            "payment_number"=>$i,
                            "created_on"=>date("Y:m:d H:i:s")
                        ));
			
            $start=strtotime("+".$frequency." ".$period,$start);

            if($expiration_method==1) // No of payments
            {
            	if($i==$num_of_payments)
            	{
            		break;
            	}
            }
            else if($expiration_method==2)
            {
	            if($start>$expiry_date)
	            {
	                break;
	            }
	        }
	        else
	        {
	        	if($start>$hard_date)
	        	{
	        		break;
	        	}
	        }
	        if($start>$hard_date)
        	{
        		break;
        	}
            $i++;
		}
	}

	public function getPrevRow($order_itemId)
	{
		if(!is_numeric($order_itemId)) return array();
		$q = $this->db->select("*")->from($this->tableName)->where("order_item_id",$order_itemId)->order_by("id","desc")->get();
		if($q->num_rows() > 0)
		{
			$r = $q->row();
			return $r;
		}
		return false;
	}

	public function updateProfileId($orderItemId,$profileId)
	{
		$this->db->where("order_item_id",$orderItemId);
		$this->db->where("profile_id !=",null);
		$this->db->update($this->tableName,array(
							"profile_id"=>$profileId
						));
	}

	/**
		8 = Paid
		101 = Inprocess (only for cheque)
		102 = Bounced (only for cheque)
	**/
	public function offlineUpdate($id,$paymentMode='',$paymentStatus='',$txNote='')
	{
		$payment=$this->getById($id);
		if(empty($payment))
		{
			return 0;
		}
		if($payment->payment_mode=='cheque' && ($payment->status==101 || $payment->status==8))
		{
			$paymentMode='cheque';
		}

		//Conditions for CHEQUE
		if($paymentMode=='cheque')
		{
			if($payment->status==0 || $payment->status==102 || $payment->status==103) // If pending or bounced or refund
			{
				if($paymentStatus!='inprocess') //Allow only inprocess status
				{
					return 0;
				}
			}
			if($payment->status==101)
			{
				if($paymentStatus!='paid' && $paymentStatus!='bounced') //Allow only paid and bounced status
				{
					return 0;
				}
			}
			if($payment->status==8)
			{
				if($paymentStatus!='bounced' && $paymentStatus!='refund') //Allow only bounced and refund status
				{
					return 0;
				}
			}
		}
		else //Remaining all payment modes
		{
			if($payment->status==0 || $payment->status==103 || $payment->status==102) //Allow from pending and bounced and refund
			{
				if($paymentStatus!='paid') //Allow only paid status
				{
					return 0;
				}
			}
			else if($payment->status==8) //Allow from paid
			{
				if($paymentStatus!='refund') //Allow only refund status
				{
					return 0;
				}
			}
			else //Dont allow for any other existing statuses
			{
				return 0;
			}
		}

		//Get order details
		$orderData=$this->orders_model->orderData($payment->order_id);
		$transaction_created=0;
		$is_manual_payment=0;
		$is_foreign_payment=0;

		if(($paymentMode=='cheque' && $paymentStatus=='inprocess') || ($paymentMode!='cheque' && $paymentStatus=='paid'))
		{
			//Create transaction and attach
			$txNote="<b>".date("d M Y H:i:s")."</b> (".$paymentStatus.")\n".$txNote;
			$txid=$this->transaction_model->createCashTransaction($orderData,$payment->amount,$paymentMode,$txNote);

			$this->transaction_model->updateDetails($txid,
												array(
														"subscription"=>1,
														'status'=>$paymentStatus,
														"order_item_id"=>$payment->order_item_id,
														"is_manual_payment"=>empty($this->input->post("is_manual_payment"))?0:$this->input->post("is_manual_payment"),
														"is_foreign_payment"=>empty($this->input->post("is_foreign_payment"))?0:$this->input->post("is_foreign_payment"),
														"manual_receipt_number"=>empty($this->input->post("manual_receipt_number"))?null:$this->input->post("manual_receipt_number"),
														"manual_receipt_date"=>empty($this->input->post("manual_receipt_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("manual_receipt_date"))),
														"offline_number"=>empty($this->input->post("offline_number"))?null:$this->input->post("offline_number"),
														"offline_bank"=>empty($this->input->post("offline_bank"))?null:$this->input->post("offline_bank"),
														"offline_date"=>empty($this->input->post("offline_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("offline_date"))),
														"foreign_currency"=>empty($this->input->post("foreign_currency"))?0:$this->input->post("foreign_currency"),
														"foreign_amount"=>empty($this->input->post("foreign_amount"))?0:$this->input->post("foreign_amount"),
														"realized_amount"=>empty($this->input->post("realized_amount"))?0:$this->input->post("realized_amount")
													));

			$transaction_created=1;
			if(!empty($this->input->post("is_manual_payment")))
				$is_manual_payment=1;
			if(!empty($this->input->post("is_foreign_payment")))
				$is_foreign_payment=1;
		}

		if($paymentStatus=='paid')
		{
			$updateData['status']=8;
		}
		if($paymentStatus=='bounced')
		{
			$updateData['status']=102;
		}
		if($paymentStatus=='refund')
		{
			$updateData['status']=103;
		}
		if($paymentStatus=='inprocess')
		{
			$updateData['status']=101;
		}
		if($transaction_created==1)
		{
			$updateData['tx']=$txid;
			$updateData['date']=date("Y:m:d H:i:s");
			$updateData['payment_mode']=$paymentMode;
		}

		if($payment->tx!='')
		{
			$this->db->select("group_concat(id) as ids");
			$this->db->where("tx",$payment->tx);
			$related_ids=array_filter(explode(",",$this->db->get($this->tableName)->row()->ids));

			$this->db->select("group_concat(id) as ids");
			$this->db->where("sub_tx",$payment->tx);
			$related_txids=array_filter(explode(",",$this->db->get("transaction")->row()->ids));

			$txData=$this->transaction_model->getTransactionByTx($payment->tx);

			if($transaction_created==0)
			{
				$txUpdateData['status']=$paymentStatus;
				if($paymentStatus=='refund')
				{
					$txUpdateData['refund_reference']=empty($this->input->post("refund_reference"))?null:$this->input->post("refund_reference");
					$txUpdateData['refund_date']=empty($this->input->post("refund_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("refund_date")));
					$txUpdateData['refund_mode']=empty($this->input->post("refund_mode"))?null:$this->input->post("refund_mode");
				}
				$is_manual_payment=$txData->is_manual_payment;
				$this->transaction_model->updateDetails(
													$payment->tx,
													$txUpdateData
												);

				$tx_note=$txData->note."\n\n<b>".date("d M Y h:i A")."</b> (".$paymentStatus.")";
				$tx_note.="\n".$txNote;
				$this->transaction_model->setNote($payment->tx,$tx_note);
				$txid=$payment->tx;
			}
			else
			{
				$this->transaction_model->updateDetails(
													$payment->tx,
													array(
														"flag"=>1
													)
												);
			}

			/*$txresponse=$this->transaction_model->update(
												$txData->id,
												$paymentStatus,
												$txNote,
												$paymentMode
											);*/
		}

		if(isset($related_ids) && !empty($related_ids) && 
			(($paymentMode=='cheque' && $paymentStatus!='inprocess') || ($paymentMode!='cheque' && $paymentStatus!='paid'))
		)
			$this->db->where_in("id",$related_ids);
		else	
			$this->db->where("id ",$id);

		$this->db->update($this->tableName,$updateData);


		if(isset($related_txids) && !empty($related_txids) && 
			(($paymentMode=='cheque' && $paymentStatus!='inprocess') || ($paymentMode!='cheque' && $paymentStatus!='paid'))
		)
		{
			$updateData=array();
			$updateData['status']=$paymentStatus;
			//$updateData['sub_tx']=$txid;
			$updateData['modified_on']=date("Y:m:d H:i:s");
			$updateData['payment_mode']=$paymentMode;
			$updateData['note']=$txData->note."\n\n<b>".date("d M Y h:i A")."</b> (".$paymentStatus.")\n".$txNote;
			$this->db->where_in("id",$related_txids);
			$this->db->update("transaction",$updateData);
		}

		if($transaction_created==1)
		{
			$this->db->insert("subscription_payments_transaction_map",
							array(
									"tx"=>$txid,
									"subscription_payment_id"=>$id
							));
			
		}

		foreach ($orderData['order_items'] as $item)
		{
			$this->orders_model->calculateOrderItemDue($item->order_id,$item->id);
		}

		if($is_manual_payment==0)
		{
			if(isset($related_ids) && !empty($related_ids))
			{
				if(in_array(strtolower($paymentStatus),$this->payment_success_statuses))
				{
					$this->orders_model->sendTransactionReceiptEmail($payment->order_id,$payment->tx);
					$this->orders_model->sendTransactionStatusEmailOffline($payment->order_id,$payment->tx,0);
					$this->orders_model->sendTransactionStatusEmailOfflineBCC($payment->order_id,$payment->tx);
				}
				else
				{
					if($txid!='')
					{
						$this->orders_model->sendTransactionStatusEmailOffline($txData->order_id,$txid);
						$this->orders_model->sendTransactionStatusEmailOfflineBCC($txData->order_id,$txid);
					}
				}
				/*foreach ($related_ids as $related_id)
					$this->orders_model->sendSubscriptionTransactionStatusEmail($payment->order_id,$payment->order_item_id,$related_id);*/
			}
			else
			{
				if(in_array(strtolower($paymentStatus),$this->payment_success_statuses))
				{
					$this->orders_model->sendTransactionReceiptEmail($payment->order_id,$txid);
					$this->orders_model->sendSubscriptionTransactionStatusEmail($payment->order_id,$payment->order_item_id,$id,0);
					$this->orders_model->sendSubscriptionTransactionStatusEmailBCC($payment->order_id,$payment->order_item_id,$id,0);
				}
				else
				{
					$this->orders_model->sendSubscriptionTransactionStatusEmail($payment->order_id,$payment->order_item_id,$id);
					$this->orders_model->sendSubscriptionTransactionStatusEmailBCC($payment->order_id,$payment->order_item_id,$id);
				}
			}
		}

		if(in_array(strtolower($paymentStatus),$this->payment_success_statuses))
		{
			$this->payment_model->updateOrderTotalPaid($payment->order_id,$payment->amount,$txid);
			$this->payment_model->populateTransactionReport($txid);
		}

		return 1;

	}
	public function offlineUpdateBulk($ids,$paymentMode='',$paymentStatus='',$txNote='',$contains_subscription=0)
	{
		$pids=array();
		if(is_array($ids))
			$pids=$ids;
		else
			$pids=array_filter(explode(",",$ids));

		$totalAmount=0;
		$paymentRecords=array();
		$txids=array();
		//Get Payment ids
		foreach ($pids as $pid)
		{
			$payment=$this->getById($pid);
			if(empty($payment))
			{
				$payment=$this->transaction_model->getTransactionByTx($pid);
				if(empty($payment))
					return 0;

				if($payment->status=='pending' || $payment->status=='cash_pending')
					$payment->status=0;
				else if($payment->status=='bounced')
					$payment->status=102;
				else if($payment->status=='refund')
					$payment->status=103;
				else if($payment->status=='inprocess')
					$payment->status=101;
				else if(in_array($payment->status,$this->payment_success_statuses))
					$payment->status=8;
				else
					$payment->status=1;

				$payment->is_tx=1;
				$txids[]=$pid;
			}
			if($this->checkPaymentModeStatus($paymentMode,$paymentStatus,$payment->status)==0)
			{
				return 0;
			}

			$paymentRecords[$pid]=$payment;
			$totalAmount+=$payment->amount;
		}

		/*print_r($pids);
		exit;*/
		$is_manual_payment=0;
		//Get order details
		$orderData=$this->orders_model->orderData($payment->order_id);

		if($paymentStatus=='paid' || $paymentStatus=='inprocess')
		{
			//Create transaction and attach
			$txxNote="<b>".date("d M Y h:i A")."</b> (".$paymentStatus.")\n".$txNote;
			if($contains_subscription == 1)
			{
				$txid=$this->transaction_model->createCashTransaction($orderData,$totalAmount,$paymentMode,$txxNote);
				//$this->transaction_model->updateDetails($txid,array("subscription"=>1,'status'=>$paymentStatus));

				$this->transaction_model->updateDetails($txid,
													array(
															"subscription"=>1,
															'status'=>$paymentStatus,
															"order_item_id"=>$payment->order_item_id,
															"is_manual_payment"=>empty($this->input->post("is_manual_payment"))?0:$this->input->post("is_manual_payment"),
															"is_foreign_payment"=>empty($this->input->post("is_foreign_payment"))?0:$this->input->post("is_foreign_payment"),
															"manual_receipt_number"=>empty($this->input->post("manual_receipt_number"))?null:$this->input->post("manual_receipt_number"),
															"manual_receipt_date"=>empty($this->input->post("manual_receipt_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("manual_receipt_date"))),
															"offline_number"=>empty($this->input->post("offline_number"))?null:$this->input->post("offline_number"),
															"offline_bank"=>empty($this->input->post("offline_bank"))?null:$this->input->post("offline_bank"),
															"offline_date"=>empty($this->input->post("offline_date"))?null:date("Y:m:d H:i:s",strtotime($this->input->post("offline_date"))),
															"foreign_currency"=>empty($this->input->post("foreign_currency"))?0:$this->input->post("foreign_currency"),
															"foreign_amount"=>empty($this->input->post("foreign_amount"))?0:$this->input->post("foreign_amount"),
															"realized_amount"=>empty($this->input->post("realized_amount"))?0:$this->input->post("realized_amount")
														));
			}
			else
			{
				$txid=$this->transaction_model->createCashTransaction($orderData,0,$paymentMode,$txxNote);
			}
			

			//,"order_item_id"=>$payment->order_item_id));
			if(!empty($this->input->post("is_manual_payment")))
				$is_manual_payment=1;

			if($is_manual_payment==0)
			{
				if($paymentStatus=='paid')
				{
					$this->orders_model->sendTransactionReceiptEmail($payment->order_id,$txid);
					$this->orders_model->sendTransactionStatusEmailOffline($payment->order_id,$txid,0);
					$this->orders_model->sendTransactionStatusEmailOfflineBCC($payment->order_id,$txid);
				}
				else
				{
					$this->orders_model->sendTransactionStatusEmailOffline($payment->order_id,$txid);
					$this->orders_model->sendTransactionStatusEmailOfflineBCC($payment->order_id,$txid);
				}
			}
		}
		else
		{
			return 0;
		}
		foreach ($pids as $pid)
		{
			if(in_array($pid,$txids))
			{
				$updateData=array();
				$updateData['status']=$paymentStatus;
				$updateData['sub_transaction']=1;
				$updateData['sub_tx']=$txid;
				// $updateData['date']=date("Y:m:d H:i:s");
				$updateData['payment_mode']=$paymentMode;
				$updateData['note']=date("d M Y h:i A")."</b> (".$paymentStatus.")\n".$txNote;

				$this->db->where("tx",$pid);
				$this->db->update("transaction",$updateData);

				if(isset($paymentRecords[$pid]) && $paymentRecords[$pid]->sub_tx!='')
				{
					$this->transaction_model->updateDetails(
														$paymentRecords[$pid]->sub_tx,
														array(
															"flag"=>1
														)
													);
				}

				$this->db->where("tx_id",$paymentRecords[$pid]->id);
				$this->db->update("onetime_payments_transaction_map",
								array(
										"flag"=>1
									));

				$this->db->insert("onetime_payments_transaction_map",
								array(
										"tx"=>$txid,
										"tx_id"=>$paymentRecords[$pid]->id
								));

				//$this->orders_model->sendSubscriptionTransactionStatusEmail($payment->order_id,$payment->order_item_id,$pid);
			}
			else
			{
				$updateData=array();
				if($paymentStatus=='paid')
				{
					$updateData['status']=8;
				}
				if($paymentStatus=='inprocess')
				{
					$updateData['status']=101;
				}
				
				$updateData['tx']=$txid;
				$updateData['date']=date("Y:m:d H:i:s");
				$updateData['payment_mode']=$paymentMode;

				$this->db->where("id ",$pid);
				$this->db->update($this->tableName,$updateData);

				$this->db->insert("subscription_payments_transaction_map",
								array(
										"tx"=>$txid,
										"subscription_payment_id"=>$pid
								));

				if(isset($paymentRecords[$pid]) && $paymentRecords[$pid]->tx!='')
				{
					$this->transaction_model->updateDetails(
														$paymentRecords[$pid]->tx,
														array(
															"flag"=>1
														)
													);
				}

				//$this->orders_model->sendSubscriptionTransactionStatusEmail($payment->order_id,$payment->order_item_id,$pid);
			}
		}
		foreach ($pids as $pid)
		{
			$this->orders_model->calculateOrderItemDue($paymentRecords[$pid]->order_id,$paymentRecords[$pid]->order_item_id);
			if(in_array(strtolower($paymentStatus),$this->payment_success_statuses))
			{
				$this->payment_model->updateOrderTotalPaid($paymentRecords[$pid]->order_id,$paymentRecords[$pid]->amount,$paymentRecords[$pid]->tx);
				$this->payment_model->populateTransactionReport($paymentRecords[$pid]->tx);
			}
		}
		return 1;
	}

	private function checkPaymentModeStatus($paymentMode,$paymentStatus,$currentStatus)
	{
		//Conditions for CHEQUE
		if($paymentMode=='cheque')
		{
			if($currentStatus==0 || $currentStatus==102 || $currentStatus==103) // If pending or bounced or refunded
			{
				if($paymentStatus!='inprocess') //Allow only inprocess status
				{
					return 0;
				}
			}
			if($currentStatus==101)
			{
				if($paymentStatus!='paid' && $paymentStatus!='bounced') //Allow only paid and bounced status
				{
					return 0;
				}
			}
			if($currentStatus==8)
			{
				if($paymentStatus!='bounced' || $paymentStatus!='refund') //Allow only bounced status
				{
					return 0;
				}
			}
		}
		else //Remaining all payment modes
		{
			if($currentStatus==0 || $currentStatus==103 || $currentStatus==102) //Allow from pending and refund and bounced as well
			{
				if($paymentStatus!='paid') //Allow only paid status
				{
					return 0;
				}
			}
			else if($currentStatus==8) //Allow from paid
			{
				if($paymentStatus!='refund') //Allow only refund status
				{
					return 0;
				}
			}
			else //Dont allow for any other existing statuses
			{
				return 0;
			}
		}
		return 1;
	}

	public function subpaymentReminder()
	{
		$q = $this->db->select("s.id,s.payment_number,s.payment_date,s.payment_mode,s.order_id,oi.item_name,s.amount")->from($this->tableName." as s")->join("order_items as oi","oi.id = s.order_item_id")->where("DATE(s.payment_date)",date("Y-m-d",strtotime("+2 days")))->where("oi.status",1)->get();
		if($q->num_rows() > 0)
		{
			$r = $q->result_array();
			
			foreach ($r as $key => $value) 
			{
				$orderData=$this->orders_model->orderData($value["order_id"]);
				$data['orderData']=$orderData;
				$data['payment_date']=date("l, d M Y",strtotime($value["payment_date"]));
				$data['subscription_name']=$value["item_name"];
				$data['amount']=$value["amount"];
				$body=$this->load->view("orders/public/_email_subs_payment_reminders",$data,true);
				$subject='Subscription payment reminder for '.$orderData['order']->order_number;
				$this->email_extension->sendOrdersMail(
												"subs_payment_reminders",
												$orderData['order']->user_id,
												$orderData['order']->firstname." ".$orderData['order']->lastname,
												$orderData['order']->email,
												$subject,
												$body,
												'',
												1);
			}
		}
	}

	public function notify_expiry_cards()
	{
		$months = array("01","02","03","04","05","06","07","08","09","10","11","12");
		$current_month = date("m");
		if($current_month == "12")
		{
			$check_month = "12";
			$check_year = date("Y");
		}
		else
		{
			$check_month = $current_month;
			$check_year = date("Y");
		}
		$maxDays=date('t');
        $currentDayOfMonth=date('j');
		$this->db->select('id,card_expiry_month,card_expiry_year,user_id,payment_info,order_id,30_days_alert,15_days_alert,7_days_alert');
        $this->db->from("subscription_profiles_payflow");
        $this->db->where("card_expiry_month",$check_month);
        $this->db->where('card_expiry_year',$check_year);
        $result = $this->db->get()->result_array();
        if ($result) 
        {
        	foreach ($result as $key => $value) 
        	{
        		if(($currentDayOfMonth >= 1 && $currentDayOfMonth <= 15) && ($value["30_days_alert"] == 1))
                {
                    continue;
                }
                if(($currentDayOfMonth >= 15 && $currentDayOfMonth <= 21) && ($value["15_days_alert"]  == 1))
                {
                    continue;
                }
                if(($currentDayOfMonth >= 21) && ($value["7_days_alert"]  == 1))
                {
                    continue;
                }
                if($value["30_days_alert"] != 1 || $value["15_days_alert"]  != 1 || $value["7_days_alert"]  != 1)
                {
	        		$orderData=$this->orders_model->orderData($value["order_id"]);
	        		$payment_info=explode("\n",$this->encryption->decrypt($value['payment_info']));
	        		$data['orderData']=$orderData;
	        		$data['card_number']=$payment_info[0];
					$body=$this->load->view("orders/public/_email_subscription_card_expire",$data,true);
					$subject='Card Expiry Notification - Subscription payment for '.$orderData['order']->order_number;
					$this->email_extension->sendOrdersMail(
													"subs_card_exp_alerts_".$orderData['order']->ashram_id."_".strtolower($orderData['order']->currency),
													$orderData['order']->user_id,
													$orderData['order']->firstname." ".$orderData['order']->lastname,
													$orderData['order']->email,
													$subject,
													$body,
													'',
													1);
				}
				if(($currentDayOfMonth >= 1 && $currentDayOfMonth <= 15))
                {
                    $this->db->where("id",$value["id"]);
                    $this->db->update("subscription_profiles_payflow",array(
                                    "30_days_alert"=>1
                                ));
                }
                if(($currentDayOfMonth >= 15 && $currentDayOfMonth <= 21))
                {
                    $this->db->where("id",$value["id"]);
                    $this->db->update("subscription_profiles_payflow",array(
                                    "15_days_alert"=>1
                                ));
                }
                if(($currentDayOfMonth >= 21))
                {
                    $this->db->where("id",$value["id"]);
                    $this->db->update("subscription_profiles_payflow",array(
                                    "7_days_alert"=>1
                                ));
                }
        	}
        }
        else 
        {
            return false;
        }
	}

	public function listAdminRecurringPayments($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);
		if($this->session->userdata("ashramId"))
		{
			$ashramData=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			$subscriptions=$this->subscriptions_model->getByAshramId($this->session->userdata("ashramId"));
			$subscriptionsArray=array();
			foreach ($subscriptions as $donationData)
			{
				$subscriptionsArray[$donationData->id]=$donationData;
			}
			$ashramTrusts=$this->ashrams_trust_accounts_model->getAllTrustsBasicDetailsByAshramId($this->session->userdata("ashramId"));
			$ashramTrustsArray=array();
			foreach ($ashramTrusts as $ashramTrustData)
			{
				$ashramTrustsArray[$ashramTrustData->id]=$ashramTrustData;
			}
		}
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(sp.id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("sp.tx as transaction_id,o.id as order_id,o.date,o.order_number,o.payment_mode,o.currency,o.address1,o.address2,o.address3,o.city,o.state,o.zipcode,o.email,o.phone,sp.status as sub_status,oi.item_name,oi.period,oi.frequency,oi.num_of_payments,oi.subscription_id,sp.amount,o.country,sp.payment_date,sp.payment_number,sp.id,o.payment_alt_mode,o.username,o.firstname,o.lastname,o.user_id,oi.status as subscription_status");
		}
		$query1->where("o.order_number !=",NULL);
		$query1->where_in("oi.status",array(1,0));
		$query1->from($this->tableName." as sp");
		$query1->join("orders as o",'o.id=sp.order_id');
		$query1->join("order_items as oi",'oi.id=sp.order_item_id');
		$preData="Ashram: ";
		if($this->session->userdata("ashramId"))
		{
			$query1->where("o.ashram_id",$this->session->userdata("ashramId"));
			$preData.=$ashramData->name;
		}
		else
		{
			$preData.="All Ashrams";
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nSubscription(s): ";
			if(isset($_POST['subscription_id']) && $_POST['subscription_id']!='')
			{
				if(is_array($_POST['subscription_id']))
				{
					$query1->where_in("oi.item_id",$_POST['subscription_id']);
					$pii=0;
					foreach ($_POST['subscription_id'] as $donation_id)
					{
						if($pii) $preData.=", ";
						$preData.=$subscriptionsArray[$donation_id]->subscription_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("oi.item_id",$_POST['subscription_id']);
					$preData.=$donationsArray[$_POST['subscription_id']]->subscription_name;
				}
			}
			else
			{
				$preData.="All Subscriptions";
			}
		}

		if($this->session->userdata("ashramId"))
		{
			$preData.="\nTrust(s): ";
			if(isset($_POST['trust_ids']) && $_POST['trust_ids']!='')
			{
				if(is_array($_POST['trust_ids']))
				{
					$query1->join("transaction as txs",'txs.order_id=o.id');
					$query1->where_in("txs.trust_id",$_POST['trust_ids']);
					$pii=0;
					foreach ($_POST['trust_ids'] as $trust_ids)
					{
						if($pii) $preData.=", ";
						$preData.=$ashramTrustsArray[$trust_ids]->trust_name;
						$pii++;
					}
				}
				else
				{					
					$query1->where("txs.trust_id",$_POST['trust_ids']);
					$preData.=$ashramTrustsArray[$_POST['trust_ids']]->trust_name;
				}
			}
			else
			{
				$preData.="All Trusts";
			}
		}

		$preData.="\nRecords Type: ";
		if(isset($_POST['records_type']) && $_POST['records_type']=='latestUnique')
		{
			$preData.="Latest Records";
		}
		else
		{
			$preData.="All Records";
		}

		$preData.="\nSearch Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($this->searchAliasNames[$_POST['search_col']]) && ($this->searchAliasNames[$_POST['search_col']]!=''))
			{
				$preData.=$this->searchAliasNames[$_POST['search_col']];
			}
			$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='contains')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			else if($_POST['wild']=='starts')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like('o.'.$_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}
		$preData.="\nPayment Mode: ";
		if(isset($_POST['payment_type']) && is_numeric($_POST['payment_type']) && in_array($_POST['payment_type'],array(0,1)))
		{
			if($_POST['payment_type']==1)
			{
				$query1->where_in("o.payment_alt_mode",array("paypal","payu","razorpay","stripe","authorize.net"));
				$preData.="Online";
			}
			else
			{
				$query1->where("o.payment_alt_mode",'cash');
				$preData.="Offline";
			}
		}
		else
		{
			$preData.="All Payment Modes";
		}

		$preData.="\nSubscription Status: ";
		if(isset($_POST['subscription_status']) && $_POST['subscription_status']!='')
		{
			$query1->where("oi.status",$_POST['subscription_status']);
			if($_POST['subscription_status'] == '0')
			{
				$preData.="Pending";
			}
			if($_POST['subscription_status'] == '1')
			{
				$preData.="In-Progress";
			}
			if($_POST['subscription_status'] == '2')
			{
				$preData.="Fully Paid";
			}
			if($_POST['subscription_status'] == '3')
			{
				$preData.="Cancelled";
			}
		}
		else
		{
			$preData.="All Subscriptions";
		}

		$preData.="\nPayment Status: ";
		if(isset($_POST['payment_status']) && $_POST['payment_status']!='')
		{
			$query1->where("sp.status",$_POST['payment_status']);
			if($_POST['payment_status'] == '8')
			{
				$preData.="Paid";
			}
			if($_POST['payment_status'] == '0')
			{
				$preData.="Pending";
			}
			if($_POST['payment_status'] == '1')
			{
				$preData.="Failed";
			}
			if($_POST['payment_status'] == '101')
			{
				$preData.="InProcess";
			}
			if($_POST['payment_status'] == '102')
			{
				$preData.="Bounced";
			}
			if($_POST['payment_status'] == '103')
			{
				$preData.="Refunded";
			}
		}

		$preData.="\nPayment Source: ";
		if(isset($_POST['payment_mode']) && $_POST['payment_mode']!='')
		{
			$query1->where("o.payment_alt_mode",$_POST['payment_mode']);
			if($_POST['payment_mode'] == 'cash')
			{
				$preData.='Offline';
			}
			else
			{
				$preData.=$_POST['payment_mode'];
			}
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(sp.payment_date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(sp.payment_date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		$preData.="\nCurrency: ";
		if(isset($_POST['currency']) && $_POST['currency']!='')
		{
			$query1->where("o.currency",$_POST['currency']);
			$preData.=strtoupper($_POST['currency']);
		}
		else
		{
			$preData.="All Currencies";
		}

		$preData.="\nSubscription Mode: ";
		if(isset($_POST['subscription_type']) && in_array($_POST['subscription_type'],array("days","months","weeks","years")))
		{
			$query1->where("oi.period",$_POST['subscription_type']);
			if($_POST['subscription_type']=="weeks")
			{
				$preData.="Weekly";
			}
			if($_POST['subscription_type']=="days")
			{
				$preData.="Daily";
			}
			if($_POST['subscription_type']=="months")
			{
				$preData.="Monthly";
			}
			if($_POST['subscription_type']=="years")
			{
				$preData.="Yearly";
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('sp.payment_date',$_POST['dir']);
				else
					$query1->order_by('sp.payment_date',"desc");
			}

			if(isset($_POST['records_type']) && $_POST['records_type']=='latestUnique')
			{
				$query1->group_by("sp.payment_number, sp.order_item_id,sp.order_id");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","orders/subscription_payments_model",$sql,$this->currentUser,"default",$_POST,"Subscriptions Report",$preData,2);
			return $requestResp;
		}


		if($i==1)
		{
			$query1->group_by("o.currency");
			$temp_result = $query1->get()->result();
			$t_total=0;
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
			}

			$rtn['recordsTotal'] = $t_total;
			$rtn['recordsFiltered'] = $t_total;
			
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && is_array($GLOBALS['current_acl']['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && is_array($GLOBALS['current_acl']['sort_columns']) && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('sp.payment_date',$dir);
		}
		else
		{
			$query1->order_by('sp.payment_date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		if(isset($_POST['records_type']) && $_POST['records_type']=='latestUnique')
		{
			$query1->group_by("sp.payment_number, sp.order_item_id,sp.order_id");
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();
		$c=0;
		$sno=$start+1;
		$ids=array();
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if(empty($row['transaction_id']))
			{
				$rtn['data'][$c]['transaction_id']=$row['transaction_id'];
			}
			else
			{
				$rtn['data'][$c]['phone']="N/A";
			}
			if($row['period'] == "weeks")
			{
				$rtn['data'][$c]['period']="Weekly";
			}
			else if($row['period'] == "days")
			{
				$rtn['data'][$c]['period']="Daily";
			}
			else if($row['period'] == "months")
			{
				$rtn['data'][$c]['period']="Monthly";
			}
			else if($row['period'] == "years")
			{
				$rtn['data'][$c]['period']="Yearly";
			}
			$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];
			$rtn['data'][$c]['date']=date("d M Y",strtotime($rtn['data'][$c]['date']));
			$rtn['data'][$c]['total_price']=strtoupper($rtn['data'][$c]['currency'])." ".$rtn['data'][$c]['amount'];
			$rtn['data'][$c]['payment_date']=date("d M Y",strtotime($rtn['data'][$c]['payment_date']));

			if($rtn['data'][$c]['subscription_status'] == '0')
			{
				$rtn['data'][$c]['subscription_status_str']="<span class='label label-warning' style = 'margin-top:5px;'>Pending</span>";
			}
			else if($rtn['data'][$c]['subscription_status'] == '1')
			{
				$rtn['data'][$c]['subscription_status_str']="<span class='label label-info' style = 'margin-top:5px;'>In-Progress</span>";
			}
			else if($rtn['data'][$c]['subscription_status'] == '2')
			{
				$rtn['data'][$c]['subscription_status_str']="<span class='label label-success' style = 'margin-top:5px;'>Fully Paid</span>";
			}
			else if($rtn['data'][$c]['subscription_status'] == '3')
			{
				$rtn['data'][$c]['subscription_status_str']="<span class='label label-danger' style = 'margin-top:5px;'>Cancelled</span>";
			}
			else
			{
				$rtn['data'][$c]['subscription_status_str'] = 'NA';
			}

			$ids[]=$row['id'];
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->recurringsExcelReportAdmin($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Total");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Total Paid");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Type");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Created By");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Paid Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Refunded Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Failed Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Cancelled Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Inprocess Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Bounced Tx ID(s)");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Source");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tokens Issued?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Shipping Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"App?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);


		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$txids = $reportrow->paid_tx_ids;
			#$txids=str_replace("<br>",", ",$this->orderTransactions($reportrow->id,0,1));
			#$totalPaid=$this->orderTransactions($reportrow->id,1,1);
			$totalPaid=$reportrow->total_paid;
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->total_price);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$totalPaid);

			$otype="Poojas";
			if($reportrow->order_type==2)
				$otype="Donations";
			if($reportrow->order_type==3)
				$otype="Store";
			if($reportrow->order_type==4 || $reportrow->subscription_mixed_order==1)
				$otype="Subscription";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$otype);

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;
			if($reportrow->zipcode!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}

			

			$created_by="Admin";
			if($reportrow->created_by==2)
				$created_by="User";
			if($reportrow->created_by==0)
				$created_by="Guest";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$created_by);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->paid_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->refunded_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->failed_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->cancelled_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->inprocess_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->bounced_tx_ids);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);

			$pstatus="Pending";
			if($reportrow->payment_status==1)
				$pstatus="Paid";
			if($reportrow->payment_status==2)
				$pstatus="Partially Paid";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);

			$tokens="Yes";
			if($reportrow->tokens==0)
				$tokens="No";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$tokens);

			

			$ship_status="N/A";
			if($reportrow->dispatch_status==1)
				$ship_status="Pending";
			else if($reportrow->dispatch_status==2)
				$ship_status="Completed";
			else if($reportrow->dispatch_status==3)
				$ship_status="Returned";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$ship_status);

			if($reportrow->app==1)
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"Yes");
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"No");

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function recurringsExcelReportAdmin($excelData,$objPHPExcel)
	{	
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date and Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Time");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Tx ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subscription");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Amount");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		// $alpha++;
		// $objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Frequency");
		// $objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment#");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Period");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Total Payments");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Mode");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Payment Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subscription Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Full Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);
		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Zip code");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->order_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname." ".$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);

			$address=$reportrow->address1;
			if($reportrow->address2!='')
				$address.="\n".$reportrow->address2;
			if($reportrow->address3!='')
				$address.="\n".$reportrow->address3;
			$address.="\n".$reportrow->city;
			$address.="\n".$reportrow->state;
			$address.="\n".$reportrow->country;
			if($reportrow->zipcode!='')
    		{
    			$address.= "\n".$reportrow->zipcode;
    		}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->transaction_id);
			

			$pstatus="Pending";
			if($reportrow->sub_status==8)
				$pstatus="Paid";
			if($reportrow->sub_status==1)
				$pstatus="Failed";
			if($reportrow->sub_status==101)
				$pstatus="InProcess";
			if($reportrow->sub_status==102)
				$pstatus="Bounced";
			if($reportrow->sub_status==103)
				$pstatus="Refund";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,strtoupper($reportrow->currency)." ".$reportrow->amount);
			// $objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->frequency);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_number);

			$subPeriod = "";
			if($reportrow->period == "weeks")
			{
				$subPeriod="Weekly";
			}
			else if($reportrow->period == "days")
			{
				$subPeriod="Daily";
			}
			else if($reportrow->period == "months")
			{
				$subPeriod="Monthly";
			}
			else if($reportrow->period == "years")
			{
				$subPeriod="Yearly";
			}
			else
			{
				$subPeriod = "NA";
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$subPeriod);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->num_of_payments);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->payment_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->payment_mode);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$pstatus);

			if($reportrow->subscription_status == '0')
			{
				$substatus="Pending";
			}
			else if($reportrow->subscription_status == '1')
			{
				$substatus="In-Progress";
			}
			else if($reportrow->subscription_status == '2')
			{
				$substatus="Fully Paid";
			}
			else if($reportrow->subscription_status == '3')
			{
				$substatus="Cancelled";
			}
			else
			{
				$substatus = 'NA';
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$substatus);


			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address3);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->zipcode);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>